<?php
//76east include_once("../v2/db_connect.php");
include_once("../v2/db_connect_pdo.php");//db connect classs
class videoSiteMapManager
{
 private $db_conn;
 function __construct($conn=null){ //set db connection in constructor
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection();
		$this->db_conn = $dbconnect_obj->conn;
	}
 }
 function generateSiteMapForGoogleSearchEngine()
 {
   $String_sitemap_content = "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\""
        ."xmlns:video=\"http://www.google.com/schemas/sitemap-video/1.1\">";
   /**  
    * Get information from database and generate xml item
    * <loc></loc>
    * Get information from database and generate xml items
    * 1)<video:thumbnail_loc>
    * 2)<video:title>
    * 3)<video:description>
    * 4)<video:content_loc>
    * 5)<video:duration>
    * 6)<video:expiration_date>
    */   
   $allVideos = $this->getVideodetails();
   $numOfVideos = count($allVideos);
   for ($i=0;$i<$numOfVideos;$i++)
   {
    $String_sitemap_content .= "<url>"
                            ."<loc>".$allVideos[$i]['video_play_page_url']."</loc>"
                            ."<video:video>"
                                ."<video:thumbnail_loc>".$allVideos[$i]['thumbnail_image_url']."</video:thumbnail_loc>"
                                ."<video:title>".$allVideos[$i]['video_title']."</video:title>"
                                ."<video:description>".$allVideos[$i]['video_desc']."</video:description>"
                                ."<video:content_loc>".$allVideos[$i]['video_url']."</video:content_loc>"
                                ."<video:duration>".$allVideos[$i]['video_duration']."</video:duration>"
                                ."<video:expiration_date>".$allVideos[$i]['video_expiration_date']."</video:expiration_date>"
                                ."<video:publication_date>".$allVideos[$i]['added_on']."</video:publication_date>"
                            ."</video:video>"
                            ."</url>";
   }
   $String_sitemap_content .= "</urlset>";
   return $String_sitemap_content;
 }
 
 /**
  * 
  * @param type $vide_category
  * @return string
  */
 function generateMarkedupHTMLCcontentOfVideos($vide_category)
 {
   $String_markupHTML_content = "";
   $allVideos = $this->getVideodetails();
   $numOfVideos = count($allVideos); 
   for ($i=0;$i<$numOfVideos;$i++)
   {
    $String_markupHTML_content .= "<div itemprop=\"video\" itemscope itemtype=\"http://schema.org/VideoObject\">"
              ."<span style=\"display:none\" itemprop=\"name\">".$allVideos[$i]['video_title']."</span>"
              ."<meta itemprop=\"duration\" content=\"".$allVideos[$i]['video_duration']."\" />"
              ."<meta itemprop=\"thumbnailUrl\" content=\"".$allVideos[$i]['thumbnail_image_url']."\" />"
              ."<meta itemprop=\"contentURL\" content=\"".$allVideos[$i]['video_url']."\" />"
              ."<meta itemprop=\"uploadDate\" content=\"".$allVideos[$i]['added_on']."\" />"
              ."<meta itemprop=\"expires\" content=\"".$allVideos[$i]['video_expiration_date']."\" />"
              ."<meta itemprop=\"height\" content=\"400\" />"
              ."<meta itemprop=\"width\" content=\"400\" />"
              ."<span  style=\"display:none\" itemprop=\"description\">".$allVideos[$i]['video_desc']."</span>"
              ."</div>";
   }   
   return $String_markupHTML_content;
 }
 
 function getVideodetails()
 {
  $allVideos = array();   
  $String_SQL = "Select * From video Order by video_id;";   
  $status = $this->db_conn->query($String_SQL);
  if (!$status)
  {
    echo "[getVideodetails]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   while($row=  $status->fetch())
   {
    $allVideos[] = array(
     "video_id"=>$row['video_id'],  
     "video_title"=>$row['video_title'],
     "thumbnail_image_url"=>"http://www.banknews.tv/assets/".$row['video_tag'],  
     "related_pdf"=>$row['related_pdf'],
     "video_url"=>"http://www.banknews.tv/assets/".$row['video_url'],  
     "priority"=>$row['priority'],
     "status"=>$row['status'],  
     "added_on"=>$row['added_on'],
     "video_desc"=>$row['video_desc'],  
     "video_play_page_url"=>$row['video_play_page_url'],
     "video_duration"=>$row['video_duration'],  
     "video_expiration_date"=>$row['video_expiration_date']        
    );   
   }
   return $allVideos;
  }
 }
 
 function getSingleVideoDetails($video_id)
 {
  $singleVideo = array();   
  $String_SQL = "Select * From video Where video_id = ? Order by video_id;";   
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$video_id]);
  if (!$status)
  {
    echo "[getSingleVideoDetails]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   while($row=  $status->fetch())
   {
    $singleVideo = array(
     "video_id"=>$row['video_id'],  
     "video_title"=>$row['video_title'],
     "thumbnail_image_url"=>$row['video_tag'],  
     "related_pdf"=>$row['related_pdf'],
     "video_url"=>$row['video_url'],  
     "priority"=>$row['priority'],
     "status"=>$row['status'],  
     "added_on"=>$row['added_on'],
     "video_desc"=>$row['video_desc'],  
     "video_play_page_url"=>$row['video_play_page_url'],
     "video_duration"=>$row['video_duration'],  
     "video_expiration_date"=>$row['video_expiration_date']        
    );   
   }
   return $singleVideo;
  }     
 } 
 
 function getRelatedPDF($video_id)
 {
  $relatedPDF = "";   
  $String_SQL = "Select related_pdf From video Where video_id = ?";
  $result = $this->db_conn->prepare($String_SQL);
  $result->execute([$video_id]);
  while ($row=  $result->fetch())
  {
   $relatedPDF = $row['related_pdf'];    
  }
  return $relatedPDF;
 }
 
 function loadVideoBlock($video_id)
 {
  $contentOfVideoBlock = "<section id='mainBanner'>"
     ."<article id='bannerText'>"
     ."<table border='0' width='100%'>"
     ."<tr><td align='center'>"
     ."<figure id='video_player' style='margin-right:2px;'>"
     ."<div class='video' id='video' style='margin-left:48px;float:left;'>" 
     ."<video controls  id=\"ourvideo\" height='324' width='240'>";
  $sql_query = 'SELECT * from video  where video_id= ?' ;
  $result = $this->db_conn->prepare($sql_query);
  $result->execute([$video_id]);
  $video_url = "";
  $video_tag = ""; 
  $youtube_video_url = "";
  while ($row = $result->fetch())
  { 
    $video_url = $row['video_url']; 
    $video_tag =  $row['video_tag'];
    $youtube_video_url = $row['video_youtube_url'];
    $contentOfVideoBlock .="<source src='../assets/".$video_url."' id='".$row['video_id']."' ​type=\"video/ogg\">";
  }
  $videoPlayer = $this->getVideoPlayer();
  if ($videoPlayer==1)
  {
   $contentOfVideoBlock = "<div class='videoWrapper'><iframe src='https://www.youtube.com/embed/".$youtube_video_url."?autoplay=1' allowfullscreen></iframe></div>";   
   return $contentOfVideoBlock;   
  }
  $contentOfVideoBlock .= "</video>"
                       ."</div>"
		       ."<figcaption>"
                       ."<a href='".$video_url."' class='currentvidaa' >";
  $i=0;
  $sql_query = 'SELECT * from image  where video_id= ?';
  $result = $this->db_conn->prepare($sql_query);
  $result->execute([$video_id]);
  while ($row = $result->fetch())
  { 
    $i++;
    $contentOfVideoBlock .= "<input type='hidden' id='imageid' value='../uploads/".$row['image_url']."' >"
    ."<input type='hidden' id='imagefrom' value='".$row['from']."'>"
    ."<input type='hidden' id='imageto' value='".$row['to']."'>"
    ."<input type='hidden' id='imagepdf' value='".$row['related_pdf']."'>"
    ."<div id='aa' style='display:none'>"
    ."<input type='text' id='videoId".$i."' value='".$video_id."'>"
    ."<input type='text' id='image".$i."' value='../uploads/".$row['image_url']."'>"
    ."<input type='text' id='from".$i."' value='".$row['display_from']."'>"
    ."<input type='text' id='to".$i."' value='".$row['display_to']."'>"
    ."<input type='text' id='poster".$i."' value='".$video_tag."'>"
    ."</div>";      
  }
  $contentOfVideoBlock .= "</a>"
         ."</figcaption>"
   		       ."</div><!-- end of video -->"
		       //."</td><td width='70%'><div id=\"footnotediv\"></div></td></tr>"
                       ."<div id=\"footnotediv\" style='margin-left:4px;float:left;'></div></td></tr>"
		       //."<tr><td>&nbsp;</td></tr>"
	    ."</table>"
	 ."</article>"
    ."</section>"; 
  return $contentOfVideoBlock;
 }
 
 function getVideoPlayer()
 {
  $videoPlaer = 0;
  $String_SQL = "Select * From settings a Where a.key='videoPlayer'";
  $status = $this->db_conn->query($String_SQL);
  if (!$status)
  {
   echo "[getVideoPlayer]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  { 
   while($row=  $status->fetch())
   {
    $videoPlaer = $row['value'];
   }  
  }
  return $videoPlaer;
 }
 
 function updateVideoPlayer($videoPlayer)
 {
  $String_SQL = "Update settings a Set value= ? Where a.key='videoPlayer'";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$videoPlayer]);
  if (!$status)
  {
   echo "[getVideoPlayer]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
   return false;
  }else
  {
   return true;   
  }  
 }
 
}
?>

