<?php
	
	session_start();
	
	include_once("php-inc/system.php");
	include_once("php-inc/variables.php");
	
	$vars = new Config();
	$system = new System();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Pogo.pro - Parking Management</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="description" content="Professionals on the Go!">
<meta name="author" content="Pogo.pro">
<link href='http://fonts.googleapis.com/css?family=Open+Sans:400,300italic,400italic,600,600italic' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Crete+Round' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Crete+Round' rel='stylesheet' type='text/css'><link href="css/bootstrap.css" rel="stylesheet">
<link href="css/bootstrap-responsive.css" rel="stylesheet">
<link href="css/style.css" rel="stylesheet">
<link href="css/flexslider.css" type="text/css" media="screen" rel="stylesheet"  />
<link href="css/jquery.fancybox.css" rel="stylesheet">
<link href="css/cloud-zoom.css" rel="stylesheet">

<!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
<!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->
<!-- fav -->
<link rel="stylesheet" href="js-validation/css/validationEngine.jquery.css" type="text/css"/>
<link rel="stylesheet" href="js-validation/css/template.css" type="text/css"/>
<script src="js-validation/js/jquery-1.7.2.min.js" type="text/javascript"></script>
<script src="js-validation/js/languages/jquery.validationEngine-en.js" type="text/javascript" charset="utf-8"></script>
<script src="js-validation/js/jquery.validationEngine.js" type="text/javascript" charset="utf-8"></script>

<link rel="shortcut icon" href="assets/ico/favicon.html">
	<script>
		jQuery(document).ready(function(){
			// binds form submission and fields to the validation engine
			jQuery("#formID").validationEngine();
		});

		/**
		*
		* @param {jqObject} the field where the validation applies
		* @param {Array[String]} validation rules for this field
		* @param {int} rule index
		* @param {Map} form options
		* @return an error string if validation failed
		*/
		function checkHELLO(field, rules, i, options){
			if (field.val() != "HELLO") {
				// this allows to use i18 for the error msgs
				return options.allrules.validate2fields.alertText;
			}
		}
	</script>
</head>
<body>
<!-- Header Start -->
<header>
  <div class="headerstrip">
    <div class="container">
      <div class="row">
        <div class="span12">
          <a href="index.php" class="logo pull-left"><img src="img/logo_80.png" alt="SimpleOne" title="SimpleOne"></a>
          <!-- Top Nav Start -->
          <div class="pull-left">
            <div class="navbar" id="topnav">
              <div class="navbar-inner">
                <ul class="nav" >
                  <li><a class="home active" href="#">Home</a>
                  </li>
                  <?php if(@$_SESSION['user_id']){ ?>
				  <li><a class="myaccount" href="#">My Account</a>
                  </li>
                  <li><a class="myaccount" href="#">Logout</a>
                  </li>
				  <?php } ?>
                </ul>
              </div>
            </div>
          </div>
          <!-- Top Nav End -->
          <div class="pull-right">
            <form class="form-search top-search">
              <input type="text" class="input-medium search-query" placeholder="Search Here…">
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="container">
    <div class="headerdetails">
      <div class="pull-left">
        
      </div>
      
	  <div class="pull-right">
        <ul class="nav language pull-left">
          <li class="dropdown hover">
            <a href="#" class="dropdown-toggle" data-toggle="">Canadian Dollar <b class="caret"></b></a>
            <ul class="dropdown-menu currency">
              <li><a href="#">Canadian Dollar</a>
			  <li><a href="#">US Dollar</a>
              </li>
              <li><a href="#">Euro</a>
              </li>
              <li><a href="#">British Pound</a>
              </li>
            </ul>
          </li>
          <li class="dropdown hover">
            <a href="#" class="dropdown-toggle" data-toggle="">English <b class="caret"></b></a>
            <ul class="dropdown-menu language">
              <li><a href="#">French</a>
              </li>
			  <li><a href="#">English</a>
              </li>
              <li><a href="#">Spanish</a>
              </li>
              <li><a href="#">German</a>
              </li>
            </ul>
          </li>
        </ul> 
		
      </div>
    </div>
	
    <div id="categorymenu">
      <nav class="subnav">
        <ul class="nav-pills categorymenu">
          <li><a class="active" href="index.php">Dashboard</a>
          <li><a href="#">Parking Management</a>
          <div>
              <ul>
                <li><a href="index_lots.php">Parking Lots</a>
                </li>
                <li><a href="index__.php">Lot Construction</a>
                </li>
                <li><a href="index___.php">Parking Features</a>
                </li>
                <!--li><a href="#">Control Systems</a>
                </li-->
                <li><a href="index____.php">Manufaturers</a>
                </li>
                <li><a href="index_.php">Lot Category</a>
                </li>
              </ul>
            </div>
          </li> 
          <li><a href="api.php">API Integration</a>
          </li>
          <?php if(@$_SESSION['user_id']){ ?>
          <li><a href="#">My Account</a>
          </li> 
          <li><a href="#">Logout</a>
          </li> 
		  <?php } ?>
          <li><a href="support.php">Support</a>
          </li>         
        </ul>
      </nav>
    </div>
  </div>
</header>
<!-- Header End -->

<div id="maincontainer">
  <section id="product">
    <div class="container">
     <!--  breadcrumb --> 
      <ul class="breadcrumb">
        <li>
          <a href="#">Dashboard</a>
          <span class="divider">/</span>
        </li>
        <li class="active">Registration</li>
      </ul>
      
      <div class="row">        
        <!-- Register Account-->
        <div class="span9">
          <h1 class="heading1"><span class="maintext">Parking Operators</span><span class="subtext">Operator Registration</span></h1>
          <form class="form-horizontal" id="formID" name="" action="index.php<?php if(@$_GET['blob']) echo "?blob=".$_GET['blob']; ?>" method="post" >
            <h3 class="heading3">Operator Details</h3>
            
			<div class="registerbox">
              <fieldset>
                <div class="control-group">
                  <label class="control-label"><span class="red">*</span> Name:</label>
                  <div class="controls">
                    <input type="text" name="name" class="validate[required] input-xxlarge" <?php if(@$_GET['blob']) echo 'value="'.$parking->active_array[1].'"';?> >
                  </div>
                </div>
				<div class="control-group">
                  <label class="control-label"><span class="red">*</span> Email:</label>
                  <div class="controls">
                    <input type="text" name="name" class="validate[required,custom[email]] input-xxlarge" <?php if(@$_GET['blob']) echo 'value="'.$parking->active_array[1].'"';?> >
                  </div>
                </div>
				<div class="control-group">
                  <label class="control-label"><span class="red">*</span> Password:</label>
                  <div class="controls">
                    <input type="text" name="name" class="validate[required] input-xxlarge" <?php if(@$_GET['blob']) echo 'value="'.$parking->active_array[1].'"';?> >
                  </div>
                </div>
				<div class="control-group">
                  <label class="control-label"><span class="red">*</span> Confirm Password:</label>
                  <div class="controls">
                    <input type="text" name="name" class="validate[required] input-xxlarge" <?php if(@$_GET['blob']) echo 'value="'.$parking->active_array[1].'"';?> >
                  </div>
                </div>
				
				<div class="control-group">
                  <label class="control-label">Website:</label>
                  <div class="controls">
                    <input type="text" name="name" class="validate[required] input-xxlarge" <?php if(@$_GET['blob']) echo 'value="'.$parking->active_array[1].'"';?> >
                  </div>
                </div>
				<div class="control-group">
                  <label class="control-label"><span class="red">*</span> Operator Type:</label>
                  <div class="controls">
                    <?php
						$system->generate_dropdown($vars->operator_types);
					?>
                  </div>
                </div>
                <div class="control-group">
                  <label class="control-label"> Description:</label>
                  <div class="controls">
                    <input type="text" name="description" class="input-xxlarge" <?php if(@$_GET['blob']) echo 'value="'.$parking->active_array[2].'"';?>>
                  </div>
                </div>
                <div class="control-group">
                  <label class="control-label">Terms and Conditions:</label>
                  <div class="controls">
                    <label class="checkbox inline">
                      <input type="checkbox" name="terms" class="validate[required]" value="Yes" >
                      I&nbsp;agree. </label>
                  </div>
                </div>
                <div class="control-group">
                  <label class="control-label"></label>
                  <div class="controls">
                      <input type="Submit" name="Submit" class="btn btn-orange" value="Submit">
                  </div>
                </div>
				</form>
				
              </fieldset>
            </div>
          
          <div class="clearfix"></div>
          <br>
          
          
          
        </div> 
        
        <!-- Sidebar Start-->
        <aside class="span3">
          <div class="sidewidt">
            <h2 class="heading2"><span>Account</span></h2>
            <ul class="nav nav-list categories">
              <li>
                <a href="../index.php">Home</a>
              </li>
              <li>
              	<a href="login.php">Login</a>
              </li>
              <li>
                <a href="registration.php">Registration</a>
              </li>
            </ul>
          </div>
        </aside>
        <!-- Sidebar End-->
      </div>
    </div>
  </section>
</div>

<!-- Footer -->
<footer id="footer">
  <!--section class="footersocial">
    <div class="container">
      <div class="row">
        <div class="span3 aboutus">
          <h2>About Us </h2>
          <p> Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. <br>
            <br>
            t has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. </p>
        </div>
        <div class="span3 contact">
          <h2>Contact Us </h2>
          <ul>
            <li class="phone"> +123 456 7890, +123 456 7890</li>
            <li class="mobile"> +123 456 7890, +123 456 78900</li>
            <li class="email"> test@test.com</li>
            <li class="email"> test@test.com</li>
          </ul>
        </div>
        <div class="span3 twitter">
          <h2>Twitter </h2>
          <div id="twitter">
          </div>
        </div>
        <div class="span3 facebook">
          <h2>Facebook </h2>
          <div id="fb-root"></div>
          <script src="http://static.ak.connect.facebook.com/js/api_lib/v0.4/FeatureLoader.js.php" type="text/javascript"></script>
          <script type="text/javascript">FB.init("");</script>
          <script type="text/javascript">
//<![CDATA[
document.write('<fb:fan profile_id="80655071208" stream="0"	connections="6"	logobar="0" height="190px"	width="200"css="css/fb.css"></fb:fan> ');
//]]>
</script>
        </div>
      </div>
    </div>
  </section-->
  <section class="footerlinks">
    <div class="container">
      <div class="info">
        <ul>
          <li><a href="#">Privacy Policy</a>
          </li>
          <li><a href="#">Terms &amp; Conditions</a>
          </li>
          <li><a href="#">Affiliates</a>
          </li>
          <li><a href="#">Merchants</a>
          </li>
        </ul>
      </div>
      <div id="footersocial">
        <a href="#" title="Facebook" class="facebook">Facebook</a>
        <a href="#" title="Twitter" class="twitter">Twitter</a>
        <a href="#" title="Linkedin" class="linkedin">Linkedin</a>
        <a href="#" title="rss" class="rss">rss</a>
        <a href="#" title="Googleplus" class="googleplus">Googleplus</a>
        <a href="#" title="Skype" class="skype">Skype</a>
        <!--a href="#" title="Flickr" class="flickr">Flickr</a-->
      </div>
    </div>
  </section>
  <section class="copyrightbottom">
    <div class="container">
      <div class="row">
        <div class="span6"> Powered by Payez. </div>
        <div class="span6 textright"> Professionals on the Go! &copy; <?php echo date("Y"); ?> </div>
      </div>
    </div>
  </section>
  <a id="gotop" href="#">Back to top</a>
</footer>
<!-- javascript
    ================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<!--script src="js/jquery.js"></script-->
<script src="js/bootstrap.js"></script>
<script src="js/respond.min.js"></script>
<script src="js/application.js"></script>
<script src="js/bootstrap-tooltip.js"></script>
<script defer src="js/jquery.fancybox.js"></script>
<script defer src="js/jquery.flexslider.js"></script>
<script type="text/javascript" src="js/jquery.tweet.js"></script>
<script  src="js/cloud-zoom.1.0.2.js"></script>
<script  type="text/javascript" src="js/jquery.validate.js"></script>
<script type="text/javascript"  src="js/jquery.carouFredSel-6.1.0-packed.js"></script>
<script type="text/javascript"  src="js/jquery.mousewheel.min.js"></script>
<script type="text/javascript"  src="js/jquery.touchSwipe.min.js"></script>
<script type="text/javascript"  src="js/jquery.ba-throttle-debounce.min.js"></script>
<script defer src="js/custom.js"></script>
</body>
</html>