    $.event.special.hoverintent = {
    setup: function() {
      $( this ).bind( "mouseover", jQuery.event.special.hoverintent.handler );
    },
    teardown: function() {
      $( this ).unbind( "mouseover", jQuery.event.special.hoverintent.handler );
    },
    handler: function( event ) {
      var currentX, currentY, timeout,
        args = arguments,
        target = $( event.target ),
        previousX = event.pageX,
        previousY = event.pageY;
 
      function track( event ) {
        currentX = event.pageX;
        currentY = event.pageY;
      };
 
      function clear() {
        target
          .unbind( "mousemove", track )
          .unbind( "mouseout", clear );
        clearTimeout( timeout );
      }
 
      function handler() {
        var prop,
          orig = event;
 
        if ( ( Math.abs( previousX - currentX ) +
            Math.abs( previousY - currentY ) ) < 7 ) {
          clear();
 
          event = $.Event( "hoverintent" );
          for ( prop in orig ) {
            if ( !( prop in event ) ) {
              event[ prop ] = orig[ prop ];
            }
          }
          // Prevent accessing the original event since the new event
          // is fired asynchronously and the old event is no longer
          // usable (#6028)
          delete event.originalEvent;
 
          target.trigger( event );
        } else {
          previousX = currentX;
          previousY = currentY;
          timeout = setTimeout( handler, 100 );
        }
      }
 
      timeout = setTimeout( handler, 100 );
      target.bind({
        mousemove: track,
        mouseout: clear
      });
     }
    };
    
  function addMorePogoproQuote(user_id)
  { 
    var xmlhttp;
    if (window.XMLHttpRequest) 
    { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
    }else 
    { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    xmlhttp.onreadystatechange = function() 
    {
        if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {
         //document.getElementById(field).innerHTML = "Loading..";
        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        {
         var distance = 100;   
         var div_add_project_quote = document.getElementById("zone_add_project_quote");
         div_add_project_quote.innerHTML = xmlhttp.responseText;
         div_add_project_quote.style.display = ''; 
         
         $( "#slider-range-max" ).slider({
          range: "max",
          min: 1,
          max: 5,
          value: 3,
          slide: function( event, ui ) {
            $( "#amount" ).val( ui.value );
          }
        });
        $( "#amount" ).val( $( "#slider-range-max" ).slider( "value" ) );  
        }else 
        {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
    }
    xmlhttp.open("POST", "createProjectQuoteForm.php?pqid=0&uid="+user_id, false);
    xmlhttp.send();      
  }
  
  function cancelAddProjectQuote()
  {
     var div_add_project_quote = document.getElementById("zone_add_project_quote");
     div_add_project_quote.style.display = 'none';      
  }
  
  function AddProjectQuote()
  {
    var quote_name = document.getElementById("quote_name").value;
    var quote_desc = document.getElementById("quote_desc").value;
    var user_id    = document.getElementById("current_user_id").value;
    var start_date = document.getElementById("start_date").value;
    var start_rate = document.getElementById("start_rate").value;
    var language = document.getElementById("language").value;
    var distance_from = document.getElementById("distance_from").value;
    var deal_close_in_days = document.getElementById("deal_close_in_days").value;
    //alert(quote_name+","+quote_desc+","+start_date+","+start_rate+","+language)

    var div_add_project_quote = document.getElementById("zone_add_project_quote");
    div_add_project_quote.innerHTML ="";
    div_add_project_quote.style.display = 'none'; 
    
    var xmlhttp;
    if (window.XMLHttpRequest) 
    { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
    }else 
    { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    xmlhttp.onreadystatechange = function() 
    {
        if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {
         //document.getElementById(field).innerHTML = "Loading..";
        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        {
         $("#accordion").accordion("destroy");  
         //Get JSON Objects and show the map
         var response = xmlhttp.responseText; 
         var json_obj = JSON.parse(response);   
         var contents = json_obj.content_details;
         var accordions_group = (json_obj.accordions).split(",");
         var div_add_project_quote = document.getElementById("accordion");
         div_add_project_quote.innerHTML = contents;
         $("#accordion").accordion({
            heightStyle: "content",
            collapsible: true,
            active: 0     
         });
         count = accordions_group.length;
         for (var k=0;k<count;k++)
         {
          $(accordions_group[k]).accordion({
            heightStyle: "content",
            collapsible: true,
            active: 0     
          });             
         }
        }else 
        {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
    }

    xmlhttp.open("POST", "createProjectQuoteForm.php?pqid=-1&uid="+user_id+"&qname="+quote_name+"&qdesc="+quote_desc+"&sd="+start_date+"&sr="+start_rate+"&l="+language+"&df="+distance_from+"&dcid="+deal_close_in_days, false);
    xmlhttp.send();
  }
  /**
  * Function editProjectQuote
  * Purpose: edit information of project 
  * @returns {undefined}   */
  function editProjectQuote(project_quote_id)
  {    
    var xmlhttp;
    if (window.XMLHttpRequest) 
    { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
    }else 
    { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    xmlhttp.onreadystatechange = function() 
    {
        if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {
         //document.getElementById(field).innerHTML = "Loading..";
        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        {   
         var div_update_project_quote = document.getElementById("update_project_quote_"+project_quote_id);
         div_update_project_quote.innerHTML = xmlhttp.responseText;
         div_update_project_quote.style.display = ''; 
        }else 
        {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
    }
    xmlhttp.open("POST", "createProjectQuoteForm.php?pqid="+project_quote_id, false);
    xmlhttp.send();      
  }
  
  function UpdateProjectQuote()
  {  
    var quote_name = document.getElementById("quote_name").value;
    var quote_desc = document.getElementById("quote_desc").value;
    var quote_id = document.getElementById("current_project_quote_id").value;
    var user_id = document.getElementById("current_user_id").value;
    var start_date = document.getElementById("start_date").value;
    var start_rate = document.getElementById("start_rate").value;
    var language = document.getElementById("language").value;    

    var div_update_project_quote = document.getElementById("update_project_quote_"+quote_id);
    div_update_project_quote.innerHTML ="";
    div_update_project_quote.style.display = 'none'; 
    
    var xmlhttp;
    if (window.XMLHttpRequest) 
    { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
    }else 
    { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    xmlhttp.onreadystatechange = function() 
    {
        if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {
         //document.getElementById(field).innerHTML = "Loading..";
        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        {
         /*$("#accordion").accordion("destroy");  
         var div_add_project_quote = document.getElementById("accordion");
         div_add_project_quote.innerHTML = xmlhttp.responseText;
         $("#accordion").accordion({
            heightStyle: "content",
            collapsible: true,
            active: false      
         });*/
         $("#accordion").accordion("destroy");  
         //Get JSON Objects and show the map
         var response = xmlhttp.responseText; 
         var json_obj = JSON.parse(response);   
         var contents = json_obj.content_details;
         var accordions_group = (json_obj.accordions).split(",");
         var div_add_project_quote = document.getElementById("accordion");
         div_add_project_quote.innerHTML = contents;
         $("#accordion").accordion({
            heightStyle: "content",
            collapsible: true,
            active: 0     
         });
         count = accordions_group.length;
         for (var k=0;k<count;k++)
         {
          $(accordions_group[k]).accordion({
            heightStyle: "content",
            collapsible: true,
            active: 0     
          });             
         }            
        }else 
        {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
    }
    xmlhttp.open("POST", "createProjectQuoteForm.php?pqid=-2&uid="+user_id+"&qid="+quote_id+"&qname="+quote_name+"&qdesc="+quote_desc+"&sd="+start_date+"&sr="+start_rate+"&l="+language, false);
    xmlhttp.send();
  }  
  
  function cancelUpdateProjectQuote(project_quote_id)
  {
     var div_update_project_quote = document.getElementById("update_project_quote_"+project_quote_id);
     div_update_project_quote.style.display = 'none';       
  }
  
  function refreshProjectQuoteAccordion(accordion_new_innerHTML)
  {
    var accordionObject = document.getElementById("accordion");
    accordionObject.innerHTML = accordion_new_innerHTML;
    $('#accordion').accordion( "refresh" );        
  }
  
  function ShowConfirmMessageWithProjectQuoteRemove(member_id,project_quote_id)
  {   
   modalWin.Draggable = false;
   modalWin.Param1 = member_id;
   modalWin.Param2 = project_quote_id;
   modalWin.ShowConfirmationMessage('Are you sure to delete this project?',160,360,'Pogo.Pro Remove Project',null,'Yes',yesRemoveServiceAction,'No',noRemoveServiceAction);
  } 
    
  function yesRemoveServiceAction()
  {      
   modalWin.HideModalPopUp();
    var xmlhttp;
    if (window.XMLHttpRequest) 
    { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
    }else 
    { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    xmlhttp.onreadystatechange = function() 
    {
        if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {
         //document.getElementById(field).innerHTML = "Loading..";
        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        {
         /*$("#accordion").accordion("destroy");  
         var div_add_project_quote = document.getElementById("accordion");
         div_add_project_quote.innerHTML = xmlhttp.responseText;
         $("#accordion").accordion({
            heightStyle: "content",
            collapsible: true,
            active: false      
         });*/
         $("#accordion").accordion("destroy");  
         //Get JSON Objects and show the map
         var response = xmlhttp.responseText; 
         var json_obj = JSON.parse(response);   
         var contents = json_obj.content_details;
         var accordions_group = (json_obj.accordions).split(",");
         var div_add_project_quote = document.getElementById("accordion");
         div_add_project_quote.innerHTML = contents;
         $("#accordion").accordion({
            heightStyle: "content",
            collapsible: true,
            active: 0     
         });
         count = accordions_group.length;
         for (var k=0;k<count;k++)
         {
          $(accordions_group[k]).accordion({
            heightStyle: "content",
            collapsible: true,
            active: 0     
          });             
         }            
        }else 
        {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
    }
    xmlhttp.open("POST", "createProjectQuoteForm.php?pqid=-3&uid="+modalWin.Param1+"&qid="+modalWin.Param2, false);
    xmlhttp.send();   
  }

  function noRemoveServiceAction()
  {
   modalWin.HideModalPopUp();
  } 
  
  function manageMyQuoteDetails(project_quote_id)
  {
    document.location.assign("pogoproQuote.php?pqid="+project_quote_id);  
  }
  
    function refreshGoogleMaps()
    {  
     var xmlhttp;
     if (window.XMLHttpRequest) 
     { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
     }else 
     { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
     }
     xmlhttp.onreadystatechange = function() 
     {
        if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {
         //document.getElementById(field).innerHTML = "Loading..";
        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        {
         //Get JSON Objects and show the map
         var response = xmlhttp.responseText; 

         var json_obj = JSON.parse(response);
         //ID array
         var merchants_id_array = (json_obj.merchants_id).split(",");
         //NAME array
         var merchants_name_array = (json_obj.merchants_name).split(",");  
         //User GPS Array
         var gps_center = (json_obj.gps_center).split(",");
         var geoCenter_lat = gps_center[0];
         var geoCenter_long = gps_center[1];         
         //Merchant GPS Lat array
         var gps_lat_mercants = (json_obj.gps_lat_merchants).split(",");
         //Merchant GPS Long array
         var gps_long_mercants = (json_obj.gps_long_merchants).split(",");
         //
         count = merchants_id_array.length;
         for (var k=0;k<count;k++)
         {
             var map_object = document.getElementById("map_canvas_"+merchants_id_array[k]);
             var mapCanvas = new google.maps.Map(map_object);
             var mapCenter = new google.maps.LatLng(geoCenter_lat,geoCenter_long);
             
             mapCanvas.setCenter(mapCenter);
             mapCanvas.setZoom(16);
             mapCanvas.setMapTypeId(google.maps.MapTypeId.ROADMAP);
             
             var initPos = new google.maps.LatLng(gps_lat_mercants[k],gps_long_mercants[k]);
             var infoWnd = new google.maps.InfoWindow({
                content :  merchants_name_array[k],
                maxWidth: 100
              }); 
             var marker = new google.maps.Marker({
                position : initPos,
                map : mapCanvas,
                clickable : true
              });
             infoWnd.open(null, marker);
             google.maps.event.trigger(mapCanvas, 'resize');
         }         
        }else 
        {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
    }
    xmlhttp.open("POST", "bestProSearchOfProjectManager.php?op=1&uid=91&pno=1&pmax=20", false);
    xmlhttp.send();     
    }
    
    function showListOfBestPro(project_quote_id)
    {
        var xmlhttp;
        if (window.XMLHttpRequest) 
        { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
        }else 
        { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlhttp.onreadystatechange = function() 
        {
        if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {
         //document.getElementById(field).innerHTML = "Loading..";
        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        { 
           
         var response = xmlhttp.responseText; 
         //alert(response);
         var json_obj = JSON.parse(response);

         var accordions = json_obj.accordions;
         var tabs = json_obj.tabs;
         var content = json_obj.content;
         //alert(content);
         var merchants = json_obj.merchants;
         //alert(merchants);
         var gps_data_lat = json_obj.gps_data_lat;
         //alert(gps_data_lat);
         var gps_data_long = json_obj.gps_data_long;  
         //alert(gps_data_long);
         var accordion_id = "#accordion_"+project_quote_id;
         //alert(accordion_id);
         
         //$( accordion_id ).accordion("destroy");
         var zone_show_pro_list = document.getElementById("show_pro_list_zone_"+project_quote_id);
         zone_show_pro_list.style.display = '';
         var zone_add_construction_object = document.getElementById("accordion_"+project_quote_id);
         zone_add_construction_object.innerHTML = content;
         zone_add_construction_object.style.display = '';
         
         $( accordion_id ).accordion({
            heightStyle: "content",
            collapsible: true
            //active: false           
         });
         
        var icons = {
            header: "ui-icon-circle-arrow-e",
            activeHeader: "ui-icon-circle-arrow-s"
        };
        $( accordion_id ).accordion({
        icons: icons
        });
        
        $('h3').click(function () {
            refreshGoogleMaps();
        });
        
        var ui_header = "#accordion_"+project_quote_id+" .ui-accordion-header";
        var ui_content = "#accordion_"+project_quote_id+" .ui-accordion-content";
        var accordion_checkbox = "#accordion_"+project_quote_id+" input[type='checkbox']";
        
         $(ui_header).css({display:"block",background:"transparent", width:"800px",margin:"0px",border:"4px solid #66ccff"});
         $(ui_content).css({background:"white", width:"800px"});
         $(accordion_checkbox).click(function(e) {
          e.stopPropagation();
         });                  
         
         var array_accordions = accordions.split(",");
         var count = array_accordions.length;
         for (var i=0;i<count;i++)
         {
            $( array_accordions[i] ).accordion({ 
              heightStyle: "content"
            });
         }
         var array_tabs = tabs.split(",");
         count = array_tabs.length;
         for (var i=0;i<count;i++)
         {
           $( array_tabs[i] ).tabs();            
         } 
                
         //show the map         
         var geoCenter_lat = 45.50867; 
         var geoCenter_long = -73.553992;
         var lats = gps_data_lat.split(",");
         var longs = gps_data_long.split(",");
         var array_merchants = merchants.split(",");
         count = array_merchants.length; 
         
         for (var k=0;k<count;k++)
         {
             var map_object = document.getElementById("map_canvas_"+array_merchants[k]);
             var mapCanvas = new google.maps.Map(map_object);
             var mapCenter = new google.maps.LatLng(geoCenter_lat,geoCenter_long);
             
             mapCanvas.setCenter(mapCenter);
             mapCanvas.setZoom(16);
             mapCanvas.setMapTypeId(google.maps.MapTypeId.ROADMAP);
             
             var initPos = new google.maps.LatLng(lats[k],longs[k]);
             var infoWnd = new google.maps.InfoWindow({
                content :  "United "+k,
                maxWidth: 100
              }); 
             var marker = new google.maps.Marker({
                position : initPos,
                map : mapCanvas,
                clickable : true
              });
             infoWnd.open(null, marker); 
             google.maps.event.trigger(mapCanvas, 'resize');
         }
        }else 
        {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
        }
        xmlhttp.open("POST", "bestProSearchOfProjectManager.php?op=0", false);
        xmlhttp.send();         
    }
    
    function cancelPostProject(project_quote_id)
    {
     var accordion_id = "#accordion_"+project_quote_id;
     $( accordion_id ).accordion("destroy");
     var zone_add_construction_object = document.getElementById("accordion_"+project_quote_id);
     zone_add_construction_object.innerHTML = '';
     zone_add_construction_object.style.display = 'none';        
     var obj_zone_show_pros_list = document.getElementById("show_pro_list_zone_"+project_quote_id); 
     obj_zone_show_pros_list.style.display = 'none';
    }
    
    function postMyProject(project_quote_id)
    {
     var current_user_id = document.getElementById('current_user_id').value;
     // Get the list of pros list
     var cboxes = document.getElementsByName('invite_check[]');     
     var len = cboxes.length;
     var item_ids = "";
     for (var i=0; i<len; i++) 
     {
      if (cboxes[i].checked) item_ids += cboxes[i].value+",";
     } 
     item_ids = item_ids.substr(0,item_ids.length-1);
     //Call AJAX to post project
    var xmlhttp;
    if (window.XMLHttpRequest) 
    { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
    }else 
    { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    xmlhttp.onreadystatechange = function() 
    {
     if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
     {
      //document.getElementById(field).innerHTML = "Loading..";
     }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
     {
       //(xmlhttp.responseText);  
       $("#accordion").accordion("destroy");  
       var div_add_project_quote = document.getElementById("accordion");
       div_add_project_quote.innerHTML = xmlhttp.responseText;
       $("#accordion").accordion({
         heightStyle: "content",
         collapsible: true,
         active: false      
      });
     }else 
     {
      //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
     }
    }
     xmlhttp.open("POST", "bestProSearchOfProjectManager.php?op=2&uid="+current_user_id+"&pqid="+project_quote_id+"&pros="+item_ids, false);
     xmlhttp.send();            
    }
    
    function buildContructionProjectOffer(project_bid_id,root)
    { 
      document.location.assign("pogoproBidMaker.php?pbid="+project_bid_id+"&root="+root);          
    }
    /**
    * Function submitConstructionOffer
    * @param {type} project_bid_id
    * @returns {undefined}     
    * */
    function submitContructionProjectOffer(project_bid_id)
    {
        //alert(9999);
        var obj_current_owner = document.getElementById("current_user_id");
        var project_owner = obj_current_owner.value;
        var xmlhttp;
        if (window.XMLHttpRequest) 
        { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
        }else 
        { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlhttp.onreadystatechange = function() 
        {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //refresh content of pogoproQuoteManager
          /*var response = xmlhttp.responseText; 
          var json_obj = JSON.parse(response); 
          var contents = json_obj.content_details;
          var accordions_group = (json_obj.accordions).split(",");
          var zone_accordion = document.getElementById("accordion");
          zone_accordion.innerHTML = contents;*/
          //var response = xmlhttp.responseText; 
          //alert(response);
        /* $("#accordion").accordion("destroy");  
         //Get JSON Objects and show the map
         var response = xmlhttp.responseText; 
         var json_obj = JSON.parse(response);   
         var contents = json_obj.content_details;
         var accordions_group = (json_obj.accordions).split(",");
         var div_add_project_quote = document.getElementById("accordion");
         div_add_project_quote.innerHTML = contents;
         $("#accordion").accordion({
            heightStyle: "content",
            collapsible: true,
            active: 0     
         });
         count = accordions_group.length;
         for (var k=0;k<count;k++)
         {
          $(accordions_group[k]).accordion({
            heightStyle: "content",
            collapsible: true,
            active: 0     
          });             
         } */
          var response = xmlhttp.responseText; 
          var json_obj = JSON.parse(response);   
          var status = json_obj.status;
          if (status==='1')
          {
           document.getElementById("btn_submit_offer_"+project_bid_id).style.display = 'none';   
          }
          var div_show_submit_message = document.getElementById("div_show_submit_message_"+project_bid_id);
          div_show_submit_message.style.display = '';
          var message_show_zone = document.getElementById("message_submit_offer_"+project_bid_id);
          message_show_zone.innerHTML = json_obj.show_message;
          message_show_zone.style.display = ''; 
          setTimeout(hideSubmitOfferMessage, 5000,project_bid_id);
         }else 
         {
         }
        }
        var formData = new FormData();
        formData.append("op",3);
        formData.append("pbid",project_bid_id);
        formData.append("poid",project_owner);
        xmlhttp.open("POST", "bestProSearchOfProjectManager.php", false);
        xmlhttp.send(formData);          
    } 
    /**
    * Function zone of project bids management 
    */
 function hideSubmitOfferMessage(project_bid_id)
 {
   var div_show_submit_message = document.getElementById("div_show_submit_message_"+project_bid_id);
   div_show_submit_message.style.display = 'none';
   var message_show_zone = document.getElementById("message_submit_offer_"+project_bid_id);
   message_show_zone.innerHTML = "";
   message_show_zone.style.display = 'none';      
 }
   
 function changeBid(project_id)
 {
  //alert("Change Preferred Bid");   
  var obj_project_bid_selector = document.getElementById("project_bid_"+project_id);
  var bid_id = obj_project_bid_selector.value;
  //alert("Bid:"+bid_id);

  //Call AJAX to set member preferred bid and get the owner of project and bidder's ID
   var xmlhttp;
   if (window.XMLHttpRequest) 
   { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
   }else 
   { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
   }
   xmlhttp.onreadystatechange = function() 
   {
     if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
     {
      //document.getElementById(field).innerHTML = "Loading..";
     }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
     {
      var response = xmlhttp.responseText;
      var json_obj = JSON.parse(response);
      var project_owner = json_obj.project_owner;
      var project_bidder = json_obj.project_bidder;
      //alert("Owner:"+project_owner+",Bidder:"+project_bidder);
      
      var obj_start = document.getElementById("start_"+project_id);
      var obj_message = document.getElementById("message_"+project_id);
      var obj_showdetails = document.getElementById("show_details_"+project_id); 
      
      var new_innerHTML_start = "<img src='projectmanager_icons/start_icon.gif' style='width:48px;height:48px;' onclick='actionOnStart("+project_id+","+bid_id+")'>";
      var new_innerHTML_message = "<img src='projectmanager_icons/message_icon.png' style='width:48px;height:48px;' onclick='actionOnMessage("+project_id+","+project_owner+","+project_bidder+")'>";
      var new_innerHTML_showdetails = "<img src='projectmanager_icons/details_icon.png' style='width:48px;height:48px;' onclick='actionOnShowDetails("+project_id+","+bid_id+")'>";

      obj_start.innerHTML = new_innerHTML_start;
      obj_message.innerHTML = new_innerHTML_message;
      obj_showdetails.innerHTML = new_innerHTML_showdetails;       
     }else 
     {
      //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
     }
   }
   var formData = new FormData();
   formData.append("op",4);
   formData.append("pid",project_id);
   formData.append("pbid",bid_id);
   xmlhttp.open("POST", "pogoproMessagemanager.php", false);
   xmlhttp.send(formData);    
 }
 /*
 function  actionOnStart(project_id,project_bid_id)
 {
  alert("Welcome to start project:"+project_id+", on bid:"+project_bid_id);
  
 }*/
 /**
  * Show Bid details
  * @param {type} project_id
  * @param {type} sender_id
  * @param {type} receiver_id
  * @returns {undefined}
  */
 function  actionOnShowDetails(project_id,project_bid_id)
 {
   //alert("Welcome to show details of project:"+project_id+", on bid:"+project_bid_id); 
   var xmlhttp;
   if (window.XMLHttpRequest) 
   { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
   }else 
   { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
   }
   xmlhttp.onreadystatechange = function() 
   {
     if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
     {
      //document.getElementById(field).innerHTML = "Loading..";
     }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
     {
      var response = xmlhttp.responseText;
      var json_obj = JSON.parse(response);

      var quote_cost = (json_obj.quote_cost).split(",");//response.indexOf("{");
      //document.getElementById("quote_material_cost").innerHTML = (parseFloat(quote_cost[0])).toFixed(2);     
      //document.getElementById("quote_labor_cost").innerHTML = (parseFloat(quote_cost[1])).toFixed(2);          
      //document.getElementById("quote_total_cost").innerHTML = (parseFloat(quote_cost[0])+parseFloat(quote_cost[1])).toFixed(2);         
      var accordions = json_obj.accordions;//response.substring(index+1,response.length-2);
      response = json_obj.quote_details;//response.substring(0,index); 
      //alert(response);

      var zone_add_construction_object = document.getElementById("show_bid_zone_"+project_id);
      var table_bid_details = document.getElementById("table_bid_details_"+project_id);
      table_bid_details.style.display = '';
      var bid_material_cost = document.getElementById("material_cost_"+project_id);
      bid_material_cost.innerHTML = "Material Cost:"+(parseFloat(quote_cost[0])).toFixed(2); 
      var bid_labor_cost = document.getElementById("labor_cost_"+project_id);
      bid_labor_cost.innerHTML = "Labor Cost:"+(parseFloat(quote_cost[1])).toFixed(2);
      var zone_bid_details = document.getElementById("bid_details_"+project_id);
      zone_bid_details.innerHTML = response;
      //zone_add_construction_object.innerHTML = response;
      zone_add_construction_object.style.display = '';
      var array_accordions = accordions.split(",");
      var count = array_accordions.length;
      for (var i=0;i<count;i++)
      {
        $( array_accordions[i] ).accordion({ 
          heightStyle: "content"
        });           
      }      
     }else 
     {
      //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
     }
   }
   var formData = new FormData();
   formData.append("op",3);
   formData.append("pid",project_id);
   formData.append("pbid",project_bid_id);
   xmlhttp.open("POST", "pogoproMessagemanager.php", false);
   xmlhttp.send(formData);  
 }
 
 function closeBidDetails(project_id)
 {
   var zone_add_construction_object = document.getElementById("show_bid_zone_"+project_id);
   zone_add_construction_object.style.display = 'none';
   var table_bid_details = document.getElementById("table_bid_details_"+project_id); 
   table_bid_details.style.display = 'none';
   var bid_material_cost = document.getElementById("material_cost_"+project_id);
   bid_material_cost.innerHTML = ""; 
   var bid_labor_cost = document.getElementById("labor_cost_"+project_id);
   bid_labor_cost.innerHTML = "";
   var zone_bid_details = document.getElementById("bid_details_"+project_id);
   zone_bid_details.innerHTML = "";   
 }
 
 function pressEnterKeySendMessage(project_id,sender_id,receiver_id)
 {
  if (event.keyCode == 13)
  { 
   sendMessage(project_id,sender_id,receiver_id);   
  }
 }
  /**
   * Pogopro chat message system functions
   */
 function sendMessage(project_id,sender_id,receiver_id)
 {  
  var sendMessage_content = document.getElementById("message_area").value; 
  if (sendMessage_content.length===0)
  {
      document.getElementById("message_area").value ='';
      //alert("clear textarea");
      return;
  }
  stopRefreshMessageLogTimer();
  //Store into database
  var xmlhttp;
  if (window.XMLHttpRequest) 
   { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
   }else 
   { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
   }
   xmlhttp.onreadystatechange = function() 
   {
     if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
     {
      //document.getElementById(field).innerHTML = "Loading..";
     }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
     {
      var response = xmlhttp.responseText; 
      var json_obj = JSON.parse(response); 
      //alert(json_obj.chat_owner);
      var chatBox = document.getElementById("chat_message_list");
      var append_message_logs = json_obj.message_log_append;
      if (append_message_logs.length>0)
      {   
       var newInnerHtml = chatBox.innerHTML + append_message_logs;
       chatBox.innerHTML = newInnerHtml;
       //scroll to bottom of message list
       var div_chat_box = document.getElementById("messages");
       div_chat_box.scrollTop = div_chat_box.scrollHeight;
       document.getElementById("message_area").value = '';
      }
      lastMessageId = json_obj.last_message_id;      
      pogoproRefreshMessageLogTimer = setInterval(function(){ refreshMessageLogTimer(project_id,sender_id,receiver_id) }, 5000);      
     }else 
     {
      //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
     }
   }
   var formData = new FormData();
   formData.append("op",0);
   formData.append("project_id",project_id);
   formData.append("senderId",sender_id);
   formData.append("receiverId",receiver_id);
   formData.append("sendMessage",sendMessage_content);
   formData.append("lastMessageId",lastMessageId);
   xmlhttp.open("POST", "pogoproMessagemanager.php", false);
   xmlhttp.send(formData);   
 } 
 
 var pogoproRefreshMessageLogTimer;
 var lastMessageId = -1;

 function refreshMessageLogTimer(project_id,sender_id,receiver_id) 
 {
  var xmlhttp;
  if (window.XMLHttpRequest) 
   { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
   }else 
   { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
   }
   xmlhttp.onreadystatechange = function() 
   {
     if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
     {
      //document.getElementById(field).innerHTML = "Loading..";
     }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
     {
      //insert message list into chat box  
      var response = xmlhttp.responseText; 
      var json_obj = JSON.parse(response); 
      var chatBox = document.getElementById("chat_message_list");
      var append_message_logs = json_obj.message_log_append;
      if (append_message_logs.length>0)
      {
       //alert(json_obj.chat_owner);  
       chatBox.innerHTML = chatBox.innerHTML + append_message_logs;
       //scroll to bottom of message list
       var div_chat_box = document.getElementById("messages");
       div_chat_box.scrollTop = div_chat_box.scrollHeight;  
      }
      lastMessageId = json_obj.last_message_id;
      //pogoproRefreshMessageLogTimer = setInterval(function(){ refreshMessageLogTimer() }, 5000);
     }else 
     {
      //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
     }
   }
   var formData = new FormData();
   formData.append("op",2);
   formData.append("project_id",project_id);
   formData.append("senderId",sender_id);
   formData.append("receiverId",receiver_id);
   formData.append("lastMessageId",lastMessageId);
   xmlhttp.open("POST", "pogoproMessagemanager.php", false);
   xmlhttp.send(formData);   
 }

 function stopRefreshMessageLogTimer() {
    clearInterval(pogoproRefreshMessageLogTimer);
 }
 /**
  * 
  * @param {type} project_id
  * @param {type} sender_id : (project owner)
  * @param {type} receiver_id (project bidder)
  * @returns {undefined}
  */
 function actionOnMessage(project_id,sender_id,receiver_id)
 {   
  var xmlhttp;
  if (window.XMLHttpRequest) 
   { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
   }else 
   { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
   }
   xmlhttp.onreadystatechange = function() 
   {
     if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
     {
      //document.getElementById(field).innerHTML = "Loading..";
     }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
     {
      //insert message list into chat box  
      var response = xmlhttp.responseText; 
      var json_obj = JSON.parse(response); 
      //alert(json_obj.message_log);
      
      var chatBox = document.getElementById("chat_message_"+project_id); 
      if (chatBox===null)
      {
          chatBox = document.getElementById("zone_change_management_"+project_id);
          if (chatBox===null)
              chatBox = document.getElementById("leads_chat_zone_"+project_id);
      } 
      
      chatBox.innerHTML = json_obj.message_log;
      chatBox.style.width = "";
      chatBox.style.display='';
      //scroll to bottom of message list
      var div_chat_box = document.getElementById("messages");
      div_chat_box.scrollTop = div_chat_box.scrollHeight;  
      lastMessageId = json_obj.last_message_id;
      pogoproRefreshMessageLogTimer = setInterval(function(){ refreshMessageLogTimer(project_id,sender_id,receiver_id) }, 5000);
     }else 
     {
      //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
     }
   }
   var formData = new FormData();
   formData.append("op",1);
   formData.append("project_id",project_id);
   formData.append("senderId",sender_id);
   formData.append("receiverId",receiver_id);
   xmlhttp.open("POST", "pogoproMessagemanager.php", false);
   xmlhttp.send(formData);     
 }
 
 function closeChatMessage(project_id)
 {
  //var chatBox = document.getElementById("chat_message_"+project_id);
  var chatBox = document.getElementById("chat_message_"+project_id); 
  if (chatBox===null)
  {
      chatBox = document.getElementById("zone_change_management_"+project_id);
      if (chatBox===null)
          chatBox = document.getElementById("leads_chat_zone_"+project_id);
  }  
  chatBox.innerHTML = '';
  chatBox.style.display = 'none';
  stopRefreshMessageLogTimer();
 } 
  /*
  * Functions for in progress Project images 
  */
 function actionOnProjectImages(project_id,owner_id,owner_role)
 {   
  var xmlhttp;
  if (window.XMLHttpRequest) 
   { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
   }else 
   { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
   }
   xmlhttp.onreadystatechange = function() 
   {
     if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
     {
      //document.getElementById(field).innerHTML = "Loading..";
     }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
     {  
      //insert message list into chat box  
      var response = xmlhttp.responseText;

      var json_obj = JSON.parse(response);
      //var zone_project_image = document.getElementById("zone_project_images_"+project_id);
      var zone_project_image = document.getElementById("zone_change_management_"+project_id);
      zone_project_image.style.display = '';
      zone_project_image.style.width = "98%";
      zone_project_image.innerHTML = json_obj.imagelist;
      var div_upload_image = document.getElementById("img-upload-"+project_id);
      div_upload_image.style.display='';
      div_upload_image.innerHTML = json_obj.uploader;
     }else 
     {
      //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
     }
   }
   var formData = new FormData();
   formData.append("op",0);
   formData.append("pid",project_id);
   formData.append("oid",owner_id);
   formData.append("role",owner_role);
   xmlhttp.open("POST", "inProgressProjectManager.php", false);
   xmlhttp.send(formData);       
  }
  
  function cancelAddPictureToProject(project_id)
  {
    var div_upload_image = document.getElementById("img-upload-"+project_id);
    div_upload_image.style.display='none'; 
    div_upload_image.innerHTML ="";
  }
  
  function eventOnInputImagaDesc()
  {
   document.getElementById("error_image_desc").style.display = 'none';    
  }
  
  function showImagePreview()
  {
   document.getElementById("error_image_select").style.display = 'none';    
   var upload_msg = document.getElementById("upload-msg");
   upload_msg.innerHTML = "";   
   var fileSelect = document.getElementById("userImage");
   var files = fileSelect.files;
   var file = files[0];
   var previewImg = document.getElementById("draggable");
   var reader = new FileReader();
   reader.onload = function(e)
    {
      previewImg.innerHTML = "<img src='" + e.target.result + "' />";				
    };
    reader.readAsDataURL(file);   
  }
  
  function addImageOfProject(project_id,owner_id,owner_role)
  {
    var image_desc = document.getElementById("image_desc");  
    if (image_desc.value.length<1)
    {
     document.getElementById("error_image_desc").style.display = '';   
     return;        
    }
    //alert(image_desc.value);
    var form = document.getElementById("file-form");
    var fileSelect = document.getElementById("userImage");
    if (fileSelect.value.length<4)
    {
     document.getElementById("error_image_select").style.display = '';   
     return;   
    }    
 
    var uploadButton = document.getElementById("upload-button");
    var files = fileSelect.files;
      
    // Create a new FormData object.
    var formData = new FormData(form);
    var file = files[0];
    var upload_msg = document.getElementById("upload-msg");
    upload_msg.innerHTML = "";
    //var item_id = document.getElementById("item_id").value;
    
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
          {
           uploadButton.innerHTML = 'Uploading...';
          }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
          {
           uploadButton.innerHTML = 'Upload' ;
           var response = xmlhttp.responseText; 
           var json_obj = JSON.parse(response);
           upload_msg.innerHTML = json_obj.status;
           //var div_upload_image = document.getElementById("zone_project_images_"+project_id);
           var div_upload_image = document.getElementById("zone_change_management_"+project_id);
           div_upload_image.innerHTML = json_obj.imagelist;                        
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
      xmlhttp.upload.addEventListener("progress", progressHandler, false);
      xmlhttp.addEventListener("load", completeHandler, false);
        // Add the file to the request.
      var formData = new FormData();  
      formData.append('op',1);  
      formData.append('image', file);
      formData.append('pid', project_id);
      formData.append("oid",owner_id);
      formData.append("role",owner_role);
      formData.append('image_desc', image_desc.value);          
      xmlhttp.open("POST", "inProgressProjectManager.php", false);
      xmlhttp.send(formData);    
  }
  
  function _(el)
  {
    return document.getElementById(el);
  }  
  
  function progressHandler(event)
  {
    //_("loaded_n_total").innerHTML = "Uploaded "+event.loaded+" bytes of "+event.total;
    var percent = (event.loaded / event.total) * 100;
    //alert(Math.round(percent));
    _("progressBar").value = Math.round(percent);
    _("status").innerHTML = Math.round(percent)+"%";
  }
  function completeHandler(event)
  {
   //_("status").innerHTML = event.target.responseText;
   //_("progressBar").value = 0;
   //cancelAddPictureToItem()
  }  
  
  function showLargeImage(item_id,item_pic_id,item_image_name)
  {  
   var show_large_image_zone = document.getElementById("imgContainer_"+item_id);  
   show_large_image_zone.style.display='';

   var item_pic = document.getElementById("project_pic_"+item_pic_id);
   var image_desc = document.getElementById("title_image_"+item_id);

   image_desc.style.display ='';
   var new_html = "<table border='0' style='width:800px;margin-bottom:-16px;'>";
       new_html +="<tr>";
       new_html +="<td align='center' style='width:95%'><h2>"+item_pic.title+"</h2></td>";   
       new_html +="<td style='width:5%;padding-left:0px;background-color:transparent;margin-bottom: 0px;' align='right'><img style='margin-left: -32px;margin-top: 0px;width:24px;height:24px;' src='projectmanager_icons/btnClose.gif' onclick='hideLargeImageZone("+item_id+");'></td>";    
       new_html +="</tr>";
       new_html +="</table>";
    image_desc.innerHTML = new_html;
    new_image_html ="<img style='position:relative;top:0px;left:0px;' id='imgMy' src='pogopro_renovation/Project_images/"+item_image_name+"'/>"; 
    show_large_image_zone.innerHTML = new_image_html; 
    $( "#imgMy" ).draggable({
        drag: function( event, ui ) {
            //$("#locationX").val($("#imgMy").css('left'));
            //$("#locationY").val($("#imgMy").css('top'));
        }
    });
  }
  
  function hideLargeImageZone(item_id)
  {
   var show_large_image_zone = document.getElementById("imgContainer_"+item_id); 
   show_large_image_zone.innerHTML = '';
   show_large_image_zone.style.display='none';
   var image_desc = document.getElementById("title_image_"+item_id);
   image_desc.innerHTML ='';
   image_desc.style.display ='';   
  } 
  
  function removePictureFromProject(image_id,project_id,owner_id,owner_role)
  {
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
          {
           
          }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
          {
           var response = xmlhttp.responseText; 
           //var div_upload_image = document.getElementById("zone_project_images_"+project_id);
           var div_upload_image = document.getElementById("zone_change_management_"+project_id);
           div_upload_image.innerHTML = response;                        
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append('op',2);  
      formData.append('imgid', image_id);
      formData.append('pid', project_id);
      formData.append("oid",owner_id);
      formData.append("role",owner_role);
      xmlhttp.open("POST", "inProgressProjectManager.php", false);
      xmlhttp.send(formData);      
  }
  /*
   * Functions for start page
   */
 function hideWarningOfServiceTerms(project_id)
 {
  var warning_of_terms = document.getElementById("warning_of_terms_service_"+project_id);
  warning_of_terms.style.display = 'none';
 }
 
 function /*showStartPage*/actionOnStart(project_id,project_bid_id)
 {
  var xmlhttp;
  if (window.XMLHttpRequest) 
   { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
   }else 
   { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
   }
   xmlhttp.onreadystatechange = function() 
   {
     if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
     {
      //document.getElementById(field).innerHTML = "Loading..";
     }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
     {
      //insert message list into chat box  
      var response = xmlhttp.responseText; 
      var json_obj = JSON.parse(response); 
      var zone_project_details = document.getElementById("zone_project_details_"+project_id);
      zone_project_details.innerHTML = json_obj.project_task;
      zone_project_details.style.display = '';
      var zone_terms_of_service = document.getElementById("zone_terms_of_service_"+project_id);
      zone_terms_of_service.innerHTML = json_obj.serviceTerms;              
      zone_terms_of_service.style.display = '';
     }else 
     {
      //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
     }
   }
   var formData = new FormData();
   formData.append("op",5);
   formData.append("pid",project_id);
   formData.append("pbid",project_bid_id);
   xmlhttp.open("POST", "pogoproMessagemanager.php", false);
   xmlhttp.send(formData);      
 }
 
 function hideStartPageZone(project_id)
 {
  var zone_project_details = document.getElementById("zone_project_details_"+project_id);
  zone_project_details.style.display = 'none';
  var zone_terms_of_service = document.getElementById("zone_terms_of_service_"+project_id);            
  zone_terms_of_service.style.display = 'none';     
 }
 
 function addToShoppingCart(project_id,project_bid_id)
 {
  var agree_with_terms = document.getElementById("agree_service_terms_"+project_id+"_"+project_bid_id); 
  if (agree_with_terms.checked)
  {
    var zone_project_details = document.getElementById("zone_project_details_"+project_id);
    zone_project_details.style.display = 'none';
    var zone_terms_of_service = document.getElementById("zone_terms_of_service_"+project_id);            
    zone_terms_of_service.style.display = 'none'; 
    var content_of_payment_method = "<table border=\"0\" style=\"width:100%\">"
           +"<tr>"
           +"<td aling=\"center\"><label>Please select your payment method:</label></td>"   
           +"</tr>" 
           +"<tr>"
           +"<td aling=\"center\">"
           //<label class=\"radio-inline\"><input type=\"radio\" value=\"1\" name=\"payment_method\" style=\"width:16px;height:16p\" checked>ACH</label>
           +"<label class=\"radio-inline\"><input type=\"radio\" value=\"2\" name=\"payment_method\" style=\"width:16px;height:16px;\">Cheque</label></td>"               
           +"</tr>" 
           +"<tr>"
           +"<td><label></label></td>"   
           +"</tr>" 
           +"<tr>"
           +"<td><label></label></td>"   
           +"</tr>" 
           +"<tr>"
           +"<td><label></label></td>"   
           +"</tr>" 
           +"<tr>"
           +"<td><label></label></td>"   
           +"</tr>"            
           +"<tr>"
           +"<td aling=\"center\"><img src=\"projectmanager_icons/btn_checkout.gif\" style=\"width: 84px;height: 28px;\" onClick=\"checkout("+project_id+","+project_bid_id+");\">&nbsp;&nbsp;&nbsp;<img src=\"projectmanager_icons/btnCancel.gif\" style=\"width: 68px;height: 28px;\" onClick=\"checkoutCancel("+project_id+","+project_bid_id+");\"></td>"
           +"</tr>"
       +"</table>";
       var zone_payment_mthod = document.getElementById("payment_method_"+project_id);
       zone_payment_mthod.innerHTML = content_of_payment_method;
       zone_payment_mthod.style.display = '';
  }else
  {
     var warning_of_terms = document.getElementById("warning_of_terms_service_"+project_id);
     warning_of_terms.style.display = '';   
  }
 }
 function checkoutCancel(project_id,project_bid_id)
 {
  var zone_payment_mthod = document.getElementById("payment_method_"+project_id);
  zone_payment_mthod.innerHTML = '';
  zone_payment_mthod.style.display = 'none';
 }
 
 function closeDialog()
 {
  $( "#dialog_message" ).dialog( "close" );  
 }
 
 function checkout(project_id,project_bid_id)
 {
  var radios = document.getElementsByName("payment_method");
  var payment_mthod = 0;
  for (var i = 0; i < radios.length; i++) {       
    if (radios[i].checked) {
        payment_mthod = radios[i].value;
        break;
    }
   }
  //Call AJAX to change status of project. 
  var xmlhttp;
  if (window.XMLHttpRequest) 
   { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
   }else 
   { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
   }
   xmlhttp.onreadystatechange = function() 
   {
     if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
     {
      //document.getElementById(field).innerHTML = "Loading..";
     }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
     {
      //refresh the content of project manager 
      $( "#dialog_message" ).html("The agreement has been accepted and send to pro");
      $( "#dialog_message" ).dialog( "open" );
      setTimeout(closeDialog, 5000);
      $("#accordion").accordion("destroy");  
      //Get JSON Objects and show the map
      var response = xmlhttp.responseText; 
      console.log(response);
      var json_obj = JSON.parse(response);   
      var contents = json_obj.content_details;
      var accordions_group = (json_obj.accordions).split(",");
      var div_add_project_quote = document.getElementById("accordion");
      div_add_project_quote.innerHTML = contents;
      $("#accordion").accordion({
        heightStyle: "content",
        collapsible: true,
        active: 0     
      });
      count = accordions_group.length;
      for (var k=0;k<count;k++)
      {
      $(accordions_group[k]).accordion({
        heightStyle: "content",
        collapsible: true,
        active: 0     
      });             
     }      
     }else 
     {
      //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
     }
   }
   var formData = new FormData();
   formData.append("op",6);
   formData.append("pid",project_id);
   formData.append("pbid",project_bid_id);
   formData.append("payment_method",payment_mthod)
   xmlhttp.open("POST", "pogoproMessagemanager.php", false);
   xmlhttp.send(formData);  
 }
  
  var saved_details_row = 0;
  function showProjectChange(project_change_id,change_status)
  {   
      if (project_change_id!== saved_details_row && saved_details_row >0 )
         {
           document.getElementById("details_"+saved_details_row).style.display = 'none';
         }
      saved_details_row = project_change_id;

      var details_row = document.getElementById("details_"+project_change_id);
      if (details_row.style.display==='')
      {
        details_row.style.display = 'none';
        details_row.innerHTML = '';
        var arrow = "#row_project_change_"+project_change_id;
        $(arrow).removeClass("fa fa-angle-up");
        $(arrow).addClass("fa fa-angle-down");
      }
      else
      {  
         //CALL AJAX to get details of project change and show in the table
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {

              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              {
               var response = xmlhttp.responseText;
               console.log("Response:"+response);
               details_row.style.display = '';
               details_row.innerHTML = response;
               var arrow = "#row_project_change_"+project_change_id;
               $(arrow).removeClass("fa fa-angle-down");
               $(arrow).addClass("fa fa-angle-up");
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }
            // Add the file to the request.
          var formData = new FormData();  
          formData.append('op',4);  
          formData.append('pcid', project_change_id);
          formData.append('cstatus',change_status);
          xmlhttp.open("POST", "inProgressProjectManager.php", false);
          xmlhttp.send(formData);         
      }
     }
     
     function actionOnProjectChangeManagement(project_id)
     {
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
          {
           
          }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
          {
           var response = xmlhttp.responseText; 
           var div_project_change_zone = document.getElementById("zone_change_management_"+project_id);
           div_project_change_zone.innerHTML = response; 
           div_project_change_zone.style.display = '';
           div_project_change_zone.style.width = '98%';
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append('op',3);  
      formData.append('pid', project_id);
      xmlhttp.open("POST", "inProgressProjectManager.php", false);
      xmlhttp.send(formData); 
     }
     
     function approveProjectChange(project_change_id)
     {
      //CALL AJAX to get details of project change and show in the table
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
          {

          }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
          {
           var response = xmlhttp.responseText;
           var project_change_row = document.getElementById("project_change_row_"+project_change_id);
           project_change_row.innerHTML = response;
           project_change_row.onclick = function(){showProjectChange(project_change_id,2)};
           var details_row = document.getElementById("details_"+project_change_id);
           details_row.style.display = 'none';
           details_row.innerHTML = '';
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append('op',5);  
      formData.append('pcid', project_change_id);
      xmlhttp.open("POST", "inProgressProjectManager.php", false);
      xmlhttp.send(formData);          
     }
    /*  
    var saved_project_task = 0;
    function writeComplains(project_id,task_id)
    { 
      //alert("Project:"+project_id+",Task:"+task_id);  
      var zone_complain_row = document.getElementById("customer_complain_"+task_id);   
      if (saved_project_task>0 && task_id!==saved_project_task)  
      {
       var old_zone = document.getElementById("customer_complain_"+saved_project_task); 
       old_zone.style.display='none';
       old_zone.innerHTML = '';
      }
      saved_project_task = task_id;
      if (zone_complain_row.style.display==='')
          zone_complain_row.style.display = 'none'; 
      else
      {
          //Call AJAX to get list of complains for this task
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {

              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              {                 
               var response = xmlhttp.responseText;
               zone_complain_row.style.display = ''; 
               var complain_row = document.getElementById("customer_complain_row_"+saved_project_task);
               complain_row.innerHTML = response;
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }
            // Add the file to the request.
          var formData = new FormData();  
          formData.append('op',7); 
          formData.append("pid",project_id);
          formData.append('tid', task_id);
          xmlhttp.open("POST", "inProgressProjectManager.php", false);
          xmlhttp.send(formData);       
      }       
    }
     
     function actionOnProjectStatus(project_id)
     {
      //CALL AJAX to get details of project change and show in the table
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
          {

          }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
          { 
           var response = xmlhttp.responseText;
           var project_change_row = document.getElementById("zone_change_management_"+project_id);
           project_change_row.innerHTML = response;
           project_change_row.style.display = '';
           project_change_row.style.width ='98%';
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append('op',6);  
      formData.append('pid', project_id);
      xmlhttp.open("POST", "inProgressProjectManager.php", false);
      xmlhttp.send(formData);         
     }
     
     function openTaskComplainEditor(task_id)
     {
      var task_add_complain_div = document.getElementById("task_add_complain_div_"+task_id);
      task_add_complain_div.style.display = '';
     }
     
     function cancelSubmitComplain(task_id)
     {
      var task_add_complain_div = document.getElementById("task_add_complain_div_"+task_id);
      task_add_complain_div.style.display = 'none';         
     }
     
     function submitTaskComplain(project_id,task_id)
     {
      var subject = document.getElementById("suject_task_complain_"+task_id).value;   
      var content = document.getElementById("content_task_complain_"+task_id).value;
      if (subject.length>0 && content.length>0)
      {
          //Call AJAX to add new complain and refresh list.
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {

              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              { 
               var task_add_complain_div = document.getElementById("task_add_complain_div_"+task_id);
               task_add_complain_div.style.display = 'none';                  
               var response = xmlhttp.responseText;
               var complain_row = document.getElementById("customer_complain_row_"+task_id);
               complain_row.innerHTML = response;
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }
            // Add the file to the request.
          var formData = new FormData();  
          formData.append('op',8);  
          formData.append("pid",project_id);
          formData.append('tid', task_id);
          formData.append("subject",subject);
          formData.append("content",content);
          xmlhttp.open("POST", "inProgressProjectManager.php", false);
          xmlhttp.send(formData);        
      }
     }
     
     function editComplain(index,complain_id)
     {
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
          {

          }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
          { 
           var task_complain = document.getElementById("task_complain_"+complain_id);
           task_complain.style.display = '';                  
           var response = xmlhttp.responseText;
           var task_complain_row = document.getElementById("task_complain_row_"+complain_id);
           task_complain_row.innerHTML = response;
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }

      var formData = new FormData();  
      formData.append('op',9);  
      formData.append("cid",complain_id);
      formData.append("index",index);
      xmlhttp.open("POST", "inProgressProjectManager.php", false);
      xmlhttp.send(formData);       
     }
     
     function cancelUpdateComplain(complain_id)
     {
       var task_complain = document.getElementById("task_complain_"+complain_id);
       task_complain.style.display = 'none';                  
       var task_complain_row = document.getElementById("task_complain_row_"+complain_id);
       task_complain_row.innerHTML = '';         
     }
     
     function updateTaskComplain(index,complain_id)
     {
      var subject = document.getElementById("edit_suject_task_complain_"+complain_id).value;   
      var content = document.getElementById("edit_content_task_complain_"+complain_id).value;
      if (subject.length>0 && content.length>0)
      {
          //Call AJAX to add new complain and refresh list.
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {

              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              {
               var task_complain = document.getElementById("task_complain_"+complain_id);
               task_complain.style.display = 'none';                  
               var task_complain_row = document.getElementById("task_complain_row_"+complain_id);
               task_complain_row.innerHTML = ''; 
               var response = xmlhttp.responseText;
               var row_task_complain = document.getElementById("row_task_complain_"+complain_id);
               row_task_complain.innerHTML = response;
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }
            // Add the file to the request.
          var formData = new FormData();  
          formData.append('op',10);  
          formData.append("cid",complain_id);
          formData.append("index",index);
          formData.append("subject",subject);
          formData.append("content",content);
          xmlhttp.open("POST", "inProgressProjectManager.php", false);
          xmlhttp.send(formData);        
      }         
     }
     
     function deleteComplain(project_id,task_id,complain_id)
     {
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
          {

          }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
          {                
           var response = xmlhttp.responseText;;
           var complain_row = document.getElementById("customer_complain_row_"+task_id);
           complain_row.innerHTML = response;
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append('op',11); 
      formData.append('pid',project_id);
      formData.append('tid',task_id);
      formData.append("cid",complain_id);
      xmlhttp.open("POST", "inProgressProjectManager.php", false);
      xmlhttp.send(formData);         
     }     
*/

