show databases;
use leojcollard;

CREATE TABLE IF NOT EXISTS Player (id BIGINT, version BIGINT, firstname VARCHAR(32), lastname VARCHAR(32), email VARCHAR(254), user BIGINT, PRIMARY KEY(id), INDEX(user), UNIQUE(email));

CREATE TABLE IF NOT EXISTS User (id INTEGER, version INTEGER, username VARCHAR(64) unique, password VARCHAR(256), PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS UserRole (user_id INTEGER, role_id INTEGER, PRIMARY KEY (user_id, role_id)) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS Team (id BIGINT, version BIGINT, name VARCHAR(32), player BIGINT, PRIMARY KEY(id), INDEX(player), UNIQUE(player,name));

CREATE TABLE IF NOT EXISTS Pilot ( id BIGINT, version BIGINT, name VARCHAR(32), player BIGINT, PRIMARY KEY(id), INDEX(player) );

CREATE TABLE IF NOT EXISTS TeamMembership (pilot BIGINT, team BIGINT, INDEX(pilot), INDEX(team) );
CREATE TABLE IF NOT EXISTS Challenge (id BIGINT, version BIGINT, challengingPlayer BIGINT, challengedPlayer BIGINT, challengeStatus INT, PRIMARY KEY(id), INDEX(challengedPlayer) );

CREATE TABLE IF NOT EXISTS Notification (id BIGINT, version BIGINT, recipient BIGINT, seen INT, message VARCHAR(255), challengeId BIGINT, status INT, PRIMARY KEY(id), INDEX(recipient) );

CREATE TABLE IF NOT EXISTS Matches (id BIGINT, version BIGINT, firstTeam BIGINT, secondTeam BIGINT, gameStatus INT, PRIMARY KEY(id), INDEX(secondTeam) );

show tables;

select * from Notification;