<?php
  session_start();
  
  include_once("inc/fns.php");
  include_once("inc/vars.php"); 
  include_once("../pogo_utility/professionalServiceManager.php");
  
  if (!isset($_SESSION['merchant_id']))
  {
      header("Location:login.php?logout=yes");  
  }

  //connect to db
  //echo $_SESSION['merchant_id']; // for test
 // db_connect(HOST,USER,PASSWORD,DB);
  $manager = new pogoproProfessionalServiceManager();
  $generalInfo = $manager->getProfessioalServiceGeneralInfo($_SESSION['merchant_id']);
  $extra_business_locations = $generalInfo['extra_business_locations'];
  $allOfferedServices = $manager->getOfferedServicesByMerchant($_SESSION['merchant_id']);
  $encode_profile_editor = $manager->getPogoproServiceProfileEditor($_SESSION['merchant_id']);
  $profile_editor = json_decode($encode_profile_editor);
  //print_r($allOfferedServices);
  $numOfServiceLanguages = $manager->getCountOfServiceLanguages(); 
  $allSpokenLanguagesByPro = $manager->getServiceLanguagesOfPogoPro($_SESSION['merchant_id']);
  $allCertificatesOwnedBypro = array();//$manager->getValidCertificationsOfProfessionalServices($_SESSION['merchant_id']);
  $simpleProjects = $manager->getAllMySimpleProjects($_SESSION['merchant_id']);
  $p=0;
  if (isset($_GET['p']))
  {
   $p= $_GET['p'];   
  }
  $show_add_logo = "";
  $show_change_logo = "";
  if ($generalInfo['logo_url']!="")
  {
   $show_add_logo = "none";
   $show_change_logo = "";      
  }else
  {
   $show_add_logo = "";
   $show_change_logo = "none";        
  }
?>
<html lang="en">
<head>
  <meta charset="utf-8">
    <style>
    /* Tooltip */
    .form-control + .tooltip > .tooltip-inner {
        background-color: #73AD21;
        color: #FFFFFF;
        border: 1px solid green;
        padding: 15px;
        font-size: 12px;
    }
    .tooltip > .tooltip-inner {
        background-color: #73AD21;
        color: #FFFFFF;
        border: 1px solid green;
        padding: 15px;
        font-size: 12px;
    }        
      /* Tooltip on right */
     .form-control + .tooltip.left > .tooltip-arrow 
     {
      border-left: 5px solid red;
     } 
    .tooltip.left > .tooltip-arrow {
      border-left: 5px solid red;
  } 
  .ui-autocomplete {
    max-height: 200px;
    overflow-y: auto;
    /* prevent horizontal scrollbar */
    overflow-x: hidden;
    /* add padding to account for vertical scrollbar */
    padding-right: 20px;
    }
   * html .ui-autocomplete {
    height: 100px;
    }  
  </style> 
  <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,300italic,400italic,600,600italic' rel='stylesheet' type='text/css'>
  <link href='https://fonts.googleapis.com/css?family=Crete+Round' rel='stylesheet' type='text/css'>
  <link href='https://fonts.googleapis.com/css?family=Crete+Round' rel='stylesheet' type='text/css'>
<link href="css/bootstrap.css" rel="stylesheet">
<link href="css/bootstrap-responsive.css" rel="stylesheet">
<link href="css/style.css" rel="stylesheet">
<link href="css/flexslider.css" type="text/css" media="screen" rel="stylesheet"  />
<link href="css/jquery.fancybox.css" rel="stylesheet">
<link href="css/cloud-zoom.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.6.3/css/font-awesome.min.css">

<!-- JavaScript Calendar -->  
<link rel="stylesheet" type="text/css" media="all" href="../jsCalendar/jsDatePick_ltr.min.css" />
<script type="text/javascript" src="../jsCalendar/jsDatePick.min.1.3.js"></script>
<!-- Modal pop up window -->
<script src="../pogo_popup_modal/javascript/modalpopupwindow.js" type="text/javascript"></script>
<script src="../pogo_popup_modal/javascript/modalpopupwindowoperations.js" type="text/javascript"></script>
<script src="../pogo_utility/js/pogoProDateUtility.js" type="text/javascript"></script>

<!-- BootStrap -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>

<!-- jQuery UI -->
<script src="jquery_ui/jquery.js"></script>
<script src="jquery_ui/jquery-ui.js"></script>
<link href="jquery_ui/jquery-ui.css" rel="stylesheet"> 
<script>
    var currentOpenedAccordion = -1;
    var tags = [];
    var user_account_id = <?php echo $_SESSION['user_id']; ?>;
    var logo_url = "<?php echo $generalInfo['logo_url']; ?>";
    var merchant_id = <?php echo $_SESSION['merchant_id']; ?>;
    var message_dialogInit = false;
    var open_create_certificate_dialog = false;
    var open_calendar_for_certificate = false;
    var current_index = 0;
    $(document).ready(function(){
      $('[data-toggle="tooltip"]').tooltip();
       $(window).resize(function(){
      //resize popup window
     if (open_create_certificate_dialog) openNewCertificateDialog(merchant_id);
     //if (open_calendar_for_certificate) 
    });
      /*if (logo_url.length===0)
      {
       $("#add_logo").css({"display":""}); 
       $("#change_logo").css({"display":"none"});
      }else
      {
       $("#add_logo").css({"display":"none"}); 
       $("#change_logo").css({"display":""});          
      }*/
      initDialog();
      initAllButtons(); 
      
      $(".nav-tabs a").click(function(){
            $(this).tab('show');
        });      
      
      $('.nav-tabs a').on('shown.bs.tab', function(event){
        var x = $(event.target).attr('href').toLowerCase();         // active tab
        //var y = $(event.relatedTarget).text();  // previous tab
        console.log("Activate tab:"+x);
        //console.log("Content:"+$(x).html());
        //$(".act span").text(x);
        //$(".prev span").text(y);
        if (x==="#my_account")
        {
         loadMyAccountTab(x);   
        }else if (x==="#pro_certificates")
        {
         loadProCertificatesTab(x);   
        }else if (x==="#pro_promotions")
        {
         loadProPromotionsTab(x);   
        }else if (x==="#pro_services")
        {
         loadProServicesTab(x);   
        }
    });
    });
    
    $(function() {
        $( "#accordion_simple_projects" ).accordion({
          heightStyle: "content"
      });
    }); 
    //service_accordion
    $(function() {
        $( "#service_second_levels" ).accordion({
          collapsible: true,   
          heightStyle: "content"
      });        
        $( "#service_accordion" ).accordion({
          collapsible: true,   
          heightStyle: "content"
      });//service_accordion_
        $( "#service_accordion_0" ).accordion({
          collapsible: true,   
          heightStyle: "content"
      });
        $( "#service_accordion_1" ).accordion({
          collapsible: true,   
          heightStyle: "content"
      });      
    });
    
    function loadMyAccountTab(x)
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          console.log("Response:"+response);
          var json_obj = JSON.parse(response);
          var account_info = json_obj.account_info;
          var countries = json_obj.countries;
          var count_country = countries.length;
          var provinces = json_obj.provinces;
          var count_province = provinces.length;
          var my_account_tab_content = "<p style='text-align:center;'><table style='width:100%'><tr><td style='width:90%;text-align:center'><label style='font-size:large;'>Edit your account information</label></td><td align='center'><i class='fa fa-refresh' title='Update my account.' onClick='UpdateMyAccount()' style='font-size:26px;color:#107FC9'></i></td></tr></table></p>"
                                    + "<hr style='margin-top:-5px;color:red;'>"
                                    + "<table border='0' style='margin-top:-16px;width:100%'>"
                                    + "<tr><td style='width:40%;text-align:right'><label>Salutation&nbsp;&nbsp;</label></td><td><input type='text' id='salutation' value='"+account_info.salutation+"' style='margin-top:8px;height:28px;'></td>"
                                    + "<tr><td style='width:40%;text-align:right'><label>Full name&nbsp;&nbsp;</label></td><td><input type='text' id='name' value='"+account_info.name+"' style='margin-top:8px;height:28px;'></td>"
                                    + "<tr><td style='width:40%;text-align:right'><label>Account email&nbsp;&nbsp;</label></td><td><input type='text' id='email' value='"+account_info.email+"' style='margin-top:8px;height:28px;'></td>"
                                    + "<tr><td style='width:40%;text-align:right'><label>Mobile/Phone no.&nbsp;&nbsp;</label></td><td><input type='text' id='phone' value='"+account_info.phone+"' style='margin-top:8px;height:28px;'></td>"
                                    + "<tr><td style='width:40%;text-align:right'><label>Address&nbsp;&nbsp;</label></td><td><input type='text' id='address' value='"+account_info.address+"' style='margin-top:8px;height:28px;'></td>"
                                    + "<tr><td style='width:40%;text-align:right'><label>Postal code&nbsp;&nbsp;</label></td><td><input type='text' id='postal_code' value='"+account_info.postal_code+"' style='margin-top:8px;height:28px;'></td>"
                                    + "<tr><td style='width:40%;text-align:right'><label>Street&nbsp;&nbsp;</label></td><td><input type='text' id='street' value='"+account_info.street+"' style='margin-top:8px;height:28px;'></td>"
                                    + "<tr><td style='width:40%;text-align:right'><label>City&nbsp;&nbsp;</label></td><td><input type='text' id='city' value='"+account_info.city+"' style='margin-top:8px;height:28px;'><br/><span class='badge' style='background-color:red;color:white;margin-top:-4px;'>Type one or more letters to get cities list</span><br/></td>"
                                    + "<tr><td style='width:40%;text-align:right'><label>Province/Territory&nbsp;&nbsp;</label></td><td id='select_tag_pt'><select id='pt' style='height:28px;margin-top:8px;' onChange='changeOnRegionForMyAccount();'>";
          for (var i=0;i<count_province;i++)
          {
           if (provinces[i]===account_info.pt)   
               my_account_tab_content += "<option value='"+provinces[i]+"' selected>"+provinces[i]+"</option>"; 
           else
               my_account_tab_content += "<option value='"+provinces[i]+"' >"+provinces[i]+"</option>"; 
          }

          my_account_tab_content += "</select></td>"
                                 + "<tr><td style='width:40%;text-align:right'><label>Country&nbsp;&nbsp;</label></td><td><select id='country' style='margin-top:8px;height:28px;' onChange='changeOnCountryForMyAccount();'>";
          for (var i=0;i<count_country;i++)
          {
           if (countries[i]===account_info.country)
               my_account_tab_content += "<option value='"+countries[i]+"' selected>"+countries[i]+"</option>";
           else
               my_account_tab_content += "<option value='"+countries[i]+"' >"+countries[i]+"</option>"; 
          }
          my_account_tab_content +="</select></td>"
                                    + "</table>";
          $(x).html(my_account_tab_content);
          tags = json_obj.tags;
          console.log("cities:"+tags);
          $("#city").autocomplete({
              source: function( request, response ) {
                      var matcher = new RegExp( "^" + $.ui.autocomplete.escapeRegex( request.term ), "i" );
                      response( $.grep( tags, function( item ){
                          return matcher.test( item );
                      }) );
                  }
            });
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",17);
       formData.append("uid",user_account_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);          
    }
    
    function UpdateMyAccount()
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);
          var status = json_obj.status;
          if (status)
          {
           var content = "Your account has been updated successfully.";
           var title   = "Notification";
           $("#message_dialog").html(content);             
           $("#message_dialog").dialog('option', 'title', title);
           $("#message_dialog").dialog('option', 'width', 240);
           $("#message_dialog").dialog('option', 'height', 180);
           $("#message_dialog" ).dialog( "open" ); 
          }else
          {
           var content = "Your account has not been updated successfully.";
           var title   = "Notification";              
           $("#message_dialog").html(content);             
           $("#message_dialog").dialog('option', 'title', title);
           $("#message_dialog").dialog('option', 'width', 240);
           $("#message_dialog").dialog('option', 'height', 180);
           $("#message_dialog" ).dialog( "open" );              
          }
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",18);
       formData.append("uid",user_account_id);
       formData.append("salutation",$("#salutation").val());
       formData.append("name",$("#name").val());
       formData.append("email",$("#email").val());
       formData.append("phone",$("#phone").val());
       formData.append("address",$("#address").val());
       formData.append("postal_code",$("#postal_code").val());
       formData.append("street",$("#street").val());
       formData.append("city",$("#city").val());
       formData.append("pt",$("#pt").val());
       formData.append("country",$("#country").val());
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);            
    }
    
    function loadProServicesTab(x)
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          //console.log("Response:"+response);
          var json_obj = JSON.parse(response); 
          var offered_services = json_obj.pro_services;
          var count = offered_services.length;
          var secondLevels = json_obj.second_levels;
          console.log("Second Levels:"+secondLevels);
          //console.log(secondLevels[0]);
          //console.log(secondLevels[1]);
          var tab_content = "<div id='accordion_pro_services'>";
          for (var i=0;i<secondLevels.length;i++)
          {
           tab_content += "<h3><table style='width:100%'><tr><td style='width:82%'>"+secondLevels[i]+"</td><td><i id='btn_pro_service_action_0_"+i+"' class='fa fa-check-square' title='Select all' style='font-size:24px;color:white' onClick='SelectAllOfferedServices("+i+")'></i></td><td><i id='btn_pro_service_action_1_"+i+"' class='fa fa-plus-circle' title='Add service' style='font-size:24px;color:white' onClick='loadServicesToAdd("+merchant_id+","+i+");'></i></td><td><i id='btn_pro_service_action_2_"+i+"' class='fa fa-trash' title='Remove service' style='font-size:24px;color:white' onClick='removeSelectedServices("+merchant_id+","+i+")'></i></td></tr></table></h3>"; 
           tab_content += "<div id='service_tab_"+i+"'>";
           if (count>0)
           {
               tab_content += "<table style='width:100%'>";
               for (var k=0;k<count;k++)
               {
                if (offered_services[k].second_level===secondLevels[i])   
                    tab_content += "<tr><td><input type='checkbox' name='checkbox' id='service_"+i+"_"+k+"' value='"+offered_services[k].offeredService_id+"'>"+offered_services[k].name+"</td></tr>";   
               }
               tab_content += "</table>";
           }
           tab_content += "</div>";
          }
          tab_content += "</div>";
          $(x).html(tab_content);
          $("#accordion_pro_services").accordion(
              {
               heightStyle: "content",
               collapsible: true
              }
              );
          for (var i=0;i<secondLevels.length;i++)
          {
            $("#btn_pro_service_action_0_"+i).click(function(e) {
                    e.stopPropagation();
                    }); 
            $("#btn_pro_service_action_1_"+i).click(function(e) {
                    e.stopPropagation();
                    }); 
            $("#btn_pro_service_action_2_"+i).click(function(e) {
                    e.stopPropagation();
                    });                     
          }
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",19);
       formData.append("mid",merchant_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);          
    }
    
    function loadServicesToAdd(merchant_id,index)
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          console.log("Response:"+response);
          var json_obj = JSON.parse(response);
          var content = "<p><table border='0' style='width:100%'><tr><td style='width:90%;text-align:center'><label style='font-size:x-large;'>Select services you want to offer</label></td><td style='width:5%'><i class='fa fa-check-square' title='Select all' onClick='selectAllUnOfferedServices()' style='font-size:24px;color:#107FC9'></i></td><td><i class='fa fa-plus-circle' title='Add offered service' style='font-size:24px;color:#107FC9' onClick='addSelectedUnofferedServices("+merchant_id+","+index+")'></i></td></tr></table></p>"
                       +"<hr>";
          var unOfferedServices = json_obj.unOfferedServices;
          var count = unOfferedServices.length;
          content += "<table style='width:100%'>";
          for (var i=0;i<count;i++)
          {
           content += "<tr>"; 
           content += "<td>";
           content += "<input type='checkbox' name='unoffere_checkbox' id='cb_unoffer_"+i+"' value='"+unOfferedServices[i].category_code+"'>"+unOfferedServices[i].category_name;
           content += "</td>";
           //if ((count-i)
           content += "</tr>"; 
          }
          content += "</table>";     
          var title   = "Add services";
          $("#message_dialog").html(content);             
          $("#message_dialog").dialog('option', 'title', title);
          var w = $(window).width()*0.8;
          var h = $(window).height()*0.8;
          $("#message_dialog").dialog('option', 'width', w);
          $("#message_dialog").dialog('option', 'height', h);
          $("#message_dialog" ).dialog( "open" );          
          //var my_account_tab_content = "Tab of Pro Certificates";
          //$(x).html(my_account_tab_content); 
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",21);
       formData.append("mid",merchant_id);
       formData.append("parent",index);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);  
       ///var tab_content = "<p><input type='checkbox' name='checkbox' value='143'>abc</p>";
       ///$("#service_tab_"+index).html(tab_content);
    }
    
    function selectAllUnOfferedServices()
    {
     var allTags = document.body.getElementsByTagName('*');
     var ids = [];
     for (var tg = 0; tg< allTags.length; tg++) 
     {
      var tag = allTags[tg];
      if (startWith(tag.id,"cb_unoffer_")) 
        {
         ids.push("#"+tag.id);
        }   
     }
 
     var counter = ids.length;
     for (var i=0;i<counter;i++)
      {
       if ($(ids[i]).prop('checked') === true)   
           $(ids[i]).prop("checked", false);
       else
           $(ids[i]).prop("checked", true);
      }         
    }
    
    function addSelectedUnofferedServices(merchant_id,index)
    {
     var selected_services = $("input[name=unoffere_checkbox]:checked").map(function() {
            return this.value;
       }).get().join(",");   
     console.log("Selected unoffered services:"+selected_services); 

     if (selected_services==="")
     {
      //show error message   
     }else
     {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);
          var refreshList = json_obj.refresh_list;
          var tab_content = "<table style='width:100%'>";
          for (var k=0;k<refreshList.length;k++)
           {   
            tab_content += "<tr><td><input type='checkbox' name='checkbox' id='service_"+index+"_"+k+"' value='"+refreshList[k].offeredService_id+"'>"+refreshList[k].name+"</td></tr>";   
           }
          tab_content += "</table>";
          $("#service_tab_"+index).html(tab_content);         
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",22);
       formData.append("mid",merchant_id);
       formData.append("services",selected_services);
       formData.append("index",index);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);          
     }
    }
    
    function removeSelectedServices(merchant_id,index)
    {
     var selected_services = $("input[name=checkbox]:checked").map(function() {
            return this.value;
       }).get().join(",");
     if (selected_services==="")  
     {
      //show message in popup window   
     }else
     { //call AJAX to remove selected services from pro's services list
      console.log("Selected services:"+selected_services); 
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          //console.log("response:"+response);
          var json_obj = JSON.parse(response);
          var refreshList = json_obj.refresh_list;
          var tab_content = "<table style='width:100%'>";
          for (var k=0;k<refreshList.length;k++)
           {   
            tab_content += "<tr><td><input type='checkbox' name='checkbox' id='service_"+index+"_"+k+"' value='"+refreshList[k].offeredService_id+"'>"+refreshList[k].name+"</td></tr>";   
           }
          tab_content += "</table>";
          $("#service_tab_"+index).html(tab_content);            
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",20);
       formData.append("mid",merchant_id);
       formData.append("services",selected_services);
       formData.append("index",index);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);        
     }
    }
    
    function SelectAllOfferedServices(index)
    {
     var allTags = document.body.getElementsByTagName('*');
     var ids = [];
     for (var tg = 0; tg< allTags.length; tg++) 
     {
      var tag = allTags[tg];
      if (startWith(tag.id,"service_"+index+"_")) 
        {
         ids.push("#"+tag.id);
        }   
     }
 
     var counter = ids.length;
     for (var i=0;i<counter;i++)
      {
       if ($(ids[i]).prop('checked') === true)   
           $(ids[i]).prop("checked", false);
       else
           $(ids[i]).prop("checked", true);
      }         
    }
    
    function loadProCertificatesTab(x)
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          //console.log(response);
          var json_obj = JSON.parse(response);
          var allValidCertificates = json_obj.certificates;
          var pro_services = json_obj.pro_services;
          //console.log("counter:"+pro_services.length);
          var second_levels = json_obj.second_levels;
          var tab_content = "<p><table style='width:100%'><tr><td style='90%'><label style='font-size:x-large;'>Certificates</label></td><td align='right'><i class='fa fa-plus-circle' title='Add certificate' style='font-size:24px;color:#107FC9'  onClick='openNewCertificateDialog("+merchant_id+")'></i></td></tr></table></p>";
          var count = allValidCertificates.length;

          if (count>0)
          {
           tab_content += "<hr style='margin-top:-8px;background-color: #107FC9; height: 2px;'>";
           tab_content += "<div id='certificates_accordion'>";
           for (var i=0;i<count;i++)
           {
            var coveredServices = (allValidCertificates[i].coveredServices).split(",");   
            tab_content += "<h3><table style='width:100%'><tr><td style='width:90%' id='offer_name_"+allValidCertificates[i].certificate_id+"'>"+allValidCertificates[i].certificate_name+"</td><td align='right'><i class='fa fa-trash' title='Delete this offer' id='btn_delete_offer_"+allValidCertificates[i].certificate_id+"' style='font-size:24px;color:white' onClick='certificateDeleteConfirm("+allValidCertificates[i].certificate_id+",\""+allValidCertificates[i].certificate_name+"\")'></i></td></tr></table></h3>"; 
            tab_content += "<div id='offer_zone_"+allValidCertificates[i].certificate_id+"'>";
            tab_content += "<table border='0' style='width:100%'>";
            tab_content += "<tr>"
                        +"<td colspan='4' style='width:10%'>Expiry date:</td>"
                        +"<td style='width:20%' align='center' id='end_date_"+allValidCertificates[i].certificate_id+"'>"+allValidCertificates[i].certificate_end_date+"</td>"
                        +"<td style='width:20%'><i class='fa fa-calendar' title='Change end date of offer.' style='margin-left:0px;font-size:24px;color:#107FC9'  onClick='openCaledarForServiceCertificate("+allValidCertificates[i].certificate_id+",1)'></i></td>"
                        +"</tr>";
            tab_content += "<tr><td colspan='6'>Offer description:<i class='fa fa-edit' title='Edit description of offer' style='margin-left:16px;font-size:24px;color:#107FC9' onClick='openeditorForDescriptionOfCertificate("+allValidCertificates[i].certificate_id+")'></i></td></tr>";
            tab_content += "<tr><td colspan='6'><textarea row='4'  id='offer_desc_"+allValidCertificates[i].certificate_id+"' cols='80' style='width:100%'>"+allValidCertificates[i].certificate_desc+"</textarea></td></tr>";
            tab_content += "<tr><td colspan='6'>"
                        +"<table border='0' style='width:100%;'><tr>"
                        +"<tr><td style='width:50%'>Image:<i class='fa fa-picture-o' title='Change image' style='margin-left:16px;font-size:24px;color:#107FC9' onClick='changeImageOfCertificate("+allValidCertificates[i].certificate_id+")'></i></td><td style='width:50%'><table style='width:100%'><tr><td style='width:75%'><p style='margin-left:16px;margin-top:8px;'>Covered services:</p></td><td align='right'><i class='fa fa-check-circle' title='Bind with all services' style='font-size:24px;color:#107FC9' onClick='setOrCleanAllCoveredServiceBindedWithCertificate("+allValidCertificates[i].certificate_id+",1)'></i><i class='fa fa-circle-o' title='Unbind with all services' style='font-size:24px;color:#107FC9' onClick='setOrCleanAllCoveredServiceBindedWithCertificate("+allValidCertificates[i].certificate_id+",0)'></i></td></tr></table></td></tr>"
                        +"<td style='width:50%;vertical-align:top;'><img id='img_"+allValidCertificates[i].certificate_id+"' src='"+allValidCertificates[i].certificate_image+"' style='width:640px;'></td>"
                        +"<td style='width:50%'><div id='covered_service_div_"+allValidCertificates[i].certificate_id+"' style='margin-left:16px;height:480px;overflow-y: scroll;'>"
                        +"<table style='width:100%'>";
            for (var k=0;k<second_levels.length;k++)
            {
              tab_content += "<tr><td><label>"+second_levels[k]+":</label></td></tr>";  
              for (var j=0;j<pro_services.length;j++)
              {
                if (pro_services[j].second_level===second_levels[k])
                {
                  if (coveredServices.indexOf(pro_services[j].offeredService_id)>=0)  
                      tab_content += "<tr><td><input type='checkbox' name='cb_covered_services_"+allValidCertificates[i].certificate_id+"' id='cb_covered_service_"+allValidCertificates[i].certificate_id+"_"+pro_services[j].offeredService_id+"' value='"+pro_services[j].offeredService_id+"' checked onClick='updateCoveredServiceWithCertificate("+allValidCertificates[i].certificate_id+","+pro_services[j].offeredService_id+")'>"+pro_services[j].name+"</td></tr>";
                  else
                      tab_content += "<tr><td><input type='checkbox' name='cb_covered_services_"+allValidCertificates[i].certificate_id+"' id='cb_covered_service_"+allValidCertificates[i].certificate_id+"_"+pro_services[j].offeredService_id+"' value='"+pro_services[j].offeredService_id+"' onClick='updateCoveredServiceWithCertificate("+allValidCertificates[i].certificate_id+","+pro_services[j].offeredService_id+")'>"+pro_services[j].name+"</td></tr>";
                }
              }
            }
            tab_content += "</table></div></td>"
                        +"</tr></table>";
            tab_content += "</table>";
            tab_content += "</div>";
           }
           tab_content += "</div>";
           $(x).html(tab_content);
           $("#certificates_accordion").accordion(
            {
             //heightStyle: "content",
             collapsible: true                       
            });
           for (var i=0;i<count;i++)
           {
            $("#btn_edit_offer_"+allValidCertificates[i].certificate_id).click(function(e) {
                    e.stopPropagation();
                    });  
            $("#btn_delete_offer_"+allValidCertificates[i].certificate_id).click(function(e) {
                    e.stopPropagation();
                    });                    
           }
          }else
          {
            tab_content += "<hr style='margin-top:-8px;background-color: #107FC9; height: 2px;'>";
            tab_content += "<p style='text-align:center'>You have no service certificates currently.</p>";
            $(x).html(tab_content);
          }
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",31);
       formData.append("mid",merchant_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);                
    }
    
    function certificateDeleteConfirm(certificate_id,certificate_name)
    {
           var content = "Are you sure you want to delete certificate:<br/>"+certificate_name;
           var title   = "Confirmation";
           $("#message_dialog").html(content);             
           $("#message_dialog").dialog('option', 'title', title);
           $("#message_dialog").dialog('option', 'width', 320);
           $("#message_dialog").dialog('option', 'height', 180);
           $( "#message_dialog" ).dialog( "option", "buttons", 
              [
                {
                  text: "Yes",
                  icon: "ui-icon-circle-plus",
                  click: function() {
                    deletewServiceCertificate(certificate_id,certificate_name);  
                    $( this ).dialog( "close" );
                  },
                  showText: false
                },
                {
                  text: "Cancel",
                  icon: "ui-icon-circle-plus",
                  click: function() {
                    $( this ).dialog( "close" );
                  }
                }    
              ]
            );           
           $("#message_dialog" ).dialog( "open" );        
    }
    
    function openNewCertificateDialog(merchant_id)
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          open_create_certificate_dialog = true;   
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response); 
          var second_levels = json_obj.second_levels;
          var offered_services = json_obj.pro_services;
          var title = "Add service certificate"
          var dialog_content = "<div class='form-group'><table border='0' style='width:100%'>"
              +"<tr><td><label for='usr' style='color:#333'>Title:</label></td>"
              +"<td><input type='text' class='form-control' id='offer_title' style='height:24px;'></td></tr>"
              +"<tr><td><label for='pwd' style='color:#333'>Description:</label></td>"
              +"<td><textarea class='form-control' rows='5' id='offer_desc' style='width:100%'></textarea></td></tr>"
              +"<tr><td colspan='2'><table border='0' style='margin-top:8px;width:100%'>"
              +"<tr>"
              //+"<td style='width:25%'><label for='usr'>Start date:</label></td>"
              //+"<td style='width:25%'><input type='text' class='form-control' id='offer_start_date' style='height:24px;width:96px;'></td>"
              +"<td style='width:25%' align='center'><label for='pwd' style='color:#333'>Expiry date:</label></td>"
              +"<td style='width:25%'><input type='text' class='form-control' id='offer_end_date' style='height:24px;width:96px;'></td></tr></table></td></tr>"
              +"<tr>" //image
              +"<td><label for='pwd' style='color:#333'>Photo of certification:</label><span style='font-weight: bold;color:red;font-size: 14px;'>(Required)</span></td>"
              +"<td>"
                   +"<form enctype='multipart/form-data'>"
                   //+"Select image to upload:"
                   +"<p><input type='file' name='fileToUpload' id='logo_fileToUpload' onchange='readURL(this);'></p>"
                   //+"<p><input type='button' value='Upload Image' name='uploadImage' onClick='uploadImageOfOffer(0);'></p>"
                   +"<p style='margin-top:16px;display:none' id='p_preview'><img id='logo_preview' src='#' alt='your image' /></p>"
                   +"</form>"     
              +"</td></tr>"
							+"<tr class='image_mesage_toggle' style='display:none'>"//image require message
							+"<td colspan='2' height='100'><span style='color:red;'>A screen shot or electronic copy of the certificate is required for validation. If you require instruction on how to screen capture click <a href='https://www.howtogeek.com/226280/how-to-take-screenshots-in-windows-10'>here</a>.</span></td></tr>"
              +"<tr>" //Bind offered services
              +"<td valign='top'>"
              +"<p><label for='pwd' style='color:#333'>Services which offer covered :</label><p>"
              +"<p><i class='fa fa-check-circle' title='Bind with all services' style='font-size:24px;color:#107FC9' onClick='selecttOrCleanAllCoveredService(1)'></i><i class='fa fa-circle-o' title='Unbind with all services' style='font-size:24px;color:#107FC9' onClick='selecttOrCleanAllCoveredService(0)'></i></p>"
              +"</td>"      
              +"<td>"
              +"<div style='width:100%;height:320px;overflow-y: scroll'>";
            for (var i=0;i<second_levels.length;i++)
            {
             dialog_content +="<p style='color:#333'>"+second_levels[i]+"</p>";   
             for (var k=0;k<offered_services.length;k++)
             {
              if (offered_services[k].second_level===second_levels[i]) 
                  dialog_content +="<p style='color:#333'><input type='checkbox' name='cb_services' id='cb_service_"+i+"_"+k+"' value='"+offered_services[k].offeredService_id+"'>"+offered_services[k].name+"</p>";
             }
            }
            dialog_content +="</div>"
              +"</td></tr>"      
              +"</table></div>";
          $("#message_dialog").html(dialog_content);             
          $("#message_dialog").dialog('option', 'title', title);
          console.log("window width:"+$(window).width());
          console.log("window height:"+$(window).height());
                    console.log("window innerwidth:"+$(window).innerWidth());
          console.log("window innerheight:"+$(window).innerHeight());
                    //console.log("window width:"+$(window).width());
          //console.log("window height:"+$(window).height());
          
          var w = 640;//$(window).innerWidth()/2;
          var h = 480;//$(window).innerHeight()/2;
          $("#message_dialog").dialog('option', 'width', w);
          $("#message_dialog").dialog('option', 'height', h);
          //$("#message_dialog").dialog({ position: 'top' });
          $("#message_dialog").dialog({ position: { my: "center", at: "top+300", of: window } });
          $( "#message_dialog" ).dialog( "option", "buttons", 
              [
                {
                  text: "Save",
                  icon: "ui-icon-circle-plus",
                  click: function() {
                    open_create_certificate_dialog = false;  
                    saveNewServiceCertificate();  
                    //$( this ).dialog( "close" ); 12-03-2020 now will close after saving new cert
                  },
                  showText: false
                },
                {
                  text: "Cancel",
                  icon: "ui-icon-circle-plus",
                  click: function() {
                    open_create_certificate_dialog = false;   
                    $( this ).dialog( "close" );
                  }
                }    
              ]
            );          
          $("#message_dialog" ).dialog( "open" ); 
          $("#offer_end_date" ).datepicker({
       dateFormat: 'yy-mm-dd'});   
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",28);
       formData.append("mid",merchant_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);           
    }
    
    function saveNewServiceCertificate()
    {
     var title = $("#offer_title").val();
     var desc  = $("#offer_desc").val();
     var end_date = $("#offer_end_date").val();
     var fileSelect = document.getElementById("logo_fileToUpload");
		 var files = fileSelect.files;
     var file = files[0];
		 if(files.length==0){
			$(".image_mesage_toggle").show();
		 }else{
			 var selected_services = $("input[name=cb_services]:checked").map(function() {
							return this.value;
				 }).get().join(",");   
				 
				var xmlhttp;
				if (window.XMLHttpRequest) 
				 { 
							xmlhttp = new XMLHttpRequest();
				 }else 
				 { 
							xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
				 }
				 xmlhttp.onreadystatechange = function() 
				 {
					 if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
					 {
					 }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
					 {
						var response = xmlhttp.responseText;
						console.log("Response:"+response);
						var json_obj = JSON.parse(response);
						var status = json_obj.status;
						if (status)
						{
						 loadProCertificatesTab("#pro_certificates");
						 $("#message_dialog").dialog('close');
						}
					 }else 
					 {
					 }
				 }
				 var formData = new FormData();
				 formData.append("op",32);
				 formData.append("mid",merchant_id);
				 formData.append("account_id",user_account_id);
				 formData.append("title",title);
				 formData.append("desc",desc);
				 formData.append("end_date",end_date);
				 formData.append("image",file);
				 formData.append("bind_services",selected_services);
				 xmlhttp.open("POST", "pogoproProfileManager.php", false);
				 xmlhttp.send(formData);
			 }			 
    }
    
    function loadProPromotionsTab(x)
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          //console.log("Offers:"+response);
          var json_obj = JSON.parse(response);
          var allValidOffers = json_obj.offers;
          var pro_services = json_obj.pro_services;
          //console.log("counter:"+pro_services.length);
          var second_levels = json_obj.second_levels;
          var tab_content = "<p><table style='width:100%'><tr><td style='90%'><label style='font-size:x-large;'>Promotions</label></td><td align='right'><i class='fa fa-plus-circle' title='Add offer' style='font-size:24px;color:#107FC9'  onClick='openNewPromotionDialog("+merchant_id+")'></i></td></tr></table></p>";
          var count = allValidOffers.length;
          if (count>0)
          {
           tab_content += "<hr style='margin-top:-8px;background-color: #107FC9; height: 2px;'>";
           tab_content += "<div id='promotions_accordion'>";
           for (var i=0;i<count;i++)
           {
            var coveredServices = (allValidOffers[i].coveredServices).split(",");   
            tab_content += "<h3><table style='width:100%'><tr><td style='width:90%' id='offer_name_"+allValidOffers[i].offer_id+"'>"+allValidOffers[i].offer_name+"</td><td align='right'><i class='fa fa-trash' title='Delete this offer' id='btn_delete_offer_"+allValidOffers[i].offer_id+"' style='font-size:24px;color:white' onClick='promotionDeleteConfirm("+allValidOffers[i].offer_id+",\""+allValidOffers[i].offer_name+"\")'></i></td></tr></table></h3>"; 
            tab_content += "<div id='offer_zone_"+allValidOffers[i].offer_id+"'>";
            tab_content += "<table border='0' style='width:100%'>";
            tab_content += "<tr>"
                        +"<td style='width:10%'>From:</td>"
                        +"<td style='width:20%' align='center' id='start_date_"+allValidOffers[i].offer_id+"'>"+allValidOffers[i].offer_start_date+"</td>"
                        +"<td style='width:20%'><i class='fa fa-calendar' title='Change start date of offer.' style='margin-left:0px;font-size:24px;color:#107FC9' onClick='openCaledarForOfferSchedule("+allValidOffers[i].offer_id+",0)'></i></td>"
                        +"<td style='width:10%'>To:</td>"
                        +"<td style='width:20%' align='center' id='end_date_"+allValidOffers[i].offer_id+"'>"+allValidOffers[i].offer_end_date+"</td>"
                        +"<td style='width:20%'><i class='fa fa-calendar' title='Change end date of offer.' style='margin-left:0px;font-size:24px;color:#107FC9'  onClick='openCaledarForOfferSchedule("+allValidOffers[i].offer_id+",1)'></i></td>"
                        +"</tr>";//fa-calendar
            tab_content += "<tr><td colspan='6'>Offer description:<i class='fa fa-edit' title='Edit description of offer' style='margin-left:16px;font-size:24px;color:#107FC9' onClick='openeditorForDescriptionOfOffer("+allValidOffers[i].offer_id+")'></i></td></tr>";
            tab_content += "<tr><td colspan='6'><textarea row='4'  id='offer_desc_"+allValidOffers[i].offer_id+"' cols='80' style='width:100%'>"+allValidOffers[i].offer_desc+"</textarea></td></tr>";
            tab_content += "<tr><td colspan='6'>"
                        +"<table border='0' style='width:100%;'><tr>"
                        +"<tr><td style='width:50%'>Image:<i class='fa fa-picture-o' title='Change image' style='margin-left:16px;font-size:24px;color:#107FC9' onClick='changeImageOfOffer("+allValidOffers[i].offer_id+")'></i></td><td style='width:50%'><table style='width:100%'><tr><td style='width:75%'><p style='margin-left:16px;margin-top:8px;'>Covered services:</p></td><td align='right'><i class='fa fa-check-circle' title='Bind with all services' style='font-size:24px;color:#107FC9' onClick='setOrCleanAllCoveredService("+allValidOffers[i].offer_id+",1)'></i><i class='fa fa-circle-o' title='Unbind with all services' style='font-size:24px;color:#107FC9' onClick='setOrCleanAllCoveredService("+allValidOffers[i].offer_id+",0)'></i></td></tr></table></td></tr>"
                        +"<td style='width:50%;vertical-align:top;'><img id='img_"+allValidOffers[i].offer_id+"' src='"+allValidOffers[i].offer_image+"' style='width:640px;'></td>"
                        +"<td style='width:50%'><div id='covered_service_div_"+allValidOffers[i].offer_id+"' style='margin-left:16px;height:480px;overflow-y: scroll;'>"
                        +"<table style='width:100%'>";
            for (var k=0;k<second_levels.length;k++)
            {
              tab_content += "<tr><td><label>"+second_levels[k]+":</label></td></tr>";  
              for (var j=0;j<pro_services.length;j++)
              {
                if (pro_services[j].second_level===second_levels[k])
                {
                  if (coveredServices.indexOf(pro_services[j].offeredService_id)>=0)  
                      tab_content += "<tr><td><input type='checkbox' name='cb_covered_services_"+allValidOffers[i].offer_id+"' id='cb_covered_service_"+allValidOffers[i].offer_id+"_"+pro_services[j].offeredService_id+"' value='"+pro_services[j].offeredService_id+"' checked onClick='updateCoveredService("+allValidOffers[i].offer_id+","+pro_services[j].offeredService_id+")'>"+pro_services[j].name+"</td></tr>";
                  else
                      tab_content += "<tr><td><input type='checkbox' name='cb_covered_services_"+allValidOffers[i].offer_id+"' id='cb_covered_service_"+allValidOffers[i].offer_id+"_"+pro_services[j].offeredService_id+"' value='"+pro_services[j].offeredService_id+"' onClick='updateCoveredService("+allValidOffers[i].offer_id+","+pro_services[j].offeredService_id+")'>"+pro_services[j].name+"</td></tr>";
                }
              }
            }
            tab_content += "</table></div></td>"
                        +"</tr></table>";
            tab_content += "</table>";
            tab_content += "</div>";
           }
           tab_content += "</div>";
           $(x).html(tab_content);
           $("#promotions_accordion").accordion(
            {
             //heightStyle: "content",
             collapsible: true                       
            });
           for (var i=0;i<count;i++)
           {
            $("#btn_edit_offer_"+allValidOffers[i].offer_id).click(function(e) {
                    e.stopPropagation();
                    });  
            $("#btn_delete_offer_"+allValidOffers[i].offer_id).click(function(e) {
                    e.stopPropagation();
                    });                    
           }
          }else
          {
            tab_content += "<hr style='margin-top:-8px;background-color: #107FC9; height: 2px;'>";
            tab_content += "<p style='text-align:center'>You have no promotions currently.</p>";
            $(x).html(tab_content);
          }
          
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",23);
       formData.append("mid",merchant_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);                 
    }
    
    function promotionDeleteConfirm(offer_id,offer_name)
    {
     //console.log("Offer name:"+offer_name);  
           var content = "Are you sure you want to delete promotion:<br/>"+offer_name;
           var title   = "Confirmation";
           $("#message_dialog").html(content);             
           $("#message_dialog").dialog('option', 'title', title);
           $("#message_dialog").dialog('option', 'width', 320);
           $("#message_dialog").dialog('option', 'height', 180);
           $( "#message_dialog" ).dialog( "option", "buttons", 
              [
                {
                  text: "Yes",
                  icon: "ui-icon-circle-plus",
                  click: function() {
                    deletewServicePromotion(offer_id,offer_name);  
                    $( this ).dialog( "close" );
                  },
                  showText: false
                },
                {
                  text: "Cancel",
                  icon: "ui-icon-circle-plus",
                  click: function() {
                    $( this ).dialog( "close" );
                  }
                }    
              ]
            );           
           $("#message_dialog" ).dialog( "open" );      
    }

    function deletewServiceCertificate(certificate_id,certificate_name)
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { 
            xmlhttp = new XMLHttpRequest();
       }else 
       { 
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response); 
          var status = json_obj.status;
          if (status)
          {
           loadProCertificatesTab("#pro_certificates");
          }          
         }else 
         {
         }
       }
       var formData = new FormData();
       formData.append("op",33);
       formData.append("certificate_id",certificate_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);         
    }

    function deletewServicePromotion(offer_id,offer_name)
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { 
            xmlhttp = new XMLHttpRequest();
       }else 
       { 
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response); 
          var status = json_obj.status;
          if (status)
          {
           loadProPromotionsTab("#pro_promotions");
          }          
         }else 
         {
         }
       }
       var formData = new FormData();
       formData.append("op",30);
       formData.append("offer_id",offer_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);         
    }
    
    function openNewPromotionDialog(merchant_id)
    {
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response); 
          var second_levels = json_obj.second_levels;
          var offered_services = json_obj.pro_services;
          var title = "Add service promotion"
          var dialog_content = "<div class='form-group'><table border='0' style='width:100%'>"
              +"<tr><td><label for='usr' style='color: #333;'>Title:</label></td>"
              +"<td><input type='text' class='form-control' id='offer_title' style='height:24px;'></td></tr>"
              +"<tr><td><label for='pwd' style='color: #333;'>Description:</label></td>"
              +"<td><textarea class='form-control' rows='5' id='offer_desc' style='width:100%'></textarea></td></tr>"
              +"<tr><td colspan='2'><table border='0' style='margin-top:8px;width:100%'><tr><td style='width:25%'><label for='usr' style='color: #333;'>Start date:</label></td>"
              +"<td style='width:25%'><input type='text' class='form-control' id='offer_start_date' style='height:24px;width:96px;'></td>"
              +"<td style='width:25%' align='center'><label for='pwd' style='color: #333;'>End date:</label></td>"
              +"<td style='width:25%'><input type='text' class='form-control' id='offer_end_date' style='height:24px;width:96px;'></td></tr></table></td></tr>"
              +"<tr>" //image
              +"<td><label for='pwd' style='color: #333;'>Image of promotion:</label></td>"
              +"<td>"
                   +"<form enctype='multipart/form-data'>"
                   //+"Select image to upload:"
                   +"<p><input type='file' name='fileToUpload' id='logo_fileToUpload' onchange='readURL(this);'></p>"
                   //+"<p><input type='button' value='Upload Image' name='uploadImage' onClick='uploadImageOfOffer(0);'></p>"
                   +"<p style='margin-top:16px;display:none' id='p_preview'><img id='logo_preview' src='#' alt='your image' /></p>"
                   +"</form>"     
              +"</td></tr>"
              +"<tr>" //Bind offered services
              +"<td valign='top'>"
              +"<p><label for='pwd' style='color: #333;'>Services which offer covered :</label><p>"
              +"<p><i class='fa fa-check-circle' title='Bind with all services' style='font-size:24px;color:#333' onClick='selecttOrCleanAllCoveredService(1)'></i><i class='fa fa-circle-o' title='Unbind with all services' style='font-size:24px;color:#333' onClick='selecttOrCleanAllCoveredService(0)'></i></p>"
              +"</td>"      
              +"<td>"
              +"<div style='width:100%;height:320px;overflow-y: scroll'>";
            for (var i=0;i<second_levels.length;i++)
            {
             dialog_content +="<p style='color:#333'>"+second_levels[i]+"</p>";   
             for (var k=0;k<offered_services.length;k++)
             {
              if (offered_services[k].second_level===second_levels[i]) 
                  dialog_content +="<p style='color:#333'><input type='checkbox' name='cb_services' id='cb_service_"+i+"_"+k+"' value='"+offered_services[k].offeredService_id+"'>"+offered_services[k].name+"</p>";
             }
            }
            dialog_content +="</div>"
              +"</td></tr>"      
              +"</table></div>";
          $("#message_dialog").html(dialog_content);             
          $("#message_dialog").dialog('option', 'title', title);
          
          var w = $(window).width()*0.8;
          var h = $(window).height()*0.6;
          $("#message_dialog").dialog('option', 'width', w);
          $("#message_dialog").dialog('option', 'height', h);
          $("#message_dialog").dialog({ position: 'top' });
          
          $( "#message_dialog" ).dialog( "option", "buttons", 
              [
                {
                  text: "Save",
                  icon: "ui-icon-circle-plus",
                  click: function() {
                    saveNewServicePromotion();  
                    $( this ).dialog( "close" );
                  },
                  showText: false
                },
                {
                  text: "Cancel",
                  icon: "ui-icon-circle-plus",
                  click: function() {
                    $( this ).dialog( "close" );
                  }
                }    
              ]
            );          
          $("#message_dialog" ).dialog( "open" ); 
          $("#offer_start_date" ).datepicker({
       dateFormat: 'yy-mm-dd'});
          $("#offer_end_date" ).datepicker({
       dateFormat: 'yy-mm-dd'});   
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",28);
       formData.append("mid",merchant_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);        
    }
    
    function saveNewServicePromotion()
    {
     var title = $("#offer_title").val();
     var desc  = $("#offer_desc").val();
     var start_date = $("#offer_start_date").val();
     var end_date = $("#offer_end_date").val();
     var fileSelect = document.getElementById("logo_fileToUpload");
     var files = fileSelect.files;
     var file = files[0];
     var selected_services = $("input[name=cb_services]:checked").map(function() {
            return this.value;
       }).get().join(",");   
       
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { 
            xmlhttp = new XMLHttpRequest();
       }else 
       { 
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          //console.log("Response:"+response);
          var json_obj = JSON.parse(response);
          var status = json_obj.status;
          if (status)
          {
           loadProPromotionsTab("#pro_promotions");   
          }
         }else 
         {
         }
       }
       var formData = new FormData();
       formData.append("op",29);
       formData.append("mid",merchant_id);
       formData.append("title",title);
       formData.append("desc",desc);
       formData.append("start_date",start_date);
       formData.append("end_date",end_date);
       formData.append("image",file);
       formData.append("bind_services",selected_services);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);       
    }
    
    function selecttOrCleanAllCoveredService(action_code)
    {
     var allTags = document.body.getElementsByTagName('*');
     var ids = [];
     for (var tg = 0; tg< allTags.length; tg++) 
     {
      var tag = allTags[tg];
      if (startWith(tag.id,"cb_service_")) 
        {
         ids.push("#"+tag.id);
        }   
     }
 
     var counter = ids.length;
     for (var i=0;i<counter;i++)
      {
       if (action_code===0)   
           $(ids[i]).prop("checked", false);
       else
           $(ids[i]).prop("checked", true);
      } 
    }

    function openCaledarForServiceCertificate(certificate_id,index)
    {
     open_calendar_for_certificate = true;   
     var current_date = $("#start_date_"+certificate_id).html();
     if (index===1)
         current_date = $("#end_date_"+certificate_id).html();
     var title = "Change start date of certificate";
     if (index===1)
         title = "Change end date of Certificate";
     var content = "<table border='0' style='width:100%'>"
                  +"<tr><td>Date: <input type='text' id='datepicker' style='width:96px;'></td></tr>"
                  +"</table>";    
     $("#message_dialog").html(content);             
     $("#message_dialog").dialog('option', 'title', title);
     $("#message_dialog").dialog('option', 'width', 320);
     $("#message_dialog").dialog('option', 'height',180);
     $("#message_dialog").dialog("option", "buttons", {});
     $("#message_dialog" ).dialog( "open" ); 
     $("#datepicker" ).datepicker({
       dateFormat: 'yy-mm-dd',
       onClose: function( selectedDate ) {  
        var xmlhttp;
        if (window.XMLHttpRequest) 
        { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
        }else 
        { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlhttp.onreadystatechange = function() 
        {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          if (index===0)
              $("#start_date_"+certificate_id).html(selectedDate);
          else
              $("#end_date_"+certificate_id).html(selectedDate);
          $("#message_dialog").dialog( "close" );    
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
        }
         var formData = new FormData();
         formData.append("op",37);
         formData.append("certificate_id",certificate_id);
         formData.append("index",index);
         formData.append("new_date",selectedDate);
         xmlhttp.open("POST", "pogoproProfileManager.php", false);
         xmlhttp.send(formData);        
      }        
    });
    $("#datepicker" ).val(current_date);
    }

    function openCaledarForOfferSchedule(offer_id,index)
    {
     var current_date = $("#start_date_"+offer_id).html();
     if (index===1)
         current_date = $("#end_date_"+offer_id).html();
     var title = "Change start date of offer";
     if (index===1)
         title = "Change end date of offer";
     var content = "<table border='0' style='width:100%'>"
                  +"<tr><td>Date: <input type='text' id='datepicker'></td></tr>"
                  //+"<tr><td><hr></td></tr>"
                  //+"<tr><td><button type='button' class='btn btn-primary' onClick='updateDescriptionOfOffer("+offer_id+")'>Update</button></td></tr>"
                  +"</table>";
          
     $("#message_dialog").html(content);             
     $("#message_dialog").dialog('option', 'title', title);
     $("#message_dialog" ).dialog( "open" ); 
     $("#datepicker" ).datepicker({
       dateFormat: 'yy-mm-dd',
       onClose: function( selectedDate ) {  
        var xmlhttp;
        if (window.XMLHttpRequest) 
        { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
        }else 
        { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlhttp.onreadystatechange = function() 
        {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          if (index===0)
              $("#start_date_"+offer_id).html(selectedDate);
          else
              $("#end_date_"+offer_id).html(selectedDate);
          $("#message_dialog").dialog( "close" );    
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
        }
         var formData = new FormData();
         formData.append("op",27);
         formData.append("offer_id",offer_id);
         formData.append("index",index);
         formData.append("new_date",selectedDate);
         xmlhttp.open("POST", "pogoproProfileManager.php", false);
         xmlhttp.send(formData);        
      }        
    });
    $("#datepicker" ).val(current_date);
    }
    
    
    function openeditorForDescriptionOfCertificate(certificate_id)
    {
     var offer_desc = $("#offer_desc_"+certificate_id).html();
     var title = "Edit description of certificate";
     var content = "<table border='0' style='width:100%'>"
                  +"<tr><td>Description of certificate:</td></tr>"
                  +"<tr><td><textarea id='desc_certificate' style='width:100%' rows='4' cols='80'>"+offer_desc+"</textarea></td></tr>"
                  //+"<tr><td><hr></td></tr>"
                  //+"<tr><td><button type='button' class='btn btn-primary' onClick='updateDescriptionOfOffer("+certificate_id+")'>Update</button></td></tr>"
                  +"</table>";
          
     $("#message_dialog").html(content);             
     $("#message_dialog").dialog('option', 'title', title);
     $( "#message_dialog" ).dialog( "option", "buttons", 
          [
            {
              text: "Update",
              icon: "ui-icon-circle-plus",
              click: function() {
                updateDescriptionOfCertificate(certificate_id);  
                $( this ).dialog( "close" );
              },
              showText: false
            },
            {
              text: "Cancel",
              icon: "ui-icon-circle-plus",
              click: function() {
                $( this ).dialog( "close" );
              }
            }    
          ]
        );     
     $("#message_dialog" ).dialog( "open" );         
    }
    
    function updateDescriptionOfCertificate(certificate_id)
    {
     var desc_certificate = $("#desc_certificate").val();
     console.log("desc:"+desc_certificate);

      //Call AJAX to uplaoad image and insert into database
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
          {
           //uploadButton.innerHTML = 'Uploading...';
          }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
          {  
           var response = xmlhttp.responseText;
           console.log(response);
           var json_obj = JSON.parse(response);
           var status = json_obj.status;
           if (status)
           {
               $("#message_dialog" ).dialog( "close" ); 
               $("#offer_desc_"+certificate_id).html(desc_certificate);  
           }
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append("op",36);
      formData.append("certificate_id",certificate_id);
      formData.append("certificate_desc", desc_certificate);          
      xmlhttp.open("POST", "pogoproProfileManager.php", true);
      xmlhttp.send(formData);         
    }
    
    function openeditorForDescriptionOfOffer(offer_id)
    {
     var offer_desc = $("#offer_desc_"+offer_id).html();
     var title = "Edit description of offer";
     var content = "<table border='0' style='width:100%'>"
                  +"<tr><td>Description of offer:</td></tr>"
                  +"<tr><td><textarea id='offer_desc' style='width:100%' rows='4' cols='80'>"+offer_desc+"</textarea></td></tr>"
                  +"<tr><td><hr></td></tr>"
                  +"<tr><td><button type='button' class='btn btn-primary' onClick='updateDescriptionOfOffer("+offer_id+")'>Update</button></td></tr>"
                  +"</table>";
          
     $("#message_dialog").html(content);             
     $("#message_dialog").dialog('option', 'title', title);
     $("#message_dialog" ).dialog( "open" );     
    }
    
    function updateDescriptionOfOffer(offer_id)
    {
     var desc_offer = $("#offer_desc").val();
      //Call AJAX to uplaoad image and insert into database
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
          {
           //uploadButton.innerHTML = 'Uploading...';
          }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
          {  
           var response = xmlhttp.responseText;
           console.log(response);
           var json_obj = JSON.parse(response);
           var status = json_obj.status;
           if (status)
           {
               $("#message_dialog" ).dialog( "close" ); 
               $("#offer_desc_"+offer_id).html(desc_offer);  
           }
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append("op",26);
      formData.append("offer_id",offer_id);
      formData.append("offer_desc", desc_offer);          
      xmlhttp.open("POST", "pogoproProfileManager.php", true);
      xmlhttp.send(formData);        
    }
    
    function changeImageOfCertificate(certificate_id)
    {
      var title = "Change image of certificate";
      var content = "<p class='validateTips'>All form fields are required.</p>" 
                   +"<form enctype='multipart/form-data'>"
                   +"Select image to upload:"
                   +"<p><input type='file' name='fileToUpload' id='logo_fileToUpload' onchange='readURL(this);'></p>"
                   +"<p><input type='button' value='Upload Image' name='uploadImage' onClick='uploadImageOfCertificate("+certificate_id+");'></p>"
                   +"<p style='margin-top:16px;display:none' id='p_preview'><img id='logo_preview' src='#' alt='your image' /></p>"
                   +"</form>";
      $("#message_dialog").html(content);             
      $("#message_dialog").dialog('option', 'title', title);
			$("#message_dialog").dialog({ position: { my: "center", at: "top+300", of: window } });//added 12-03-2020
			    $( "#message_dialog" ).dialog( "option", "buttons", 
              [
                
              ]
            );  
      $("#message_dialog" ).dialog( "open" );        
    }    
    
    function changeImageOfOffer(offer_id)
    {
      var title = "Change image of offer";
      var content = "<p class='validateTips'>All form fields are required.</p>" 
                   +"<form enctype='multipart/form-data'>"
                   +"Select image to upload:"
                   +"<p><input type='file' name='fileToUpload' id='logo_fileToUpload' onchange='readURL(this);'></p>"
                   +"<p><input type='button' value='Upload Image' name='uploadImage' onClick='uploadImageOfOffer("+offer_id+");'></p>"
                   +"<p style='margin-top:16px;display:none' id='p_preview'><img id='logo_preview' src='#' alt='your image' /></p>"
                   +"</form>";
      $("#message_dialog").html(content);             
      $("#message_dialog").dialog('option', 'title', title);
			$("#message_dialog").dialog({ position: { my: "center", at: "top+300", of: window } });//added 12-03-2020
			$( "#message_dialog" ).dialog( "option", "buttons", 
         [
                
         ]
       );  
      $("#message_dialog" ).dialog( "open" );        
    }

    function uploadImageOfCertificate(certificate_id)
    {
      var fileSelect = document.getElementById("logo_fileToUpload");
      var files = fileSelect.files;
      var file = files[0]; 

      //Call AJAX to uplaoad image and insert into database
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
          {
           //uploadButton.innerHTML = 'Uploading...';
          }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
          {  
           var response = xmlhttp.responseText;
           console.log(response);
           var json_obj = JSON.parse(response);
           var status = json_obj.status;
           if (status)
           {
               $("#message_dialog" ).dialog( "close" ); 
               $('#img_'+certificate_id).attr('src', json_obj.offer_image);  
           }
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append("op",13);
      formData.append("certificate_id",certificate_id);
      formData.append("image", file);          
      xmlhttp.open("POST", "upload.php", true);
      xmlhttp.send(formData);           
    }

    function uploadImageOfOffer(offer_id)
    {
      var fileSelect = document.getElementById("logo_fileToUpload");
      var files = fileSelect.files;
      var file = files[0]; 

      //Call AJAX to uplaoad image and insert into database
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
          {
           //uploadButton.innerHTML = 'Uploading...';
          }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
          {  
           var response = xmlhttp.responseText;
           console.log(response);
           var json_obj = JSON.parse(response);
           var status = json_obj.status;
           if (status)
           {
               $("#message_dialog" ).dialog( "close" ); 
               $('#img_'+offer_id).attr('src', json_obj.offer_image);  
           }
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append("op",12);
      formData.append("offer_id",offer_id);
      formData.append("image", file);          
      xmlhttp.open("POST", "upload.php", true);
      xmlhttp.send(formData);           
    }

    function updateCoveredServiceWithCertificate(certificate_id,offered_service_id)
    {
      //console.log("offer id:"+offer_id);   
      var checked = $("#cb_covered_service_"+certificate_id+"_"+offered_service_id). prop("checked");
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          console.log("response:"+response);
          var json_obj = JSON.parse(response);
           
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",35);
       formData.append("certificate_id",certificate_id);
       formData.append("offered_service_id",offered_service_id);
       formData.append("checked",checked);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }

    function updateCoveredService(offer_id,offered_service_id)
    {
      //console.log("offer id:"+offer_id);   
      var checked = $("#cb_covered_service_"+offer_id+"_"+offered_service_id). prop("checked");
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          console.log("response:"+response);
          var json_obj = JSON.parse(response);
           
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",25);
       formData.append("offer_id",offer_id);
       formData.append("offered_service_id",offered_service_id);
       formData.append("checked",checked);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }

    function setOrCleanAllCoveredServiceBindedWithCertificate(certificate_id,action)
    {        
     var allTags = document.body.getElementsByTagName('*');
     var ids = [];
     for (var tg = 0; tg< allTags.length; tg++) 
     {
      var tag = allTags[tg];
      if (startWith(tag.id,"cb_covered_service_"+certificate_id)) 
        {
         ids.push("#"+tag.id);
        }   
     }
 
     var counter = ids.length;
     for (var i=0;i<counter;i++)
      {
       if (action === 1)   
           $(ids[i]).prop("checked", true);
       else
           $(ids[i]).prop("checked", false); 
      }
     var cb_name = "input[name=cb_covered_services_"+certificate_id+"]:checked"; 
     var binded_services = $(cb_name).map(function() {
            return this.value;
       }).get().join(",");
     console.log("covered services:"+binded_services); 

      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          console.log("response:"+response);
          var json_obj = JSON.parse(response);
           
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",34);
       formData.append("certificate_id",certificate_id);
       formData.append("action",action);
       formData.append("binded_services",binded_services);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }

    function setOrCleanAllCoveredService(offer_id,action)
    {        
     var allTags = document.body.getElementsByTagName('*');
     var ids = [];
     for (var tg = 0; tg< allTags.length; tg++) 
     {
      var tag = allTags[tg];
      if (startWith(tag.id,"cb_covered_service_"+offer_id)) 
        {
         ids.push("#"+tag.id);
        }   
     }
 
     var counter = ids.length;
     for (var i=0;i<counter;i++)
      {
       if (action === 1)   
           $(ids[i]).prop("checked", true);
       else
           $(ids[i]).prop("checked", false); 
      }
     var cb_name = "input[name=cb_covered_services_"+offer_id+"]:checked"; 
     var binded_services = $(cb_name).map(function() {
            return this.value;
       }).get().join(",");
     console.log("covered services:"+binded_services); 
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         {
          var response = xmlhttp.responseText;
          console.log("response:"+response);
          var json_obj = JSON.parse(response);
           
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",24);
       formData.append("offer_id",offer_id);
       formData.append("action",action);
       formData.append("binded_services",binded_services);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }
    
    function startWith(tag,prix)
    {
     var len = prix.length;
     var compares = tag.substr(0,len);
     if (compares===prix)
         return true;
     else
         return false;
    }
    
    function initAllButtons()
    {
         var allTags = document.body.getElementsByTagName('*');
         var ids = [];
         for (var tg = 0; tg< allTags.length; tg++) 
         {
            var tag = allTags[tg];
            if (startWith(tag.id,"btn_add_certificate_")
                    ||startWith(tag.id,"btn_add_special_offer_")
                    ||startWith(tag.id,"btn_delete_service_")) 
            {
                    ids.push("#"+tag.id);
             }   
         }
         //console.log("All buttons:"+ids); 
         var counter = ids.length;
         for (var i=0;i<counter;i++)
          {
           $(ids[i]).click(function(e) {
                    e.stopPropagation();
                    });   
          }         
    }
    
    function getCurrentAccordionPosition(offered_service_id)
    {
      //head_offered_service_  
      var allTags = document.body.getElementsByTagName('*');
      var ids = [];
      for (var tg = 0; tg< allTags.length; tg++) 
      {
        var tag = allTags[tg];
        if (startWith(tag.id,"head_offered_service_")) 
           {
            ids.push("#"+tag.id);
           }   
      }
      //console.log("All headers:"+ids);
      return ids.indexOf("#head_offered_service_"+offered_service_id);
    }
    
    function ShowConfirmMessageWithOfferedServiceRemove(merchant_id,category_code,offered_service_id)
    {   
     modalWin.Draggable = false;
     modalWin.Param1 = merchant_id;
     modalWin.Param2 = category_code;
     modalWin.Param3 = offered_service_id;
     modalWin.ShowConfirmationMessage('Are you sure to delete this service?',160,360,'Pogo.Pro remove professional service',null,'Yes',yesRemoveServiceAction,'No',noRemoveServiceAction);
    }  
    function yesRemoveServiceAction()
    {
     //var width = screen.availWidth/2;
     //var height = screen.availHeight/2; 
     var offered_service_id = modalWin.Param3;
     modalWin.HideModalPopUp();
     //window.parent.modalWin.Draggable = false; 
     //var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     //window.parent.modalWin.ShowURL('professionalService/removeOfferedProfessionalService.php?mid='+modalWin.Param1+"&ccode="+modalWin.Param2,height,width,'Pogo.Pro remove professional service',null,callbackFunctionArray);  
      //Call AJAX to update database
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //alert(xmlhttp.responseText);  
          //$( "#service_accordion" ).accordion("destory");
          //alert(99);
          
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);
          var offered_service_zone = document.getElementById("service_accordion");
          //alert(offered_service_zone);
          offered_service_zone.innerHTML = json_obj.content;
          offered_service_zone.style.display ='';
          
          var offers = json_obj.specialOffers;
          var array_accordions = offers.split(",");
          //alert(array_accordions);
          var count = array_accordions.length;
          for (var i=0;i<count;i++)
          {
            var name = "#accordion_special_offer_"+array_accordions[i];  
            $( name ).accordion({ 
              collapsible: true,   
              heightStyle: "content"
            });           
          }           
          $( "#service_accordion" ).accordion("refresh");
          initAllButtons();
          
          /*var head_offered_service = document.getElementById("head_offered_service_"+offered_service_id);
          head_offered_service.style.display = 'none';
          var body_offered_service = document.getElementById("body_offered_service_"+offered_service_id);
          body_offered_service.style.display = 'none';*/
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",7);
       formData.append("mid",modalWin.Param1);
       formData.append("ccode",modalWin.Param2);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);  
    }

    function noRemoveServiceAction()
    {
     modalWin.HideModalPopUp();
    } 
    function manageProOfferedServices(merchant_id)
    {
     //var width = screen.availWidth/2+200;
     //var height = screen.availHeight/2+200;        
     //window.parent.modalWin.Draggable = false; 
     //var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     //window.parent.modalWin.ShowURL('professionalService/manageProOfferedServices.php',height,width,'Pogo.Pro Add More Professional Services',null,callbackFunctionArray);   
     //add_new_zone
     //alert(0);
      //Call AJAX to update database
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //alert(xmlhttp.responseText);  
          //$( "#service_accordion" ).accordion("destory");
          //alert(99);
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);
          //var offered_service_zone = document.getElementById("service_accordion");
          //alert(offered_service_zone);
          //offered_service_zone.innerHTML = json_obj.content;
          //offered_service_zone.style.display ='';
          
          //var offers = json_obj.specialOffers;
          //var array_accordions = offers.split(",");
          //alert(array_accordions);
          //var count = array_accordions.length;
          //for (var i=0;i<count;i++)
          //{
           // var name = "#accordion_special_offer_"+array_accordions[i];  
           // $( name ).accordion({ 
           //   collapsible: true,   
           //   heightStyle: "content"
           // });           
          //}           
          //$( "#service_accordion" ).accordion("refresh");
          var add_new_zone = document.getElementById("add_new_zone");
          add_new_zone.innerHTML = json_obj.content;
          add_new_zone.style.display = '';
          $( "#accordion" ).accordion({
            collapsible: true,  
            heightStyle: "content"
           });
          $('[data-toggle="tooltip"]').tooltip();
          var offers = json_obj.tabs;
          var array_accordions = offers.split(",");
          var count = array_accordions.length;
          for (var i=0;i<count;i++)
          {
            var name = "#tabs-"+array_accordions[i];  
            $( name ).tabs();           
          }          
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",8);
       formData.append("mid",merchant_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }
    
    function cancelAddPogoproOfferedService()
    {
      var add_new_zone = document.getElementById("add_new_zone");
      add_new_zone.innerHTML = '';
      add_new_zone.style.display = 'none';        
    }
    
    function AddPogoproOfferedService(merchant_id)
    {
     //alert(99);   
     var services = document.getElementsByName("service[]"); 
     var selectedServices = "";
     var counter = services.length;
     for (var i=0;i<counter;i++)
     {
      if (services[i].checked)
          selectedServices += services[i].value+",";
     }

     if (selectedServices.length>0)
     {
       selectedServices = selectedServices.substr(0,selectedServices.length-1);
       //Call AJAX to insert into db and refresh page
             var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //alert(xmlhttp.responseText); 
          cancelAddPogoproOfferedService();
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);
          var offered_service_zone = document.getElementById("service_accordion");
          //alert(json_obj.content);
          //alert(offered_service_zone.innerHTML + json_obj.content);
          console.log("old innerHTML:"+offered_service_zone.innerHTML);
          offered_service_zone.innerHTML = offered_service_zone.innerHTML + json_obj.content;
          console.log("new innerHTML:"+offered_service_zone.innerHTML);
          offered_service_zone.style.display ='';
          var no_offered_services_message_h4 = document.getElementById("no_offered_services_message");
          if (no_offered_services_message_h4!==null)
          {
           no_offered_services_message_h4.style.display = 'none';  
           document.getElementById("no_offered_services_warn_div").style.display ='none';
          }
          var table_offered_service_control_bar = document.getElementById("table_offered_service_control_bar");
          if (table_offered_service_control_bar!==null)
          {
           if (table_offered_service_control_bar.style.display==='none')
               table_offered_service_control_bar.style.display = '';
          }
          /*
          var offers = json_obj.specialOffers;
          var array_accordions = offers.split(",");
          //alert(array_accordions);
          var count = array_accordions.length;
          for (var i=0;i<count;i++)
          {
            var name = "#accordion_special_offer_"+array_accordions[i];  
            $( name ).accordion({ 
              collapsible: true,   
              heightStyle: "content"
            });           
          }*/           
          $( "#service_accordion" ).accordion("refresh"); 
          initAllButtons();
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",9);
       formData.append("mid",merchant_id);
       formData.append("account_id",user_account_id);
       formData.append("services",selectedServices);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);   
     }
    }
    
    function ShowConfirmMessageWithServiceLanguageRemove(merchant_id,language_id)
    {   
     modalWin.Draggable = false;
     modalWin.Param1 = merchant_id;
     modalWin.Param2 = language_id;
     modalWin.ShowConfirmationMessage('Are you sure to delete this service language?',160,360,'Pogo.Pro remove professional service language',null,'Yes',yesRemoveServiceLanguageAction,'No',noRemoveServiceLanguageAction);
    }  
    function yesRemoveServiceLanguageAction()
    {      
      modalWin.HideModalPopUp();
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //alert(xmlhttp.responseText);   
          var zone_language = document.getElementById("language");
          zone_language.innerHTML = xmlhttp.responseText;
          var add_language_zone = document.getElementById("add_language_zone");
          add_language_zone.innerHTML = '';
          add_language_zone.style.display ='none';
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",4);
       formData.append("mid",modalWin.Param1);
       formData.append("lid",modalWin.Param2);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);       
    }
    function noRemoveServiceLanguageAction()
    {
     modalWin.HideModalPopUp();
    }   
    function editProOfferedServiceLanguages(merchant_id)
    {
      //Call AJAX to update database
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          var add_language_zone = document.getElementById("add_language_zone");
          add_language_zone.innerHTML = xmlhttp.responseText;
          add_language_zone.style.display ='';
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",2);
       formData.append("mid",merchant_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);        
    }
    function cancelAddPogoproServiceLanguages()
    {
     var add_language_zone = document.getElementById("add_language_zone");
     add_language_zone.innerHTML = '';
     add_language_zone.style.display ='none';        
    }
    
    function addPogoproServiceLanguages(merchant_id)
    {
     var selectedServiceLanguages = "";   
     var languages = document.getElementsByName("language[]");
     var counter = languages.length;
     for (var i=0;i<counter;i++)
     {
      if (languages[i].checked)
          selectedServiceLanguages += languages[i].value+",";
     }
     if (selectedServiceLanguages.length>0)
     {
       selectedServiceLanguages = selectedServiceLanguages.substr(0,selectedServiceLanguages.length-1);
      //Call AJAX to update database
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //alert(xmlhttp.responseText);   
          var zone_language = document.getElementById("language");
          zone_language.innerHTML = xmlhttp.responseText;
          var add_language_zone = document.getElementById("add_language_zone");
          add_language_zone.innerHTML = '';
          add_language_zone.style.display ='none';
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",3);
       formData.append("mid",merchant_id);
       formData.append("account_id",user_account_id);
       formData.append("lids",selectedServiceLanguages);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);       
     }
    }
    
    function openSpecialOfferManager(merchant_id,service_categoey_id,offer_id,offeredService_id)
    {  
      var accordion_pos = getCurrentAccordionPosition(offeredService_id);
      currentOpenedAccordion = accordion_pos;
      $("#service_accordion").accordion( "option", "active", accordion_pos);  
      console.log("Open special offer manager:"+offeredService_id+",accordion pos:"+accordion_pos);  
      //Call AJAX to update database
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //alert(xmlhttp.responseText);   
          var add_new_special_offer = document.getElementById("add_new_special_offer_"+offeredService_id);
          add_new_special_offer.innerHTML = xmlhttp.responseText;
          add_new_special_offer.style.display = '';
          $('[data-toggle="tooltip"]').tooltip();
          var c1 =new JsDatePick({
                useMode:2,
                target:"start_date_"+offeredService_id,         
                dateFormat:"%Y-%m-%d"});
          var c2 =new JsDatePick({
                useMode:2,
                target:"end_date_"+offeredService_id,          
                dateFormat:"%Y-%m-%d"});          
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",10);
       formData.append("mid",merchant_id);
       formData.append("scid",service_categoey_id);
       formData.append("oid",offer_id);
       formData.append("osid",offeredService_id)
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }
    
    function cancelAddSpecialOfferTOPogoproOfferedService(offeredService_id)
    {
     var add_new_special_offer = document.getElementById("add_new_special_offer_"+offeredService_id);
     add_new_special_offer.innerHTML ='';
     add_new_special_offer.style.display = 'none';
    }
    
    function cancelAddCertificateTOPogoproOfferedService(offeredService_id)
    {  
     cancelAddSpecialOfferTOPogoproOfferedService(offeredService_id);
    }
    
    function AddCertificateToPogoproOfferedService(
             merchant_id,
             offeredService_id,
             service_category_code)
    {
          
          //return ;
          var option_add_certificate = document.getElementById("status_of_adding_certificate").value;
          if (option_add_certificate==="0")
          { //add new certificate
          //alert(990);
          var offer_name = document.getElementById("offer_name_"+offeredService_id).value;
          //alert(offer_name);
          var offer_desc = document.getElementById("offer_desc_"+offeredService_id).value;
          //alert(offer_desc);
          var end_date = document.getElementById("end_date_"+offeredService_id).value;
          //alert(end_date);
          var form = document.getElementById("file-form");
          var fileSelect = document.getElementById("myFile_"+offeredService_id);
          var files = fileSelect.files;
          var file = files[0];
          //Call AJAX to uplaoad image and insert into database
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {
               //uploadButton.innerHTML = 'Uploading...';
              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              {
               cancelAddSpecialOfferTOPogoproOfferedService(offeredService_id);   
               var response = xmlhttp.responseText;
               //alert(response);
               var json_obj = JSON.parse(response);
               var offered_service_zone = document.getElementById("service_accordion");
               //alert(offered_service_zone);
               offered_service_zone.innerHTML = json_obj.content;
               offered_service_zone.style.display ='';

               var offers = json_obj.specialOffers;
               var array_accordions = offers.split(",");
               //alert(array_accordions);
               var count = array_accordions.length;
               for (var i=0;i<count;i++)
               {
                var name = "#accordion_special_offer_"+array_accordions[i];  
                $( name ).accordion({ 
                  collapsible: true,   
                  heightStyle: "content"
                });           
               }           
               $( "#service_accordion" ).accordion("refresh");  
               $( "#service_accordion" ).accordion("option", "active", currentOpenedAccordion);
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }
            // Add the file to the request.
          var formData = new FormData(form);  
          formData.append("op",8);
          formData.append("mid",merchant_id);
          formData.append("account_id",user_account_id);
          formData.append("offered_service_id",offeredService_id);
          formData.append("service_category_code",service_category_code);
          formData.append("offer_name",offer_name);
          formData.append("offer_desc",offer_desc);
          formData.append("offer_end_date",end_date);
          formData.append("image", file);          
          xmlhttp.open("POST", "upload.php", true);
          xmlhttp.send(formData);      
        }else
        { //use existing certificate
          var selector = document.getElementById("select_certificate");
          var existing_certificate_id = selector.options[selector.selectedIndex].value;
          console.log("Select certificate id:"+existing_certificate_id);
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {
               //uploadButton.innerHTML = 'Uploading...';
              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              {
               cancelAddSpecialOfferTOPogoproOfferedService(offeredService_id);   
               var response = xmlhttp.responseText;
               //alert(response);
               var json_obj = JSON.parse(response);
               var offered_service_zone = document.getElementById("service_accordion");
               //alert(offered_service_zone);
               offered_service_zone.innerHTML = json_obj.content;
               offered_service_zone.style.display ='';

               var offers = json_obj.specialOffers;
               var array_accordions = offers.split(",");
               //alert(array_accordions);
               var count = array_accordions.length;
               for (var i=0;i<count;i++)
               {
                var name = "#accordion_special_offer_"+array_accordions[i];  
                $( name ).accordion({ 
                  collapsible: true,   
                  heightStyle: "content"
                });           
               }           
               $( "#service_accordion" ).accordion("refresh");                  
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }          
          var formData = new FormData(form);  
          formData.append("op",10);
          formData.append("mid",merchant_id);
          formData.append("offered_service_id",offeredService_id);
          formData.append("service_category_code",service_category_code); 
          formData.append("existing_certificate_id",existing_certificate_id);
          xmlhttp.open("POST", "upload.php", true);
          xmlhttp.send(formData);          
        }
    }  
    
    function AddSpecialOfferToPogoproOfferedService(
             merchant_id,
             offeredService_id,
             service_category_code)
    {
          //alert(990);
          var offer_name = document.getElementById("offer_name_"+offeredService_id).value;
          //alert(offer_name);
          var offer_desc = document.getElementById("offer_desc_"+offeredService_id).value;
          //alert(offer_desc);
          var start_date = document.getElementById("start_date_"+offeredService_id).value;
          //alert(start_date);
          var end_date = document.getElementById("end_date_"+offeredService_id).value;
          //alert(end_date);
          var form = document.getElementById("file-form");
          var fileSelect = document.getElementById("myFile_"+offeredService_id);
          var files = fileSelect.files;
          var file = files[0];
          //Call AJAX to uplaoad image and insert into database
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {
               //uploadButton.innerHTML = 'Uploading...';
              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              {
               cancelAddSpecialOfferTOPogoproOfferedService(offeredService_id);   
               var response = xmlhttp.responseText;
               //alert(response);
               var json_obj = JSON.parse(response);
               var offered_service_zone = document.getElementById("service_accordion");
               //alert(offered_service_zone);
               offered_service_zone.innerHTML = json_obj.content;
               offered_service_zone.style.display ='';

               var offers = json_obj.specialOffers;
               var array_accordions = offers.split(",");
               //alert(array_accordions);
               var count = array_accordions.length;
               for (var i=0;i<count;i++)
               {
                var name = "#accordion_special_offer_"+array_accordions[i];  
                $( name ).accordion({ 
                  collapsible: true,   
                  heightStyle: "content"
                });           
               }           
               $( "#service_accordion" ).accordion("refresh");  
               $( "#service_accordion" ).accordion("option", "active", currentOpenedAccordion);
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }
            // Add the file to the request.
          var formData = new FormData(form);  
          formData.append("op",6);
          formData.append("mid",merchant_id);
          formData.append("offered_service_id",offeredService_id);
          formData.append("service_category_code",service_category_code);
          formData.append("offer_name",offer_name);
          formData.append("offer_desc",offer_desc);
          formData.append("offer_start_date",start_date);
          formData.append("offer_end_date",end_date);
          formData.append("image", file);          
          xmlhttp.open("POST", "upload.php", true);
          xmlhttp.send(formData);      
    }
    
    function UpdateSpecialOfferToPogoproOfferedService(
           merchant_id,
           offeredService_id,
           offer_id)
    {
          //alert(990);
          var offer_name = document.getElementById("offer_name_"+offeredService_id).value;
          //alert(offer_name);
          var offer_desc = document.getElementById("offer_desc_"+offeredService_id).value;
          //alert(offer_desc);
          var start_date = document.getElementById("start_date_"+offeredService_id).value;
          //alert(start_date);
          var end_date = document.getElementById("end_date_"+offeredService_id).value;
          //alert(end_date);
          var form = document.getElementById("file-form");
          var fileSelect = document.getElementById("myFile_"+offeredService_id);
          var files = fileSelect.files;
          var file = files[0];
          //Call AJAX to uplaoad image and insert into database
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {
               //uploadButton.innerHTML = 'Uploading...';
              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              {
               cancelAddSpecialOfferTOPogoproOfferedService(offeredService_id);   
               var response = xmlhttp.responseText;
               //alert(response);
               var json_obj = JSON.parse(response);
               var offered_service_zone = document.getElementById("service_accordion");
               //alert(offered_service_zone);
               offered_service_zone.innerHTML = json_obj.content;
               //alert(json_obj.content);
               offered_service_zone.style.display ='';

               var offers = json_obj.specialOffers;
               var array_accordions = offers.split(",");
               //alert(array_accordions);
               var count = array_accordions.length;
               for (var i=0;i<count;i++)
               {
                var name = "#accordion_special_offer_"+array_accordions[i];  
                $( name ).accordion({ 
                  collapsible: true,   
                  heightStyle: "content"
                });           
               }           
               $( "#service_accordion" ).accordion("refresh");                  
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }
            // Add the file to the request.
          var formData = new FormData(form);  
          formData.append("op",7);
          formData.append("mid",merchant_id);
          formData.append("offer_id",offer_id);
          formData.append("offered_service_id",offeredService_id);
          formData.append("offer_name",offer_name);
          formData.append("offer_desc",offer_desc);
          formData.append("offer_start_date",start_date);
          formData.append("offer_end_date",end_date);
          formData.append("image", file);          
          xmlhttp.open("POST", "upload.php", true);
          xmlhttp.send(formData);         
    }
    
    function UpdateCertificateToPogoproOfferedService(
             merchant_id,
             offeredService_id,
             certificate_id)
    {
          var offer_name = document.getElementById("offer_name_"+offeredService_id).value;
          //alert(offer_name);
          var offer_desc = document.getElementById("offer_desc_"+offeredService_id).value;
          //alert(offer_desc);
          var end_date = document.getElementById("end_date_"+offeredService_id).value;
          //alert(end_date);
          var form = document.getElementById("file-form");
          var fileSelect = document.getElementById("myFile_"+offeredService_id);
          var files = fileSelect.files;
          var file = files[0];
          //Call AJAX to uplaoad image and insert into database
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {
               //uploadButton.innerHTML = 'Uploading...';
              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              {
               cancelAddSpecialOfferTOPogoproOfferedService(offeredService_id);   
               var response = xmlhttp.responseText;
               //alert(response);
               var json_obj = JSON.parse(response);
               var offered_service_zone = document.getElementById("service_accordion");
               //alert(offered_service_zone);
               offered_service_zone.innerHTML = json_obj.content;
               offered_service_zone.style.display ='';

               var offers = json_obj.specialOffers;
               var array_accordions = offers.split(",");
               //alert(array_accordions);
               var count = array_accordions.length;
               for (var i=0;i<count;i++)
               {
                var name = "#accordion_special_offer_"+array_accordions[i];  
                $( name ).accordion({ 
                  collapsible: true,   
                  heightStyle: "content"
                });           
               }           
               $( "#service_accordion" ).accordion("refresh");                  
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }
            // Add the file to the request.
          var formData = new FormData(form);  
          formData.append("op",9);
          formData.append("mid",merchant_id);
          formData.append("cid",certificate_id);
          formData.append("offered_service_id",offeredService_id);
          formData.append("offer_name",offer_name);
          formData.append("offer_desc",offer_desc);
          formData.append("offer_end_date",end_date);
          formData.append("image", file);          
          xmlhttp.open("POST", "upload.php", true);
          xmlhttp.send(formData);         
    }
    
    function ShowConfirmMessageWithSpecialOfferRemove(merchant_id,offer_id)
    {   
     modalWin.Draggable = false;
     modalWin.Param1 = merchant_id;
     modalWin.Param2 = offer_id;
     modalWin.ShowConfirmationMessage('Are you sure to delete this special offer?',160,360,'Pogo.Pro Remove special offer of professional service',null,'Yes',yesRemoveSpecialOfferAction,'No',noRemoveSpecialOfferAction);
    }  
    function yesRemoveSpecialOfferAction()
    {    
     modalWin.HideModalPopUp();
          //Call AJAX to uplaoad image and insert into database
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
              if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
              {
               //uploadButton.innerHTML = 'Uploading...';
              }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
              {
               //cancelAddSpecialOfferTOPogoproOfferedService(offeredService_id);   
               var response = xmlhttp.responseText;
               //alert(response);
               var json_obj = JSON.parse(response);
               var offered_service_zone = document.getElementById("service_accordion");
               //alert(offered_service_zone);
               offered_service_zone.innerHTML = json_obj.content;
               offered_service_zone.style.display ='';

               var offers = json_obj.specialOffers;
               var array_accordions = offers.split(",");
               //alert(array_accordions);
               var count = array_accordions.length;
               for (var i=0;i<count;i++)
               {
                var name = "#accordion_special_offer_"+array_accordions[i];  
                $( name ).accordion({ 
                  collapsible: true,   
                  heightStyle: "content"
                });           
               }           
               $( "#service_accordion" ).accordion("refresh");  
               $( "#service_accordion" ).accordion("option", "active", currentOpenedAccordion);
              }else 
              {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
              }
          }
            // Add the file to the request.
          var formData = new FormData();  
          formData.append("op",11);
          formData.append("mid",modalWin.Param1);
          formData.append("oid",modalWin.Param2);      
          xmlhttp.open("POST", "pogoproProfileManager.php", true);
          xmlhttp.send(formData);       
    }

    function noRemoveSpecialOfferAction()
    {
     modalWin.HideModalPopUp();
    } 
    
    function showExistingCertificates()
    {
     document.getElementById("div_add_new_certificate").style.display = 'none';
     document.getElementById("div_use_existing_certificate").style.display = '';
     document.getElementById("status_of_adding_certificate").value = "1";
    }
    
    function openEditorForAddingNewCertificate()
    {
     document.getElementById("div_add_new_certificate").style.display = '';
     document.getElementById("div_use_existing_certificate").style.display = 'none';
     document.getElementById("status_of_adding_certificate").value = "0";
    }    
    
    function manageCertificateOwnedByPro(merchant_id,offer_service_id,certificate_id,service_category_code)
    {
     console.log("Edit this certificate:"+offer_service_id); 
     var accordion_pos = getCurrentAccordionPosition(offer_service_id);
     currentOpenedAccordion = accordion_pos;
     $("#service_accordion").accordion( "option", "active", accordion_pos);
     //var title= "Pogo.Pro Add More Professional Service certificate";   
     //if (certificate_id>0)
     //    title = "Pogo.Pro Edit Professional Service certificate" 
     //var width = screen.availWidth/2+200;
     //var height = screen.availHeight/2+200;        
     //window.parent.modalWin.Draggable = false; 
     //var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     //window.parent.modalWin.ShowURL('professionalService/manageCertificateOfProfessionalService.php?mid='+merchant_id+"&cid="+certificate_id,height,width,title,null,callbackFunctionArray);   
           //Call AJAX to update database
      //alert(merchant_id+","+offer_service_id+","+certificate_id+","+service_category_code);     
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         { 
          //$( "#accordion_certificates" ).accordion("destory");
          //alert(xmlhttp.responseText);
          var zone_add_certificate = document.getElementById("add_new_special_offer_"+offer_service_id);
          zone_add_certificate.innerHTML = xmlhttp.responseText;
          zone_add_certificate.style.display = '';
          var c1 =new JsDatePick({
                    useMode:2,
                    target:'end_date_'+offer_service_id,          
                    dateFormat:'%Y-%m-%d'});

            $( "#accordion" ).accordion({
              heightStyle: "content"
            });


            $('[data-toggle="tooltip"]').tooltip();     
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",6);
       formData.append("mid",merchant_id);
       formData.append("osid",offer_service_id);
       formData.append("cid",certificate_id);
       formData.append("sccode",service_category_code);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }
    function ShowConfirmMessageWithCertificateRemove(merchant_id,certificate_id)
    {   
     modalWin.Draggable = false;
     modalWin.Param1 = merchant_id;
     modalWin.Param2 = certificate_id;
     modalWin.ShowConfirmationMessage('Are you sure to delete this certificate?',160,360,'Pogo.Pro remove professional service certificate',null,'Yes',yesRemoveCertificateAction,'No',noRemoveCertificateAction);
    }  
    function yesRemoveCertificateAction()
    {
      modalWin.HideModalPopUp();
      //Call AJAX to update database
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState !== 4 && xmlhttp.status === 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState === 4 && xmlhttp.status === 200) 
         { 
           var response = xmlhttp.responseText;
           var json_obj = JSON.parse(response);  
           var offered_service_zone = document.getElementById("service_accordion");
           offered_service_zone.innerHTML = json_obj.content;
           offered_service_zone.style.display ='';

           var offers = json_obj.specialOffers;
           var array_accordions = offers.split(",");
           var count = array_accordions.length;
           for (var i=0;i<count;i++)
           {
            var name = "#accordion_special_offer_"+array_accordions[i];  
            $( name ).accordion({ 
              collapsible: true,   
              heightStyle: "content"
            });           
           }           
           $( "#service_accordion" ).accordion("refresh"); 
           console.log("current Opened Accordion:"+currentOpenedAccordion);
           $( "#service_accordion" ).accordion("option", "active", currentOpenedAccordion);
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",5);
       formData.append("mid",modalWin.Param1);
       formData.append("cid",modalWin.Param2);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData); 
    }

    function noRemoveCertificateAction()
    {
     modalWin.HideModalPopUp();
    }
    
    function editProfessionalServiceProfile(merchant_id)
    {
      //alert(9);  
      //Call AJAX to update database
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //alert(xmlhttp.responseText); 
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);          
          var general_zone = document.getElementById("general_zone");
          general_zone.style.display ='none';
          var general_update_zone = document.getElementById("general_update_zone");
          general_update_zone.innerHTML = json_obj.editor_content;
          general_update_zone.style.display = ''; 
          var distance_from = json_obj.serviceDistanceRange;
          $( "#distance_range" ).slider({
          range: "max",
          min: 0,
          max: 500,
          value: distance_from,
          slide: function( event, ui ) {
            $( "#distance_from" ).val( ui.value );
          }
          });
          $( "#distance_from" ).val( $( "#distance_range" ).slider( "value" ) ); 
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",0);
       formData.append("mid",merchant_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);           
    }
    
    function openProjectGallery(project_id)
    {
      var title="Pogo.Pro project Gallery viewer";  
      modalWin.Draggable = false; 
      var width = screen.availWidth/2+200;
      var height = screen.availHeight/2+200;
      var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
      var url_string = "projectGalleryViewer.php?ppid="+project_id+"&stype=p";
      modalWin.ShowURL(url_string,height,width,title,null,callbackFunctionArray);        
    }
    
    function updatePogoproProfile(merchant_id)
    {
      var business_no = document.getElementById("business_no").value;
      //alert(business_no);
      var num_of_employee = document.getElementById("num_of_employee").value;
      //alert(num_of_employee);
      var years_in_business = document.getElementById("years_in_business").value;
      //alert(years_in_business);
      var warranty_in_years = document.getElementById("warranty_in_years").value;
      
      var num_of_locations = document.getElementById("num_of_locations").value;
      
      var respond_RFP_in_days = document.getElementById("respond_RFP_in_days").value;
      
      var service_distance_range = document.getElementById("distance_from").value;
      
      var member_of_association = $("#member_of").val();
      console.log("member_of_association:"+member_of_association);
      //alert(warranty_in_years);
      /*
       * supply_material[]
       * has_insurance[]
       * has_work_permit[]
       */
      var supply_material = 0;
      var supply_material_array = document.getElementsByName("supply_material[]");
      if (supply_material_array[0].checked)
          supply_material = 1;
      //alert("Supply Material:"+supply_material);
      
      var has_insurance = 0;
      var has_insurance_array = document.getElementsByName("has_insurance[]");
      if (has_insurance_array[0].checked)
          has_insurance = 1;
      //alert("Has Insurance:"+has_insurance);
      
      var has_work_permit = 0;
      var has_work_permit_array = document.getElementsByName("has_work_permit[]");
      if (has_work_permit_array[0].checked)
          has_work_permit = 1;
      //alert("Has Work Permit:"+has_work_permit);      
        
      //var suite_no = document.getElementById("suite_no").value;
      //alert(suite_no);
      //var street = document.getElementById("street").value;
      //alert(street);
      //var city = document.getElementById("city").value;
      //alert(city);
      //var province = document.getElementById("province").value;
      //alert(province);
      //var country = document.getElementById("country").value;
      //alert(country);
      //var postal_code = document.getElementById("postal_code").value;
      //alert(postal_code);

      //Call AJAX to update database
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //alert(xmlhttp.responseText); 
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);    
          var general_zone = document.getElementById("general_zone_row");
          
          general_zone.innerHTML = json_obj.editor_content;
          general_zone.style.display = '';
          
          document.getElementById("update_notify").style.display ='';
          //start timer for 10 seconds
          setTimeout(hideUpdateNotification, 10000);
          
          //var general_update_zone = document.getElementById("general_update_zone");
          //general_update_zone.innerHTML = '';
          //general_update_zone.style.display = 'none';
         var distance_from = json_obj.serviceDistanceRange;
          $( "#distance_range" ).slider({
          range: "max",
          min: 0,
          max: 500,
          value: distance_from,
          slide: function( event, ui ) {
            $( "#distance_from" ).val( ui.value );
          }
          });
          $( "#distance_from" ).val( $( "#distance_range" ).slider( "value" ) );          
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",1);
       formData.append("mid",merchant_id);
       formData.append("account_id",user_account_id);
       
       formData.append("business_no",business_no);
       formData.append("num_of_employee",num_of_employee);
       formData.append("years_in_business",years_in_business);
       formData.append("warranty_in_years",warranty_in_years);
       formData.append("num_of_locations",num_of_locations);
       formData.append("respond_RFP_in_days",respond_RFP_in_days);
     
       formData.append("supply_material",supply_material);
       formData.append("has_insurance",has_insurance);
       formData.append("has_work_permit",has_work_permit);
       formData.append("service_distance_range",service_distance_range);
        formData.append("member_of_association",member_of_association);
       /*
       formData.append("suite_no",suite_no);
       formData.append("street",street);
       formData.append("city",city);
       formData.append("province",province);
       formData.append("country",country);
       formData.append("postal_code",postal_code);
       */       
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);            
    }
    
    function hideUpdateNotification()
    {
     document.getElementById("update_notify").style.display ='none';   
    }
    
    function cancelUPdatePogoproProfile()
    {
     var general_update_zone = document.getElementById("general_update_zone");
     general_update_zone.style.display = 'none';
     general_update_zone.innerHTML = '';
     var general_zone = document.getElementById("general_zone");
     general_zone.style.display ='';     
    }
    
    function deleteExtraBusinessLocation(extra_biz_address_id)
    {  
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
           var extra_biz_address = document.getElementById("extra_biz_address_"+extra_biz_address_id);
           extra_biz_address.style.display = 'none';
           var num_of_locations = document.getElementById("num_of_locations");
           var numOfLocations = parseInt(num_of_locations.value) - 1;
           num_of_locations.value = numOfLocations;
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",14);
       formData.append("ebaid",extra_biz_address_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }
    
    function showUpdateExtraBusinessLocationEditor(extra_biz_address_id)
    {
      //Call AJAX to update database
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          //alert(xmlhttp.responseText); 
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);
          tags = json_obj.city_list;
          var update_biz_addr_zone = document.getElementById("update_biz_addr_zone_"+extra_biz_address_id);
          update_biz_addr_zone.style.display = '';
          var biz_addr_update_zone = document.getElementById("biz_addr_update_zone_"+extra_biz_address_id);
          biz_addr_update_zone.innerHTML = json_obj.editor;
          
          $("#city_"+extra_biz_address_id).autocomplete({
              source: function( request, response ) {
                      var matcher = new RegExp( "^" + $.ui.autocomplete.escapeRegex( request.term ), "i" );
                      response( $.grep( tags, function( item ){
                          return matcher.test( item );
                      }) );
                  }
            });
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",12);
       formData.append("ebaid",extra_biz_address_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData); 
    }
    
    function changeOnCountry(biz_addr_id)
    {
          var country_name = $("#country_"+biz_addr_id).val();
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
           if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
            {

            }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
            {  
              var response = xmlhttp.responseText;
              //console.log("response:"+response);
              var json_obj = JSON.parse(response);
              $("#biz_address_region").html(json_obj.regions);
              tags = json_obj.city_list;
              console.log("regions:"+json_obj.regions);
            }else 
            {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
            }
          }
          // Add the file to the request.
          var formData = new FormData();  
          formData.append('op',41); 
          formData.append("index",biz_addr_id);
          formData.append("country_name",country_name);      
          xmlhttp.open("POST", "bestProSearchOfProjectManager.php", false);
          xmlhttp.send(formData);          
    }
    
    function changeOnRegion(biz_addr_id)
    {
      var country_name = $("#country_"+biz_addr_id).val();
      var region_name = $("#province_"+biz_addr_id).val();
      console.log("Country:"+country_name+",region:"+region_name);
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
       if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {

        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        {  
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);
          tags = json_obj.city_list;
        }else 
        {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
      }
      // Add the file to the request.
      var formData = new FormData();  
      formData.append('op',40); 
      formData.append("country",country_name);
      formData.append("region",region_name);
      xmlhttp.open("POST", "bestProSearchOfProjectManager.php", false);
      xmlhttp.send(formData);         
    }

    function changeOnCountryForMyAccount()
    {
          var country_name = $("#country").val();
          var xmlhttp;
          if (window.XMLHttpRequest) 
          { // for IE7+, Firefox, Chrome, Opera, Safari
              xmlhttp = new XMLHttpRequest();
          }else 
          { // for IE6, IE5
              xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
          }
          xmlhttp.onreadystatechange = function() 
          {
           if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
            {

            }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
            {  
              var response = xmlhttp.responseText;
              //console.log("response:"+response);
              var json_obj = JSON.parse(response);
              $("#select_tag_pt").html(json_obj.regions);
              tags = json_obj.city_list;
              console.log("regions:"+json_obj.regions);
            }else 
            {
                //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
            }
          }
          // Add the file to the request.
          var formData = new FormData();  
          formData.append('op',54); 
          formData.append("country_name",country_name);      
          xmlhttp.open("POST", "bestProSearchOfProjectManager.php", false);
          xmlhttp.send(formData);          
    }
    
    function changeOnRegionForMyAccount()
    {
      var country_name = $("#country").val();
      var region_name = $("#pt").val();
      //console.log("Country:"+country_name+",region:"+region_name);
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
       if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {

        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        {  
          var response = xmlhttp.responseText;
          //console.log("response:"+response);
          var json_obj = JSON.parse(response);
          tags = json_obj.city_list;
        }else 
        {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
      }
      // Add the file to the request.
      var formData = new FormData();  
      formData.append('op',40); 
      formData.append("country",country_name);
      formData.append("region",region_name);
      xmlhttp.open("POST", "bestProSearchOfProjectManager.php", false);
      xmlhttp.send(formData);         
    }
    
    function cancelUPdatePogoproExtraBusinessAddress(extra_biz_address_id)
    {
      var update_biz_addr_zone = document.getElementById("update_biz_addr_zone_"+extra_biz_address_id);
      update_biz_addr_zone.style.display = 'none';
      var biz_addr_update_zone = document.getElementById("biz_addr_update_zone_"+extra_biz_address_id);
      biz_addr_update_zone.innerHTML = "";        
    }
    
    function updatePogoproExtraBusinessAddress(extra_biz_address_id)
    { 
     var biz_addr_suite_no = document.getElementById("suite_no_"+extra_biz_address_id).value; 
     var biz_addr_street = document.getElementById("street_"+extra_biz_address_id).value;
     var biz_addr_city = document.getElementById("city_"+extra_biz_address_id).value;
     var biz_addr_province = document.getElementById("province_"+extra_biz_address_id).value;
     var biz_addr_country = document.getElementById("country_"+extra_biz_address_id).value;
     var biz_addr_postal_code = document.getElementById("postal_code_"+extra_biz_address_id).value;

     var xmlhttp;
     if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          var update_biz_addr_zone = document.getElementById("update_biz_addr_zone_"+extra_biz_address_id);
          update_biz_addr_zone.style.display = 'none';
          var biz_addr_update_zone = document.getElementById("biz_addr_update_zone_"+extra_biz_address_id);
          biz_addr_update_zone.innerHTML = "";
          
          var column_extra_biz_address = document.getElementById("column_extra_biz_address_"+extra_biz_address_id);
          var new_address = biz_addr_street;
          if (biz_addr_suite_no!=="")
              new_address += " Suite no."+ biz_addr_suite_no;
          new_address +="\r\n"+biz_addr_city+" "+biz_addr_province+" "+biz_addr_country+"\r\n"+biz_addr_postal_code;
          column_extra_biz_address.value = new_address;           
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",13);
       formData.append("ebaid",extra_biz_address_id);
       formData.append("suite_no",biz_addr_suite_no);
       formData.append("street",biz_addr_street);
       formData.append("city",biz_addr_city);
       formData.append("province",biz_addr_province);
       formData.append("country",biz_addr_country);
       formData.append("postal_code",biz_addr_postal_code);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }
    
    function showExtraBusinessAddressAddEditor(merchant_id)
    {  
      var xmlhttp;
      if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          var response = xmlhttp.responseText;
          var json_obj = JSON.parse(response);
          tags = json_obj.city_list;             
          var add_biz_addr_zone = document.getElementById("add_extra_biz_address_zone");
          add_biz_addr_zone.style.display = '';
          add_biz_addr_zone.innerHTML = json_obj.editor;
          var extra_biz_address_id = 0;
          $("#city_"+extra_biz_address_id).autocomplete({
              source: function( request, response ) {
                      var matcher = new RegExp( "^" + $.ui.autocomplete.escapeRegex( request.term ), "i" );
                      response( $.grep( tags, function( item ){
                          return matcher.test( item );
                      }) );
                  }
            });          
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",15);
       formData.append("mid",merchant_id);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);        
    }
    
    function cancelAddPogoproExtraBusinessAddress()
    {
      var add_biz_addr_zone = document.getElementById("add_extra_biz_address_zone");
      add_biz_addr_zone.style.display = 'none';
      add_biz_addr_zone.innerHTML = "";        
    }
    
    function addPogoproExtraBusinessAddress(merchant_id)
    {   
     var extra_biz_address_id = 0;   
     var biz_addr_suite_no = document.getElementById("suite_no_"+extra_biz_address_id).value; 
     var biz_addr_street = document.getElementById("street_"+extra_biz_address_id).value;
     var biz_addr_city = document.getElementById("city_"+extra_biz_address_id).value;
     var biz_addr_province = document.getElementById("province_"+extra_biz_address_id).value;
     var biz_addr_country = document.getElementById("country_"+extra_biz_address_id).value;
     var biz_addr_postal_code = document.getElementById("postal_code_"+extra_biz_address_id).value; 
     var new_extra_biz_address = biz_addr_street;
     if (biz_addr_suite_no!=="")
         new_extra_biz_address += " Suite no."+biz_addr_suite_no;
     new_extra_biz_address += "\r\n"+biz_addr_city+" "+biz_addr_province+" "+biz_addr_country+"\r\n"+biz_addr_postal_code;
     var xmlhttp;
     if (window.XMLHttpRequest) 
       { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
       }else 
       { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
       }
       xmlhttp.onreadystatechange = function() 
       {
         if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
         {
          //document.getElementById(field).innerHTML = "Loading..";
         }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
         {
          cancelAddPogoproExtraBusinessAddress(); 
          var json_obj = JSON.parse(xmlhttp.responseText);
          var new_biz_addr_id = json_obj.new_biz_addr_id;
          var extra_biz_address_set = document.getElementById("extra_biz_address_set"); 
          var contentOfInnerHTML = extra_biz_address_set.innerHTML;
          contentOfInnerHTML += "<tr id='extra_biz_address_"+new_biz_addr_id+"'>";
          contentOfInnerHTML+= "<td style='width: 80%'><textarea rows='3' id=\"column_extra_biz_address_"+new_biz_addr_id+"\" class=\"form-control\" readonly=\"true\" style=\"background-color: transparent;border-color: transparent;\">"+new_extra_biz_address+"</textarea></td>";
          contentOfInnerHTML+= "<td style=\"width: 10%\" valign=\"top\"><i class='fa fa-edit' style='font-size:32px;color:#107FC9' onClick=\"showUpdateExtraBusinessLocationEditor("+new_biz_addr_id+");\"></i></td>";
          contentOfInnerHTML+= "<td style=\"width: 10%\" valign=\"top\"><i class='fa fa-trash' style='font-size:32px;color:#107FC9' onClick=\"deleteExtraBusinessLocation("+new_biz_addr_id+")\"></i></td>";                        
          contentOfInnerHTML+= "</tr>";   
          contentOfInnerHTML+= "<tr id=\"update_biz_addr_zone_"+new_biz_addr_id+"\" style=\"display:none\">";
          contentOfInnerHTML+= "<td colspan=\"3\" id=\"biz_addr_update_zone_"+new_biz_addr_id+"\">";  
          contentOfInnerHTML+= "</td>";   
          contentOfInnerHTML+= "</tr>";          
          //alert(contentOfInnerHTML);
          extra_biz_address_set.innerHTML = contentOfInnerHTML;  
          var num_of_locations = document.getElementById("num_of_locations");
          var numOfLocations = parseInt(num_of_locations.value) + 1;
          num_of_locations.value = numOfLocations;
         }else 
         {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
         }
       }
       var formData = new FormData();
       formData.append("op",16);
       formData.append("mid",merchant_id);
       formData.append("suite_no",biz_addr_suite_no);
       formData.append("street",biz_addr_street);
       formData.append("city",biz_addr_city);
       formData.append("province",biz_addr_province);
       formData.append("country",biz_addr_country);
       formData.append("postal_code",biz_addr_postal_code);
       xmlhttp.open("POST", "pogoproProfileManager.php", false);
       xmlhttp.send(formData);      
    }
    
    function initDialog() {
         $( "#message_dialog" ).dialog({
           autoOpen: false,
           resizable: true,
           height: 350,
           width: 400,
           modal:true,
           overflow:"auto",
           show: {
            effect: "blind",
            duration: 1000
          },
          hide: {
            effect: "explode",
            duration: 1000
          },          
            open: function() 
            {  
             $(this).parents('.ui-dialog').attr('tabindex', -1)[0].focus();
             console.log("")
             if (!message_dialogInit)
             {
              message_dialogInit = true;   
              var closeBtn = $('.ui-dialog-titlebar-close');
              closeBtn.append('<span class="ui-button-icon-primary ui-icon ui-icon-closethick"></span><span class="ui-button-text"></span>');
             }
            },
        close:function()
        {
         open_create_certificate_dialog = false;
        }                
          }); 
      }    
    
   function manageProLogo(action_code)
   {
      var title = "Add logo";
      if (action_code===1)
          title = "Change logo";
      var content = "<p class='validateTips'>All form fields are required.</p>" 
                   +"<form action='upload.php' method='post' enctype='multipart/form-data'>"
                   +"Select image to upload:"
                   +"<p><input type='file' name='fileToUpload' id='logo_fileToUpload' onchange='readURL(this);'></p>"
                   +"<p><input type='button' value='Upload Image' name='uploadImage' onClick='uploadProLogo();'></p>"
                   +"<p style='margin-top:16px;display:none' id='p_preview'><img id='logo_preview' src='#' alt='your image' /></p>"
                   +"</form>";
      $("#message_dialog").html(content);             
      $("#message_dialog").dialog('option', 'title', title);      
      $("#message_dialog" ).dialog( "open" );        
   }
        
   function uploadProLogo()
   {
      var fileSelect = document.getElementById("logo_fileToUpload");
      var files = fileSelect.files;
      var file = files[0]; 

      //Call AJAX to uplaoad image and insert into database
      var xmlhttp;
      if (window.XMLHttpRequest) 
      { // for IE7+, Firefox, Chrome, Opera, Safari
          xmlhttp = new XMLHttpRequest();
      }else 
      { // for IE6, IE5
          xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
      }
      xmlhttp.onreadystatechange = function() 
      {
          if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
          {
           //uploadButton.innerHTML = 'Uploading...';
          }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
          {  
           var response = xmlhttp.responseText;
           //console.log(response);
           var json_obj = JSON.parse(response);
           var status = json_obj.status;
           //console.log("file path:"+json_obj.file_path);
           if (status)
           {
               $("#message_dialog" ).dialog( "close" ); 
               $('#pro_logo').attr('src', json_obj.logo);  
               logo_url = json_obj.logo_image;
               $("#add_logo").css({"display":"none"});
               $("#change_logo").css({"display":""});
           }
          }else 
          {
            //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
          }
      }
        // Add the file to the request.
      var formData = new FormData();  
      formData.append("op",11);
      formData.append("mid",merchant_id);
      formData.append("ex_logo",logo_url);
      formData.append("image", file);          
      xmlhttp.open("POST", "upload.php", true);
      xmlhttp.send(formData);      
   }
   
   function readURL(input)
   {
    console.log("input232",input.files[0]); 
   // alert(input.files[0]);
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function (e) {
            $('#logo_preview').attr('src', e.target.result);
            $("#p_preview").css({"display":""});
        }
        reader.readAsDataURL(input.files[0]);
    }
    } 
  </script>  
</head>
<body style="width:100%;margin-left: 0px;margin-right: -1px;">  
    <div id='message_dialog' title='Pogo.pro promotion material'>        
    </div>    
<?php include_once("includes/header.php");?>     
<div class="container">
    <ul class="breadcrumb" style="color:lightgrey;">
    <li>
      <a href="../index.php">Home</a>
    </li>
    <li class="active">Service profile <label style="color:red">(Get help press Shift + F1)</label></li>
</ul>    
<!--span class="badge" style="height:24px;background-color:#107FC9"><h4 style="margin-top:0px;">My Professional Service Profile</h4></span-->
  <ul class="nav nav-tabs service-profile-nav">
    <li><a data-toggle="tab" href="#general"><span class="badge" style="background-color: #ddd;color: #333;text-shadow: none;font-size: 14px !important;border: 1px solid transparent;border-radius: 4px;">General</span></a></li>
    <li><a data-toggle="tab" href="#language"><span class="badge" style="background-color: #ddd;color: #333;text-shadow: none;font-size: 14px !important;border: 1px solid transparent;border-radius: 4px;">Language</span></a></li>
    <!--li><a data-toggle="tab" href="#offered_services"><span class="badge" style="background-color:lightgrey;">Offered services</span></a></li-->    
    <li><a data-toggle="tab" href="#my_account"><span class="badge" style="background-color: #ddd;color: #333;text-shadow: none;font-size: 14px !important;border: 1px solid transparent;border-radius: 4px;">My account</span></a></li>
    <li><a data-toggle="tab" href="#pro_services"><span class="badge" style="background-color: #ddd;color: #333;text-shadow: none;font-size: 14px !important;border: 1px solid transparent;border-radius: 4px;">Services</span></a></li>    
    <li><a data-toggle="tab" href="#pro_certificates"><span class="badge" style="background-color: #ddd;color: #333;text-shadow: none;font-size: 14px !important;border: 1px solid transparent;border-radius: 4px;">Certificates</span></a></li>
    <li><a data-toggle="tab" href="#pro_promotions"><span class="badge" style="background-color: #ddd;color: #333;text-shadow: none;font-size: 14px !important;border: 1px solid transparent;border-radius: 4px;">Promotions</span></a></li>
    <li><a data-toggle="tab" href="#simple_projects"><span class="badge" style="background-color: #ddd;color: #333;text-shadow: none;font-size: 14px !important;border: 1px solid transparent;border-radius: 4px;">Sample projects</span></a></li>    
  </ul>

  <div class="tab-content">
    <div id="general" class="tab-pane fade<?php if ($p==0) echo " in active"; ?>">
    <table border='0' class="table" style="margin-top: 2px;">
    <thead>
        <th style="width:20%"><img id='pro_logo' src="<?php if ($generalInfo['logo_url']!="") echo SITE_URL.RENOVATION_PRO_LOGO_SERVER_DIR.$generalInfo['logo_url']; else echo RENOVATION_PRO_LOGO_SERVER_DIR."logo-placeholder.jpg"; ?>" style="width:64px;height:64px;border-radius: 8px;"></th>
        <th style="width:70%"><label style="font-size:xx-large;margin-bottom: 32px;"><?php echo $generalInfo['business_name'];?></label></th>	
        <th style="width:10%"><table><tr><td><i class='fa fa-picture-o' id='add_logo' style='font-size:32px;color:#002040;display:<?php echo $show_add_logo; ?>;padding-left: 20px;' data-toggle="tooltip" data-placement="left" title="<?php echo 'Add logo.';?>" onclick="manageProLogo(0)"></i></td><td><i class='fa fa-picture-o' id='change_logo' style='font-size:32px;color:#002040;display:<?php echo $show_change_logo; ?>;padding-left: 20px;' data-toggle="tooltip" data-placement="left" title="<?php echo 'Change logo.';?>" onclick="manageProLogo(1)"></i></td></tr></table></th>
    </thead> 
    <tbody>
    </tbody> 
    </table>      
      <?php 
        //echo $_SESSION['merchant_id'];
        //$generalInfo = $manager->getProfessioalServiceGeneralInfo($_SESSION['merchant_id']);
        //print_r($generalInfo);
      ?>
      <!--p><?php echo $generalInfo['business_name'];?></p-->
      <table border="0" id="general_zone_table" style="width:100%"> 
          <tr>
              <td colspan="2" id="general_zone_row"><?php echo $profile_editor->{"editor_content"};?></td>
          </tr>    
          <tr>
              <td colspan="2">
                  <table style="width: 80%" id="extra_biz_address_set">
                      <tr>
                          <td style="width: 80%">Business location(s):</td>
                          <td style="width: 10%"><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' onclick="showExtraBusinessAddressAddEditor(<?php echo $generalInfo['merchant_id'] ?>)"></i></td>
                          <td style="width: 10%"></td>
                      </tr> 
                      <tr>
                          <td colspan="3" id="add_extra_biz_address_zone" style="display:none"></td>    
                      </tr>
                      <tr id="extra_biz_address_<?php echo $generalInfo['merchant_id']*(-1); ?>">
                          <td style="width: 80%"><textarea rows="3"  id="column_extra_biz_address_<?php echo $generalInfo['merchant_id']*(-1) ?>" class="form-control" readonly="true" style="background-color: transparent;border-color: transparent;"><?php echo $generalInfo['business_location'];?></textarea></td>
                          <td style="width: 10%" valign="top"><i class='fa fa-edit' style='font-size:32px;color:#107FC9' onClick="showUpdateExtraBusinessLocationEditor(<?php echo $generalInfo['merchant_id']*(-1); ?>)"></i></td>
                          <td style="width: 10%;display:none" valign="top"><img src="img/remove.png"></td>                          
                      </tr>
                      <tr id="update_biz_addr_zone_<?php echo $generalInfo['merchant_id']*(-1); ?>" style="display:none">
                          <td colspan="3" id="biz_addr_update_zone_<?php echo $generalInfo['merchant_id']*(-1); ?>">  
                          </td>    
                      </tr>                      
                      <?php
                      $numOfExtraBusinessLocations = count($extra_business_locations);
                      for ($var=0;$var<$numOfExtraBusinessLocations;$var++)
                      {
                       $suite = " Suite ";
                       if ($extra_business_locations[$var]['business_suit_no']=='')
                           $suite ="";
                       else
                           $suite .= $extra_business_locations[$var]['business_suit_no'];
                       $bizLocation = $extra_business_locations[$var]['business_address'].$suite."&#13;&#10;"
                                    .$extra_business_locations[$var]['business_city']." ".$extra_business_locations[$var]['business_province']." ".$extra_business_locations[$var]['business_country']."&#13;&#10;"
                                    .$extra_business_locations[$var]['post_code'];
                      ?>
                      <tr id="extra_biz_address_<?php echo $extra_business_locations[$var]['business_addr_id']; ?>">
                          <td style="width: 80%"><textarea rows="3" id="column_extra_biz_address_<?php echo $extra_business_locations[$var]['business_addr_id']; ?>" class="form-control" readonly="true" style="background-color: transparent;border-color: transparent;"><?php echo $bizLocation;?></textarea></td>
                          <td style="width: 10%" valign="top"><i class='fa fa-edit' style='font-size:32px;color:#107FC9' onClick="showUpdateExtraBusinessLocationEditor(<?php echo $extra_business_locations[$var]['business_addr_id'];?>);"></i></td>
                          <td style="width: 10%" valign="top"><i class='fa fa-trash' style='font-size:32px;color:#107FC9' onClick="deleteExtraBusinessLocation(<?php echo $extra_business_locations[$var]['business_addr_id'];?>)"></i></td>                          
                      </tr>
                      <tr id="update_biz_addr_zone_<?php echo $extra_business_locations[$var]['business_addr_id']; ?>" style="display:none">
                          <td colspan="3" id="biz_addr_update_zone_<?php echo $extra_business_locations[$var]['business_addr_id']; ?>">  
                          </td>    
                      </tr>
                      <?php
                      }
                      ?>                    
                  </table>   
              </td>    
          </tr>        
      </table> 
      <div id="general_update_zone" style="display:none">          
      </div>
    </div>      
    <div id="certificates" class="tab-pane fade<?php if ($p==1) echo " in active"; ?>"> <!-- start of certificates -->
    <?php
     $numOfAllCertificates = count($allCertificatesOwnedBypro);
     if ($numOfAllCertificates>0)
     {
    ?>
        <table class="table" style="width:100%">
        <thead>
            <th style="width:70%">Service Certificates:</th>
	    <th style="width:10%"></th>
            <th style="width:20%"margin-right: 20px;" align="right"><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' class="img-rounded"  data-toggle="tooltip" data-placement="left" title="<?php echo 'Add more service certificate.';?>" onclick="manageCertificateOwnedByPro(<?php echo $_SESSION[merchant_id];?>,-1)" style="padding-left: 20px;"></i></th>
        </thead>
        <tbody>
            <tr><td colspan="3"><div id="add_new_certificate" style="display:none">abc</div></td></tr>    
        </tbody>
        </table>
        <!-- start accordion of certificates -->
<div id="accordion_certificates">
  <?php
   for ($ic=0;$ic<$numOfAllCertificates;$ic++)
   {
    $index = $_SESSION['merchant_id']."_".$allCertificatesOwnedBypro[$ic]['certificate_id'];   
  ?>  
    <h4 style="background-color: lightgray;"><table border="0" style="width:100%" id="table_<?php echo $index."_0"; ?>">
        <tr>
            <td style="width:3%"></td>
            <td style="width:50%"><?php echo $allCertificatesOwnedBypro[$ic]['certificate_name'];?></td> 
            <td style="width:30%"><?php echo "Expires: ".$allCertificatesOwnedBypro[$ic]['certificate_end_date'];?></td>
            <td style="width:9%" align='right'><i class='fa fa-edit' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Click me to edit this certificate.';?>" onclick="manageCertificateOwnedByPro(<?php echo $_SESSION['merchant_id'].",".$allCertificatesOwnedBypro[$ic]['certificate_id']; ?>)"></i></td>
            <td style="width:8%" align='right'><i class='fa fa-trash' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Click me to delete this certificate.';?>" onclick="ShowConfirmMessageWithCertificateRemove(<?php echo $_SESSION['merchant_id'].",".$allCertificatesOwnedBypro[$ic]['certificate_id']; ?>)"></i></td>
        </tr>   
        </table></h4>
  <div>
  <!-- content of certifcate -->
      <table  border="0" style="width:100%" id="table_<?php echo $index."_1"; ?>">
          <thead>
          <th style="width:20%;"></th> 
          <th style="width:80%;"></th>
          </thead>
          <tr>
              <?php if ($allCertificatesOwnedBypro[$ic]['certificate_image']<>'') { ?>
              <td><img src="<?php echo $allCertificatesOwnedBypro[$ic]['certificate_image']; ?>" style="width:32px;height:32px;"></td>
              <?php }else {?>
              <td></td>
              <?php } ?>
              <td><p><?php echo $allCertificatesOwnedBypro[$ic]['certificate_desc']; ?> </p></td>
          </tr>
      </table>   
  </div>
   <?php } ?> 
</div>
        <!-- end accordion of certificates -->
     <?php }else { ?>  
    <div class="alert alert-danger">
        <strong><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' class="img-rounded"  data-toggle="tooltip" data-placement="right" title="<?php echo 'Add more service certificate.';?>" onclick="manageCertificateOwnedByPro(<?php echo $_SESSION[merchant_id];?>,-1)" style="padding-left: 20px;"></i>&nbsp;&nbsp;&nbsp;No Service Certificate!</strong>
    </div>      
     <?php } ?>
            
    </div>     <!-- end of certificates --> 
  <div id="language" class="tab-pane fade<?php if ($p==2) echo " in active"; ?>">
    <?php 
    $numOfSpokenLanguages = count($allSpokenLanguagesByPro);
    $btn_add_visible = "";
    if ($numOfSpokenLanguages>=$numOfServiceLanguages)
        $btn_add_visible = "none";
    if ($numOfSpokenLanguages>0)
    {
    ?> 
        <table class="table" border="0" style="width:100%" >
        <thead>
            <th style="width:70%">Service languages:</th>
	    <th style="width:10%;"></th>
            <th style="width:20%"><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' id="btn_add_language" class="img-rounded"  data-toggle="tooltip" data-placement="left" title="<?php echo 'Add more service language.';?>" onclick="editProOfferedServiceLanguages(<?php echo $_SESSION['merchant_id'];?>)" style="display:<?php echo $btn_add_visible; ?>;padding-left: 20px;"></i></th>
        </thead>
        <tbody>
          <?php  
           for ($kk=0;$kk<$numOfSpokenLanguages;$kk++)
           {
          ?>
          <tr class="<?php if ($kk%2==0) echo 'success'; else echo 'danger'; ?>">
            <td><?php echo $allSpokenLanguagesByPro[$kk]['language_name'] ?></td>  
	    <td></td>
            <td><i class='fa fa-trash' style='font-size:32px;color:#107FC9' class="img-rounded"  data-toggle="tooltip" data-placement="left" title="<?php echo 'Remove this service language.';?>" onClick="ShowConfirmMessageWithServiceLanguageRemove(<?php echo $allSpokenLanguagesByPro[$kk]['merchant_id'].",'".$allSpokenLanguagesByPro[$kk]['language_id']."'"; ?>)"></i></td>                                
          </tr> 
           <?php            
           } ?>
        </tbody>        
        </table>            
    <?php  
    }else { 
    ?>
    <div class="alert alert-danger">
        <strong><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9;padding-left: 20px;' data-toggle="tooltip" data-placement="right" title="<?php echo 'Add more service language.';?>" onclick="editProOfferedServiceLanguages(<?php echo $_SESSION['merchant_id']; ?>)"></i>&nbsp;&nbsp;&nbsp;No service language!</strong>
    </div>        
    <?php
        }  
    ?> 
    <div id="add_language_zone" style="display:none">abc</div>  
    </div>
    <div id="offered_services" class="tab-pane fade<?php if ($p==3) echo " in active"; ?>">     
    <?php 
    $numOfOfferedServices = count($allOfferedServices);
    //echo $numOfOfferedServices;
    if ($numOfOfferedServices>0)
    {
    ?> 
        <table border="0" style="width:100%">
            <tr>
                <td style="width:70%;">Offered Services:</td>
                <td style="width:10%;"></td>
                <td style="width:20%;margin-right: 20px;" align="right"><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9;padding-left: 20px;' data-toggle="tooltip" data-placement="left" title="<?php echo 'Add more professional service.';?>" onclick="manageProOfferedServices(<?php echo $_SESSION['merchant_id'];?>)"></i></td>   
            </tr>
            <tr><td><div id="add_new_zone" style="display:none">abc</div></td></tr>
        </table>
        
        <!-- offered service zone modification -->
        <!--
        <div id="service_second_levels">
        <?php
        /* $num_second_levels = count($allOfferedServices[$numOfOfferedServices-1]);
         if ($num_second_levels>0)
         {
             $promotion_accordions_1 = array();
             for ($ns=0;$ns<$num_second_levels;$ns++)
             {
             ?>
                <h3><?php echo $allOfferedServices[$numOfOfferedServices-1][$ns]; ?></h3>
                <div>
                    <div id="service_accordion_<?php echo $ns; ?>">
                    <?php
                       for ($kk=0;$kk<$numOfOfferedServices-1;$kk++)
                       { 
                        if ($allOfferedServices[$kk]['second_level']==$allOfferedServices[$numOfOfferedServices-1][$ns]) 
                        {
                    ?>
                    <h4 id="head_offered_service_<?php echo $allOfferedServices[$kk]['offeredService_id']; ?>" style="background-color: lightgray"><table border="0" style="width:100%"> <!-- header of accordion -->
                        <tr>
                            <td style="width:2%"></td>
                            <td style="width:40%;"><?php echo $allOfferedServices[$kk]['category_name']; ?></td>
                            <td style="width:20%;"><span class="badge" style="background-color:lightgray"><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Add certificate.';?>" id="btn_add_certificate_<?php echo $allOfferedServices[$kk]['offeredService_id']?>" onClick="manageCertificateOwnedByPro(
                            <?php 
                            $params = $allOfferedServices[$kk]['merchant_id'].",".$allOfferedServices[$kk]['offeredService_id'].",-1,".$allOfferedServices[$kk]['category_id'];
                            echo $params; ?>)"></i>&nbsp;Certificate</span></td>
                            <td style="width:20%;"><span class="badge" style="background-color:lightgray"><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Add special offer.';?>" id="btn_add_special_offer_<?php echo $allOfferedServices[$kk]['offeredService_id']?>" onClick="openSpecialOfferManager(
                            <?php 
                            $params = $allOfferedServices[$kk]['merchant_id'].",".$allOfferedServices[$kk]['category_id'].",-1,".$allOfferedServices[$kk]['offeredService_id'];
                            echo $params; ?>)"></i>&nbsp;Special Offer</span></td>                    
                            <td style="width:18%;"><i class='fa fa-trash' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Remove this professional service.';?>" id="btn_delete_service_<?php echo $allOfferedServices[$kk]['offeredService_id']?>" onClick="ShowConfirmMessageWithOfferedServiceRemove(<?php echo $allOfferedServices[$kk]['merchant_id'].",'".$allOfferedServices[$kk]['pro_service_category_id']."',".$allOfferedServices[$kk]['offeredService_id']; ?>)"></i></td>
                        </tr>    
                        </table></h4> 
                        <div>
                            
                        </div>
                    <?php
                        }
                       }
                    ?> 
                    </div>   
                </div>
            <?php    
             }
         }*/
        ?> 
        </div> 
        -->
        <!-- offered service zone modification --->
        <div id="service_accordion">
          <?php 
          
           for ($kk=0;$kk<$numOfOfferedServices-1;$kk++)
           {
            //echo $kk;   
            $promotion_accordions[$kk] = $allOfferedServices[$kk]['offeredService_id'];            
            //echo "1".$allOfferedServices[$kk]['merchant_id'].",".$allOfferedServices[$kk]['pro_service_category_id'];
            $manager = new pogoproProfessionalServiceManager();
            $certificates = $manager->getValidCertificationsOfProfessionalServices($allOfferedServices[$kk]['merchant_id'],$allOfferedServices[$kk]['pro_service_category_id']);
            $specialOffers = $manager->getValidServiceSpecialOffersForSpecialService($allOfferedServices[$kk]['merchant_id'],$allOfferedServices[$kk]['pro_service_category_id']); 
            if (count($certificates)>0&&count($specialOffers)>0)
                $specialOffers = array_merge($certificates,$specialOffers);
            else{
              if (count($certificates)>0)   
                  $specialOffers = $certificates;
            }
            //echo "2";

          ?> 
            <h4 id="head_offered_service_<?php echo $allOfferedServices[$kk]['offeredService_id']; ?>" style="background-color: lightgray"><table border="0" style="width:100%"> <!-- header of accordion -->
                <tr>
                    <td style="width:2%"></td>
                    <td style="width:40%;"><?php echo $allOfferedServices[$kk]['category_name']; ?></td>
                    <td style="width:20%;"><span class="badge" style="background-color:lightgray"><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Add certificate.';?>" id="btn_add_certificate_<?php echo $allOfferedServices[$kk]['offeredService_id']?>" onClick="manageCertificateOwnedByPro(
                    <?php 
                    $params = $allOfferedServices[$kk]['merchant_id'].",".$allOfferedServices[$kk]['offeredService_id'].",-1,".$allOfferedServices[$kk]['category_id'];
                    echo $params; ?>)"></i>&nbsp;Certificate</span></td>
                    <td style="width:20%;"><span class="badge" style="background-color:lightgray"><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Add special offer.';?>" id="btn_add_special_offer_<?php echo $allOfferedServices[$kk]['offeredService_id']?>" onClick="openSpecialOfferManager(
                    <?php 
                    $params = $allOfferedServices[$kk]['merchant_id'].",".$allOfferedServices[$kk]['category_id'].",-1,".$allOfferedServices[$kk]['offeredService_id'];
                    echo $params; ?>)"></i>&nbsp;Special Offer</span></td>                    
                    <td style="width:18%;"><i class='fa fa-trash' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Remove this professional service.';?>" id="btn_delete_service_<?php echo $allOfferedServices[$kk]['offeredService_id']?>" onClick="ShowConfirmMessageWithOfferedServiceRemove(<?php echo $allOfferedServices[$kk]['merchant_id'].",'".$allOfferedServices[$kk]['pro_service_category_id']."',".$allOfferedServices[$kk]['offeredService_id']; ?>)"></i></td>
                </tr>    
                </table></h4>  
          <div id="body_offered_service_<?php echo $allOfferedServices[$kk]['offeredService_id']; ?>" style='border:0'>             
           <?php 
             $specialOfferCounter = count($specialOffers);             
             if ($specialOfferCounter>0)
             {
           ?>  
          <div id="accordion_special_offer_<?php echo $promotion_accordions[$kk]; ?>">               
            <?php
             for ($specialOffer=0;$specialOffer<$specialOfferCounter;$specialOffer++)
             {              
           ?>
    <h4 id="header_special_offer_<?php echo $specialOffers[$specialOffer]['offer_id']; ?>" style="background-color: lightgray"><table id="special_offer_<?php echo $specialOffers[$specialOffer]['offer_id']."_0"; ?>" style="width:100%" border="0">
        <tr>
            <td style="width:3%"></td>
            <td style="width:50%"><?php echo $specialOffers[$specialOffer]['offer_name'];?></td> 
            <td style="width:12%"><?php echo $specialOffers[$specialOffer]['offer_start_date'];?></td>
            <td style="width:12%"><?php echo $specialOffers[$specialOffer]['offer_end_date'];?></td>
            <?php
            if ($specialOffers[$specialOffer]['offer_id']>0)
            {
            ?>
            <td style="width:11%"><i class='fa fa-edit' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Edit this special offer.';?>" onclick="openSpecialOfferManager(<?php echo $_SESSION['merchant_id'].",'',".$specialOffers[$specialOffer]['offer_id'].",".$allOfferedServices[$kk]['offeredService_id']; ?>)"/></i></td>
            <td style="width:12%"><i class='fa fa-trash' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Delete this special offer.';?>" onclick="ShowConfirmMessageWithSpecialOfferRemove(<?php echo $_SESSION['merchant_id'].",".$specialOffers[$specialOffer]['offer_id']; ?>)"/></i></td>
            <?php
            }else
            {?>
            <td style="width:11%"><i class='fa fa-edit' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Edit this certificate.';?>" onclick="manageCertificateOwnedByPro(<?php echo $_SESSION['merchant_id'].",".$allOfferedServices[$kk]['offeredService_id'].",".$specialOffers[$specialOffer]['offer_id']*(-1).",0"; ?>)"/></i></td>
            <td style="width:12%"><i class='fa fa-trash' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="left" title="<?php echo 'Delete this certificate.';?>" onclick="ShowConfirmMessageWithCertificateRemove(<?php echo $_SESSION['merchant_id'].",".$specialOffers[$specialOffer]['offer_id']*(-1); ?>)"/></i></td>            
            <?php 
            }?>
        </tr>   
    </table></h4>
  <div id="body_special_offer_<?php echo $specialOffers[$specialOffer]['offer_id']; ?>" style='border:0'>
      <table border="0" style="width:100%" id="special_offer_<?php echo $specialOffers[$specialOffer]['offer_id']."_1"; ?>">
          <thead>
          <th style="width:20%;"></th> 
          <th  style="width:80%;"></th>
          </thead>
          <tr>
              <?php if ($specialOffers[$specialOffer]['offer_image']<>'') { ?>
              <td><img src="<?php echo $specialOffers[$specialOffer]['offer_image']; ?>" style="width:32px;height:32px;"></td>
              <?php }else {?>
              <td></td>
              <?php } ?>
              <td><p><?php echo $specialOffers[$specialOffer]['offer_desc']; ?> </p></td>
          </tr>
      </table>   
  </div>
             <?php              
             } ?>
          </div>
             <?php }
             else { ?> 
              <p><strong style="height:16px;">No special offer for this service!</strong></p>             
             <?php } ?>  
          <div id="add_new_special_offer_<?php echo $allOfferedServices[$kk]['offeredService_id'];?>" style="margin-top: 8px;display:none">abcd</div>      
          </div> <!-- end of content of accordion -->
          <?php  
           }
          ?>          
        </div> <!-- end of service_accordion -->     
    <?php } else { ?>
    <table border="0" style="width:100%;display:none" id='table_offered_service_control_bar'>
        <tr>
            <td style="width:70%;">Offered Services:</td>
            <td style="width:10%;"></td>
            <td style="width:20%;margin-right: 20px;" align="right"><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9;padding-left: 20px;' data-toggle="tooltip" data-placement="left" title="<?php echo 'Add more professional service.';?>" onclick="manageProOfferedServices(<?php echo $_SESSION['merchant_id'];?>)"></i></td>   
        </tr>
        <!--tr><td><div id="add_new_zone" style="display:none">abc</div></td></tr-->
    </table>        
    <div id="service_accordion">
    <h4 style="background-color: lightgray;height:32px;" id='no_offered_services_message'>You have no offered service(s)</h4>    
    <div class="alert alert-danger" id='no_offered_services_warn_div'>
        <strong><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="right" title="<?php echo 'Add more professional service.';?>" onclick="manageProOfferedServices(<?php echo $_SESSION['merchant_id'];?>)" style="padding-left: 20px;"></i>&nbsp;&nbsp;&nbsp;Add your offered service!</strong>        
    </div>            
    </div>    
    <div id="add_new_zone" style="margin-top: 8px;display:none">abc</div>    
    <?php } ?>    
    </div>
    <div id="simple_projects" class="tab-pane fade<?php if ($p==4) echo " in active"; ?>"> <!-- simple project -->
    <?php 
     //echo "welcome";
     //$simpleProjects = $manager->getAllMySimpleProjects($_SESSION['merchant_id']);
     $simpleProjectsCounter = count($simpleProjects);
     //echo $simpleProjectsCounter;
     if ($simpleProjectsCounter>0)
     {
    ?>
     <div id="accordion_simple_projects" style="padding-left:4px;padding-right: 4px;"> <!-- accordion simple project -->
     <?php
      for ($sp=0;$sp<$simpleProjectsCounter;$sp++)
      {
       $PostProjectDetails = $simpleProjects[$sp];
       $status = "Closed";          
     ?>
      <!--h3>Simple Project <?php echo $sp+1; ?></h3>
      <div>
      <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
      </div-->
  <!-- Begin of accordion header -->  
  <table border="0" style="width:100%;">
      <tr>
          <td style="width:3%"></td>
          <td style="width:50%"><span class="badge" style="background-color: red"><?php echo $PostProjectDetails['project_title']; ?></span></td>
          <td style="width:20%;visibility:hidden;"><span class="badge" style="background-color: black">Status:<?php echo $status; ?></span></td>
          <td style="width:30%;visibility:hidden;"><span class="badge" style="background-color: blue" onClick="showProjectMessageDashboard(<?php echo $PostProjectDetails['project_id'];  ?>,'Pogo.Pro Message Dashboard')">Messages&nbsp;<span class="badge" style="background-color: yellowgreen;">5</span></span></td>          
          <td style="width:30%;visibility:hidden;"><span class="badge" style="background-color: blue;" onClick="makeAppointment(<?php echo $PostProjectDetails['project_id'];  ?>,'Make Estimation Appointment')">Bids&nbsp;<span class="badge" style="background-color: yellowgreen;">New</span></span></td>
      </tr>         
  </table>  
  <!-- End of accordion header -->
  <!-- Begin of accordion content -->
  <div style="padding-left: 10px;padding-top: 2px;">
      <table border="0" cellpadding="4" style="width:100%;">
          <tr>
              <td style="width:100%;">
                  <div id="tabs<?php echo '_simple-'.$sp;?>" border="0" style="width:100%" >
                    <ul>
                        <li><a href="#tab_desc_<?php echo$sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Description</a></li> 
                        <?php 
                          if ($PostProjectDetails['project_deal_id']>0)
                          {
                        ?>
                        <li><a href="#tab_deal_<?php echo $sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Deal</a></li>
                        <li><a href="#tab_workschedule_<?php echo $sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Work Schedule</a></li>
                        <li><a href="#tab_paymentschedule_<?php echo $sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Payment Schedule</a></li>
                        <li><a href="#tab_gallery_<?php echo $sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Gallery</a></li>                        
                        <?php 
                          }else
                          {?>
                        <li onmouseover="hide_bids_new(<?php echo $sp; ?>);"><a href="#tab_bids_<?php echo$sp ?>"><img src="images/parking-icon.png"/>&nbsp;Bids</a></li>                        
                        <?php
                          }
                        ?>
                    </ul>
                    <div id="tab_desc_<?php echo$sp; ?>"> 
                        <table border="0" border="0" style="width:100%" >
                            <tr>
                                <?php if ($PostProjectDetails['project_attachment']<>'') {?>
                                <td style="width:10%;" valign="top" align="center"><a href="<?php echo $PostProjectDetails['project_attachment'];?>"><img src="img/document_attach.png"></a></td>
                                <td style="width:90%;" valign="top"><?php echo $PostProjectDetails['project_desc']; ?></td>
                                <?php }else {?>
                                <td style="width:100%;" valign="top"><?php echo $PostProjectDetails['project_desc']; ?></td>
                                <?php } ?>    
                            </tr>   
                        </table>     
                    </div>
                    <?php                     
                    //}else {   // Project is in progress    
                      $projectDealDetails = $manager->getProjectDealDetails($PostProjectDetails['project_deal_id']); 
                    ?> 
                    <div id="tab_deal_<?php echo$sp; ?>"> 
                        <table border="0" style="width:100%;">
                            <tr>
                                <?php if ($projectDealDetails['offer_attachment']<>'') {?>
                                <td style="width:10%;" valign="top" align="center"><a href="<?php echo $projectDealDetails['offer_attachment'];?>"><img src="img/document_attach.png"></a></td>
                                <td style="width:90%;" valign="top">
                                    <p><?php echo $projectDealDetails['offer_title']; ?></p>
                                    <p><?php echo $projectDealDetails['offer_price']; ?></p>
                                    <p><?php echo $projectDealDetails['offer_desc']; ?></p>
                                </td>
                                <?php }else {?>
                                <td style="width:100%;" valign="top">
                                    <p><?php echo $projectDealDetails['offer_title']; ?></p>
                                    <p><?php echo $projectDealDetails['offer_price']; ?></p>
                                    <p><?php echo $projectDealDetails['offer_desc']; ?></p>
                                </td>
                                <?php } ?>    
                            </tr>   
                        </table>     
                    </div>  
                    <?php
                     $allWorkSchedules = $manager->getAllWorkSchedulesOfProject($projectDealDetails['posted_project_id']);
                    ?>
                    <div id="tab_workschedule_<?php echo$sp ?>" style="padding-top: 2px;"> 
                      <?php
                       $counter1 = count($allWorkSchedules);
                       if ($counter1>0)
                       {?>
                          <table class="table" style="width:100%">
                            <thead>
                              <tr>
                                <th style="width:13%">Start date</th>
                                <th style="width:12%">End date</th>
                                <th style="width:48%">Task</th>
                                <th style="width:27%">Notice</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php 
                               for ($kk=0;$kk<$counter1;$kk++)
                               {
                              ?>
                              <tr class="<?php if ($kk%2==0) echo "success"; else echo "danger"; ?>">
                                <td><?php echo $allWorkSchedules[$kk]['start_date'];?></td>
                                <td><?php echo $allWorkSchedules[$kk]['end_date'];?></td>
                                <td><?php echo $allWorkSchedules[$kk]['task'];?></td>
                                <td><?php echo $allWorkSchedules[$kk]['notice'];?></td>
                              </tr>
                               <?php } ?>
                            </tbody>
                          </table>                
                           <?php  
                        }else
                        {
                       ?>
                        <div class="alert alert-danger">
                          <strong>No work schedule information!</strong> 
                        </div>                        
                        <?php                         
                        } 
                       ?>  
                    </div>
                    <?php 
                    $allPaymentSchedules = $manager->getAllPaymentSchedulesOfProject($projectDealDetails['posted_project_id']);
                    ?>
                    <div id="tab_paymentschedule_<?php echo$sp; ?>"> 
                      <?php
                       $counter1 = count($allPaymentSchedules);
                       if ($counter1>0)
                       {?>
                        <table class="table" style="width:100%">
                            <thead>
                              <tr>
                                <th style="width:15%">Name</th>
                                <th style="width:38%">Description</th>
                                <th style="width:8%">Amount</th>
                                <th style="width:14%">Issue Date</th>
                                <th style="width:25%">Notice</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php  
                               for ($kk=0;$kk<$counter1;$kk++)
                               {
                              ?>
                              <tr class="<?php if ($kk%2==0) echo 'success'; else echo 'danger'; ?>">
                                <td><?php echo $allPaymentSchedules[$kk]['payment_name'];?></td>
                                <td><?php echo $allPaymentSchedules[$kk]['payment_desc'];?></td>
                                <td><?php echo $allPaymentSchedules[$kk]['payment_amount'];?></td>
                                <td><?php echo $allPaymentSchedules[$kk]['payment_issue_date'];?></td>
                                <td><?php echo $allPaymentSchedules[$kk]['notice'];?></td>
                              </tr>
                               <?php } ?>
                            </tbody>
                          </table>                
                           <?php  
                        }else
                        {
                       ?>
                        <div class="alert alert-danger">
                        <strong>No payment schedule information!</strong>   
                        </div>                        
                        <?php                         
                        } 
                       ?>     
                    </div>
                    <?php 
                    $allGalleryImages = $manager->getAllGalleryImages($projectDealDetails['posted_project_id']);
                    ?>
                    <div id="tab_gallery_<?php echo$sp; ?>"> 
                      <?php
                       $counter1 = count($allGalleryImages);
                       if ($counter1>0)
                       {?>
                          <table class="table">
                            <thead>
                              <tr>
                                <th style="width:10%"></th>  
                                <th style="width:20%">Title</th>
                                <th style="width:60%">Description</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php  
                               for ($kk=0;$kk<$counter1;$kk++)
                               {
                              ?>
                              <tr class="<?php if ($kk%2==0) echo 'success'; else echo 'danger'; ?>">
                                <td><img src="<?php echo $allGalleryImages[$kk]['image_name'] ?>" class="image-round" style="width:32px;height:32px;"   onClick="openProjectGallery(<?php echo $projectDealDetails['posted_project_id'];?>)"/></td>  
                                <td><?php echo $allGalleryImages[$kk]['image_title'];?></td>
                                <td><?php echo $allGalleryImages[$kk]['image_desc'];?></td>
                              </tr>
                               <?php } ?>
                            </tbody>
                          </table>                
                           <?php  
                        }else
                        {
                       ?>
                        <div class="alert alert-danger">
                            <strong><i class='fa fa-plus-square' style='font-size:32px;color:#107FC9' data-toggle="tooltip" data-placement="right" title="<?php echo 'Add more image to project gallery.';?>" onclick="manageImageGalleryOfProject(<?php echo $projectDealDetails['posted_project_id'].',-1'; ?>)" style="padding-left: 20px;"></i>&nbsp;&nbsp;&nbsp;No image for this contract!</strong>
                        </div>                        
                        <?php                         
                        } 
                       ?>     
                    </div>                      
                    <?php //} ?>  
                  </div>
              </td>
          </tr>              
      </table>   
  </div>  
      <?php 
      }
      ?>
      </div> <!-- accordion simple project -->
     <?php 
     }else
     {
     ?>
    <div class="alert alert-danger">
      <strong>Not available</strong> 
    </div>            
     <?php 
     }
     ?>
    </div> <!-- simple project -->
    <div id="my_account" class="tab-pane">
    </div> 
    <div id="pro_services" class="tab-pane">
    </div>     
    <div id="pro_certificates" class="tab-pane">
    </div>
    <div id="pro_promotions" class="tab-pane">
    </div>    
  </div>
</div>
<?php include_once("includes/footer.php"); ?> 
<script>
   <?php 
   for ($i=0;$i<$simpleProjectsCounter;$i++){
   ?>
   $( "#tabs<?php echo "_simple-".$i; ?>").tabs();
   <?php } ?>  
  <?php 
  $count1 = count($accordions);
  for ($i=0;$i<$count1;$i++) {
  ?>
 $(function() {
    $( "#accordion_<?php echo $accordions[$i]; ?>" ).accordion({
      collapsible: true,  
      heightStyle: "content"
    });
   //capture the click on the a tag
   $("#accordion_<?php echo $accordions[$i]; ?> a").click(function() {
      window.location = $(this).attr('href');
      return false;
   });    
  }); 
  <?php }?> 

  <?php 
   for ($go=0;$go<$numOfOfferedServices;$go++)  
   {
  ?>
 $(function() {
    $( "#accordion_special_offer_<?php echo $promotion_accordions[$go]; ?>" ).accordion({
      collapsible: true,  
      heightStyle: "content"
    });   
  });     
  <?php
  } ?>
 $(function() {
    $( "#accordion_certificates" ).accordion({
      collapsible: true,  
      heightStyle: "content"
    });   
  });
  
    /*  $("#btn_add_certificate_79").click(function(e) {
            e.stopPropagation();
            });  
                $("#btn_add_certificate_80").click(function(e) {
            e.stopPropagation();
            });  
                $("#btn_add_certificate_81").click(function(e) {
            e.stopPropagation();
            });  
                $("#btn_add_certificate_82").click(function(e) {
            e.stopPropagation();
            }); 
                $("#btn_add_certificate_83").click(function(e) {
            e.stopPropagation();
            });
                $("#btn_add_certificate_84").click(function(e) {
            e.stopPropagation();
            }); */           
  function callFromChild()
  {
   $( "#accordion_certificates" ).accordion("refresh");
  }
  function refresh_accordion(accordion_name)
  { 
   $( "#"+accordion_name ).accordion("refresh");  
  }
  
  $( "#distance_range" ).slider({
      range: "max",
      min: 0,
      max: 500,
      value: <?php echo $profile_editor->{"serviceDistanceRange"};?>,
      slide: function( event, ui ) {
        $( "#distance_from" ).val( ui.value );
      }
  });
  $( "#distance_from" ).val( $( "#distance_range" ).slider( "value" ) );
</script>
<script src="js/bootstrap.js"></script>
<script src="js/respond.min.js"></script>
<script src="js/application.js"></script>
<script src="js/bootstrap-tooltip.js"></script>
<script defer src="js/jquery.fancybox.js"></script>
<script defer src="js/jquery.flexslider.js"></script>
<script type="text/javascript" src="js/jquery.tweet.js"></script>
<script  src="js/cloud-zoom.1.0.2.js"></script>
<script  type="text/javascript" src="js/jquery.validate.js"></script>
<script type="text/javascript"  src="js/jquery.carouFredSel-6.1.0-packed.js"></script>
<script type="text/javascript"  src="js/jquery.mousewheel.min.js"></script>
<script type="text/javascript"  src="js/jquery.touchSwipe.min.js"></script>
<script type="text/javascript"  src="js/jquery.ba-throttle-debounce.min.js"></script>
<script defer src="js/custom.js"></script>
</body>
</html>

