<?php
  session_start();
  
  include_once("inc/fns.php");
  include_once("inc/vars.php"); 
  include_once("../pogo_utility/professionalServiceManager.php");
  //Test purpose
  $geolocations_lat = array();//45.50867,45.509445,45.508565);
  $geolocations_long = array();//-73.553992,-73.558187,-73.560591);
  $geoCenter_lat = 45.50867; 
  $geoCenter_long = -73.553992;
  $geolocation_info = array();//"Montreal Elm Street Parking Lot. <br />Click on marker to load information",
                          //"Avenue Hotel Parking. <br />Click on marker to load information",
                          //"Boulevard Saint Laurent. <br />Click on marker to load information");   
  //connect to db
  //25-10-2019  db_connect(HOST,USER,PASSWORD,DB);
  if (!isset($_SESSION['current_search_results_page']))
      $_SESSION['current_search_results_page'] = 1;
  $hasSearchFilters = false;
  $counter = -1;
  if (isset($_GET['init']))
  {
   unset($_SESSION['category_codes']);   
  }
  if (isset($_SESSION['category_codes']))
      $hasSearchFilters = true;
  if ($hasSearchFilters)
  {
      $current_page_no = $_SESSION['current_search_results_page'];
      $max_results_per_page = $Max_Records_Display_Per_Page; 
      $current_search_member = 0;
      if (isset($_SESSION['user_id']))
          $current_search_member = $_SESSION['user_id'];
      else if (isset($_SESSION['user_id_tmp']))
          $current_search_member = $_SESSION['user_id_tmp'];
      $manager = new pogoproProfessionalServiceManager();
      $searchResult = $manager->searchPogoProProfessionalService(
              91,//$current_search_member, 
              1,//$current_page_no, 
              20);//$max_results_per_page);

      $counter = count($searchResult);
      //$prosListArray = $manager->getContentOfPogoproProsList($searchResult);
      //$accordions = $prosListArray['accordions'];
      //$tabs = $prosListArray['tabs'];
      //print_r($tabs);
      //$content_pros_list = $prosListArray['content'];;
  }
?>
<html lang="en">
<head>
  <meta charset="utf-8">
    <style>
    /* Tooltip */
    .form-control + .tooltip > .tooltip-inner {
        background-color: #73AD21;
        color: #FFFFFF;
        border: 1px solid green;
        padding: 15px;
        font-size: 12px;
    }
    .tooltip > .tooltip-inner {
        background-color: #73AD21;
        color: #FFFFFF;
        border: 1px solid green;
        padding: 15px;
        font-size: 12px;
    }        
      /* Tooltip on right */
     .form-control + .tooltip.left > .tooltip-arrow 
     {
      border-left: 5px solid red;
     } 
    .tooltip.left > .tooltip-arrow {
      border-left: 5px solid red;
  }  
  </style> 
  <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,300italic,400italic,600,600italic' rel='stylesheet' type='text/css'>
  <link href='https://fonts.googleapis.com/css?family=Crete+Round' rel='stylesheet' type='text/css'>
  <link href="css/bootstrap.css" rel="stylesheet">
  <link href="css/bootstrap-responsive.css" rel="stylesheet">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/flexslider.css" type="text/css" media="screen" rel="stylesheet"  />
  <link href="css/jquery.fancybox.css" rel="stylesheet">
  <link href="css/cloud-zoom.css" rel="stylesheet">
  <!-- JavaScript Calendar -->  
  <link rel="stylesheet" type="text/css" media="all" href="../jsCalendar/jsDatePick_ltr.min.css" />
  <script type="text/javascript" src="../jsCalendar/jsDatePick.min.1.3.js"></script>
  <!-- Modal pop up window -->
  <script src="../pogo_popup_modal/javascript/modalpopupwindow.js" type="text/javascript"></script>
  <script src="../pogo_popup_modal/javascript/modalpopupwindowoperations.js" type="text/javascript"></script>
  <script src="../pogo_utility/js/pogoProDateUtility.js" type="text/javascript"></script>
  <!-- BootStrap -->
  <link rel="stylesheet" href="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
  <script src="http://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>
  <!-- jQuery UI -->
  <script src="jquery_ui/external/jquery.js"></script>
  <script src="jquery_ui/jquery-ui.js"></script>
  <link href="jquery_ui/jquery-ui.css" rel="stylesheet">
  <style>
    #accordion h3 {
        cursor:pointer;
        margin:0px 0px;
        padding:7px 15px;
        background-color:blue;
        font:bold 11px Verdana,Arial,Sans-Serif;
        color:#e6e6e6;
        text-shadow:0px 1px 0px rgba(0,0,0,0.4);
    }      
    #accordion h3.active {
      background-color: red;
      border: 4px solid blue;
  }       
  </style>
  <script>
    $(document).ready(function(){
        $('[data-toggle="tooltip"]').tooltip();
    });
    $(function() {
        $( "#accordion" ).accordion({
          heightStyle: "content"
      });
    });  
    $(function() {
        $( "#accordion_simple_projects" ).accordion({
          heightStyle: "content"
      });
    });     

    function ShowConfirmMessageWithOfferedServiceRemove(merchant_id,category_code)
    {   
     modalWin.Draggable = false;
     modalWin.Param1 = merchant_id;
     modalWin.Param2 = category_code;
     modalWin.ShowConfirmationMessage('Are you sure to delete this service?',160,360,'Pogo.Pro remove professional service',null,'Yes',yesRemoveServiceAction,'No',noRemoveServiceAction);
    }  
    function yesRemoveServiceAction()
    {
     var width = screen.availWidth/2;
     var height = screen.availHeight/2;        
     modalWin.HideModalPopUp();
     window.parent.modalWin.Draggable = false; 
     var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     window.parent.modalWin.ShowURL('professionalService/removeOfferedProfessionalService.php?mid='+modalWin.Param1+"&ccode="+modalWin.Param2,height,width,'Pogo.Pro remove professional service',null,callbackFunctionArray);     
    }

    function noRemoveServiceAction()
    {
     modalWin.HideModalPopUp();
    } 
    function manageProOfferedServices()
    {
     var width = screen.availWidth/2+200;
     var height = screen.availHeight/2+200;        
     window.parent.modalWin.Draggable = false; 
     var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     window.parent.modalWin.ShowURL('professionalService/manageProOfferedServices.php',height,width,'Pogo.Pro Add More Professional Services',null,callbackFunctionArray);             
    }
    function ShowConfirmMessageWithServiceLanguageRemove(merchant_id,language_id)
    {   
     modalWin.Draggable = false;
     modalWin.Param1 = merchant_id;
     modalWin.Param2 = language_id;
     modalWin.ShowConfirmationMessage('Are you sure to delete this service language?',160,360,'Pogo.Pro remove professional service language',null,'Yes',yesRemoveServiceLanguageAction,'No',noRemoveServiceLanguageAction);
    }  
    function yesRemoveServiceLanguageAction()
    {
     var width = screen.availWidth/2;
     var height = screen.availHeight/2;        
     modalWin.HideModalPopUp();
     window.parent.modalWin.Draggable = false; 
     var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     window.parent.modalWin.ShowURL('professionalService/removeOfferedProfessionalServiceLanguage.php?mid='+modalWin.Param1+"&lid="+modalWin.Param2,height,width,'Pogo.Pro Remove Service Language',null,callbackFunctionArray);     
    }
    function noRemoveServiceLanguageAction()
    {
     modalWin.HideModalPopUp();
    }   
    function showProfessionalServiceSearchEngine()
    {
     var width = screen.availWidth/2+200;
     var height = screen.availHeight/2+200;        
     window.parent.modalWin.Draggable = false; 
     var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     window.parent.modalWin.ShowURL('professionalService/manageProOfferedServiceSearchEngine.php',height,width,'Pogo.Pro Professional Services Search Engine',null,callbackFunctionArray);             
    }
    function showServiceReviewOfProfessional(mid)
    {
     var width = screen.availWidth/2+100;
     var height = screen.availHeight/2+100;        
     window.parent.modalWin.Draggable = false; 
     var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     window.parent.modalWin.ShowURL('professionalService/showprofessionalServiceReviews.php?mid='+mid,height,width,'Pogo.Pro Professional Services Reviews',null,callbackFunctionArray);             
    }
    function showServiceSpecialOfferOfProfessional(mid)
    {
     var width = screen.availWidth/2+100;
     var height = screen.availHeight/2+100;        
     window.parent.modalWin.Draggable = false; 
     var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     window.parent.modalWin.ShowURL('professionalService/showprofessionalServiceSpecialOffers.php?mid='+mid,height,width,'Pogo.Pro Professional Services Reviews',null,callbackFunctionArray);             
    } 
    function showServiceCertificatesOfProfessional(mid)
    {
     var width = screen.availWidth/2+100;
     var height = screen.availHeight/2+100;        
     window.parent.modalWin.Draggable = false; 
     var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
     window.parent.modalWin.ShowURL('professionalService/showprofessionalServiceCertifcates.php?mid='+mid,height,width,'Pogo.Pro Professional Services Reviews',null,callbackFunctionArray);             
    }    
    function postMyProject(scodes,user_id) 
    {
     if (user_id<0)
     {
       window.location = "sign_up.php";   
     }else{
     var invitors = getCookie("invitors");
     if (invitors=='')
     {
      //show message to notice member: before post its project, potential professionals has been chosen
      modalWin.Draggable=false;
      modalWin.ShowMessage('You need to invit potential professionals before you post project!',200,400,'Pogo.Pro Professional Service Search Engine');  
     }else
     {
       //alert(invitors);  
       //TODO:
       //clean the checkbox
       var array = invitors.split(",");
       var index;
       var cbox;
       for (index = 0; index < array.length; index++) 
       {
        cbox = document.getElementById('mid_'+array[index]);   
        cbox.checked = false;
        }       
       setCookie("invitors","",1);  
       var width = screen.availWidth/2+100;
       var height = screen.availHeight/2+100;        
       window.parent.modalWin.Draggable = false; 
       var callbackFunctionArray = new Array(EnrollNow, EnrollLater);
       window.parent.modalWin.ShowURL('professionalService/postprofessionalproject.php?scodes='+scodes+"&pips="+invitors,height,width,'Pogo.Pro Post Project',null,callbackFunctionArray);                     
     } 
     }
    }
    
    function refreshGoogleMaps()
    {
     var xmlhttp;
     if (window.XMLHttpRequest) 
     { // for IE7+, Firefox, Chrome, Opera, Safari
        xmlhttp = new XMLHttpRequest();
     }else 
     { // for IE6, IE5
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
     }
     xmlhttp.onreadystatechange = function() 
     {
        if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {
         //document.getElementById(field).innerHTML = "Loading..";
        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        {
         //Get JSON Objects and show the map
         var response = xmlhttp.responseText; 

         var json_obj = JSON.parse(response);
         //ID array
         var merchants_id_array = (json_obj.merchants_id).split(",");
         //NAME array
         var merchants_name_array = (json_obj.merchants_name).split(",");  
         //User GPS Array
         var gps_center = (json_obj.gps_center).split(",");
         var geoCenter_lat = gps_center[0];
         var geoCenter_long = gps_center[1];         
         //Merchant GPS Lat array
         var gps_lat_mercants = (json_obj.gps_lat_merchants).split(",");
         //Merchant GPS Long array
         var gps_long_mercants = (json_obj.gps_long_merchants).split(",");
         //
         count = merchants_id_array.length;
         for (var k=0;k<count;k++)
         {
             var map_object = document.getElementById("map_canvas_"+merchants_id_array[k]);
             var mapCanvas = new google.maps.Map(map_object);
             var mapCenter = new google.maps.LatLng(geoCenter_lat,geoCenter_long);
             
             mapCanvas.setCenter(mapCenter);
             mapCanvas.setZoom(16);
             mapCanvas.setMapTypeId(google.maps.MapTypeId.ROADMAP);
             
             var initPos = new google.maps.LatLng(gps_lat_mercants[k],gps_long_mercants[k]);
             var infoWnd = new google.maps.InfoWindow({
                content :  merchants_name_array[k],
                maxWidth: 100
              }); 
             var marker = new google.maps.Marker({
                position : initPos,
                map : mapCanvas,
                clickable : true
              });
             infoWnd.open(null, marker);              
         }         
        }else 
        {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
    }
    xmlhttp.open("POST", "bestProSearchOfProjectManager.php?op=1&uid=91&pno=1&pmax=20", false);
    xmlhttp.send();     
    }
    
    function showListOfBestPro()
    {
        //alert("Welcome to show list of best pros"); 
        var xmlhttp;
        if (window.XMLHttpRequest) 
        { // for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
        }else 
        { // for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlhttp.onreadystatechange = function() 
        {
        if (xmlhttp.readyState != 4 && xmlhttp.status == 200) 
        {
         //document.getElementById(field).innerHTML = "Loading..";
        }else if (xmlhttp.readyState == 4 && xmlhttp.status == 200) 
        { 
           
         var response = xmlhttp.responseText; 
         var json_obj = JSON.parse(response);

         var accordions = json_obj.accordions;
         var tabs = json_obj.tabs;
         var content = json_obj.content;
         //alert(content);
         var merchants = json_obj.merchants;
         var gps_data_lat = json_obj.gps_data_lat;
         
         var gps_data_long = json_obj.gps_data_long;    
         
         $( "#accordion" ).accordion("destroy");
         var zone_add_construction_object = document.getElementById("accordion");
         zone_add_construction_object.innerHTML = content;
         zone_add_construction_object.style.display = '';
         
         $( "#accordion" ).accordion({
            heightStyle: "content",
            collapsible: true
            //active: false           
         });
        var icons = {
            header: "ui-icon-circle-arrow-e",
            activeHeader: "ui-icon-circle-arrow-s"
        };
        $( "#accordion" ).accordion({
        icons: icons
        });
        
        $('h3').click(function () {
            refreshGoogleMaps();
        });
        
         $("#accordion .ui-accordion-header").css({display:"block",background:"transparent", width:"800px",margin:"0px",border:"4px solid #66ccff"});
         $("#accordion .ui-accordion-content").css({background:"white", width:"800px"});
         $('#accordion input[type="checkbox"]').click(function(e) {
          e.stopPropagation();
         });                  
         
         var array_accordions = accordions.split(",");
         var count = array_accordions.length;
         for (var i=0;i<count;i++)
         {
            $( array_accordions[i] ).accordion({ 
              heightStyle: "content"
            });
         }
         var array_tabs = tabs.split(",");
         count = array_tabs.length;
         for (var i=0;i<count;i++)
         {
           $( array_tabs[i] ).tabs();            
         } 

         //show the map         
         var geoCenter_lat = 45.50867; 
         var geoCenter_long = -73.553992;
         var lats = gps_data_lat.split(",");
         var longs = gps_data_long.split(",");
         var array_merchants = merchants.split(",");
         count = array_merchants.length; 
   
         for (var k=0;k<count;k++)
         {
             var map_object = document.getElementById("map_canvas_"+array_merchants[k]);
             var mapCanvas = new google.maps.Map(map_object);
             var mapCenter = new google.maps.LatLng(geoCenter_lat,geoCenter_long);
             
             mapCanvas.setCenter(mapCenter);
             mapCanvas.setZoom(16);
             mapCanvas.setMapTypeId(google.maps.MapTypeId.ROADMAP);
             
             var initPos = new google.maps.LatLng(lats[k],longs[k]);
             var infoWnd = new google.maps.InfoWindow({
                content :  "United "+k,
                maxWidth: 100
              }); 
             var marker = new google.maps.Marker({
                position : initPos,
                map : mapCanvas,
                clickable : true
              });
             infoWnd.open(null, marker);   
             //$("#map_canvas_"+array_merchants[k]).css({ height: '240px', width: '320px' });
         }
        }else 
        {
          //document.getElementById(field).innerHTML = "Error Occurred. <a href='index.php'>Reload Or Try Again</a> the page.";
        }
        }
        xmlhttp.open("POST", "bestProSearchOfProjectManager.php?op=0", false);
        xmlhttp.send();           
    }
    
    function setCookie(cname, cvalue, exdays) {
        var d = new Date();
        d.setTime(d.getTime() + (exdays*24*60*60*1000));
        var expires = "expires="+d.toUTCString();
        document.cookie = cname + "=" + cvalue;// + "; " + expires;
    }

    function getCookie(cname) {
        var name = cname + "=";
        var ca = document.cookie.split(';');
        for(var i=0; i<ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1);
            if (c.indexOf(name) == 0) return c.substring(name.length, c.length);
        }
        return "";
    }    
    function clickOnInvitation(mid)
    {  
      var invitors = getCookie("invitors"); 
      var cbox = document.getElementById('mid_'+mid);
      if (cbox.checked)
      {
          if (invitors==='')
          {
           setCookie("invitors",cbox.value,1);   
          }else
          {
           var array = invitors.split(",");
           var index = array.indexOf(cbox.value);
           if (index===-1)
           {
            array.push(cbox.value); 
            setCookie("invitors",array.toString(),1);
           }
          }
      }
      else
      {
          if (invitors!='')
          {
            var array = invitors.split(",");
            var pos = array.indexOf(cbox.value);
            if (pos>=0)
            {
             array.splice(pos,1);
             setCookie("invitors",array.toString(),1);
            }
          }
      }
    }
  </script>  
</head>
<body style="width:100%;margin-left: 0px;margin-right: 0px;">    
<?php include_once("includes/header.php");?> 
<form name="post_project" method="Post">    
<div class="container" style="margin-left: 10px;margin-top: 10px;" align="center">    
<h3 style="margin-left: 100px;margin-top: -5px;"><span class="label label-info">Welcome to Pogo.Pro Professional Service Search Dashboard</span>&nbsp;&nbsp;<img src="img/search_engine.png" data-toggle="tooltip" title="<?php echo 'Click me to open search engine.';?>" data-placement="right" onClick="showProfessionalServiceSearchEngine();">&nbsp;&nbsp;<img src="img/projecticon.png" onclick="showListOfBestPro();;" data-toggle="tooltip" title="<?php if (isset($_SESSION['user_id'])) echo 'Click me to post your project.'; else echo 'Notice: Before you can post project, please Click here to join us!';?>" data-placement="right"></h3>    
<table border="0" style="float:center;margin-left: 10px;width:100%" align="center">
<tr>
 <td style="width:100%" valign="top">
  <div id="accordion"  style="width:75%;margin-left: 5px;margin-right: 5px;margin-top: 2px;background: none"> 
<?php if ($counter>0)
{
 //echo $content_pros_list;   
 //$counter =0;       
 for ($k=0;$k<$counter;$k++) 
 {
  $professional = $searchResult[$k]; 
  $sp_index = $professional['merchant_id'];  
  $geolocations_lat[] = $professional['gps_lat'];//45.50867,45.509445,45.508565);
  $geolocations_long[] = $professional['gps_long'];//-73.553992,-73.558187,-73.560591);
  $geolocation_info[] = $professional['business_name'];  
?>     
      <h3><table>
          <tr>
              <td style="width:6%"></td>
              <td style="width:10%"><img src="images/customers.png"</td>
              <td style="width:20%"><?php echo $professional['business_name']; ?></td>
              <td style="width:10%;visibility:<?php if ($professional['certifications']>0) echo 'visible'; else echo 'hidden';?>"><span class="badge" style="background-color: blue" onClick="showServiceCertificatesOfProfessional(<?php echo $professional['merchant_id']; ?>);" data-toggle="tooltip" title="<?php echo 'Click me to show certifications.';?>" data-placement="right">Certificated</span></td>
              <td style="width:10%;visibility:<?php if ($professional['has_work_permit']>0) echo 'visible'; else echo 'hidden';?>"><span class="badge" style="background-color: blue">Work Permit</span></td>              
              <td style="width:10%;visibility:<?php if ($professional['has_promotion']>0) echo 'visible'; else echo 'hidden';?>"><span class="badge" style="background-color: blue" onClick="showServiceSpecialOfferOfProfessional(<?php echo $professional['merchant_id']; ?>);" data-toggle="tooltip" title="<?php echo 'Click me to show Special Offer.';?>" data-placement="right">Special Offer</span></td>
              <td style="width:10%;visibility:<?php if ($professional['service_rating_count']>1) echo 'visible'; else echo 'hidden';?>"><span class="badge" style="background-color: blue" onClick="showServiceReviewOfProfessional(<?php echo $professional['merchant_id']; ?>);" data-toggle="tooltip" title="<?php echo 'Click me to show reviews.';?>" data-placement="right"><?php 
              if ($professional['service_rating_count']>1) 
                  $rating = $professional['service_rating_amount']/($professional['service_rating_count']-1); 
              echo number_format($rating, 1)."/".$professional['service_rating_count']."(reviews)"; ?></span></td>
              <td style="width:10%"><span class="badge" style="background-color: blue" data-toggle="tooltip" title="<?php echo 'Click me to invit this professional.';?>" data-placement="right"><input type="checkbox" id= "mid_<?php echo $professional['merchant_id']; ?>" name="mid_<?php echo $professional['merchant_id']; ?>" value="<?php echo $professional['merchant_id']; ?>" onclick="clickOnInvitation(<?php echo $professional['merchant_id']; ?>)">&nbsp;Invite</span></td>
          </tr>              
      </table></h3>   
  <div>
  <ul class="nav nav-tabs">
      <li><a data-toggle="tab" href="#general_<?php echo $sp_index; ?>"><span class="badge">General</span></a></li>
    <li class="active"><a data-toggle="tab" href="#language_<?php echo $sp_index; ?>"><span class="badge">Language</span></a></li>
    <li><a data-toggle="tab" href="#offered_services_<?php echo $sp_index; ?>"><span class="badge">Offered services</span></a></li>
    <li><a data-toggle="tab" href="#simple_projects_<?php echo $sp_index; ?>"><span class="badge">Sample projects</span></a></li>
  </ul>

  <div class="tab-content">
    <div id="general_<?php echo $sp_index; ?>" class="tab-pane fade">
      <h3 style="margin-top: 2px;">General Info</h3>
      <?php 
        $generalInfo = $manager->getProfessioalServiceGeneralInfo($professional['merchant_id']);
      ?>
      <p><?php echo $generalInfo['business_name'];?></p>
      <table border="0" style="width:100%">
          <tr>
              <td style="width:30%;"><span class="badge" style="background-color:blue">Business No.</span></td>
              <td><h4><?php echo $generalInfo['number_of_biz'];?></h4></td>   
          </tr> 
          <tr>
              <td style="width:30%;"><span class="badge" style="background-color:blue">Location:</td>
              <td><?php echo $generalInfo['business_location'];?></td>
          </tr>
          <tr>
              <td style="width:30%;height:32px;"><span class="badge" style="background-color:blue">Number Of Employees:</span>&nbsp;&nbsp;<?php echo $generalInfo['num_of_employee'];?></td>
              <td><span class="badge" style="background-color:blue">Year in Business:</span>&nbsp;&nbsp;<?php echo $generalInfo['years_in_biz'];?></td>
          </tr> 
          <tr>
              <td style="width:30%;height:32px;"><span class="badge" style="background-color:blue">Supply materials:</span>&nbsp;&nbsp;<?php if ($generalInfo['will_supply_materials']==1) echo "Yes"; else echo "No";?></td>
              <td><span class="badge" style="background-color:blue">Warranty(years):</span>&nbsp;&nbsp;<?php echo $generalInfo['warranty_in_years'];?></td>
          </tr> 
          <tr>
              <td style="width:30%;height:32px;"><span class="badge" style="background-color:blue">Respond RFP(days):</span>&nbsp;&nbsp;<?php echo $generalInfo['respond_RFP_in_days'];?></td>
              <td><span class="badge" style="background-color:blue">Has insurance:</span>&nbsp;&nbsp;<?php if ($generalInfo['has_insurance']==1) echo "Yes";else echo "No";?></td>
          </tr>           
      </table>        
    </div>      
  <div id="language_<?php echo $sp_index; ?>" class="tab-pane fade in active">
    <?php 
    $allSpokenLanguagesByPro = $manager->getServiceLanguagesOfPogoPro($professional['merchant_id']);
    $numOfSpokenLanguages = count($allSpokenLanguagesByPro);
    if ($numOfSpokenLanguages>0)
    {
    ?> 
        <table class="table">
        <tbody>
          <?php  
           for ($kk=0;$kk<$numOfSpokenLanguages;$kk++)
           {
          ?>
          <tr class="<?php if ($kk%2==0) echo 'success'; else echo 'danger'; ?>">
            <td><?php echo $allSpokenLanguagesByPro[$kk]['language_name'] ?></td>  
          </tr> 
           <?php            
           } ?>
        </tbody>        
        </table>            
    <?php  
    }else { 
    ?>
    <div class="alert alert-danger">
        <strong><img src="img/add0.png" class="img-rounded"  data-toggle="tooltip" data-placement="right" title="<?php echo 'Add more service language.';?>" onclick="manageProOfferedServiceLanguages()" style="padding-left: 20px;">&nbsp;&nbsp;&nbsp;No Service Language!</strong>
    </div>        
    <?php
        }  
    ?>  
    </div>
    <div id="offered_services_<?php echo $sp_index; ?>" class="tab-pane fade">
    <?php 
    $allOfferedServices = $manager->getOfferedServicesByMerchant($professional['merchant_id']);
    $numOfOfferedServices =count($allOfferedServices);
    if ($numOfOfferedServices>0)
    {
    ?>    
        <table class="table">
        <tbody>
          <?php  
           for ($kk=0;$kk<$numOfOfferedServices;$kk++)
           {
          ?>
          <tr class="<?php if ($kk%2==0) echo 'success'; else echo 'danger'; ?>">
            <td><?php echo $allOfferedServices[$kk]['category_name'] ?></td>  
          </tr>
           <?php } ?>
        </tbody>        
        </table>    
    <?php } else { ?>
    <div class="alert alert-danger">
        <strong><img src="img/add0.png" class="img-rounded"  data-toggle="tooltip" data-placement="right" title="<?php echo 'Add more professional service.';?>" onclick="manageProOfferedServices()" style="padding-left: 20px;">&nbsp;&nbsp;&nbsp;No Offered Service!</strong>
    </div>         
    <?php } ?>    
    </div>
    <div id="simple_projects_<?php echo $sp_index; ?>" class="tab-pane fade"> <!-- simple project -->
    <?php 
     $simpleProjects = $manager->getAllMySimpleProjects($professional['merchant_id']);
     $simpleProjectsCounter = count($simpleProjects);
     if ($simpleProjectsCounter>0)
     {
    ?>
     <div id="accordion_simple_projects" style="padding-left:4px;padding-right: 4px;"> <!-- accordion simple project -->
     <?php
      for ($sp=0;$sp<$simpleProjectsCounter;$sp++)
      {
       $PostProjectDetails = $simpleProjects[$sp];
       $status = "In progress";          
     ?>
      <!--h3>Simple Project <?php echo $sp+1; ?></h3>
      <div>
      <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.</p>
      </div-->
  <!-- Begin of accordion header -->  
  <table border="0" style="width:100%;">
      <tr>
          <td style="width:10%"></td>
          <td style="width:50%"><span class="badge" style="background-color: red"><?php echo $PostProjectDetails['project_title']; ?></span></td>
          <td style="width:25%;visibility:hidden;"><span class="badge" style="background-color: black">Status:<?php echo $status; ?></span></td>
          <td style="width:8%;visibility:hidden;"><span class="badge" style="background-color: blue" onClick="showProjectMessageDashboard(<?php echo $PostProjectDetails['project_id'];  ?>,'Pogo.Pro Message Dashboard')">Messages&nbsp;<span class="badge" style="background-color: yellowgreen;">5</span></span></td>          
          <td style="width:7%;visibility:hidden;"><span class="badge" style="background-color: blue;" onClick="makeAppointment(<?php echo $PostProjectDetails['project_id'];  ?>,'Make Estimation Appointment')">Bids&nbsp;<span class="badge" style="background-color: yellowgreen;">New</span></span></td>
      </tr>         
  </table>  
  <!-- End of accordion header -->
  <!-- Begin of accordion content -->
  <div style="padding-left: 10px;padding-top: 2px;">
      <table border="0" cellpadding="4" style="width:100%;">
          <tr>
              <td style="width:100%;">
                  <div id="tabs<?php echo '-'.$sp;?>">
                    <ul>
                        <li><a href="#tab_desc_<?php echo$sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Description</a></li> 
                        <?php 
                          if ($PostProjectDetails['project_deal_id']>0)
                          {
                        ?>
                        <li><a href="#tab_deal_<?php echo $sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Deal</a></li>
                        <li><a href="#tab_workschedule_<?php echo $sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Work Schedule</a></li>
                        <li><a href="#tab_paymentschedule_<?php echo $sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Payment Schedule</a></li>
                        <li><a href="#tab_gallery_<?php echo $sp; ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Gallery</a></li>                        
                        <?php 
                          }else
                          {?>
                        <li onmouseover="hide_bids_new(<?php echo $sp; ?>);"><a href="#tab_bids_<?php echo$sp ?>"><img src="images/function_module.png" style="width:16px;height:16px;"/>&nbsp;Bids</a></li>                        
                        <?php
                          }
                        ?>
                    </ul>
                    <div id="tab_desc_<?php echo$sp; ?>"> 
                        <table border="0">
                            <tr>
                                <?php if ($PostProjectDetails['project_attachment']<>'') {?>
                                <td style="width:10%;" valign="top" align="center"><a href="<?php echo $PostProjectDetails['project_attachment'];?>"><img src="img/document_attach.png"></a></td>
                                <td style="width:90%;" valign="top"><?php echo $PostProjectDetails['project_desc']; ?></td>
                                <?php }else {?>
                                <td style="width:100%;" valign="top"><?php echo $PostProjectDetails['project_desc']; ?></td>
                                <?php } ?>    
                            </tr>   
                        </table>     
                    </div>
                    <?php if ($status=='Pending')
                    {
                     $accordions[] = $sp;  
                     $allBids = $manager->getAllBidsOfProject($PostProjectDetails['project_id']);
                     $count_bids = count($allBids);
                     if ($count_bids>0)
                     { 
                    ?>    
                      <div id="tab_bids_<?php echo$sp; ?>"> 
                        <!-- Begin of bids_accordion header -->  
                        <div id="accordion_<?php echo$sp; ?>">
                            <!-- header -->
                            <?php 
                             for ($bid=0;$bid<$count_bids;$bid++)
                             {
                            ?>
                            <table border="0" style="width:100%">
                                <tr>
                                    <td style="width:16%"><img src="images/function_module.png" style="width:16px;height:16px;"/></td>
                                    <td style="width:45%"><?php echo $allBids[$bid]['offer_title']; ?></td>
                                    <td style="width:35%"><?php echo $allBids[$bid]['offer_price']; ?></td>
                                    <?php
                                      if ($allBids[$bid]['offer_attachment']<>'')
                                      {
                                    ?>
                                    <td style="width:16%"><a href="<?php echo $allBids[$bid]['offer_attachment']; ?>"><img src="img/document_attach.png" class="img-round" style="width:24px;height:24px" data-toggle="tooltip" data-placement="right" title="Click me to view attachment of Offer."/></a></td>
                                    <?php                                      
                                      }else
                                      {?> 
                                    <td style="width:16%;visibility:hidden"><a href="<?php echo $allBids[$bid]['offer_attachment']; ?>"><img src="img/document_attach.png" class="img-round" style="width:24px;height:24px" data-toggle="tooltip" data-placement="right" title="Click me to view attachment of Offer."/></a></td>                                        
                                    <?php }?>    
                                    <td style="width:16%" align="right"><img src="img/accept.png" class="image-round" style="width:24px;height:24px" data-toggle="tooltip" data-placement="right" title="Click me to accept this offer." onclick="ShowMessageWithAction(<?php echo $allBids[$bid]['posted_project_id'].",".$allBids[$bid]['project_deal_id'].",".$allBids[$bid]['merchant_id'];?>)"/></td>
                                </tr>   
                            </table>
                            <!-- content -->
                            <div>
                                <p><?php echo $allBids[$bid]['offer_desc']; ?></p>   
                            </div> 
                             <?php                              
                             } 
                             ?>
                        </div>
                        <!-- Begin of accordion header -->
                      </div>
                     <?php }else { ?>
                      <div id="tab_bids_<?php echo$sp; ?>"> 
                        <p>No any bid from invited professionals.</p>
                      </div>
                     <?php } ?> 
                    <?php                     
                    }else {   // Project is in progress    
                      $projectDealDetails = $manager->getProjectDealDetails($PostProjectDetails['project_deal_id']); 
                    ?> 
                    <div id="tab_deal_<?php echo$sp; ?>"> 
                        <table border="0" style="width:100%;">
                            <tr>
                                <?php if ($projectDealDetails['offer_attachment']<>'') {?>
                                <td style="width:10%;" valign="top" align="center"><a href="<?php echo $projectDealDetails['offer_attachment'];?>"><img src="img/document_attach.png"></a></td>
                                <td style="width:90%;" valign="top">
                                    <p><?php echo $projectDealDetails['offer_title']; ?></p>
                                    <p><?php echo $projectDealDetails['offer_price']; ?></p>
                                    <p><?php echo $projectDealDetails['offer_desc']; ?></p>
                                </td>
                                <?php }else {?>
                                <td style="width:100%;" valign="top">
                                    <p><?php echo $projectDealDetails['offer_title']; ?></p>
                                    <p><?php echo $projectDealDetails['offer_price']; ?></p>
                                    <p><?php echo $projectDealDetails['offer_desc']; ?></p>
                                </td>
                                <?php } ?>    
                            </tr>   
                        </table>     
                    </div>  
                    <?php
                     $allWorkSchedules = $manager->getAllWorkSchedulesOfProject($projectDealDetails['posted_project_id']);
                    ?>
                    <div id="tab_workschedule_<?php echo$sp ?>" style="padding-top: 2px;"> 
                      <?php
                       $counter1 = count($allWorkSchedules);
                       if ($counter1>0)
                       {?>
                          <table class="table">
                            <thead>
                              <tr>
                                <th style="width:9%">Start date</th>
                                <th style="width:9%">End date</th>
                                <th style="width:53%">Task</th>
                                <th style="width:23%">Notice</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php 
                               for ($kk=0;$kk<$counter1;$kk++)
                               {
                              ?>
                              <tr class="<?php if ($kk%2==0) echo "success"; else echo "danger"; ?>">
                                <td><?php echo $allWorkSchedules[$kk]['start_date'];?></td>
                                <td><?php echo $allWorkSchedules[$kk]['end_date'];?></td>
                                <td><?php echo $allWorkSchedules[$kk]['task'];?></td>
                                <td><?php echo $allWorkSchedules[$kk]['notice'];?></td>
                              </tr>
                               <?php } ?>
                            </tbody>
                          </table>                
                           <?php  
                        }else
                        {
                       ?>
                        <div class="alert alert-danger">
                          <strong>No work schedule information!</strong> 
                        </div>                        
                        <?php                         
                        } 
                       ?>  
                    </div>
                    <?php 
                    $allPaymentSchedules = $manager->getAllPaymentSchedulesOfProject($projectDealDetails['posted_project_id']);
                    ?>
                    <div id="tab_paymentschedule_<?php echo$sp; ?>"> 
                      <?php
                       $counter1 = count($allPaymentSchedules);
                       if ($counter1>0)
                       {?>
                          <table class="table">
                            <thead>
                              <tr>
                                <th style="width:15%">Name</th>
                                <th style="width:40%">Description</th>
                                <th style="width:8%">Amount</th>
                                <th style="width:11%">Issue Date</th>
                                <th style="width:20%">Notice</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php  
                               for ($kk=0;$kk<$counter1;$kk++)
                               {
                              ?>
                              <tr class="<?php if ($kk%2==0) echo 'success'; else echo 'danger'; ?>">
                                <td><?php echo $allPaymentSchedules[$kk]['payment_name'];?></td>
                                <td><?php echo $allPaymentSchedules[$kk]['payment_desc'];?></td>
                                <td><?php echo $allPaymentSchedules[$kk]['payment_amount'];?></td>
                                <td><?php echo $allPaymentSchedules[$kk]['payment_issue_date'];?></td>
                                <td><?php echo $allPaymentSchedules[$kk]['notice'];?></td>
                              </tr>
                               <?php } ?>
                            </tbody>
                          </table>                
                           <?php  
                        }else
                        {
                       ?>
                        <div class="alert alert-danger">
                        <strong>No payment schedule information!</strong>   
                        </div>                        
                        <?php                         
                        } 
                       ?>     
                    </div>
                    <?php 
                    $allGalleryImages = $manager->getAllGalleryImages($projectDealDetails['posted_project_id']);
                    ?>
                    <div id="tab_gallery_<?php echo$sp; ?>"> 
                      <?php
                       $counter1 = count($allGalleryImages);
                       if ($counter1>0)
                       {?>
                          <table class="table">
                            <thead>
                              <tr>
                                <th style="width:10%"></th>  
                                <th style="width:20%">Title</th>
                                <th style="width:60%">Description</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php  
                               for ($kk=0;$kk<$counter1;$kk++)
                               {
                              ?>
                              <tr class="<?php if ($kk%2==0) echo 'success'; else echo 'danger'; ?>">
                                <td><img src="<?php echo $allGalleryImages[$kk]['image_name'] ?>" class="image-round" style="width:32px;height:32px;"/></td>  
                                <td><?php echo $allGalleryImages[$kk]['image_title'];?></td>
                                <td><?php echo $allGalleryImages[$kk]['image_desc'];?></td>
                              </tr>
                               <?php } ?>
                            </tbody>
                          </table>                
                           <?php  
                        }else
                        {
                       ?>
                        <div class="alert alert-danger">
                            <strong><img src="img/add0.png" class="img-rounded"  data-toggle="tooltip" data-placement="right" title="<?php echo 'Add more image to project gallery.';?>" onclick="manageImageGalleryOfProject(<?php echo $projectDealDetails['posted_project_id'].',-1'; ?>)" style="padding-left: 20px;">&nbsp;&nbsp;&nbsp;No image for this contract!</strong>
                        </div>                        
                        <?php                         
                        } 
                       ?>     
                    </div>                      
                    <?php } ?>  
                  </div>
              </td>
          </tr>              
      </table>   
  </div>  
      <?php 
      }
      ?>
      </div> <!-- accordion simple project -->
     <?php 
     }else
     {
     ?>
    <div class="alert alert-danger">
      <strong>Not available</strong> 
    </div>            
     <?php 
     }
     ?>
    </div> <!-- simple project -->
  </div>
</div>
 <!--/div--> <!-- end of accordion -->   
<?php 
     } 
 ?>    
    </div> <!-- end of accordion -->  
<?php    
   }else {  
  if ($counter==0) 
  {
?>
 <div class="alert alert-danger" style="margin-left: 80px;">
        <strong>&nbsp;No service professionals has been found,please try again!</strong>
    </div>
<?php 
  }
 } 
?>            
        </td> 
        <td style="width:32%" valign="top">
         <?php if ($counter>0) { ?>   
         <div id="map_canvas" style="height:<?php echo (($scroll-1)*48+320); ?>px; border-bottom:#000066 4px solid;"></div> 
         <?php } ?>
        </td>        
    </tr>
</table> 
</div>
</form>    
<?php include_once("includes/footer.php"); ?>  
<script type="text/javascript" src="http://maps.googleapis.com/maps/api/js?sensor=false&libraries=adsense"></script>
<script type='text/javascript'>

    var mapCanvas;
    
	function say_something(){
		alert("Lot data missing!");
	}
	
	function toggleBounce() {

        if (marker.getAnimation() != null) {
          marker.setAnimation(null);
        } else {
          marker.setAnimation(google.maps.Animation.BOUNCE);
        }
      }
	
	function intialize() {
      //Create a map
      //var initPos = new google.maps.LatLng(<?php echo 45.50867;?>,<?php echo -73.553992; ?>);
	//  var initPos_ = new google.maps.LatLng(<?php echo 45.509445;?>,<?php echo -73.558187;?>);
	//  var initPos__ = new google.maps.LatLng(<?php echo 45.508565;?>,<?php echo -73.560591;?>);
      var mapCenter = new google.maps.LatLng(<?php if (isset($_SESSION['gps_lat'])) echo $_SESSION['gps_lat']; else echo "0.00";//45.50867;?>,<?php if (isset($_SESSION['gps_long'])) echo $_SESSION['gps_long']; else echo "0.00";?>);
      mapCanvas = new google.maps.Map(document.getElementById("map_canvas"));
      mapCanvas.setCenter(mapCenter);
      mapCanvas.setZoom(16);
      mapCanvas.setMapTypeId(google.maps.MapTypeId.ROADMAP);
      <?php
       $count = count($geolocations_lat);
       for ($i=0;$i<$count;$i++)
       {
      ?>
      var initPos = new google.maps.LatLng(<?php echo $geolocations_lat[$i].",".$geolocations_long[$i]; ?>);
      var infoWnd = new google.maps.InfoWindow({
        content :  "<?php echo $geolocation_info[$i]; ?>",
        maxWidth: 100
      }); 
      var marker = new google.maps.Marker({
        position : initPos,
        map : mapCanvas,
        clickable : true
      });
      infoWnd.open(null, marker);  

      google.maps.event.addListener(marker, "click", function() {
        //say_something();
        infoWnd.setContent("<?php echo $geolocation_info[$i]; ?>");
        infoWnd.open(mapCanvas, marker);
      });      
       <?php        
       } 
       ?>      	  
    }
    google.maps.event.addDomListener(window, "load", intialize);
    /*  make checkbox enable */
    $('#accordion input[type="checkbox"]').click(function(e) {
    e.stopPropagation();
    });
  </script> 
<script>
   <?php 
   $count = count($tabs);
   for ($i=0;$i<$count;$i++){
   ?>
   $( "<?php echo $tabs[$i]; ?>").tabs();
   <?php } ?>  
  <?php 
  //$accordions = array("simple_projects_9");
  $count1 = count($accordions);
  for ($i=0;$i<$count1;$i++) {
  ?>
 $(function() {
    $( "<?php echo $accordions[$i]; ?>" ).accordion({
      heightStyle: "content"
    });
   //capture the click on the a tag
   $("<?php echo $accordions[$i]; ?> a").click(function() {
      window.location = $(this).attr('href');
      return false;
   });    
  }); 
  <?php }?> 
</script>  
<script src="js/bootstrap.js"></script>
<script src="js/respond.min.js"></script>
<script src="js/application.js"></script>
<script src="js/bootstrap-tooltip.js"></script>
<script defer src="js/jquery.fancybox.js"></script>
<script defer src="js/jquery.flexslider.js"></script>
<script type="text/javascript" src="js/jquery.tweet.js"></script>
<script  src="js/cloud-zoom.1.0.2.js"></script>
<script  type="text/javascript" src="js/jquery.validate.js"></script>
<script type="text/javascript"  src="js/jquery.carouFredSel-6.1.0-packed.js"></script>
<script type="text/javascript"  src="js/jquery.mousewheel.min.js"></script>
<script type="text/javascript"  src="js/jquery.touchSwipe.min.js"></script>
<script type="text/javascript"  src="js/jquery.ba-throttle-debounce.min.js"></script>
<script defer src="js/custom.js"></script>
</body>
</html>

