<?php
include_once("inc/fns.php");
include_once("inc/vars.php"); 
include_once("../pogo_utility/professionalServiceManager.php");
    //connect to db
//76 east db_connect(HOST,USER,PASSWORD,DB); 
$opCode = $_POST['op'];
switch ($opCode)
{
 case 1:
        getListUnApprovedObjects();
        break;
 case 2:
        getListOfUnApprovedItemsByObjectId($_POST['object_id']);
        break;
 case 3:
        getListOfUnApprovedTasksByItemId($_POST['item_id']);
        break;
 case 4:
        approveObject($_POST['object_id']);
        break;
 case 5:
        removeObject($_POST['object_id']);
        break;   
 case 6:
        approveItem($_POST['item_id'],$_POST['object_id']);
        break;
 case 7:
        removeItem($_POST['item_id'],$_POST['object_id']);
        break;     
 case 8:
        approveTask($_POST['task_id'],$_POST['item_id'],$_POST['object_id']);
        break;
 case 9:
        removeTask($_POST['task_id'],$_POST['item_id'],$_POST['object_id']);
        break;         
}

function getListUnApprovedObjects()
{
 $products = new pogoproProfessionalServiceManager();
 echo json_encode(array("objects"=>$products->getAllUnApprovedObjects()));
}

function getListOfUnApprovedItemsByObjectId($object_id)
{
 $products = new pogoproProfessionalServiceManager();
 echo json_encode(array("items"=>$products->GetAllUnApprovedItemsByObjectId($object_id)));
}

function getListOfUnApprovedTasksByItemId($item_id)
{
 $products = new pogoproProfessionalServiceManager();
 echo json_encode(array("tasks"=>$products->GetAllUnApprovedTasksByItemId($item_id)));
}

function approveObject($object_id)
{
   $products = new pogoproProfessionalServiceManager();   
   echo json_encode(
           array(
               "status"=>$products->approveObject($object_id),
               "hide_object"=>$products->shouldHideObject($object_id) 
           ));
}

function removeObject($object_id)
{
   $products = new pogoproProfessionalServiceManager();  
   echo json_encode(
           array(
               "status"=>$products->removeObject($object_id),
               "hide_object"=>$products->shouldHideObject($object_id)
           )
           );
}

function approveItem($item_id,$object_id)
{
   $products = new pogoproProfessionalServiceManager();   
   echo json_encode(
           array(
                     "status"=>$products->approveItem($item_id),
                     "hide_item"=>$products->shouldHideItem($item_id),
                     "hide_object"=>$products->shouldHideObject($object_id) 
           )
           );
}

function removeItem($item_id,$object_id)
{
   $products = new pogoproProfessionalServiceManager();  
   echo json_encode(
           array(
               "status"=>$products->removeItem($item_id),
               "hide_object"=>$products->shouldHideObject($object_id) 
           ));
}

function approveTask($task_id,$item_id,$object_id)
{
   $products = new pogoproProfessionalServiceManager();   
   echo json_encode(
           array("status"=>$products->approveTask($task_id),
                "hide_item"=>$products->shouldHideItem($item_id),
                "hide_object"=>$products->shouldHideObject($object_id)               
           )
           );
}

function removeTask($task_id,$item_id,$object_id)
{
   $products = new pogoproProfessionalServiceManager();  
   echo json_encode(
           array(
                "status"=>$products->removeTask($task_id),
                "hide_item"=>$products->shouldHideItem($item_id),
                "hide_object"=>$products->shouldHideObject($object_id)
               )
           );
}

?>

