<?php
include_once("../inc/vars.php");
include_once("../inc/lib.php");
/*
 * for demo: @demo.versapay.com
 * for production: @secure.versapay.com
 * transaction_type=>"direct_credit", Account payable 
 * transaction_type=>"direct_debit", Account receivable
 */
class versaPayAPIManager
{
 //Demo account:
 //private $token = "EVFE62xuGBB6nuRc3xHk";
 //private $key   = "1pLff-Bsd2VYapPoaRBe";
 //Production account:   
 private $token="qbdzh1Vh1E4npcrfQa5C";
 private $key="Akcwze8zz_fyehSyrbiv";   
 private $headers = array(
        "Accept:application/json",
        "Content-Type:application/json"
    );
  private $db_conn;
  function __construct($conn=null){ //set db connection in constructor
		if($conn){
			$this->db_conn = $conn;	
		}else{
			$dbconnect_obj = new dbconnection();
			$this->db_conn = $dbconnect_obj->conn;
		}
  }		
 
 function createETFTransaction($payload_data)
 {
  $url = "https://".$this->token.":".$this->key."@secure.versapay.com/api/transactions";   
  $handler = curl_init();
  curl_setopt($handler, CURLOPT_URL, $url);
  curl_setopt($handler, CURLOPT_HTTPHEADER, $this->headers);
  curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($handler, CURLOPT_POST, true);
  curl_setopt($handler, CURLOPT_POSTFIELDS, json_encode($payload_data));
  $response = curl_exec($handler); 
  $code = curl_getinfo($handler, CURLINFO_HTTP_CODE);
  return array("curl_code:"=>$code,"response:"=>$response);
 }
 
 function viewATransactionInDetails($token)
 {
  $url = "https://".$this->token.":".$this->key."@secure.versapay.com/api/transactions/".$token;  
  $handler = curl_init();
  curl_setopt($handler, CURLOPT_URL, $url);
  curl_setopt($handler, CURLOPT_HTTPHEADER, $this->headers);
  curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($handler, CURLOPT_HTTPGET, true);
  $response = curl_exec($handler); 
  $code = curl_getinfo($handler, CURLINFO_HTTP_CODE);
  return array("curl_code:"=>$code,"response:"=>$response);  
 }
 
 function cancelATransaction($token)
 {
  $url = "https://".$this->token.":".$this->key."@secure.versapay.com/api/transactions/".$token."/cancel";  
  $handler = curl_init();
  curl_setopt($handler, CURLOPT_URL, $url);
  curl_setopt($handler, CURLOPT_HTTPHEADER, $this->headers);
  curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($handler, CURLOPT_POST, true);
  $response = curl_exec($handler); 
  $code = curl_getinfo($handler, CURLINFO_HTTP_CODE);
  return array("curl_code:"=>$code,"response:"=>$response);     
 }
 
 function viewLatestTransactions($pageNo)
 {
  $url = "https://".$this->token.":".$this->key."@secure.versapay.com/api/transactions/?page=".$pageNo;  
  $handler = curl_init();
  curl_setopt($handler, CURLOPT_URL, $url);
  curl_setopt($handler, CURLOPT_HTTPHEADER, $this->headers);
  curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($handler, CURLOPT_HTTPGET, true);
  $response = curl_exec($handler); 
  $code = curl_getinfo($handler, CURLINFO_HTTP_CODE);
  return array("curl_code:"=>$code,"response:"=>$response);      
 }
 
 function getFundsSource()
 {
  $url = "https://".$this->token.":".$this->key."@secure.versapay.com/api/funds";  
  $handler = curl_init();
  curl_setopt($handler, CURLOPT_URL, $url);
  curl_setopt($handler, CURLOPT_HTTPHEADER, $this->headers);
  curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($handler, CURLOPT_HTTPGET, true);
  $response = curl_exec($handler); 
  $code = curl_getinfo($handler, CURLINFO_HTTP_CODE);
  return array("curl_code:"=>$code,"response:"=>$response);      
 }
 
 function createAnAgreement($payload_data)
 {
  $url = "https://".$this->token.":".$this->key."@secure.versapay.com/api/debit_agreements";   
  $handler = curl_init();
  curl_setopt($handler, CURLOPT_URL, $url);
  curl_setopt($handler, CURLOPT_HTTPHEADER, $this->headers);
  curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($handler, CURLOPT_POST, true);
  curl_setopt($handler, CURLOPT_POSTFIELDS, json_encode($payload_data));
  $response = curl_exec($handler); 
  $code = curl_getinfo($handler, CURLINFO_HTTP_CODE);
  return array("curl_code:"=>$code,"response:"=>$response);     
 }
 
 function viewSentAgreements($pageNo)
 {
  $url = "https://".$this->token.":".$this->key."@secure.versapay.com/api/debit_agreements/sent?page=".$pageNo;  
  $handler = curl_init();
  curl_setopt($handler, CURLOPT_URL, $url);
  curl_setopt($handler, CURLOPT_HTTPHEADER, $this->headers);
  curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($handler, CURLOPT_HTTPGET, true);
  $response = curl_exec($handler); 
  $code = curl_getinfo($handler, CURLINFO_HTTP_CODE);
  return array("curl_code:"=>$code,"response:"=>$response);     
 }
 
 function viewReceivedAgreements($pageNo)
 {
  $url = "https://".$this->token.":".$this->key."@secure.versapay.com/api/debit_agreements//received?page=".$pageNo;  
  $handler = curl_init();
  curl_setopt($handler, CURLOPT_URL, $url);
  curl_setopt($handler, CURLOPT_HTTPHEADER, $this->headers);
  curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($handler, CURLOPT_HTTPGET, true);
  $response = curl_exec($handler); 
  $code = curl_getinfo($handler, CURLINFO_HTTP_CODE);
  return array("curl_code:"=>$code,"response:"=>$response);      
 }
 
 function approveAnAgreement($token)
 {
  $url = "https://".$this->token.":".$this->key."@secure.versapay.com/api/debit_agreements/".$token."/approve";  
  $handler = curl_init();
  curl_setopt($handler, CURLOPT_URL, $url);
  curl_setopt($handler, CURLOPT_HTTPHEADER, $this->headers);
  curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($handler, CURLOPT_POST, true);
  $response = curl_exec($handler); 
  $code = curl_getinfo($handler, CURLINFO_HTTP_CODE);
  return array("curl_code:"=>$code,"response:"=>$response);       
 }
 
 function linkVersaPayTokenToPogoproAccountReceivable($pogoproAccountReceivableId,$receivable_timestamp,$versaPayToken,$_status)
 {
  $String_SQL = "Update pogopro_project_accounting_receivable Set received_date = '".$receivable_timestamp."', eft_token = '".$versaPayToken."',eft_status= '".$eft_status."' Where  project_account_receivable_id = '".$pogoproAccountReceivableId."'";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute();
  if (!$status)
     {
       echo "[linkVersaPayTokenToPogoproAccountReceivable]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
       return true;  
     }
 }

function updateStatusOfTransactionOfPogoproAccountReceivableByVersaPayWebhookCallback($versaPay_token,$receive_timestamp,$new_status) 
{
  /* 76east $String_SQL = "Update pogopro_project_accounting_receivable Set eft_status='$new_status',received_date='$receive_timestamp'  
                 Where  eft_token ='$versaPay_token'"; */
  $String_SQL = "Update pogopro_project_accounting_receivable Set eft_status= '".$new_status."', received_date= '".$receive_timestamp."'  
                 Where  eft_token = '".$versaPay_token."'";				 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute();
  if (!$status)
     {
       echo "[updateStatusOfTransactionOfPogoproAccountReceivableByVersaPayWebhookCallback]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
       return true;  
     }    
}

 function linkVersaPayTokenToPogoproAccountPayable($pogoproAccountPayableId,$versaPayToken,$_status)
 {
  $String_SQL = "Update pogopro_project_accounting_payable Set eft_token = :eft_token,eft_status= :eft_status Where  project_account_payable_id = :project_account_payable_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([":project_account_payable_id"=>$pogoproAccountPayableId,":eft_token"=>$versaPayToken,":eft_status"=>$_status]);
  if (!$status)
     {
       echo "[linkVersaPayTokenToPogoproAccountPayable]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
       return true;  
     }
 }

function updateStatusOfTransactionOfPogoproAccountPayableByVersaPayWebhookCallback($versaPay_token,$new_status)
{
  $String_SQL = "Update pogopro_project_accounting_payable Set eft_status= '".$new_status."'
                 Where  eft_token = '".$versaPay_token."'";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute();
  if (!$status)
     {
       echo "[updateStatusOfTransactionOfPogoproAccountPayableByVersaPayWebhookCallback]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
       return true;  
     }    
}

function getBuyerProfileAndPaymentAmountByProjectAccountReceivableId($projectAccountReceivableId)
{
 $arrayOfBuyerProfileAndPaymentInfo = array();   
 $String_SQL = "Select c.id,c.name,c.email, c.versapay_institution_number,c.versapay_branch_number,c.versapay_account_number, a.project_ar_title,a.project_ar_desc, a.project_ar_amount,a.tax_amount,a.deduct_cost
                From pogopro_project_accounting_receivable a,
                     pogopro_post_project b,
                     customer_accounts c
                Where a.project_id = b.post_project_id and 
                      b.member_id = c.id and 
		      a.project_account_receivable_id = '".$projectAccountReceivableId."'";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute();
 if (!$status)
     {
       echo "[getBuyerProfileAndPaymentAmountByProjectAccountReceivableId]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row=  $status->fetch())
      {
        $arrayOfBuyerProfileAndPaymentInfo['buyer_name'] = $row['name']; 
        $arrayOfBuyerProfileAndPaymentInfo['buyer_email'] = $row['email'];
        $arrayOfBuyerProfileAndPaymentInfo['versapay_institution_number'] = $row['versapay_institution_number'];
        $arrayOfBuyerProfileAndPaymentInfo['versapay_branch_number'] = $row['versapay_branch_number'];
        $arrayOfBuyerProfileAndPaymentInfo['versapay_account_number'] = $row['versapay_account_number'];
        $arrayOfBuyerProfileAndPaymentInfo['project_ar_title'] = $row['project_ar_title'];
        $arrayOfBuyerProfileAndPaymentInfo['project_ar_desc'] = $row['project_ar_desc'];
        $arrayOfBuyerProfileAndPaymentInfo['project_ar_amount'] = $row['project_ar_amount'];
        $arrayOfBuyerProfileAndPaymentInfo['tax_amount'] = $row['tax_amount'];
        $arrayOfBuyerProfileAndPaymentInfo['deduct_cost'] = $row['deduct_cost'];
        $versapay_transcation_amount = ($row['project_ar_amount']+$row['tax_amount']-$row['deduct_cost'])*100;
        $arrayOfBuyerProfileAndPaymentInfo['versapay_transcation_amount'] = $versapay_transcation_amount;
      }
     } 
  return $arrayOfBuyerProfileAndPaymentInfo;   
}

function getProProfileAndPaymentAmountByProjectAccountPayableId($projectAccountPayableId)
{
 $arrayOfProProfileAndPaymentInfo = array();   
 $String_SQL = "Select c.name,c.email,a.project_ap_title,a.project_ap_desc,
		 a.project_ap_amount,a.tax_amount,a.deduct_cost,a.pogopro_charge
                From pogopro_project_accounting_payable a,pogopro_post_project b,customer_accounts c
                Where a.project_id = b.post_project_id 
		      and b.member_id = c.id 
		      and a.project_account_payable_id = '".$projectAccountPayableId."'";   
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute();
 if (!$status)
     {
       echo "[getBuyerProfileAndPaymentAmountByProjectAccountReceivableId]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row=  $status->fetch($status))
      {
        $arrayOfProProfileAndPaymentInfo['pro_name'] = $row['name']; 
        $arrayOfProProfileAndPaymentInfo['pro_email'] = $row['email'];
        $arrayOfProProfileAndPaymentInfo['project_ap_title'] = $row['project_ar_title'];
        $arrayOfProProfileAndPaymentInfo['project_ap_desc'] = $row['project_ar_desc'];
        $arrayOfProProfileAndPaymentInfo['project_ap_amount'] = $row['project_ap_amount'];
        $arrayOfProProfileAndPaymentInfo['tax_amount'] = $row['tax_amount'];
        $arrayOfProProfileAndPaymentInfo['deduct_cost'] = $row['deduct_cost'];
        $arrayOfProProfileAndPaymentInfo['pogopro_charge'] = $row['pogopro_charge'];
        $versapay_transcation_amount = ($row['project_ar_amount']+$row['tax_amount']-$row['deduct_cost']-$row['pogopro_charge'])*100;
        $arrayOfProProfileAndPaymentInfo['versapay_transcation_amount'] = $versapay_transcation_amount;
      }
     } 
  return $arrayOfProProfileAndPaymentInfo;  
}
}//End of class
?>


