<?php
include_once("vars.php");
/**
 * This class will be use provider pogo service catalogue management
 */
class pogoServiceCatalogueManagerClass
{
  private $db_conn;
  function __construct($conn=null){ //set db connection in constructor
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection(); //db connection object
		$this->db_conn = $dbconnect_obj->conn;
	}
  }	
 /**
  * Define class members
  */ 
  private $pogoServiceCatalogueColumns = array("id","serviceCatalogueName");  
  
 function getAllServiceCatalogues()
 {
   $pogoServiceCatalogueArray = array();  
   $String_SQL = "Select * from pogo_service_catalogue Order by id";
   $results=$this->db_conn->query($String_SQL);
   if($results)
   {
     while ($row = $results->fetch())
     {
         $pogoServiceCatalogueArray[$row['id']]=$row['serviceCatalogueName'];
     }
   }else
   {
    $this->logErrorMessage("getAccountInfo","Invalid query: " . $results->errorInfo() . "\n"); 
   }
   print_r($pogoServiceCatalogueArray);
   return $pogoServiceCatalogueArray;
 }
 function getAllCurrencies()
 {
   $allCurrencies = array();
   $String_SQL = "Select currencyName From pogo_payment_courrency Order By id";
   $results=$this->db_conn->query($String_SQL);
   if($results)
   {
     while ($row = $results->fetch())
     {
         $allCurrencies[]=$row['currencyName'];
     }
   }else
   {
    $this->logErrorMessage("getAccountInfo","Invalid query: " . $results->errorInfo() . "\n"); 
   }  
  //print_r($allCurrencies); 
  return $allCurrencies;
 }
 function getUserDefaultCurrency($user_id)
 {
   $defaultCurrency = "";
   $String_SQL="Select currency_code from customer_accounts Where id= :user_id";
   $results=$this->db_conn->prepare($String_SQL); 
   $results->execute([":user_id"=>$user_id]);
	
   if($results)
   {
     while ($row = $results->fetch())
     {
         $defaultCurrency =$row['currency_code'];
     }
   }else
   {
    $this->logErrorMessage("getAccountInfo","Invalid query: " . $results->errorInfo() . "\n"); 
   }
   return $defaultCurrency;
 }
 function getServiceList()
 {
   $serviceList = array("hotels","sports_events","taxi_limo","attractions");
   return $serviceList;
 }
 function getServiceCatalogues()
 {
   $serviceCatalogueList = array("ACCOMODATIONS","SPORTS EVENTS","VEHICLES","LOCAL ATTRACTIONS");
   return $serviceCatalogueList;     
 }
 function getGoogleMapGeocodeFromAddress($address)
 { 
    // url encode the address
    $address = urlencode($address);
     
    // google map geocode api url
    $url = "http://maps.google.com/maps/api/geocode/json?sensor=false&address={$address}";
 
    // get the json response
    $resp_json = file_get_contents($url);
     
    // decode the json
    $resp = json_decode($resp_json, true);
 
    // response status will be 'OK', if able to geocode given address 
    if($resp['status']=='OK'){
 
        // get the important data
        $lati = $resp['results'][0]['geometry']['location']['lat'];
        $longi = $resp['results'][0]['geometry']['location']['lng'];
        $formatted_address = $resp['results'][0]['formatted_address'];
         
        // verify if data is complete
        if($lati && $longi && $formatted_address){
         
            // put the data in the array
            $data_arr = array();            
             
            array_push(
                $data_arr, 
                    $lati, 
                    $longi, 
                    $formatted_address
                );
             
            return $data_arr;
             
        }else{
            return false;
        }
         
    }else{
        return false;
    }
 }
 function getClientIpAddress()
 {
     $ip = getenv('HTTP_CLIENT_IP')?:
           getenv('HTTP_X_FORWARDED_FOR')?:
           getenv('HTTP_X_FORWARDED')?:
           getenv('HTTP_FORWARDED_FOR')?:
           getenv('HTTP_FORWARDED')?:
           getenv('REMOTE_ADDR');
     return $ip;
 }
 function getClientCity($ip)
 {
    $details = json_decode(file_get_contents("http://ipinfo.io/{$ip}"));
    echo "Geo Location:".$details->loc;
    return $details->city; 
 }
  /**
   * * log mysql error message.
  */
 private function logErrorMessage($funcName,$errorMsg)
 {
   print_r( "[".$funcName."]".$errorMsg);
 }  
}
?>
