<?php
define("RECORDS_PER_PAGE",10);

	function calculateQueryLimit($pageNo){
		if(!$pageNo){$pageNo=1;}
		$start=($pageNo-1)*RECORDS_PER_PAGE;
		return $start;
	}
//function to return the pagination string
function getPaginationString($page = 1, $totalitems, $limit = 15, $adjacents = 1, $targetpage = "/", $pagestring = "?page=")
{
	
	/*
	    $page is the current page number
		$totalitems is the total number of items in the set. You usually get this from a SQL query.
		$adjacents is the number of page links to put adjacent to the current page.
		$targetpage is the URL you want to point to. e.g. index.php
		$pagetext 	is the string used to append the page variable to the URL. e.g. ?page= or &p=	*/	
	//defaults
	if(!$adjacents) $adjacents = 1;
	if(!$limit) $limit = 15;
	if(!$page) $page = 1;
	if(!$targetpage) $targetpage = "/";
	
	//other vars
	$prev = $page - 1;									//previous page is page - 1
	$next = $page + 1;									//next page is page + 1
	$lastpage = ceil($totalitems / $limit);				//lastpage is = total items / items per page, rounded up.
	$lpm1 = $lastpage - 1;								//last page minus 1
	
	/* 
		Now we apply our rules and draw the pagination object. 
		We're actually saving the code to a variable in case we want to draw it more than once.
	
	*/
	$pagination = "";
	if($lastpage > 1)
	{	
		$pagination .= "<div class=\"pagination pull-right\"";
		// if($margin || $padding)
		// {
			// $pagination .= " style=\"";
			// if($margin)
				// $pagination .= "margin: $margin;";
			// if($padding)
				// $pagination .= "padding: $padding;";
			// $pagination .= "\"";
		// }
		$pagination .= "> <ul>";

		//previous button
		if ($page > 1) 
			$pagination .= "<li><a href=\"$targetpage$pagestring$prev\">Prev</a></li>";
		else
			$pagination .= "<li class=\"prev disabled\"><li><a href=\"#\">Prev</a></li>";	
		
		//pages	
		if ($lastpage < 7 + ($adjacents * 2))	//not enough pages to bother breaking it up
		{	
			for ($counter = 1; $counter <= $lastpage; $counter++)
			{
				if ($counter == $page)
					$pagination .= "<li class=\"active\"><a href=\"#\">$counter</a></li>";
				else
					$pagination .= "<li><a href=\"" . $targetpage . $pagestring . $counter . "\">$counter</a></li>";					
			}
		}
		elseif($lastpage >= 7 + ($adjacents * 2))	//enough pages to hide some
		{
			//close to beginning; only hide later pages
			if($page < 1 + ($adjacents * 3))		
			{
				for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
				{
					if ($counter == $page)
						$pagination .= "<li class=\"active\"><a href=\"#\">$counter</a></li>";
					else
						$pagination .= "<li><a href=\"" . $targetpage . $pagestring . $counter . "\">$counter</a></li>";					
				}
				$pagination .= "<li class=\"disabled\"><a href=\"#\">…</a></li>";
				$pagination .= "<li><a href=\"" . $targetpage . $pagestring . $lpm1 . "\">$lpm1</a></li>";
				$pagination .= "<li><a href=\"" . $targetpage . $pagestring . $lastpage . "\">$lastpage</a></li>";		
			}
			//in middle; hide some front and some back
			elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
			{
				$pagination .= "<li><a href=\"" . $targetpage . $pagestring . "1\">1</a></li>";
				$pagination .= "<li><a href=\"" . $targetpage . $pagestring . "2\">2</a></li>";
				$pagination .= "<li class=\"disabled\"><a href=\"#\">…</a></li>";
				for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
				{
					if ($counter == $page)
						$pagination .= "<li class=\"active\"><a href=\"#\">$counter</a></li>";
					else
						$pagination .= "<li><a href=\"" . $targetpage . $pagestring . $counter . "\">$counter</a></li>";					
				}
				$pagination .= "...";
				$pagination .= "<li><a href=\"" . $targetpage . $pagestring . $lpm1 . "\">$lpm1</a></li>";
				$pagination .= "<li><a href=\"" . $targetpage . $pagestring . $lastpage . "\">$lastpage</a></li>";		
			}
			//close to end; only hide early pages
			else
			{
				$pagination .= "<li><a href=\"" . $targetpage . $pagestring . "1\">1</a></li>";
				$pagination .= "<li><a href=\"" . $targetpage . $pagestring . "2\">2</a></li>";
				$pagination .= "<li class=\"disabled\"><a href=\"#\">…</a></li>";
				for ($counter = $lastpage - (1 + ($adjacents * 3)); $counter <= $lastpage; $counter++)
				{
					if ($counter == $page)
						$pagination .= "<li class=\"active\"><a href=\"#\">$counter</a></li>";
					else
						$pagination .= "<li><a href=\"" . $targetpage . $pagestring . $counter . "\">$counter</a></li>";					
				}
			}
		}
		
		//next button
		if ($page < $counter - 1) 
			$pagination .= "<li><a href=\"" . $targetpage . $pagestring . $next . "\">Next</a></li>";
		else
			$pagination .= "<li class=\"next disabled\"><a href=\"#\">Next</a></li>";
		$pagination .= "</div>\n";
	}
	
	return $pagination;

}
?>