<?php
	//perform checks by zone
	function level_0_check($postal_code){
		$postal_code = strtoupper(str_replace(" ","",$postal_code));
		$two_char_str = substr($postal_code,0,2);
		$three_char_str = substr($postal_code,0,3);
		
		$two_char_array_a = array(9,"H0","H1","H2","H3","H4","H5","H6","H7","H8","H9");
		if(array_search($two_char_str,$two_char_array_a)) $zone_index = "H";
		return $zone_index;
	}
	
	function level_1_check($postal_code){
		$postal_code = strtoupper(str_replace(" ","",$postal_code));
		$two_char_str = substr($postal_code,0,2);
		$three_char_str = substr($postal_code,0,3);
		
		$two_char_array_a = array(9,"K1","K2","K3","K4","K5","K6","K7","K8","K9","G1","G2"
								  ,"G3","G6","G7","G8","G9","J1","J2","J3","J4","J5","J6","J7","J8");
		if(array_search($two_char_str,$two_char_array_a)) $zone_index = 1;
		
		$array_set_a = array(9,"G0A","G0L","G0M","G0N","G0O","G0P","G0Q","G0R","G0S","G0X","G0Y"
							 ,"G0Z","G4A","G4B","G4C","G4D","G4E","G4F","G4G","G4H","G4I","G4J","G4K","G4L"
							 ,"G4M","G4N","G4O","G4P","G4Q","G5A","G5D","G5E","G5F","G5G","G5H","G5I","G5J"
							 ,"G5K","G5L","G5M","G5N","G5O","G5P","G5Q","G5R","G5S","G5T","G5U","G5V","G5W"
							 ,"G5X","G5Y","G5Z","J0L","J0M","J0X","J9A","J9B","J9C","J9D","J9H","J9I","J9J");
		if(array_search($three_char_str,$array_set_a)) $zone_index = 1;
		return $zone_index;
	}
	
	function level_2_check($postal_code){
		$postal_code = strtoupper(str_replace(" ","",$postal_code));
		$two_char_str = substr($postal_code,0,2);
		$three_char_str = substr($postal_code,0,3);
		
		$two_char_array_a = array(9,"K0","L0","L1","L2","L3","L4","L5","L6","L7","L8","L9","M0","M1","M2","M3"
								  ,"M4","M5","M6","M7","M8","M9","N1","N2","N3","N4","N5","N6","N7","N8","N9");
		if(array_search($two_char_str,$two_char_array_a)) $zone_index = 2;
		
		$array_set_a = array(9,"N0A","N0B","N0G","G4U","G4V","G4W","J0A","J0B","J0C","J0D","J0E","J0F","J0G"
							 ,"J0H","J0I","J0J","J0K","J0N","J0O","J0P","J0Q","J0R","J0S","J0T","J0U","J0V","J0W");
		if(array_search($three_char_str,$array_set_a)) $zone_index = 2;
		return $zone_index;
	}
	
	function level_3_check($postal_code){
		$postal_code = strtoupper(str_replace(" ","",$postal_code));
		$two_char_str = substr($postal_code,0,2);
		$three_char_str = substr($postal_code,0,3);
		
		$array_set_a = array(9,"G0B","G0C","G0D","G0E","G0F","G0H","G0I","G0J","G0K","G0T","G0U","G0V","G0W"
		,"G4R","G4S","G4X","G4Y","G4Z","G5B","G5C","J0Y","J0Z","J9E","J9F","J9G","J9K","J9L","J9M","J9N","J9O"
		,"J9P","J9Q","J9R","J9S","J9T","J9U","J9V","J9W","J9X","J9Y","J9Z","N0C","N0D","N0E","N0F","N0H","N0I"
		,"N0J","N0K","N0L","N0M","N0N","N0O","N0P","N0Q","N0R","N0S","N0T","N0U","N0V","N0W","N0X","N0Y","N0Z");
		if(array_search($three_char_str,$array_set_a)) $zone_index = 3;
		return $zone_index;
	}
	
	function level_4_check($postal_code){
		$postal_code = strtoupper(str_replace(" ","",$postal_code));
		$two_char_str = substr($postal_code,0,2);
		$three_char_str = substr($postal_code,0,3);
		
		$two_char_array_a = array(9,"B1","B3","B4","C1","C2","C3","C4","C5","C6","C7","C8","C9","E0","E2","E6"
								  ,"E7","E8","E9");
		if(array_search($two_char_str,$two_char_array_a)) $zone_index = 4;
		
		$array_set_a = array(9,"B0S","B2G","B2H","B2I","B2J","B2K","B2L","B2M","B2N","B2O","B2P","B2Q","B2R"
		,"B2S","B2T","B2U","B2V","B9A","E1A","E1B","E1C","E1D","E1E","E1F","E1G","E1H","E1I","E1J","E1K","E1L"
		,"E1M","E1N","E1O","E1P","E1Q","E1R","E1S","E1T","E1U","E1V","E3A","E3B","E3C","E3D","E3E","E3F","E3G"
		,"E3H","E3I","E3J","E3K","E3O","E3P","E3Q","E3R","E3S","E3T","E3U","E3V","E3W","E3X","E3Y","E3Z","E4E"
		,"E4F","E4G","E4H","E4I","E4J","E4K","E4L","E4M","E4N","E4O","E4P","E4Q","E4R","E4S","E4T","E4U","E4V"
		,"E4W","E4X","E4Y","E5W","E5X","E5Y","E5Z","P1A","P1B","P1C","P1D","P1E","P1F","P1G","P3A","P3B","P3C"
		,"P3D","P3E","P3F","P3G","P3H","P3I","P3J","P3K");
		if(array_search($three_char_str,$array_set_a)) $zone_index = 4;
		return $zone_index;
	}
	
	function level_5_check($postal_code){
		$postal_code = strtoupper(str_replace(" ","",$postal_code));
		$two_char_str = substr($postal_code,0,2);
		$three_char_str = substr($postal_code,0,3);
		
		$two_char_array_a = array(9,"R1","R2","R3","R4","R5","B5","B6","B7","B8","P2","C0","P5","S7","R6"
							,"T1","T2","T3","T4","T5","T6");
		if(array_search($two_char_str,$two_char_array_a)) $zone_index = 5;
		
		$array_set_a = array(9,"B0F","B0G","B0H","B0I","B0J","B0K","B0L","B0M","B0N","B0O","B0P","B0Q","B0R","B0T"
		,"B0U","B0V","B0W","B0X","B0Y","B0Z","B2B","B2C","B2D","B2E","B2F","R0A","R0C","R0D","R0E","R0F","R0G","R0H"
		,"R0I","R0J","R0K","R0L","R0M","R0N","R0O","R0P","R0Q","R0R","R0S","R0T","R0U","R0V","R0W","R0X","R0Y","R0Z"
		,"B9B","B9C","B9D","B9E","B9F","B9G","B9H","B9I","B9J","B9K","B9L","B9M","B9N","B9O","B9P","B9Q","B9R","B9S"
		,"B9T","B9U","B9V","B9W","B9X","B9Y","B9Z","R7A","R7B","R7C","R7D","R7E","R7F","R7G","R7H","R7I","R7J","R7K"
		,"R7L","R7M","E1W","E1X","E1Y","E1Z","E3L","E3M","E3N","E4A","E4B","E4C","E4D","S3N");
		if(array_search($three_char_str,$array_set_a)) $zone_index = 5;
		
		$array_set_b = array(9,"P0A","P0B","P0C","P0D","P0E","P0F","P0G","P0H","P0I","P0J","P0K","P0L","P0M","P0N"
		,"P0O","P0P","P0Q","P0R","P0S","S4H","S4I","S4J","S4K","S4L","S4N","S4M","S4O","S4P","S4Q","S4R","S4S","S4T"
		,"S4U","S4V","S4W","S4X","S4Y","S4Z","P1H","P1I","P1J","P1K","P1L","P1M","P1N","P1O","P1P","P1Q","P1R","P1S"
		,"P1T","P1U","P1V","P1W","P1X","P1Y","P1Z","S6H","S6I","S6J","S6V","S6W","S6X","S6Y","S6Z","P3L","P3M","P3N"
		,"P3O","P3P","P3Q","P3R","P3S","P3T","P3U","P3V","P3W","P3X","P3Y","P3Z","P4A","P4B","P4C","P4D","P4E","P4F"
		,"P4G","P4H","P4I","P4J","P4K","P4L","P4M","T0L","T0M","T8A","T8B","T8C","T8D","T8H","T8I","T8J","T8K","T8L"
		,"T8M","T8N","T8O","T8P","T8Q","T8R","T8S","T8T","T8U","T9A","T9B","T9C","T9D","T9E","T9F","T9V","E5H","E5I"
		,"E5J","E5K","E5L","E5M","E5N","E5O","E5P","E5Q","E5R","E5S","E5T","E5U");
		if(array_search($three_char_str,$array_set_b)) $zone_index = 5;
		return $zone_index;
	}
	
	function level_6_check($postal_code){
		$postal_code = strtoupper(str_replace(" ","",$postal_code));
		$two_char_str = substr($postal_code,0,2);
		$three_char_str = substr($postal_code,0,3);
		
		$two_char_array_a = array(9,"P6","P7","P8","P9","R8","R9","S0","S1","S2","S5","S8","S9","T7","A0","A1"
		,"A2","A3","A4","A5","A6","A7","A8","A9","V0","V1","V2","V3","V4","V5","V6","V7","V8","V9","X0","X1"
		,"X2","X3","X4","X5","X6","X7","X8","X9","Y0","Y1","Y2","Y3","Y4","Y5","Y6","Y7","Y8","Y9");
		if(array_search($two_char_str,$two_char_array_a)) $zone_index = 6;
		
		$array_set_a = array(9,"B0A","B0B","B0C","B0D","B0E","E5E","E5F","E5G","E5V","G0G","G4T","R0B","P0T"
		,"P0U","P0V","P0W","P0X","P0Y","P0Z","P4N","P4O","P4P","P4Q","P4R","P4S","P4T","P4U","P4V","P4W","P4X"
		,"P4Y","P4Z","R7N","R7O","R7P","R7Q","R7R","R7S","R7T","R7U","R7V","R7W","R7X","R7Y","R7Z","S3A","S3B"
		,"S3C","S3D","S3E","S3F","S3G","S3H","S3I","S3J","S3K","S3L","S3M","S3O","S3P","S3Q","S3R","S3S","S3T"
		,"S3U","S3V","S3W","S3X","S3Y","S3Z","S4A","S4B","S4C","S4D","S4E","S4F","S4G","S6A","S6B","S6C","S6D"
		,"S6E","S6F","S6G","S6K","S6L","S6M","S6N","S6O","S6P","S6Q","S6R","S6S","S6T","S6U","T0A","T0B","T0C"
		,"T0D","T0E","T0F","T0G","T0H","T0I","T0J","T0K","T0N","T0O","T0P","T0Q","T0R","T0S","T0T","T0U","T0V"
		,"T0W","T0X","T0Y","T0Z","T8E","T8F","T8G","T8V","T8W","T8X","T8Y","T8Z","T9G","T9H","T9I","T9J","T9K"
		,"T9L","T9M","T9N","T9O","T9P","T9Q","T9R","T9S","T9T","T9U","T9W","T9X","T9Y","T9Z");
		if(array_search($three_char_str,$array_set_a)) $zone_index = 6;
		
		return $zone_index;
	}
	
	function getShippingRates($zone_index,$weight){
			
			$zone_0_array = array(5.57,5.57,5.57,5.57,5.57,6.58,6.65,6.80,6.86,6.92,6.98,7.11,7.31,7.50,7.63,7.80
							,8.02,8.29,8.54,8.69,8.88,9.06,9.21,9.46,9.77,9.78,10.12,10.19,10.27,10.39,10.65
							,10.80,10.89,11.15,11.39);

			$zone_1_array = array(6.67,6.67,6.67,6.67,6.67,
							7.19,7.41,7.44,7.49,7.55,
							7.57,7.64,7.73,7.88,8.06,
							8.26,8.44,8.72,8.99,9.16,
							9.37,9.56,9.71,9.99,10.31,
							10.35,10.70,10.92,11.06,11.14,
							11.43,11.62,11.74,12.08,12.30);

			$zone_2_array = array(7.47,7.47,7.47,7.47,7.47,
							8.22,8.28,8.36,8.39,8.44,
							8.52,8.60,9.01,9.19,9.33,
							9.70,10.08,10.52,10.90,11.28,
							11.43,11.63,11.75,11.89,12.04,
							12.72,13.00,13.11,13.19,13.27,
							13.60,13.76,13.98,14.34,14.66);

			$zone_3_array = array(8.22,8.22,8.22,8.22,8.22,
							8.95,9.21,9.27,9.33,9.40,
							9.74,10.01,10.23,10.56,11.04,
							11.42,11.76,12.30,12.82,13.28,
							13.42,13.54,13.79,14.15,14.66,
							14.88,15.35,15.50,15.56,15.66,
							16.09,16.19,16.47,16.95,17.14);

			$zone_4_array = array(8.79,8.79,8.79,8.79,8.79,
							9.68,9.86,9.94,10.12,10.55,
							10.98,11.53,11.80,12.40,12.95,
							13.29,13.63,14.31,14.93,15.59,
							15.95,16.13,16.39,16.79,17.15,
							17.61,18.04,18.25,18.56,18.75,
							19.36,19.51,19.82,20.38,21.14);

			$zone_5_array = array(10.41,10.41,10.41,10.41,10.41,
							10.86,11.14,11.52,12.29,12.81,
							13.95,14.63,15.19,15.98,16.60,
							17.30,18.19,18.75,19.38,19.98,
							20.33,20.73,20.84,20.89,21.16,
							21.76,22.20,22.39,22.48,22.65,
							23.31,23.50,24.24,24.97,25.70);

			$zone_6_array = array(12.09,12.09,12.09,12.09,12.09,
							12.71,13.60,14.11,14.98,15.64,
							16.75,17.86,18.75,19.68,20.60,
							21.37,21.89,22.21,22.96,23.50,
							23.83,24.20,24.54,24.81,25.25,
							25.92,26.29,26.51,26.81,27.17,
							27.87,28.15,28.79,29.56,30.14);
			
			if($zone_index == "H"){
				$cost_index = ceil($weight);
				$base_shipping_cost = $zone_0_array[$cost_index];
			}
			if($zone_index == 1){
				$cost_index = ceil($weight);
				$base_shipping_cost = $zone_1_array[$cost_index];
			}
			if($zone_index == 2){
				$cost_index = ceil($weight);
				$base_shipping_cost = $zone_2_array[$cost_index];
			}
			if($zone_index == 3){
				$cost_index = ceil($weight);
				$base_shipping_cost = $zone_3_array[$cost_index];
			}
			if($zone_index == 4){
				$cost_index = ceil($weight);
				$base_shipping_cost = $zone_4_array[$cost_index];
			}
			if($zone_index == 5){
				$cost_index = ceil($weight);
				$base_shipping_cost = $zone_5_array[$cost_index];
			}
			if($zone_index == 6){
				$cost_index = ceil($weight);
				$base_shipping_cost = $zone_6_array[$cost_index];
			}
			return $base_shipping_cost;
	}
?>