<?php
/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
include_once("inc/vars.php");
class autoLoginManager
{ 
 /*
  * if set rememberMe mode, cookie store:
  * (1) Encrypt user_id with default salt
  * (2) Encrypt user_name with Encrypt user_id as salt
  * (3) Encrypt hash password with salt (Encrypt user_id + Encrypt user_name)
  * auto login:
  * (1) Get Encrypt user_id and Decrypt user_name with Encrypt user_id as salt
  * (2) 
  */ 
 private $method = "aes-256-cbc"; 
 private $salt = POGOPRO_SECURITY_SALT; 
 public function getCookieSecurityKey($key_name)
 {   
  if(!isset($_COOKIE[$key_name])) {  
   return "";   
  }else
  {
   return  $_COOKIE[$key_name];  
  }
 }
 
 public function setCookieSecurityKey($key_name,$key_value,$validate_in_days)
 {
  setcookie($key_name, $key_value, time() + (86400 * $validate_in_days));   
 }
 
 
 public function generateSecurityEncriptString($ource_info,$salt)
 {
   return  $EncryptedString = openssl_encrypt($ource_info,$this->method,$salt);   
 }
 
 public function generateSecurityDecriptString($encrypted_info,$salt)
 {
   return  $DecryptedString = openssl_decrypt($encrypted_info,$this->method,$salt);   
 } 
 
 public function generateEncryptedPasswordHash($password,$salt)
 {
   return password_hash($password, PASSWORD_DEFAULT,array("salt"=>$salt));   
 }
 
 public function setCookieForAutoLogin($user_id,$user_name,$password_raw)
 {
  $cookie_value_user_id = $this->generateSecurityEncriptString($user_id,$this->salt);
  $cookie_value_user_name = $this->generateSecurityEncriptString($user_name,$cookie_value_user_id);
  $cookie_value_password_hash = $this->generateSecurityEncriptString(md5(md5(md5($password_raw))),$cookie_value_user_id.$cookie_value_user_name);
  //Set Cookies.
  $this->setCookieSecurityKey(POGOPRO_AUTO_LOGIN_USERID, $cookie_value_user_id, 365);
  $this->setCookieSecurityKey(POGOPRO_AUTO_LOGIN_USERNAME, $cookie_value_user_name, 365);
  $this->setCookieSecurityKey(POGOPRO_AUTO_LOGIN_PASSWORDHASH, $cookie_value_password_hash, 365);
 }
 
 public function getCookieForAutoLogin()
 {
  $user_id_encrypt = $this->getCookieSecurityKey(POGOPRO_AUTO_LOGIN_USERID); 
  $user_id = $this->generateSecurityDecriptString($user_id_encrypt,$this->salt);
  $user_name_encrypt = $this->getCookieSecurityKey(POGOPRO_AUTO_LOGIN_USERNAME);  
  $user_name = $this->generateSecurityDecriptString($user_name_encrypt, $user_id_encrypt);
  $user_password_hash = $this->getCookieSecurityKey(POGOPRO_AUTO_LOGIN_PASSWORDHASH);
  return array("id"=>$user_id,
               "account_name"=>$user_name,
               "password_hash"=>$user_password_hash,
               "cookie_user_id"=>$user_id_encrypt,
               "cookie_user_name"=>$user_name_encrypt,
               "cookie_password_hash"=>$user_password_hash);
 }
 
 public function calcluateAutoLoginPasswordHash($user_id,$user_name,$md5_password)
 {
  $cookie_value_user_id = $this->generateSecurityEncriptString($user_id,$this->salt);
  $cookie_value_user_name = $this->generateSecurityEncriptString($user_name,$cookie_value_user_id);
  $cookie_value_password_hash = $this->generateSecurityEncriptString($md5_password,$cookie_value_user_id.$cookie_value_user_name);
  return $cookie_value_password_hash;     
 }
 
 public function refreshCookieForAutoLogin($cookied_user_id,$cookied_user_name,$cookied_password_hash) 
 {
  $this->setCookieSecurityKey(POGOPRO_AUTO_LOGIN_USERID, $cookied_user_id, 365);
  $this->setCookieSecurityKey(POGOPRO_AUTO_LOGIN_USERNAME, $cookied_user_name, 365);
  $this->setCookieSecurityKey(POGOPRO_AUTO_LOGIN_PASSWORDHASH, $cookied_password_hash, 365);     
 }
 
 public function cancelAutologin()
 {   
  $this->deleteCookieSecurityKey(POGOPRO_AUTO_LOGIN_USERID);
  $this->deleteCookieSecurityKey(POGOPRO_AUTO_LOGIN_USERNAME);
  $this->deleteCookieSecurityKey(POGOPRO_AUTO_LOGIN_PASSWORDHASH);     
 }
 
 public function deleteCookieSecurityKey($key_name)
 {     
  setcookie($key_name, "", 1);
 }
 
 public function verifyPasswordForOperationOnBankInfo($input_password)
 {
   $cookied_user_profile = $this->getCookieForAutoLogin();
   $calculate_password_hash = $this->calcluateAutoLoginPasswordHash($cookied_user_profile['id'], $cookied_user_profile['account_name'], md5(md5(md5($input_password))));
   if ($cookied_user_profile['password_hash']==$calculate_password_hash)
       return true;
   else
       return false;
 }
}
?>

