<?php
	/*
		This page contains verification interactions for merchant accounts
		The credit card interaction initially verifies the entered credit card information
		The document verification module allows for the upload of business documents for verification 
	*/
	session_start();
	if($_SESSION['session_type'] != "merchant"){
		header("Location: login.php?logout=yes");
	}
	
	include_once "../inc/libfns.php";
	include_once "../../inc/vars.php";
	//Connect to DB
	db_connect(HOST,USER,PASSWORD,DB);
	
	//echo md5("adverts");
	
	//handle get GET vars, enable form submit persistence for GET variables
	if($_GET['mod']){
		$mod = strip_tags($_GET['mod']);
		$form_get = "?mod=$mod";
	}
	if($_GET['type']){
		$type = strip_tags($_GET['type']);
		$form_get .= "&type=$type";
	}
	if($_GET['sub']){
		$sub = strip_tags($_GET['sub']);
		$form_get .= "&sub=$sub";
	}
	if($_GET['action']){
		$action = strip_tags($_GET['action']);
		$form_get .= "&action=$action";
	}
	if($_GET['mode']){
		$mode = strip_tags($_GET['mode']);
		$form_get .= "&mode=$mode";
	}
	if($_GET['mod_select']){
		$mod_select = strip_tags($_GET['mod_select']);
		$form_get .= "&mod_select=$mod_select";
	}
	if($_GET['id']){
		$id = strip_tags($_GET['id']);
		$form_get .= "&id=$id";
	}
	if($_GET['edit_id']){
		$edit_id = strip_tags($_GET['edit_id']);
		$form_get .= "&edit_id=$edit_id";
	}
	if($_GET['page']){
		$form_get .= "&page=".$_GET['page'];
	}
	if($_GET['page_set']){
		$form_get .= "&page_set=".$_GET['page_set'];
	}
	
	//include library of primary merchant functions
	include_once "inc/libmain.php";
	include_once "inc/libsub.php";
	
	//Enable search for queries
	if($_POST['Search_'] == "Go!"){
		$where_append = " WHERE company LIKE '%".$_POST['Search']."%'";
	}
	
	//handle data deletions - function located @ ../inc/libfns
	//gridDelete();
	if($_POST['Action'] == "Submit" && $_POST['Action_'] == "Delete" && $_POST['ids']){
		//echo "--";
		for($i=0;$i<count($_POST['ids']);$i++){
			//Handle file delete
			$sql_select_file = "SELECT document FROM $tbl_docs WHERE id=".$_POST['ids'][$i];
			//echo $sql_select_file;
			$sql_file = $db_conn->query($sql_select_file);
			if($sql_file->rowCount() > 0){
				$array_file = $sql_file->fetch();
				$merchant_doc_dir = "uploads/documents/";
				if(file_exists($merchant_doc_dir.$array_file["document"])){
					unlink($merchant_doc_dir.$array_file["document"]);
				}
			}
			$sql_delete_ex = $sql_delete = "DELETE FROM $tbl_docs WHERE id=".$_POST['ids'][$i];
			$db_conn->query($sql_delete);
			@ $deleted_rows += $sql_delete_ex ->rowCount();
		}
		if($deleted_rows > 0) $banner_msg = $deleted_rows." row(s) deleted.";
	}
	
	//handle form resets for edit mode
	if($_POST['Submit'] == "Reset"){
		header("Location: index.php?mod=$mod&mod_select=$mod_select&sub=$sub&id=$id");
	}
	
	//resolve data views for each product
	if($type){
		if($type == "arts_events"){
			$where_clause = " WHERE type='$type' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";
		}
		if($type == "sports_events"){
			$where_clause = " WHERE type='$type' AND mod_id IN (SELECT id FROM $tbl_sports_events WHERE company_id = ".$_SESSION['userid']." )";
		}
		if($type == "hotels" && !$sub){
			$where_clause = " WHERE type='$type' AND mod_id IN (SELECT id FROM $tbl_hotels WHERE company_id = ".$_SESSION['userid']." )";
		}
		if($type == "hotels" && $sub == "facility"){
			$where_clause = " WHERE type='$type' AND sub_type='$sub' AND sub_id IN (SELECT id FROM $tbl_facilities WHERE company_id = ".$_SESSION['userid']." )";
		}
		if($type == "hotels" && $sub == "menu"){
			$where_clause = " WHERE type='$type' AND sub_type='$sub' AND sub_id IN (SELECT id FROM $tbl_menu WHERE company_id = ".$_SESSION['userid']." )";
		}
		
		if($type == "transport"){
			$where_clause = " WHERE type='$type' AND mod_id IN (SELECT id FROM $tbl_vehicles WHERE company_id = ".$_SESSION['userid']." )";
		}
		if($type == "attractions" && !$sub){
			$where_clause = " WHERE type='$type' AND mod_id IN (SELECT id FROM $tbl_attractions WHERE company_id = ".$_SESSION['userid']." )";
		}
	}
	
	if($_POST['Action_'] && $_POST['ids'][0] && $_POST['Action'] == "Submit"){
		
		$select_item_history = "SELECT item_history FROM $tbl_orders_sub WHERE session_id='".$_POST['ids'][0]."'";
		$item_history_ = $db_conn->query($select_item_history);
		if($item_history_->rowCount() > 0) $item_history__ = $item_history_->fetch();
		$item_history = $item_history__['item_history'];
		
		if($_POST['Action_'] == "Cancel order"){
			if($item_history) $item_history .= ":"."Cancel item order;Merchant - ".$_SESSION['company']." (".$_SESSION['userid'].");".date("m/d/Y");
			else $item_history = "Cancel item order;Merchant - ".$_SESSION['company']." (".$_SESSION['userid'].");".date("m/d/Y");
			$status = "Cancelled";
		}
		if($_POST['Action_'] == "Confirm order"){
			if($item_history) $item_history .= ":"."Confirm item order;Merchant - ".$_SESSION['company']." (".$_SESSION['userid'].");".date("m/d/Y");
			else $item_history = "Confirm item order;Merchant - ".$_SESSION['company']." (".$_SESSION['userid'].");".date("m/d/Y");
			$status = "Confirmed";
		}
		if($_POST['Action_'] == "Shipped"){
			if($item_history) $item_history .= ":"."Item shipped;Merchant - ".$_SESSION['company']." (".$_SESSION['userid'].");".date("m/d/Y");
			else $item_history = "Item shipped;Merchant - ".$_SESSION['company']." (".$_SESSION['userid'].");".date("m/d/Y");
			$status = "Shipped";
		}
		
		$sql_update_str = "UPDATE $tbl_orders_sub SET status='$status',item_history = '$item_history' WHERE session_id='".$_POST['ids'][0]."'";
		//echo $sql_update_str;
		$sql_update_str_res = $db_conn->query($sql_update_str);
		if($sql_update_str_res->rowCount() > 0){
			echo("<script language='javascript'>");
			echo("alert('Update successful!');");
			echo("</script>");
		}
		else{
			echo("<script language='javascript'>");
			echo("alert('Update failed!')");
			echo("</script>");
		}
	}
	
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Merchant account administration :: </title>

<link href="../css/main.css" rel="stylesheet" type="text/css" />
<link href="../css/scroll.css" rel="stylesheet" type="text/css" />

<script language="JavaScript" src="../js/tigra_calendar/calendar_us.js"></script>
<link rel="stylesheet" href="../js/tigra_calendar/calendar.css">

<link rel="stylesheet" href="../css/lightbox.css" type="text/css" media="screen" />
<script type="text/javascript" src="../js/prototype.js"></script>
<script type="text/javascript" src="../js/scriptaculous.js?load=effects,builder"></script>
<script type="text/javascript" src="../js/lightbox.js"></script>

</head>
<body>
<!--Top Banner-->
<table width="100%" border="0" cellpadding="4" cellspacing="0" class="tbl_banner">
  <!--DWLayoutTable-->
  <tr>
    <td width="30%" height="" class="main_txt_bold"><a href="index.php"><img src="../../img/logo_new.jpg" border="0" /></a></td>
  	<td width="70%" height="20" align="right" valign="top">
   	   <?php include("inc/top_nav.php"); ?>
    </td>
  </tr>
</table>

<!--Main area-->
<table width="970" cellpadding="0" cellspacing="0" align="center">
	<tr><td colspan="3">&nbsp;</td></tr>
	 <tr>
    	<!--side navigation-->
        <!--display side menu navigation-->
        <td width="200" bgcolor="" height="100" valign="top">
			<table width="100%" cellpadding="" cellspacing="5" class="active_border">
            	<tr>
                	<td>
                    	<table cellpadding="4" cellspacing="1" width="100%">
                           <tr>
								<td><a href="#" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($mod=="orders") echo "<b>"; ?>MANAGE ORDERS<?php if($mod=="orders") echo "</b>"; ?></a></td>
							</tr>
							<tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=orders&action=manage&type=arts_events" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($type=="arts_events") echo "<b>"; ?>ARTS EVENTS<?php if($type=="arts_events") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=orders&action=manage&type=sports_events" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($type=="sports_events") echo "<b>"; ?>SPORTS EVENTS<?php if($type=="sports_events") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;<a href="#" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($type=="hotels") echo "<b>"; ?>HOTELS<?php if($type=="hotels") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=orders&action=manage&type=hotels&sub=" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($type == "hotels" && $sub=="") echo "<b>"; ?>ACCOMODATION<?php if($type == "hotels" && $sub=="") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=orders&action=manage&type=hotels&sub=facility" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($type == "hotels" && $sub=="facility") echo "<b>"; ?>FACILITIES<?php if($type == "hotel" && $sub=="facility") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=orders&action=manage&type=hotels&sub=menu" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($type == "hotels" && $sub=="menu") echo "<b>"; ?>MENU<?php if($type == "hotels" && $sub=="menu") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=orders&action=manage&type=transport" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($type=="transport") echo "<b>"; ?>VEHICLES<?php if($type=="transport") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=orders&action=manage&type=attractions" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($type=="attractions") echo "<b>"; ?>LOCAL ATTRACTIONS<?php if($type=="attractions") echo "</b>"; ?></a></td>
							</tr>
                            <!--tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=orders&action=manage&type=parking" class="side_nav"><img src="../img/ikons/tooloptions.png" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($type=="parking") echo "<b>"; ?>PARKING<?php if($type=="parking") echo "</b>"; ?></a></td>
							</tr-->
                            
                        </table>
                    </td>
                </tr>
          </table>
		</td>
        
        <td width="10">&nbsp;</td>
        
        <!--main display area-->
        <td width="820" bgcolor="" valign="top">
			
			<table width="100%" cellpadding="0" cellspacing="0" class="active_border">
				<tr>
					<td height="25" background="../img/top_grad.jpg" class='main_txt'>
						&nbsp;&nbsp; MERCHANT ADMINISTRATION
                        <?php 
							//resolve and display form  titles
							if($mod == "orders") echo " :: ORDERS";
						?>
					</td>
				</tr>
          	</table>
		  
		  <table width="100%" cellpadding="0" cellspacing="0" class="">
          	<tr>
            	<td height="5" background=""></td>
            </tr>
          </table>
		  
		  <table width="100%" cellpadding="0" cellspacing="0" class="active_border">
            	<tr height="210">
					<td valign="top">
						
						<?php if(!$mod){?>
                        <table width="100%" cellpadding="4" cellspacing="0">
                        	<tr class="main_txt">
                            	<td colspan="2" align="center"><img src="../../img/logo_large.jpg" /></td>
                            </tr>
                        </table>
                        <?php } ?>
                        
                        <?php if($mod == "orders" && !$_GET['view']){?>
                        <form name="order_grid" action="<?php echo $_SERVER['PHP_SELF'].$form_get; ?>" method="post">
                        <table cellpadding="6" cellspacing="0" width="100%">
                            <tr>
                                <td width="80%" class="main_txt">
                                    Action
                                    <select name="Action_" class="span3">
                                        <option>---------------</option>
                                        <option>Confirm order</option>
                                        <option>Cancel order</option>
                                        <option>Shipped</option>
                                    </select>
                                    <input type="submit" name="Action" value="Submit" class="span3" />
                                    &nbsp;&nbsp;&nbsp;&nbsp; Page # 
                                    <?php if($_GET['page']) $page_no = $_GET['page']; else $page_no = 1; echo $page_no;?>
                                    &nbsp;&nbsp;&nbsp;&nbsp;<?php //echo "( Showing details for order # ".$_GET['id'].". * <a href='".base64_decode($_GET['rtn'])."' class='top_nav_links' title='Return to orders.'> Back to orders.</a>)"; ?>
                                </td>
                                <td width="20%" class="main_txt" align="right">&nbsp;</td>
                            </tr>
                        </table>
                        <table width="100%" cellpadding="4" cellspacing="1">						
                            <tr class="main_txt_bold" bgcolor="#CCCCCC" align="center">
                                <td width="5%">&nbsp;</td>
                                <td width="15%">Order #</td>
                                <td width="30%">Order Options</td>
                                <td width="15%">Order type</td>
                                <td width="15%">Item cost (CAD)</td>
                                <td width="10%">Order Status</td>
                                <td width="10%">Tasks</td>
                            </tr>
                         </table>
                         <?php
                            
                            $sql_load_orders = "SELECT * FROM $tbl_orders_sub ".$where_clause;
                            //echo $sql_load_orders;
							$sql_orders = $db_conn->query($sql_load_orders);														
                            
                            //$sql_orders = $db_conn->query($sql_load_orders);
                            //page scroller functions
                            //calculate ffwd var for scroller - forwards through pages based on current page location pointer
                            $pages_per_set_ = 10;
                            $pages_per_set_ = 10;
                            $records_per_page = 10;
                            $page = strip_tags($_GET['page']);								
                            $pages = ceil($sql_orders->rowCount()/$records_per_page);

                            //cater for single page
                            if($pages == 1 && $sql_orders->rowCount() < $pages_per_set_){
                                $scroll = $sql_orders->rowCount();
                            }else $scroll = $pages_per_set_;
                            //cater for mid pages
                            if($page < $pages && $pages > 1){
                                $scroll = $records_per_page;
                                $ffd = (($page - 1) * $pages_per_set_);
                            }
                            //cater for last page
                            if($page == $pages && $pages > 1){
                                $scroll = $sql_orders->rowCount() - (($pages - 1) * $pages_per_set_);
                                $ffd = (($pages - 1) * $pages_per_set_);
                            }
                            //cater for no data
                            if($sql_orders->rowCount() == 0) $scroll = 0;
                            if($ffd > 0) for($i=0;$i<$ffd;$i++) $order_array = $sql_orders->fetch();
                            
                            if($sql_orders->rowCount() > 0){
                                
                                for($l=0;$l<$scroll;$l++){
                                    $order_array = $sql_orders->fetch();
                                    $url = base64_encode(basename($_SERVER['PHP_SELF']).$form_get);
                                    //create link to order detailed view
                                    echo "<table cellpadding='4' cellspacing='1' width='100%' style='border-bottom: 1px solid #CCCCCC'>
                                            <tr class='main_txt'>
                                                <td width='5%'><input type='checkbox' name='ids[]' class='forms' value='".$order_array['session_id']."' /></td>
                                                <td align='center' width='15%'>".$order_array['session_id']."</td>
                                                <td align='center' width='30%'>".$order_array['order_options']."</td>
                                                <td align='center' width='15%'>".ucfirst($order_array['type'])."</td>
                                                <td align='center' width='15%'>".number_format($order_array['item_cost'],2,".",",") ."</td>
                                                <td align='center' width='10%'>".$order_array['status']."</td>
                                                <td width='10%'>
                                                    <table width='100%' cellspacing='0' cellpadding='0'>
                                                            <tr>
                                                                <td align='center'>
                                                                    <a href='".$_SERVER['PHP_SELF']."?mod=$mod&view=item_info&id=".$order_array['session_id']."&rtn=".$url."' title='View order information'><img src='../img/ikons/show.gif' border='0'></a>&nbsp;&nbsp;
                                                                    <!--a href='".$_SERVER['PHP_SELF']."?view=".strip_tags($_GET['view'])."&action=cancel&id=".strip_tags($_GET['id'])."&rtn=".strip_tags($_GET['rtn'])."' title='Request order cancellation' onclick='return confirm(\"Are you sure you want to cancel this order item?\")'><img src='../../img/reject_icon.gif' border='0'></a-->
                                                                </td>
                                                            </tr>
                                                        </table>
                                                </td>
                                            </tr>
                                        </table>";
                                }
                                
                            }else{
                                echo "<table cellpadding='6' cellspacing='0' width='100%'>
                                        <tr><td width='100%' class='errors' align='center' >Order information not available!</td></tr>
                                    </table>";
                            }
                            
                        ?>
                        </form>
                        <table cellpadding="2" cellspacing="4"  align="center">
                            <tr>
                                <td height="20" align="center"><?php skroller($pages,$pages_per_set_); ?></td>
                            </tr>
                        </table> 
                        <?php } ?>
                        
                        <?php if($mod == "orders" && $_GET['view']=="item_info"){
								
								if($_GET['id']){
									$select_item_info = "SELECT * FROM $tbl_orders_sub WHERE session_id = '".$_GET['id']."'";
									$item_info_ = $db_conn->query($select_item_info);
									if($item_info_->rowCount() > 0){
										$item_info_array = $item_info_->fetch();
										if($item_info_array['item_history']) $item_history = explode(":",$item_info_array['item_history']);
									}
								}
								
						?>
                        
                         	<table cellpadding="6" cellspacing="0" width="100%">
                                <tr>
                                    <td width="100%" class="main_txt">
                                        <?php echo "<strong>Showing history for item in order # ".$_GET['id'].". * <a href='".base64_decode($_GET['rtn'])."' class='top_nav_links' title='Return to orders.'> Back to order items.</a></strong>"; ?>
                                    </td>
                                </tr>
                            </table>
                            <table width="100%" cellpadding="4" cellspacing="1" align="left">						
                                <tr class="main_txt_bold" bgcolor="#CCCCCC" align="center">
                                    <td width='30%'>Action</td>
                                    <td width='60%'>Requested by</td>
                                    <td width='10%'>Date</td>
                                </tr>
                            </table>
                            <?php 
								//echo $order_history_;
								if(count($item_history) > 0){
									for($h=0;$h<count($item_history);$h++){
										$row = explode(";",$item_history[$h]);
										echo "<table width='100%' cellpadding='4' cellspacing='1' style='border-bottom:#CCCCCC 1px solid;'>
												<tr>
													<td class='main_txt' width='30%'>".$row[0]."</td>
													<td class='main_txt' width='60%'>".$row[1]."</td>
													<td class='main_txt' width='10%'>".$row[2]."</td>
												</tr>
											 </table>";	
									}
								}else echo "<table width='100%' cellpadding='4' cellspacing='1' style='border-bottom:#CCCCCC 1px solid;'>
												<tr>
													<td width='100%' align='center' class='errors'>Order history not available!</td>
												</tr>
											 </table>";	
							?>
                            
                         <?php } ?>
					</td>
				</tr>
		  </table>
		</td>
	</tr>
	<tr><td colspan="3">&nbsp;</td>
</table>

<!--Base banner-->
<table width="100%" cellpadding="0" cellspacing="0" class="tbl_banner_base">
	<tr>
    	<td class="base_txt" align="center"><br />A Clay-Mark Solution<br /><br /></td>
    </tr>
</table>
</body>
</html>