<?php
	/*
		This page contains verification interactions for merchant accounts
		The credit card interaction initially verifies the entered credit card information
		The document verification module allows for the upload of business documents for verification 
	*/
	session_start();
	if($_SESSION['session_type'] != "merchant"){
		header("Location: login.php?logout=yes");
	}
	
	include_once "../inc/libfns.php";
	include_once "../../inc/vars.php";
	require_once "../../inc/moneris/mpgClasses.php";
	//Connect to DB
	db_connect(HOST,USER,PASSWORD,DB);
	
	//include localization arrays for form data
	include_once("../../localization/en/lang-en.php");
	
	//handle get GET vars, enable form submit persistence for GET variables
	if($_GET['mod']){
		$mod = strip_tags($_GET['mod']);
		$form_get = "?mod=$mod";
	}
	if($_GET['sub']){
		$sub = strip_tags($_GET['sub']);
		$form_get .= "&sub=$sub";
	}
	if($_GET['action']){
		$action = strip_tags($_GET['action']);
		$form_get .= "&action=$action";
	}
	if($_GET['mode']){
		$mode = strip_tags($_GET['mode']);
		$form_get .= "&mode=$mode";
	}
	if($_GET['mod_select']){
		$mod_select = strip_tags($_GET['mod_select']);
		$form_get .= "&mod_select=$mod_select";
	}
	if($_GET['id']){
		$id = strip_tags($_GET['id']);
		$form_get .= "&id=$id";
	}
	if($_GET['edit_id']){
		$edit_id = strip_tags($_GET['edit_id']);
		$form_get .= "&edit_id=$edit_id";
	}
	
	//include library of primary merchant functions
	include_once "inc/libmain.php";
	include_once "inc/libsub.php";
				
	
	if($_POST['Submit'] == "Submit" && $mod != "ach"){
		validate_merchant();
		if($errors == 0){
			$sql_update = "UPDATE $tbl_merchants_ SET business_type='".$_POST['business_type']."',business_name='".$_POST['business_name']."'
							   ,business_address='".$_POST['address']."',business_alt_address='".$_POST['alt_address']."',business_country='".$_POST['country']."',business_pt='".$_POST['pt']."',business_city='".$_POST['city']."',business_street='".$_POST['street']."'
							   ,business_suite_no='".$_POST['suite_no']."',business_postal_code='".$_POST['postal_code']."',cs_email='".$_POST['cs_email']."',cs_phone='".$_POST['cs_phone']."',owner_salutation='".$_POST['salutation']."',owner_name='".$_POST['name']."'
							   ,country_of_citizenship='".$_POST['country_of_citizenship']."',owner_address='".$_POST['owner_address']."'
							   ,owner_country='".$_POST['owner_country']."',owner_pt='".$_POST['owner_pt']."',owner_city='".$_POST['owner_city']."',owner_street='".$_POST['street']."',owner_suite_no='".$_POST['owner_suite_no']."'
							   ,owner_postal_code='".$_POST['owner_postal_code']."',owner_work_phone='".$_POST['owner_work_phone']."'
							   ,owner_work_phone_ext='".$_POST['owner_work_phone_ext']."',owner_home_phone='".$_POST['owner_home_phone']."'
							   ,owner_mobile='".$_POST['owner_mobile']."',owner_dob='".$_POST['year']."-".$_POST['month']."-".$_POST['day']."' WHERE id=".$_SESSION['userid'];
			//echo $sql_update;
			$db_conn->query($sql_update);
		}
	}
	
	//Perform data binding operation to the current form
	if($_SESSION['userid'] && $mod != "ach"){
		$sql_select = "SELECT * FROM $tbl_merchants_ WHERE id = ".$_SESSION['userid'];
		$sql_data = $db_conn->query($sql_select);
		if($sql_data->rowCount() > 0) $sql_array = $sql_data->fetch();
		$_POST['business_type'] = $sql_array['business_type'];$_POST['address'] = $sql_array['business_address'];
		$_POST['business_name'] = $sql_array['business_name'];$_POST['alt_address'] = $sql_array['business_alt_address'];
		$_POST['country'] = $sql_array['business_country'];$_POST['pt'] = $sql_array['business_pt'];
		$_POST['city'] = $sql_array['business_city'];$_POST['street'] = $sql_array['business_street'];
		$_POST['suite_no'] = $sql_array['business_suite_no'];$_POST['postal_code'] = $sql_array['business_postal_code'];
		$_POST['cs_email'] = $sql_array['cs_email'];$_POST['cs_phone'] = $sql_array['cs_phone'];
		$_POST['owner_address'] = $sql_array['owner_address'];
		$_POST['owner_city'] = $sql_array['owner_city'];$_POST['owner_street'] = $sql_array['owner_street'];
		$_POST['owner_suite_no'] = $sql_array['owner_suite_no'];$_POST['owner_postal_code'] = $sql_array['owner_postal_code'];
		$_POST['salutation'] = $sql_array['owner_salutation'];$_POST['name'] = $sql_array['owner_name'];
		$_POST['country_of_citizenship'] = $sql_array['country_of_citizenship'];$_POST['owner_country'] = $sql_array['owner_country'];
		$_POST['owner_work_phone'] = $sql_array['owner_work_phone'];$_POST['owner_work_phone_ext'] = $sql_array['owner_work_phone_ext'];
		$_POST['owner_home_phone'] = $sql_array['owner_home_phone'];$_POST['owner_mobile'] = $sql_array['owner_mobile'];
		$_POST['owner_occupation'] = $sql_array['owner_occupation'];
		$dob = explode("-",$sql_array['owner_dob']);
		$_POST['day'] = $dob[2];$_POST['year'] = $dob[0];
		$_POST['month'] = $dob[1];
	}
	
	//Check account balance for ACH Credit option
	if($mod == "ach" || $mod == "stats"){
		$sql_acc_bal = "SELECT account_balance FROM $tbl_merchants_ WHERE id =".$_SESSION['userid'];
		$sql_acc_bal = $db_conn->query($sql_acc_bal);
		if($sql_acc_bal->rowCount() > 0) $array_acc_bal = $sql_acc_bal->fetch();
		$acc_bal = number_format($array_acc_bal[0],2,".",",");
		$_POST['acc_bal'] = $acc_bal;
		$_POST['check_no'] = mt_rand();
		//Confirm account balance by checking for evidence of prior activity
		
	}
	
	if($_POST['Submit'] == "Submit" && $mod == "ach"){
		$ach_validate = new merchant_info_validation();
		$ach_validate->validate_ach_credit();
		if($errors == 0){
			//Attempt ACH Credit and commit details to DB if successful
			/************************ Transaction Variables ******************************/
			$orderid='ach-'.date("dmy-G:i:s");
			$custid = 'RV-'.$_SESSION[''];
			/************************ Transaction Array **********************************/
			$txnArray=array(type=>'us_ach_credit',
							order_id=>$orderid,
							cust_id=>$custid,
							amount=>$_POST['amount']
							);
			/************************** ACH Info Variables *****************************/
			$sec = $sec_code[0];			
			/********************** ACH Info Associative Array *************************/
			
			$achTemplate = array(
								 sec =>$sec,
								 cust_first_name => $_POST['first_name'],
								 cust_last_name => $_POST['surname'],
								 cust_address1 => $_POST['address'],
								 cust_address2 => $_POST['alt_address'],
								 cust_city => $_POST['city'],
								 cust_state => $_POST['state'],
								 cust_zip => $_POST['postal_code'],
								 routing_num => $_POST['routing_num'],
								 account_num => $_POST['acc_no'],
								 check_num => $_POST['check_no'],
								 account_type => $_POST['acc_type']
								);
			
			/************************** ACH Info Object ********************************/
			$mpgAchInfo = new mpgAchInfo ($achTemplate);
			/************************ Transaction Object *******************************/
			$mpgTxn = new mpgTransaction($txnArray);
			/************************ Set ACH Info *************************************/
			$mpgTxn->setAchInfo($mpgAchInfo);
			/************************ Request Object **********************************/
			$mpgRequest = new mpgRequest($mpgTxn);
			/************************ mpgHttpsPost Object ******************************/
			$mpgHttpPost = new mpgHttpsPost($store_id,$api_token,$mpgRequest);
			/************************ Response Object **********************************/
			$mpgResponse=$mpgHttpPost->getMpgResponse();
			//Format response object for storage
			$ach_response = $mpgResponse->getCardType()."||".$mpgResponse->getTransAmount()."||".$mpgResponse->getTxnNumber()."||".
							$mpgResponse->getReceiptId()."||".$mpgResponse->getTransType()."||".$mpgResponse->getReferenceNum()."||".
							$mpgResponse->getResponseCode()."||".$mpgResponse->getMessage()."||".$mpgResponse->getAuthCode()."||".
							$mpgResponse->getComplete()."||".$mpgResponse->getTransDate()."||".$mpgResponse->getTransTime()."||".
							$mpgResponse->getTicket()."||".$mpgResponse->getTimedOut();
			//echo $ach_response;
			if($mpgResponse->getMessage() == "Global Error Receipt"){
				//Store ACH response for future reference
				$sql_store_ach = "INSERT INTO $tbl_ach_cr(first_name,surname,address,alt_address,city,state,postal_code,
								  routing_no,acc_no,check_no,acc_type,ach_response,rv_acc_type,rv_acc_id,ach_status,amount,order_id,date_added) 
								  VALUES('".$_POST['first_name']."','".$_POST['surname']."','".$_POST['address']."','".$_POST['alt_address']."'
								  ,'".$_POST['city']."','".$_POST['state']."','".$_POST['postal_code']."','".$_POST['routing_no']."','".$_POST['acc_no']."'
								  ,'".$_POST['check_no']."','".$_POST['acc_type']."','$ach_response','Merchant',".$_SESSION['userid'].",'Failed'
								  ,".$_POST['amount'].",'$order_id','".date("Y-m-d H:i:s")."')";
				
				$sql_ach = $db_conn->query($sql_store_ach);
			}else{
				
				$sql_store_ach = "INSERT INTO $tbl_ach_cr(first_name,surname,address,alt_address,city,state,postal_code,
								  routing_no,acc_no,check_no,acc_type,ach_response,rv_acc_type,rv_acc_id,ach_status,amount,order_id,date_added) 
								  VALUES('".$_POST['first_name']."','".$_POST['surname']."','".$_POST['address']."','".$_POST['alt_address']."'
								  ,'".$_POST['city']."','".$_POST['state']."','".$_POST['postal_code']."','".$_POST['routing_no']."','".$_POST['acc_no']."'
								  ,'".$_POST['check_no']."','".$_POST['acc_type']."','$ach_response','Merchant',".$_SESSION['userid']."
								  ,'Successful',".$_POST['amount'].",'$order_id','".date("Y-m-d H:i:s")."')";
				$sql_ach = $db_conn->query($sql_store_ach);
				
				$sql_update_bal = "UPDATE $tbl_merchants_ SET account_balance=account_balance-".$_POST['amount'];
				//echo $sql_update_bal;
				$db_conn->query($sql_update_bal);
			}
			if($sql_ach->rowCount() > 0){
				$update_msg = "&nbsp;&nbsp;&nbsp;&nbsp;Your transaction was posted.";
				$_POST = array();	
			}
		}
	}
	if($mod == "ach"){
		$sql_prev = "SELECT * FROM $tbl_ach_cr WHERE rv_acc_type='Merchant' AND rv_acc_id='".$_SESSION['userid']."' ORDER BY date_added DESC LIMIT 1";
		$sql_prev = $db_conn->query($sql_prev);
		if($sql_prev->rowCount() > 0){
			$array_prev = $sql_prev->fetch();
			$_POST['first_name'] = $array_prev['first_name'];
			$_POST['surname'] = $array_prev['surname'];
			$_POST['address'] = $array_prev['address'];
			$_POST['alt_address'] = $array_prev['alt_address'];
			$_POST['city'] = $array_prev['city'];
			$_POST['postal_code'] = $array_prev['postal_code'];
			$_POST['routing_no'] = $array_prev['routing_no'];
			$_POST['acc_no'] = $array_prev['acc_no'];
			$_POST['acc_type'] = $array_prev['acc_type'];
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Merchant account administration :: </title>

<link href="../css/main.css" rel="stylesheet" type="text/css" />
<link href="../css/scroll.css" rel="stylesheet" type="text/css" />

<script language="JavaScript" src="../js/tigra_calendar/calendar_us.js"></script>
<link rel="stylesheet" href="../js/tigra_calendar/calendar.css">

<link rel="stylesheet" href="../css/lightbox.css" type="text/css" media="screen" />
<script type="text/javascript" src="../js/prototype.js"></script>
<script type="text/javascript" src="../js/scriptaculous.js?load=effects,builder"></script>
<script type="text/javascript" src="../js/lightbox.js"></script>

</head>
<body>
<!--Top Banner-->
<table width="100%" border="0" cellpadding="4" cellspacing="0" class="tbl_banner">
  <!--DWLayoutTable-->
  <tr>
    <td width="30%" height="" class="main_txt_bold"><a href="index.php"><img src="../../img/logo_new.jpg" border="0" /></a></td>
  	<td width="70%" height="20" align="right" valign="top">
   	  <?php include("inc/top_nav.php"); ?>
    </td>
  </tr>
</table>

<!--Main area-->
<table width="970" cellpadding="0" cellspacing="0" align="center">
	<tr><td colspan="3">&nbsp;</td></tr>
	 <tr>
    	<!--side navigation-->
        <!--display side menu navigation-->
        <td width="180" bgcolor="" height="100" valign="top">
			<table width="100%" cellpadding="" cellspacing="5" class="active_border">
            	<tr>
                	<td>
                    	<table cellpadding="4" cellspacing="1" width="100%">
							
                            <tr>
								<td><a href="#" class="side_nav"><img src="../img/ikons/tooloptions.gif" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($mod=="events") echo "<b>"; ?>MY ACCOUNT<?php if($mod=="events") echo "</b>"; ?></a></td>
							</tr>
							<tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=acc&action=add" class="side_nav"><img src="../img/ikons/tooloptions.gif" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($mod=="acc") echo "<b>"; ?>DETAILS<?php if($mod=="acc") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=stats&action=view" class="side_nav"><img src="../img/ikons/tooloptions.gif" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($mod=="stats") echo "<b>"; ?>STATS<?php if($mod=="stats") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=ach&action=view" class="side_nav"><img src="../img/ikons/tooloptions.gif" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($mod=="ach") echo "<b>"; ?>ACH CREDIT<?php if($mod=="ach") echo "</b>"; ?></a></td>
							</tr>
                            <tr>
								<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="?mod=ach_history&action=view" class="side_nav"><img src="../img/ikons/tooloptions.gif" align="absmiddle" border="0" />&nbsp;&nbsp;<?php if($mod=="ach_history") echo "<b>"; ?>ACH HISTORY<?php if($mod=="ach_history") echo "</b>"; ?></a></td>
							</tr>
                        </table>
                    </td>
                </tr>
          </table>
		</td>
        
        <td width="10">&nbsp;</td>
        
        <!--main display area-->
        <td width="820" bgcolor="" valign="top">
			
			<table width="100%" cellpadding="0" cellspacing="0" class="active_border">
				<tr>
					<td height="25" background="../img/top_grad.jpg" class='main_txt'>
						&nbsp;&nbsp; MERCHANT ADMINISTRATION
                        <?php 
							//resolve and display form  titles
							if($mod == "stats") echo " :: ACCOUNT STATISTICS";
							if($mod == "docs" && $action == "show") echo " :: BUSINESS DOCUMENT VERIFICATION";
							
						?>
					</td>
				</tr>
          	</table>
		  
		  <table width="100%" cellpadding="0" cellspacing="0" class="">
          	<tr>
            	<td height="5" background=""></td>
            </tr>
          </table>
		  
		  <table width="100%" cellpadding="0" cellspacing="2" class="active_border">
            	<tr height="210">
					<td valign="top">
						
						<?php if(!$mod){?>
                        <table width="100%" cellpadding="4" cellspacing="0">
                        	<tr class="main_txt">
                            	<td colspan="2" align="center"><img src="../../img/logo_large.jpg" /></td>
                            </tr>
                        </table>
                        <?php } ?>
                        
                        <?php if($mod == "acc" && ($action == "add" || $action == "edit" || $action == "")){?>
                        <form name="acc" action="<?php echo $_SERVER['PHP_SELF'].$form_get; ?>" method="post" enctype="multipart/form-data" >
                        <table width="100%" cellpadding="4" cellspacing="0">
                            <tr class="main_txt">
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">&nbsp;</td>
                                <td class="main_txt_bold" align="left">Business information</td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right" width="35%">Business type</td>
                                <td class="error" align="left" width="65%">
                                    <?php
                                        $business_type = array("Select ..","Sole proprietorship","Partnership","Incorporated company","Franchise");
                                        echo '<select name="business_type" class="span3" id="business_type">';
                                        $i=0;
                                        for($i==0;$i<=count($business_type)-1;$i++){
                                            if($business_type[$i] == $_POST['business_type'])
                                                echo "<option value='".$_POST['business_type']."' selected>".$_POST['business_type']."</option>";
                                            else
                                                echo "<option value='".$business_type[$i]."'>".$business_type[$i]."</option>";
                                        }
                                        echo '</select>';
                                     ?>
                                    <?php echo $msg[3]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Business name</td>
                                <td class="error" align="left">
                                    <input type="text" id="" name="business_name" class="span3" value="<?php echo $_POST['business_name'];?>" size="40">
                                    <?php echo $msg[4]; ?>
                                </td>
                            </tr>	
                            
                            <tr>
                                <td class="main_txt" align="right">Address</td>
                                <td class="error" align="left">
                                    <input type="text" name="address" class="span3" value="<?php echo $_POST['address'];?>" size="40">
                                    <?php echo $msg[5]; ?>
                                </td>
                            </tr>	
                            <tr>
                                <td class="main_txt" align="right">Alternate address</td>
                                <td class="error" align="left">
                                    <input type="text" name="alt_address" class="span3" value="<?php echo $_POST['alt_address'];?>" size="40">
                                </td>
                            </tr>
                           <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_COUNTRY']; ?></td>
                                <td class="error" align="left">
                                     <?php
                                        $country = array("Canada");
                                        echo '<select name="country" class="span3">';
                                        $i=0;
                                        for($i==0;$i<=count($country)-1;$i++){
                                            if($country[$i] == $_POST['country'])
                                                echo "<option value='".$_POST['country']."' selected>".$_POST['country']."</option>";
                                            else
                                                echo "<option value='".$country[$i]."'>".$country[$i]."</option>";
                                        }
                                        echo '</select>';
                                        //echo $msg[2];
                                     ?>
                                    </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_PT']; ?></td>
                                <td class="error" align="left">
                                     <?php
                                        $pt = array("Alberta","British Columbia","Saskatchewan","Manitoba","Ontario","Quebec","New Brunswick","Newfoundland","Labrador","Nova Scotia","Prince Edward Island");
                                        echo '<select name="pt" class="span3">';
                                        $i=0;
                                        for($i==0;$i<=count($pt)-1;$i++){
                                            if($pt[$i] == $_POST['pt'])
                                                echo "<option value='".$_POST['pt']."' selected>".$_POST['pt']."</option>";
                                            else
                                                echo "<option value='".$pt[$i]."'>".$pt[$i]."</option>";
                                        }
                                        echo '</select>';
                                        //echo $msg[2];
                                     ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_CITY']; ?></td>
                                <td class="error" align="left">
                                    <input type="text" name="city" class="span3" value="<?php echo $_POST['city'];?>" size="40">
                                    <?php echo $msg[6]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_STREET']; ?></td>
                                <td class="error" align="left">
                                    <input type="text" name="street" class="span3" value="<?php echo $_POST['street'];?>" size="40">
                                    <?php echo $msg[7]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_SUITE']; ?></td>
                                <td class="error" align="left">
                                    <input type="text" name="suite_no" class="span3" value="<?php echo $_POST['suite_no'];?>" size="40">
                                    <?php echo $msg[8]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_POSTAL']; ?></td>
                                <td class="error" align="left">
                                    <input type="text" name="postal_code" class="span3" value="<?php echo $_POST['postal_code'];?>" size="40">
                                    <?php echo $msg[9]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Customer service email</td>
                                <td class="error" align="left">
                                    <input type="text" name="cs_email" class="span3" value="<?php echo $_POST['cs_email'];?>" size="40">
                                    <?php echo $msg[10].$msg[11]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Customer service phone</td>
                                <td class="error" align="left">
                                    <input type="text" name="cs_phone" class="span3" value="<?php echo $_POST['cs_phone'];?>" size="40">
                                    <?php echo $msg[1]; ?>
                                </td>
                            </tr>
                            <tr class="main_txt">
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">&nbsp;</td>
                                <td class="main_txt_bold" align="left">Business owner / business contact information</td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_OWNER']; ?></td>
                                <td class="error" align="left">
                                    <?php
                                        $salutation = array("select..","Mr.","Ms.");
                                        echo '<select name="salutation" class="span3">';
                                        $i=0;
                                        for($i==0;$i<=count($salutation)-1;$i++){
                                            if($salutation[$i] == $_POST['salutation'])
                                                echo "<option value='".$_POST['salutation']."' selected>".$_POST['salutation']."</option>";
                                            else
                                                echo "<option value='".$salutation[$i]."'>".$salutation[$i]."</option>";
                                        }
                                        echo '</select>';
                                     ?>
                                    <input type="text" name="name" class="span3" value="<?php echo $_POST['name'];?>" size="26">
                                    <?php echo $msg[12].$msg[13]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Country of citizenship</td>
                                <td class="error" align="left">
                                     <?php
                                        $country = array("Canada");
                                        echo '<select name="country_of_citizenship" class="span3">';
                                        $i=0;
                                        for($i==0;$i<=count($country)-1;$i++){
                                            if($country[$i] == $_POST['country'])
                                                echo "<option value='".$_POST['country']."' selected>".$_POST['country']."</option>";
                                            else
                                                echo "<option value='".$country[$i]."'>".$country[$i]."</option>";
                                        }
                                        echo '</select>';
                                        //echo $msg[2];
                                     ?>
                                    </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">&nbsp;</td>
                                <td class="main_txt" align="left"><em>To use your business address / do not fill in the below address section.</em></td>
                            </tr>
                             <tr>
                                <td class="main_txt" align="right">Address</td>
                                <td class="error" align="left">
                                    <input type="text" name="owner_address" class="span3" value="<?php echo $_POST['owner_address'];?>" size="40">
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_COUNTRY']; ?></td>
                                <td class="error" align="left">
                                     <?php
                                        $country = array("Canada");
                                        echo '<select name="owner_country" class="span3">';
                                        $i=0;
                                        for($i==0;$i<=count($country)-1;$i++){
                                            if($country[$i] == $_POST['owner_country'])
                                                echo "<option value='".$_POST['owner_country']."' selected>".$_POST['owner_country']."</option>";
                                            else
                                                echo "<option value='".$country[$i]."'>".$country[$i]."</option>";
                                        }
                                        echo '</select>';
                                        //echo $msg[2];
                                     ?>
                                    </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_PT']; ?></td>
                                <td class="error" align="left">
                                     <?php
                                        $pt = array("Alberta","British Columbia","Saskatchewan","Manitoba","Ontario","Quebec","New Brunswick","Newfoundland","Labrador","Nova Scotia","Prince Edward Island");
                                        echo '<select name="owner_pt" class="span3">';
                                        $i=0;
                                        for($i==0;$i<=count($pt)-1;$i++){
                                            if($pt[$i] == $_POST['owner_pt'])
                                                echo "<option value='".$_POST['owner_pt']."' selected>".$_POST['owner_pt']."</option>";
                                            else
                                                echo "<option value='".$pt[$i]."'>".$pt[$i]."</option>";
                                        }
                                        echo '</select>';
                                        //echo $msg[2];
                                     ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_CITY']; ?></td>
                                <td class="error" align="left">
                                    <input type="text" name="owner_city" class="span3" value="<?php echo $_POST['owner_city'];?>" size="40">
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_STREET']; ?></td>
                                <td class="error" align="left">
                                    <input type="text" name="owner_street" class="span3" value="<?php echo $_POST['owner_street'];?>" size="40">
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_SUITE']; ?></td>
                                <td class="error" align="left">
                                    <input type="text" name="owner_suite_no" class="span3" value="<?php echo $_POST['owner_suite_no'];?>" size="40">
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><?php echo $merchant_registration['LBL_POSTAL']; ?></td>
                                <td class="error" align="left">
                                    <input type="text" name="owner_postal_code" class="span3" value="<?php echo $_POST['owner_postal_code'];?>" size="40">
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">&nbsp;</td>
                                <td class="main_txt" align="left">&nbsp;</td>
                            </tr>
                             <tr>
                                <td class="main_txt" align="right">Work phone</td>
                                <td class="error" align="left">
                                    <input type="text" name="owner_work_phone" class="span3" value="<?php echo $_POST['owner_work_phone'];?>" size="20">
                                    &nbsp;<span class="main_txt">Ext</span> <input type="text" name="owner_work_phone_ext" class="span3" value="<?php echo $_POST['owner_work_phone_ext'];?>" size="5">                                              
                                </td>
                            </tr>
                             <tr>
                                <td class="main_txt" align="right">Home phone</td>
                                <td class="error" align="left">
                                    <input type="text" name="owner_home_phone" class="span3" value="<?php echo $_POST['owner_home_phone'];?>" size="40">
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Mobile</td>
                                <td class="error" align="left">
                                    <input type="text" name="owner_mobile" class="span3" value="<?php echo $_POST['owner_mobile'];?>" size="40">
                                </td>
                            </tr>
                             <tr>
                                <td class="main_txt" align="right">Occupation</td>
                                <td class="main_txt_bold" align="left">
                                    <?php
                                        //echo dropdown control
                                        $sql_select_str = "SELECT id,name FROM $tbl_categories WHERE category_type = 'Occupation' ";
                                        $sql_locations = $db_conn->query($sql_select_str);
                                        if(@ $sql_locations->rowCount() > 0){
                                            echo "<select id='occupation_id' name='occupation_id' class='forms'>";
                                            echo "<option value=''>Select ..</option>";
                                            for($s=0;$s<$sql_locations->rowCount();$s++){
                                                $sql_array = $sql_locations->fetch();
                                                if(!$category_id) $category_id=$sql_array["id"];													
                                                if($_POST['occupation_id'] == $sql_array["id"] || $_GET['occupation_id'] == $sql_array["id"]) echo "<option value='".$sql_array["id"]."' selected>".$sql_array["name"]."</option>";
                                                else echo "<option value='".$sql_array["id"]."'>".$sql_array["name"]."</option>";
                                            }
                                            echo "</select>";
                                        }else echo "No categories defined";
                                    ?>
                                </td>
                            </tr>
                             <tr>
                                <td class="main_txt" align="right">Date of birth</td>
                                <td class="main_txt_bold" align="left">
                                    <?php
                                      echo("<select name='day' class='forms'>");
                                      echo("<option value=''>DD</option>");
                                      for($i=1;$i<=31;$i++){
                                           if($_POST['day'] == $i) echo "<option selected>$i</option>";
                                           else	echo "<option>$i</option>";
                                      }
                                      echo "</select> / ";
                                      
                                      echo "<select name='month' class='forms'>";									  
                                      echo "<option value=''>MM</option>";
                                      for($i=1;$i<=12;$i++){
                                           $index = $i - 1;
                                           if($_POST['month'] == $i) echo "<option value='$i' selected>$month_array[$index]</option>";
                                           else echo "<option value='$i'>$month_array[$index]</option>";
                                      }
                                      echo "</select> / ";
                                      
                                      $current_year = (int)date("Y");
                                      echo "<select name='year' class='forms'>";
                                      echo "<option value=''>YYYY</option>";
                                      for($i=$current_year;$i>=1900;$i--){
                                           if($_POST['year'] == $i) echo "<option selected>$i</option>";
                                           else echo "<option>$i</option>";
                                      }
                                      echo "</select>";
                                      echo '&nbsp;&nbsp;&nbsp;&nbsp;(DD/MM/YYYY)';
                                      echo "<span class='error'>".$msg[14]."</span>";
                                ?>
                                </td>
                            </tr>
                            <tr>
                              <td class="main_txt" align="right">&nbsp;</td>
                              <td class="main_txt" align="left">
                                <input type="submit" name="Submit" value="Submit" class="span3" />
                                <?php echo $main_msg; ?>
                              </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right" colspan="2">&nbsp;</td>
                            </tr>
                         </table>   
                        </form>
                        <?php } ?>
                        
                         <?php if($mod=="stats"){?>
                        	<table cellpadding="6" cellspacing="0" width="100%">
                                <tr>
                                    <td width="100%" class="main_txt">
                                        <?php echo "<strong>Showing account statistics"; ?>
                                    </td>
                                </tr>
                            </table>
                            <table width="100%" cellpadding="4" cellspacing="1">						
                                <tr class="main_txt_bold" bgcolor="#CCCCCC">
                                    <td width="50%">Order information</td>
                                    <td width="50%">RV Earnings Summary</td>
                                </tr>
                            </table>
                            <table width="100%" cellpadding="4" cellspacing="1" style="border-bottom:1px solid #CCCCCC">						
                                <tr class="main_txt">
                                    <td width="50%">
                                    	<table width="100%" cellpadding="2" cellspacing="1">
                                        	<tr>
                                                <td colspan="2" class="main_txt_bold">&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt_bold" width="60%">Orders received today</td>
                                                <td class="main_txt">&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Arts events</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "arts_events";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND date_added LIKE '%".date("Y-m-d")."%' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND date_added LIKE '%".date("Y-m-d")."%' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Sports events</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "sports_events";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND date_added LIKE '%".date("Y-m-d")."%' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND date_added LIKE '%".date("Y-m-d")."%' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Hotels</td>
                                                <td class="main_txt">&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Accomodation</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "hotels";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='' AND date_added LIKE '%".date("Y-m-d")."%' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='' AND date_added LIKE '%".date("Y-m-d")."%' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Facility</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "hotels";
														$sub = "facility";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='$sub' AND date_added LIKE '%".date("Y-m-d")."%' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='$sub' AND date_added LIKE '%".date("Y-m-d")."%' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Menu</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "hotels";
														$sub = "menu";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='$sub' AND date_added LIKE '%".date("Y-m-d")."%' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='$sub' AND date_added LIKE '%".date("Y-m-d")."%' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Vehicles</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "transport";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND date_added LIKE '%".date("Y-m-d")."%' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND date_added LIKE '%".date("Y-m-d")."%' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Local attractions</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "attractions";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND date_added LIKE '%".date("Y-m-d")."%' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND date_added LIKE '%".date("Y-m-d")."%' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" class="main_txt_bold">&nbsp;</td>
                                            </tr>
                                            
                                            
                                            
                                            <tr>
                                                <td class="main_txt_bold" width="60%">Orders received</td>
                                                <td class="main_txt">&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Arts events</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "arts_events";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Sports events</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "sports_events";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Hotels</td>
                                                <td class="main_txt">&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Accomodation</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "hotels";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Facility</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "hotels";
														$sub = "facility";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='$sub' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='$sub' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Menu</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "hotels";
														$sub = "menu";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='$sub' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND sub_type='$sub' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Vehicles</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "transport";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt" width="60%">&nbsp;&nbsp;&nbsp;&nbsp; Local attractions</td>
                                                <td class="main_txt">
                                                	<?php
														$type = "attractions";
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_orders = $db_conn->query($sql_load_orders);
														$sql_load_orders = "SELECT * FROM $tbl_orders_sub WHERE type='$type' AND status = 'Pending' AND mod_id IN (SELECT id FROM $tbl_events WHERE company_id = ".$_SESSION['userid']." )";;
                                                    	$sql_p_orders = $db_conn->query($sql_load_orders);
														echo $sql_orders->rowCount()."&nbsp;(".$sql_p_orders->rowCount().")";
													?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" class="main_txt_bold">&nbsp;</td>
                                            </tr>
                                            
                                        </table>
                                    </td>
                                    <td width="50%" valign="top">
                                    	<table width="100%" cellpadding="2" cellspacing="1">
                                        	<tr>
                                                <td colspan="2" class="main_txt_bold">&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt_bold" width="60%">Revenue generated (CAD)</td>
                                                <td class="main_txt">-</td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt_bold" width="60%">Revenue available (CAD)</td>
                                                <td class="main_txt"><?php echo $acc_bal?></td>
                                            </tr>
                                            <tr>
                                                <td class="main_txt_bold">Commisions</td>
                                                <td class="main_txt">-</td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" class="main_txt_bold">&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" class="main_txt">** Note: For orders alongside, value in brackets() represents number of orders pending.</td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" class="main_txt_bold">&nbsp;</td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                         <?php } ?>
                         
                         <?php if($mod=="ach"){?>
                         <form name="acc" action="<?php echo $_SERVER['PHP_SELF'].$form_get; ?>" method="post" enctype="multipart/form-data" >
                         <table width="100%" cellpadding="4" cellspacing="0">
                            <tr class="main_txt">
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">&nbsp;</td>
                                <td class="main_txt_bold" align="left">ACH Address Information</td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right" width="35%">First name</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="first_name" class="span3" value="<?php echo $_POST['first_name'];?>" size="40">
                                    <?php echo $msg[0]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Surname</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="surname" class="span3" value="<?php echo $_POST['surname'];?>" size="40">
                                    <?php echo $msg[1]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Address</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="address" class="span3" value="<?php echo $_POST['address'];?>" size="40">
                                    <?php echo $msg[2]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Alternate address</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="alt_address" class="span3" value="<?php echo $_POST['alt_address'];?>" size="40">
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">City</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="city" class="span3" value="<?php echo $_POST['city'];?>" size="40">
                                    <?php echo $msg[3]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">State</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="state" class="span3" value="<?php echo $_POST['state'];?>" size="40">
                                    <?php echo $msg[4]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Postal code</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="postal_code" class="span3" value="<?php echo $_POST['postal_code'];?>" size="40">
                                    <?php echo $msg[5]; ?>
                                </td>
                            </tr>
                            <tr class="main_txt">
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">&nbsp;</td>
                                <td class="main_txt_bold" align="left">ACH Account Information</td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Amount (CAD)</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="amount" class="span3" value="<?php echo $_POST['amount'];?>" size="40">
                                    <?php echo $msg[6]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right"><strong>Available balance (CAD)</strong></td>
                                <td class="errors" align="left">
                                    <input type="text" id="" readonly name="acc_bal" class="span3" value="<?php echo $_POST['acc_bal'];?>" size="40">
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Routing no.</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="routing_no" class="span3" value="<?php echo $_POST['routing_no'];?>" size="40">
                                    <?php echo $msg[7]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Account no.</td>
                                <td class="errors" align="left">
                                    <input type="text" id="" name="acc_no" class="span3" value="<?php echo $_POST['acc_no'];?>" size="40">
                                    <?php echo $msg[8]; ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Check no.</td>
                                <td class="errors" align="left">
                                    <input type="text" readonly="readonly" id="" name="check_no" class="span3" value="<?php echo $_POST['check_no'];?>" size="40">
                                </td>
                            </tr>
                            <tr>
                                <td class="main_txt" align="right">Account type</td>
                                <td class="errors" align="left">
                                    <?php
                                        $acc_type = array("select..","Current","Savings");
                                        echo '<select name="acc_type" class="span3">';
                                        $i=0;
                                        for($i==0;$i<=count($acc_type)-1;$i++){
                                            if($acc_type[$i] == $_POST['acc_type'])
                                                echo "<option value='".$_POST['acc_type']."' selected>".$_POST['acc_type']."</option>";
                                            else
                                                echo "<option value='".$acc_type[$i]."'>".$acc_type[$i]."</option>";
                                        }
                                        echo '</select>';
										echo $msg[9];
                                     ?>
                                </td>
                            </tr>
                            <tr class="main_txt">
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr>
                              <td class="main_txt" align="right">&nbsp;</td>
                              <td class="main_txt" align="left">
                                <input type="submit" name="Submit" value="Submit" class="span3" />
                                <?php echo $update_msg; ?>
                              </td>
                            </tr>
                            <tr class="main_txt">
                                <td colspan="2">&nbsp;</td>
                            </tr>
                            <tr class="main_txt">
                                <td colspan="2">&nbsp;</td>
                            </tr>
                         </table>
                         </form>	
                         <?php } ?>
                         
                        <?php if($mod == "ach_history" && !$_GET['view']){?>
                        <form name="order_grid" action="<?php echo $_SERVER['PHP_SELF'].$form_get; ?>" method="post">
                        <table cellpadding="6" cellspacing="0" width="100%">
                            <tr>
                                <td width="80%" class="main_txt">
                                    Action
                                    <select name="Action_" class="span3">
                                        <option>---------------</option>
                                    </select>
                                    <input type="submit" name="Action" value="Submit" class="span3" />
                                    &nbsp;&nbsp;&nbsp;&nbsp; Page # 
                                    <?php if($_GET['page']) $page_no = $_GET['page']; else $page_no = 1; echo $page_no;?>
                                    &nbsp;&nbsp;&nbsp;&nbsp;<?php //echo "( Showing details for order # ".$_GET['id'].". * <a href='".base64_decode($_GET['rtn'])."' class='top_nav_links' title='Return to orders.'> Back to orders.</a>)"; ?>
                                </td>
                                <td width="20%" class="main_txt" align="right">&nbsp;</td>
                            </tr>
                        </table>
                        <table width="100%" cellpadding="4" cellspacing="1">						
                            <tr class="main_txt_bold" bgcolor="#CCCCCC" align="center">
                                <td width="5%">&nbsp;</td>
                                <td width="15%">Name</td>
                                <td width="20%">Address</td>
                                <td width="15%">Routing no.</td>
                                <td width="15%">Account no.</td>
                                <td width="15%">Amount</td>
                                <td width="15%">ACH Status</td>
                            </tr>
                         </table>
                         <?php
                            
                            $sql_load_ach = "SELECT * FROM $tbl_ach_cr WHERE rv_acc_type='Merchant' AND rv_acc_id=".$_SESSION['userid'];
                            //echo $sql_load_orders;
							$sql_ach = $db_conn->query($sql_load_ach);
                            
                            //$sql_orders = $db_conn->query($sql_load_orders);
                            //page scroller functions
                            //calculate ffwd var for scroller - forwards through pages based on current page location pointer
                            $pages_per_set_ = 10;
                            $pages_per_set_ = 10;
                            $records_per_page = 10;
                            $page = strip_tags($_GET['page']);								
                            $pages = ceil($sql_ach->rowCount()/$records_per_page);

                            //cater for single page
                            if($pages == 1 && $sql_ach->rowCount() < $pages_per_set_){
                                $scroll = $sql_ach->rowCount();
                            }else $scroll = $pages_per_set_;
                            //cater for mid pages
                            if($page < $pages && $pages > 1){
                                $scroll = $records_per_page;
                                $ffd = (($page - 1) * $pages_per_set_);
                            }
                            //cater for last page
                            if($page == $pages && $pages > 1){
                                $scroll = $sql_ach->rowCount() - (($pages - 1) * $pages_per_set_);
                                $ffd = (($pages - 1) * $pages_per_set_);
                            }
                            //cater for no data
                            if($sql_ach->rowCount() == 0) $scroll = 0;
                            if($ffd > 0) for($i=0;$i<$ffd;$i++) $ach_array = $sql_ach->fetch();
                            
                            if($sql_ach->rowCount() > 0){
                                
                                for($l=0;$l<$scroll;$l++){
                                    $ach_array = $sql_ach->fetch();
                                    //$url = base64_encode(basename($_SERVER['PHP_SELF']).$form_get);
                                    //create link to order detailed view
                                    $address = $ach_array['address'];
									if($ach_array['alt_address']) $address .= "<br />".$ach_array['alt_address'];
									if($ach_array['city']) $address .= "<br />".$ach_array['city'];
									if($ach_array['postal_code']) $address .= "<br />".$ach_array['postal_code'];
									echo "<table cellpadding='4' cellspacing='1' width='100%' style='border-bottom: 1px solid #CCCCCC'>
                                            <tr class='main_txt'>
                                                <td width='5%'><input type='checkbox' name='ids[]' class='forms' value='".$ach_array['session_id']."' /></td>
                                                <td align='center' width='15%'>".$ach_array['first_name']." ".$ach_array['surname']."</td>
                                                <td align='center' width='20%'>".$address."</td>
                                                <td align='center' width='15%'>".$ach_array['routing_no']."</td>
                                                <td align='center' width='15%'>".$ach_array['routing_no']."</td>
                                                <td align='center' width='15%'>".number_format($ach_array['amount'],2,".",",")."</td>
                                                <td width='15%' align='center'>".$ach_array['ach_status']."</td>
                                            </tr>
                                        </table>";
                                }
                                
                            }else{
                                echo "<table cellpadding='6' cellspacing='0' width='100%'>
                                        <tr><td width='100%' class='errors' align='center' >ACH information not available!</td></tr>
                                    </table>";
                            }
                            
                        ?>
                        </form>
                        <table cellpadding="2" cellspacing="4"  align="center">
                            <tr>
                                <td height="20" align="center"><?php skroller($pages,$pages_per_set_); ?></td>
                            </tr>
                        </table> 
                        <?php } ?>
					</td>
				</tr>
		  </table>
		  
		</td>
	</tr>
	<tr><td colspan="3">&nbsp;</td>
</table>

<!--Base banner-->
<table width="100%" cellpadding="0" cellspacing="0" class="tbl_banner_base">
	<tr>
    	<td class="base_txt" align="center"><br />A Clay-Mark Solution<br /><br /></td>
    </tr>
</table>
</body>
</html>