  <?php
	/*
		This page contains verification interactions for merchant accounts
		The credit card interaction initially verifies the entered credit card information
		The document verification module allows for the upload of business documents for verification 
	*/
	session_start();
	error_reporting(0);
	if($_SESSION['session_type'] != "merchant"){
		header("Location: login.php");
	}
	
	include_once "../../inc/libfns.php";
	include_once "../../inc/vars.php";
	//require_once "../../inc/moneris/mpgClasses.php";
	//Connect to DB
	db_connect(HOST,USER,PASSWORD,DB);
	
	//include localization arrays for form data
	include_once("../../localization/en/lang-en.php");
	
	//handle get GET vars, enable form submit persistence for GET variables
	if($_GET['mod']){
		$mod = strip_tags($_GET['mod']);
		$form_get = "?mod=$mod";
	}
	if($_GET['sub']){
		$sub = strip_tags($_GET['sub']);
		$form_get .= "&sub=$sub";
	}
	if($_GET['action']){
		$action = strip_tags($_GET['action']);
		$form_get .= "&action=$action";
	}
	if($_GET['mode']){
		$mode = strip_tags($_GET['mode']);
		$form_get .= "&mode=$mode";
	}
	if($_GET['mod_select']){
		$mod_select = strip_tags($_GET['mod_select']);
		$form_get .= "&mod_select=$mod_select";
	}
	if($_GET['id']){
		$id = strip_tags($_GET['id']);
		$form_get .= "&id=$id";
	}
	if($_GET['edit_id']){
		$edit_id = strip_tags($_GET['edit_id']);
		$form_get .= "&edit_id=$edit_id";
	}
	
	//include library of primary merchant functions
	include_once "inc/libmain.php";
	include_once "inc/libsub.php";
				
	
	if($_POST['Submit'] == "Submit" && $mod != "ach"){
		validate_merchant();
		if($errors == 0){
			$timestamp = strtotime($_POST['owner_dob']);
			$date = date('Y-m-d', $timestamp);
			//echo "string".$date;
			$sql_update = "UPDATE $tbl_merchants_ SET business_type='".$_POST['business_type']."',business_name='".$_POST['business_name']."'
							   ,business_address='".$_POST['address']."',business_alt_address='".$_POST['alt_address']."',business_country='".$_POST['country']."',business_pt='".$_POST['pt']."',business_city='".$_POST['city']."',business_street='".$_POST['street']."'
							   ,business_suite_no='".$_POST['suite_no']."',business_postal_code='".$_POST['postal_code']."',cs_email='".$_POST['cs_email']."',cs_phone='".$_POST['cs_phone']."',owner_salutation='".$_POST['salutation']."',owner_name='".$_POST['name']."'
							   ,country_of_citizenship='".$_POST['country_of_citizenship']."',owner_address='".$_POST['owner_address']."'
							   ,owner_country='".$_POST['owner_country']."',owner_pt='".$_POST['owner_pt']."',owner_city='".$_POST['owner_city']."',owner_street='".$_POST['street']."',owner_suite_no='".$_POST['owner_suite_no']."'
							   ,owner_postal_code='".$_POST['owner_postal_code']."',owner_work_phone='".$_POST['owner_work_phone']."'
							   ,owner_work_phone_ext='".$_POST['owner_work_phone_ext']."',owner_home_phone='".$_POST['owner_home_phone']."'
							   ,owner_mobile='".$_POST['owner_mobile']."',owner_dob='".$date."' WHERE id=".$_SESSION['userid'];
			//echo $sql_update;
			$db_conn->query($sql_update);
		}
	}
	
	//Perform data binding operation to the current form
	if($_SESSION['userid'] && $mod != "ach"){
		$sql_select = "SELECT * FROM $tbl_merchants_ WHERE id = ".$_SESSION['userid'];
		$sql_data = $db_conn->query($sql_select);
		if($sql_data->rowCount() > 0) $sql_array = $sql_data->fetch();
		$_POST['business_type'] = $sql_array['business_type'];$_POST['address'] = $sql_array['business_address'];
		$_POST['business_name'] = $sql_array['business_name'];$_POST['alt_address'] = $sql_array['business_alt_address'];
		$_POST['country'] = $sql_array['business_country'];$_POST['pt'] = $sql_array['business_pt'];
		$_POST['city'] = $sql_array['business_city'];$_POST['street'] = $sql_array['business_street'];
		$_POST['suite_no'] = $sql_array['business_suite_no'];$_POST['postal_code'] = $sql_array['business_postal_code'];
		$_POST['cs_email'] = $sql_array['cs_email'];$_POST['cs_phone'] = $sql_array['cs_phone'];
		$_POST['owner_address'] = $sql_array['owner_address'];
		$_POST['owner_city'] = $sql_array['owner_city'];$_POST['owner_street'] = $sql_array['owner_street'];
		$_POST['owner_suite_no'] = $sql_array['owner_suite_no'];$_POST['owner_postal_code'] = $sql_array['owner_postal_code'];
		$_POST['salutation'] = $sql_array['owner_salutation'];$_POST['name'] = $sql_array['owner_name'];
		$_POST['country_of_citizenship'] = $sql_array['country_of_citizenship'];$_POST['owner_country'] = $sql_array['owner_country'];
		$_POST['owner_work_phone'] = $sql_array['owner_work_phone'];$_POST['owner_work_phone_ext'] = $sql_array['owner_work_phone_ext'];
		$_POST['owner_home_phone'] = $sql_array['owner_home_phone'];$_POST['owner_mobile'] = $sql_array['owner_mobile'];
		$_POST['owner_occupation'] = $sql_array['owner_occupation'];
		$_POST['owner_dob'] =$sql_array['owner_dob'];
		$dob = explode("-",$sql_array['owner_dob']);
		$_POST['day'] = $dob[2];$_POST['year'] = $dob[0];
		$_POST['month'] = $dob[1];
	}
	
	//Check account balance for ACH Credit option
	if($mod == "ach" || $mod == "stats"){
		$sql_acc_bal = "SELECT account_balance FROM $tbl_merchants_ WHERE id =".$_SESSION['userid'];
		$sql_acc_bal = $db_conn->query($sql_acc_bal);
		if($sql_acc_bal->rowCount() > 0) $array_acc_bal = $sql_acc_bal->fetch();
		$acc_bal = number_format($array_acc_bal[0],2,".",",");
		$_POST['acc_bal'] = $acc_bal;
		$_POST['check_no'] = mt_rand();
		//Confirm account balance by checking for evidence of prior activity
		
	}
	
	if($_POST['Submit'] == "Submit" && $mod == "ach"){
		$ach_validate = new merchant_info_validation();
		$ach_validate->validate_ach_credit();
		if($errors == 0){
			//Attempt ACH Credit and commit details to DB if successful
			/************************ Transaction Variables ******************************/
			$orderid='ach-'.date("dmy-G:i:s");
			$custid = 'RV-'.$_SESSION[''];
			/************************ Transaction Array **********************************/
			$txnArray=array(type=>'us_ach_credit',
							order_id=>$orderid,
							cust_id=>$custid,
							amount=>$_POST['amount']
							);
			/************************** ACH Info Variables *****************************/
			$sec = $sec_code[0];			
			/********************** ACH Info Associative Array *************************/
			
			$achTemplate = array(
								 sec =>$sec,
								 cust_first_name => $_POST['first_name'],
								 cust_last_name => $_POST['surname'],
								 cust_address1 => $_POST['address'],
								 cust_address2 => $_POST['alt_address'],
								 cust_city => $_POST['city'],
								 cust_state => $_POST['state'],
								 cust_zip => $_POST['postal_code'],
								 routing_num => $_POST['routing_num'],
								 account_num => $_POST['acc_no'],
								 check_num => $_POST['check_no'],
								 account_type => $_POST['acc_type']
								);
			
			/************************** ACH Info Object ********************************/
			$mpgAchInfo = new mpgAchInfo ($achTemplate);
			/************************ Transaction Object *******************************/
			$mpgTxn = new mpgTransaction($txnArray);
			/************************ Set ACH Info *************************************/
			$mpgTxn->setAchInfo($mpgAchInfo);
			/************************ Request Object **********************************/
			$mpgRequest = new mpgRequest($mpgTxn);
			/************************ mpgHttpsPost Object ******************************/
			$mpgHttpPost = new mpgHttpsPost($store_id,$api_token,$mpgRequest);
			/************************ Response Object **********************************/
			$mpgResponse=$mpgHttpPost->getMpgResponse();
			//Format response object for storage
			$ach_response = $mpgResponse->getCardType()."||".$mpgResponse->getTransAmount()."||".$mpgResponse->getTxnNumber()."||".
							$mpgResponse->getReceiptId()."||".$mpgResponse->getTransType()."||".$mpgResponse->getReferenceNum()."||".
							$mpgResponse->getResponseCode()."||".$mpgResponse->getMessage()."||".$mpgResponse->getAuthCode()."||".
							$mpgResponse->getComplete()."||".$mpgResponse->getTransDate()."||".$mpgResponse->getTransTime()."||".
							$mpgResponse->getTicket()."||".$mpgResponse->getTimedOut();
			//echo $ach_response;
			if($mpgResponse->getMessage() == "Global Error Receipt"){
				//Store ACH response for future reference
				$sql_store_ach = "INSERT INTO $tbl_ach_cr(first_name,surname,address,alt_address,city,state,postal_code,
								  routing_no,acc_no,check_no,acc_type,ach_response,rv_acc_type,rv_acc_id,ach_status,amount,order_id,date_added) 
								  VALUES('".$_POST['first_name']."','".$_POST['surname']."','".$_POST['address']."','".$_POST['alt_address']."'
								  ,'".$_POST['city']."','".$_POST['state']."','".$_POST['postal_code']."','".$_POST['routing_no']."','".$_POST['acc_no']."'
								  ,'".$_POST['check_no']."','".$_POST['acc_type']."','$ach_response','Merchant',".$_SESSION['userid'].",'Failed'
								  ,".$_POST['amount'].",'$order_id','".date("Y-m-d H:i:s")."')";
				
				$sql_ach = $db_conn->query($sql_store_ach);
			}else{
				
				$sql_store_ach = "INSERT INTO $tbl_ach_cr(first_name,surname,address,alt_address,city,state,postal_code,
								  routing_no,acc_no,check_no,acc_type,ach_response,rv_acc_type,rv_acc_id,ach_status,amount,order_id,date_added) 
								  VALUES('".$_POST['first_name']."','".$_POST['surname']."','".$_POST['address']."','".$_POST['alt_address']."'
								  ,'".$_POST['city']."','".$_POST['state']."','".$_POST['postal_code']."','".$_POST['routing_no']."','".$_POST['acc_no']."'
								  ,'".$_POST['check_no']."','".$_POST['acc_type']."','$ach_response','Merchant',".$_SESSION['userid']."
								  ,'Successful',".$_POST['amount'].",'$order_id','".date("Y-m-d H:i:s")."')";
				$sql_ach = $db_conn->query($sql_store_ach);
				
				$sql_update_bal = "UPDATE $tbl_merchants_ SET account_balance=account_balance-".$_POST['amount'];
				//echo $sql_update_bal;
				$db_conn->query($sql_update_bal);
			}
			if(isset($sql_ach)$$ $sql_ach->rowCount() > 0){
				$update_msg = "&nbsp;&nbsp;&nbsp;&nbsp;Your transaction was posted.";
				$_POST = array();	
			}
		}
	}
	if($mod == "ach"){
		$sql_prev = "SELECT * FROM $tbl_ach_cr WHERE rv_acc_type='Merchant' AND rv_acc_id='".$_SESSION['userid']."' ORDER BY date_added DESC LIMIT 1";
		$sql_prev = $db_conn->query($sql_prev);
		if($sql_prev->rowCount() > 0){
			$array_prev = $sql_prev->fetch();
			$_POST['first_name'] = $array_prev['first_name'];
			$_POST['surname'] = $array_prev['surname'];
			$_POST['address'] = $array_prev['address'];
			$_POST['alt_address'] = $array_prev['alt_address'];
			$_POST['city'] = $array_prev['city'];
			$_POST['postal_code'] = $array_prev['postal_code'];
			$_POST['routing_no'] = $array_prev['routing_no'];
			$_POST['acc_no'] = $array_prev['acc_no'];
			$_POST['acc_type'] = $array_prev['acc_type'];
		}
	}
	
	
	
	
	require_once('header.php');
?>

<!-- Header End -->

<div id="maincontainer">
 <section id="product">
    <div class="container">
     <!--  breadcrumb --> 
      <ul class="breadcrumb">
        <li>
          <a href="#">Home</a>
          <span class="divider">/</span>
        </li>
        <li class="active">Register Account</li>
      </ul>
      <div class="row">  
      	<!-- Sidebar Start-->
        <aside class="span3">
          <div class="sidewidt">
            <h2 class="heading2"><span>My Account</span></h2>
            <ul class="nav nav-list categories">
         
           <li>
                  
					<li><a href="account.php?mod=acc&action=add">Details</a></li>
					<li><a href="account.php?mod=stats&action=view">Stats</a></li>
					<li><a href="account.php?mod=ach&action=view">Ach Credit</a></li>
						<ul class="">
							<li><a href="account.php?mod=ach_history&action=view">Ach History</a></li>
						 </ul>
                </li>
         
         
         
         
            </ul>
          </div>
        </aside>
        <!-- Sidebar End-->
      <div class="row">        
        <!-- Account Login-->
        <div class="span9">
          <h1 class="heading1"><span class="maintext">Merchant Administration</span><span class="subtext">
             <?php 
							//resolve and display form  titles
							if($mod == "stats") echo " :: ACCOUNT STATISTICS";
							if($mod == "docs" && $action == "show") echo " :: BUSINESS DOCUMENT VERIFICATION";
							
						?>
          	
          	</span></h1>
          	<?php if(!$mod){?>
                  <img src="../../img/logo_large.jpg" />
                        <?php } ?>
          	<!-- start of add account--> 
            <?php 
               if($mod == "acc" && ($action == "add" || $action == "edit" || $action == "")){
              
          		require_once("account/accountdetails.php");
             	}
				else if($mod=="stats" && $action == "view"){
					
				require_once("account/viewstats.php");
				}
				else if($mod == "ach" && ($action == "create" || $action == "edit" || $action == "view")){
					
				require_once("account/achcredit.php");
			    }
			   
				else if($mod == "ach_history" && ($action == "create" || $action == "edit" || $action == "view")){
				require_once("account/ach_history.php");
					// echo "included";
			    }
			 ?>
            
               
            
         
          
        </div>        
        
      </div>
    </div>
  </section>
</div>
</div>
<!-- javascript
    ================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<?php
include ('footer.php');
?>
<script src="../../datepicker/js/bootstrap-datepicker.js"></script>
<script src="../../datepicker/js/datepicker.js"></script>
</body>
</html>