<?php
/* 
 * This class Encapsulates functions which relate with pogo.pro task payment.
 */
//include_once ("../v2/inc/vars.php");
include_once("$_SERVER[DOCUMENT_ROOT]/v2/inc/vars.php");
include_once("pogoproQuoteFunctionManager.php");
include_once("pogoproHelperClass.php");
class pogoproTaskPaymentManager
{
 private $db_conn;
 private $domain_name;
 function __construct($conn=null){ //set db connection in constructor
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection();
		$this->db_conn = $dbconnect_obj->conn;
	}
	$pogoproHelperClass = new pogoproHelperClass();
	$this->domain_name = $pogoproHelperClass -> domain_name;
 }
 function getAttributesOfCompletedTask($construction_task_id) 
 {
 $measurementUnitFullNamesForPer = array(
     "EA"=>"each",
     "SF"=>"square feet",
     "LF"=>"linear feet",
     "DY"=>"day",
     "HR"=>"hour",
     "CI"=>"cubic inch",
     "CY"=>"cubic yard",
     "WK"=>"week",
     "SQ"=>"100 square feet",
     "BF"=>"board foot",
     "SI"=>"square inch",
     "CF"=>"cubic foot",
     "TN"=>"ton",
     "MI"=>"mile",
     "ST"=>"step");
 
   if ($construction_task_id>0)
   {
    $String_SQL = "Select * 
                   From pogopro_project_bid_contruction_tasks a, 
                     pogopro_construction_task_definition b
                   Where a.construction_task_definition_id = b.pogopro_construction_task_id  
                      AND a.task_status =2 
                      AND construction_task_id = ? Order by construction_task_id";
					  $param=[$construction_task_id];
   }else
   {   
    $String_SQL = "Select * 
                   From pogopro_project_change_tasks a, 
                     pogopro_construction_task_definition b
                   Where a.construction_task_definition_id = b.pogopro_construction_task_id 
                      AND a.task_status =2 
                      AND construction_task_id = ? Order by construction_task_id";  
			$param=[$construction_task_id*(-1)];					  
   }
    $status=$this->db_conn->prepare($String_SQL);
	$status->execute($param);
   if (!$status)
   {
    echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;
   }else
   {   
   $construction_task_definition_id = 0; 
   
   while ($row = $status->fetch())
   {
       $construction_task_definition_id = $row['construction_task_definition_id'];
       $owner_supply_material = $row['owner_supply_material'];
       $measureUnit = $row['task_measurement_unit'];
       $task_start_date = $row['task_start_date'];
       $task_end_date = $row['task_end_date'];
       $construction_task_name = $row['construction_task_name'];
       
       $task_cost_material = 0.00;
       $task_cost_labor = 0.00;
       $task_quantity = 0.00;
       $task_material_unit_cost = $row['material_unit_cost'];
       $task_labor_unit_cost = $row['labor_unit_cost'];
       if ($construction_task_id<0)
       {
        $task_material_unit_cost = $row['reference_material_unit_cost'];
        $task_labor_unit_cost = $row['reference_labor_unit_cost'];           
       }
       $task_size_length = $row['construction_task_measure_length'];
       $task_size_width = $row['construction_task_measure_width'];
       $task_size_height = $row['construction_task_measure_height'];
       
       if ($measureUnit=='SF'||$measureUnit=='SI')
       {
        $measure_area = $row['construction_task_measure_length']*$row['construction_task_measure_width'];
        $task_quantity = $measure_area;
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_area *$row['material_unit_cost'];
         $task_cost_labor = $measure_area *$row['labor_unit_cost']; 
        }else
        {
         $task_cost_material = $measure_area *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_area *$row['reference_labor_unit_cost'];
        }
       }else if ($measureUnit=='SQ')
       {
        $measure_area = $row['construction_task_measure_length']*$row['construction_task_measure_width']/100.00;
        $task_quantity = $measure_area;
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_area *$row['material_unit_cost'];
         $task_cost_labor = $measure_area *$row['labor_unit_cost'];            
        }else
        {
         $task_cost_material = $measure_area *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_area *$row['reference_labor_unit_cost'];
        }         
       }else if ($measureUnit=='CI'||$measureUnit=='CY'||$measureUnit=='CF')
       {
        $measure_cubic = $row['construction_task_measure_length']*$row['construction_task_measure_width']*$row['construction_task_measure_height'];
        $task_quantity = $measure_cubic;
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_cubic *$row['material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['labor_unit_cost'];            
        }else
        {
         $task_cost_material = $measure_cubic *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['reference_labor_unit_cost'];
        }          
       }else if ($measureUnit=='BF')
       {
        $measure_cubic = $row['construction_task_measure_length']*$row['construction_task_measure_width']*$row['construction_task_measure_height']/144; //(1 BF = 12 inchx 12 inch x 1 inch)
        $task_quantity = $measure_cubic;
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_cubic *$row['material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['labor_unit_cost'];            
        }else
        {
         $task_cost_material = $measure_cubic *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['reference_labor_unit_cost'];
        }          
       }else
       {
        $measure_quantity = $row['construction_task_ea_quantity'];
        $task_quantity = $measure_quantity;
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_quantity *$row['material_unit_cost'];
         $task_cost_labor = $measure_quantity *$row['labor_unit_cost'];            
        }else
        {
         $task_cost_material = $measure_quantity *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_quantity *$row['reference_labor_unit_cost'];
        }           
       }

       $item_cost[0] += $task_cost_material;
       if ($owner_supply_material==1) $item_cost[0] = 0.00;
       $item_cost[1] += $task_cost_labor;
   }
   $attributesOfCompletedTask = array(
    "measureUnit"=>$measurementUnitFullNamesForPer[$measureUnit],
    "mearsureLength"=>$task_size_length,
    "mearsureWidth"=>$task_size_width,
    "mearsureHeight"=>$task_size_height,
    "mearsureQuantity"=>$task_quantity, 
    "ownerSupplyMaterial"=>$owner_supply_material,
    "materialUnitCost"=>$task_material_unit_cost,   
    "laborUnitCost"=>$task_labor_unit_cost,
    "task_start_date"=>$task_start_date,
    "task_end_date"=>$task_end_date,
    "task_name"=>$construction_task_name,   
    "total_cost"=>($item_cost[0]+$item_cost[1])   
   ); 

   return json_encode($attributesOfCompletedTask);       
   }
 }
 function getPaymentAmountOfConstructoionTask($construction_task_id)
 {
   if ($construction_task_id>0)
   {
    $String_SQL = "Select * 
                   From pogopro_project_bid_contruction_tasks a, 
                     pogopro_construction_task_definition b
                   Where a.construction_task_definition_id = b.pogopro_construction_task_id  
                      AND a.task_status =2 
                      AND construction_task_id = ? Order by construction_task_id";
					  $param=[$construction_task_id];
   }else
   {   
    $String_SQL = "Select * 
                   From pogopro_project_change_tasks a, 
                     pogopro_construction_task_definition b
                   Where a.construction_task_definition_id = b.pogopro_construction_task_id 
                      AND a.task_status =2 
                      AND construction_task_id = ? Order by construction_task_id";     
					  $param=[$construction_task_id*(-1)];					  
   }
 $status=$this->db_conn->prepare($String_SQL);
 $status->execute($param);
 $item_cost = array(0.00,0.00);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;
 }else
 {
   $construction_task_definition_id = 0; 
   while ($row = $status->fetch())
   {
       $construction_task_definition_id = $row['construction_task_definition_id'];
       $owner_supply_material = $row['owner_supply_material'];
       $measureUnit = $row['task_measurement_unit'];
       $task_cost_material = 0.00;
       $task_cost_labor = 0.00;
       
       if ($measureUnit=='SF'||$measureUnit=='SI')
       {
        $measure_area = $row['construction_task_measure_length']*$row['construction_task_measure_width'];
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_area *$row['material_unit_cost'];
         $task_cost_labor = $measure_area *$row['labor_unit_cost'];            
        }else
        {
         $task_cost_material = $measure_area *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_area *$row['reference_labor_unit_cost'];
        }
       }else if ($measureUnit=='SQ')
       {
        $measure_area = $row['construction_task_measure_length']*$row['construction_task_measure_width']/100.00;
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_area *$row['material_unit_cost'];
         $task_cost_labor = $measure_area *$row['labor_unit_cost'];            
        }else
        {
         $task_cost_material = $measure_area *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_area *$row['reference_labor_unit_cost'];
        }         
       }else if ($measureUnit=='CI'||$measureUnit=='CY'||$measureUnit=='CF')
       {
        $measure_cubic = $row['construction_task_measure_length']*$row['construction_task_measure_width']*$row['construction_task_measure_height'];
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_cubic *$row['material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['labor_unit_cost'];            
        }else
        {
         $task_cost_material = $measure_cubic *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['reference_labor_unit_cost'];
        }          
       }else if ($measureUnit=='BF')
       {
        $measure_cubic = $row['construction_task_measure_length']*$row['construction_task_measure_width']*$row['construction_task_measure_height']/144; //(1 BF = 12 inchx 12 inch x 1 inch)
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_cubic *$row['material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['labor_unit_cost'];            
        }else
        {
         $task_cost_material = $measure_cubic *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['reference_labor_unit_cost'];
        }          
       }else
       {
        $measure_quantity = $row['construction_task_ea_quantity'];
        if ($construction_task_id>0)
        {
         $task_cost_material = $measure_quantity *$row['material_unit_cost'];
         $task_cost_labor = $measure_quantity *$row['labor_unit_cost'];            
        }else
        {
         $task_cost_material = $measure_quantity *$row['reference_material_unit_cost'];
         $task_cost_labor = $measure_quantity *$row['reference_labor_unit_cost'];
        }           
       }

       $item_cost[0] += $task_cost_material;
       if ($owner_supply_material==1) $item_cost[0] = 0.00;
       $item_cost[1] += $task_cost_labor;
   }
   return array(($item_cost[0] + $item_cost[1]),$construction_task_definition_id);
 }     
 }
    
 function addTaskPaymentRequest(
         $project_id,
         $construction_task_id,
         $construction_task_definition_id,
         $payment_amount,
         $payment_request_datetime)
 {
  $String_SQL = "Insert into pogopro_task_payment_record(project_id,construction_task_id,construction_task_definition_id,payment_amount,payment_request_datetime) 
                 values(?,?,?,?,?)"; 
   $status=$this->db_conn->prepare($String_SQL);
   $status->execute([$project_id,$construction_task_id,$construction_task_definition_id,$payment_amount,$payment_request_datetime]);
  if (!$status)
     {
      echo "[addTaskPaymentRequest]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      $this->sendNotificationOfTaskCompleteToBuyerAndSeller($project_id,$construction_task_id);   
      return true;   
     }  
 }
 
 function sendNotificationOfTaskCompleteToBuyerAndSeller($project_id,
         $construction_task_id)
 {
   //Get project profile
   $projectProfileAndEmailsOfBuyerAndSeller = (new pogoproQuoteFunctionManager())->getProjectProfileAndEmailsOfBuyerAndSeller($project_id);   
   $completedTaskAttributes = json_decode($this->getAttributesOfCompletedTask($construction_task_id));
   echo $this->sendNotificationOfTaskComplete(
         $projectProfileAndEmailsOfBuyerAndSeller,
         $completedTaskAttributes,
         0);
   echo $this->sendNotificationOfTaskComplete(
         $projectProfileAndEmailsOfBuyerAndSeller,
         $completedTaskAttributes,
         1);   
 }
 private function sendNotificationOfTaskComplete(
         $projectProfileAndEmailsOfBuyerAndSeller,
         $completedTaskAttributes,
         $role)
 {
 $client_name = $projectProfileAndEmailsOfBuyerAndSeller['m_salutation']." ".$projectProfileAndEmailsOfBuyerAndSeller['m_name'];  
 $subject = "Task completion notification and funds will be released!"; 
 $email_subject = "Task completion notification and funds will be released!";
 $email_address = $projectProfileAndEmailsOfBuyerAndSeller['m_email'];
 if ($role==1) //Pro
 {
   //$subject = "Here is copy of contract for ".$client_name."'s project";   
   //$email_subject = "Copy of contract for ".$client_name."'s project";
   $email_address = $projectProfileAndEmailsOfBuyerAndSeller['p_email'];
   $client_name = $projectProfileAndEmailsOfBuyerAndSeller['p_salutation']." ".$projectProfileAndEmailsOfBuyerAndSeller['p_name'];     
 } 
 $email_subject = str_replace("'", "\'", $email_subject);
 $emailContentOfTaskDetails = $this->getEmailContentOfTaskDetails($completedTaskAttributes);
 $email_content = "<div>"
                ."<p style='margin-left:8px;'>".$client_name.":</p>"
                ."<p style='margin-left:8px;'>".$subject."</p>"
                ."<table>"
                ."<tr>"
                ."<td style='width:8%' valign='top'><a href='http://".$this->domain_name."'><img style='width:115px;height:40px' src='http://".$this->domain_name."/v2/img/logo2.png'></a></td>"
                ."<td style='width:92%'>"
                ."<p style='margin-left:8px;'>".$projectProfileAndEmailsOfBuyerAndSeller['project_title']."</p>"
                ."<p style='margin-left:8px;'>".$projectProfileAndEmailsOfBuyerAndSeller['project_desc']."</p>"
                ."<div style='margin-top:8px;'>"
                .$emailContentOfTaskDetails  
                ."</div>"         
                . "</td>"
                . "</tr>"
                . "<table>"
                . "</div>"
                . "<div style='margin-top:16px;'>"
                . "<p style='font-size:24px;color:#3c763d'>Thanks for using ".$this->domain_name." service.</p>"
                . "</div>";
  //return $email_content;
    $email_content = str_replace("'", "\'", $email_content);
   (new pogoproEmailPoolManager())->addEmailSendRequestIntoPool
    (
     POGOPROMailSENDER,
     $email_address,
     $email_subject,
     $email_content       
    ); 
 }
 
 private function getEmailContentOfTaskDetails($completedTaskAttributes)
 {
  $tt = $completedTaskAttributes->{'task_name'};   
  $emailContentOfTaskDetails = "<p style='background-color:#337ab7;color:white;font-size:18px;'>Task:".$completedTaskAttributes->{'task_name'}."</p>"
          ."<table style='width:100%;border:solid 2px #337ab7;'>"
          ."<tr style='background-color:#dff0d8;'>"
          ."<td>Start date:".$completedTaskAttributes->{'task_start_date'}."</td><td>End date:".$completedTaskAttributes->{'task_end_date'}."</td>"
          ."</tr>"
          ."<tr style='background-color:#dff0d8;'>"
          ."<td>Material unit cost:".$completedTaskAttributes->{'materialUnitCost'}."/ per ".$completedTaskAttributes->{'measureUnit'}."</td><td>Labor unit cost:".$completedTaskAttributes->{'laborUnitCost'}."/ per ".$completedTaskAttributes->{'measureUnit'}."</td>"
          ."</tr>" 
          ."<tr style='background-color:#dff0d8;'>"
          ."<td colspan='2'>Quantity:".$completedTaskAttributes->{'mearsureQuantity'}."</td>"
          ."</tr>" 
          ."<tr style='background-color:#dff0d8;'>";
  $material_cost = $completedTaskAttributes->{'materialUnitCost'}*$completedTaskAttributes->{'mearsureQuantity'};
  $owner_supply_material = "";
  if ($completedTaskAttributes->{'ownerSupplyMaterial'}==1)
  {
      $material_cost = 0.00;
      $owner_supply_material = "(<label style='color:red'>Buyer supplies material</label>)";
  }
  $labor_cost = $completedTaskAttributes->{'laborUnitCost'}*$completedTaskAttributes->{'mearsureQuantity'};
  $emailContentOfTaskDetails.="<td>Material cost:".number_format($material_cost,2).$owner_supply_material."</td><td>Labor cost:".number_format($labor_cost,2)."</td>"
          ."</tr>"  
          ."<tr style='background-color:#dff0d8;'>"
          ."<td colspan='2'>Total cost:".number_format($completedTaskAttributes->{'total_cost'},2)."</td>"
          ."</tr>"     
          ."</table>";
  return $emailContentOfTaskDetails;
 }
 
 function issuePogoproTaskPayment(
          $task_payment_record_id,
          $payment_cheque_no,
          $payment_issuer_id,
          $payment_issue_datetime
         )
 {
  $String_SQL = "Update pogopro_task_payment_record Set 
          payment_cheque_no = ? payment_issuer_id= ? payment_issue_datetime = ? Where  task_payment_record_id = ?";  
   $status=$this->db_conn->prepare($String_SQL);
   $status->execute([$payment_cheque_no,$payment_issuer_id,$payment_issue_datetime,$task_payment_record_id]);
  if (!$status)
     {
      echo "[issuePogoproTaskPayment]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      return true;   
     }
 }
 
 private function getPaymentInfoByProjectId($project_id)
 {
  $allTaskPaymentRequests = array();   
  $String_SQL = "Select a.task_payment_record_id,a.project_id,a.construction_task_id,
                        a.payment_amount,a.payment_request_datetime,
                        a.payment_issue_datetime,c.construction_task_name
                 From pogopro_task_payment_record a,
                      pogopro_construction_task_definition c
                 Where a.project_id = ?
                       AND a.construction_task_definition_id = c.pogopro_construction_task_id 
                 Order by a.task_payment_record_id";   
  $status=$this->db_conn->prepare($String_SQL);
  $status->execute([$project_id]);
  if (!$status)
     {
      echo "[getPaymentInfoByProjectId]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row=  $status->fetch())
      {
       $allTaskPaymentRequests[] = array(
        "task_payment_record_id"=>$row['task_payment_record_id'],   
        "project_id"=>$row['project_id'], 
        "construction_task_id"=>$row['construction_task_id'],
        "payment_amount"=>$row['payment_amount'], 
        "payment_request_datetime"=>$row['payment_request_datetime'], 
        "payment_issue_datetime"=>$row['payment_issue_datetime'],
        "construction_task_name"=>$row['construction_task_name']               
       );   
      }
     }
   return $allTaskPaymentRequests;   
 }
 
 function getContentOfProjectTaskPaymentManagement($project_id)
 {
   $contentOfProjectPaymentRequest = "<div class='alert alert-info'><strong>Note!</strong> There is no payment information. </div><div id='add_payment_request_zone_".$project_id."' style='display:none'></div>";  
   $allTaskPaymentRequests = $this->getPaymentInfoByProjectId($project_id); 
   $numOfTaskPaymentRequests = count($allTaskPaymentRequests);
   if ($numOfTaskPaymentRequests>0)
   {
    $contentOfProjectPaymentRequest = "<table border='0' class='table' style='width:100%'>"
      ."<thead>"
      ."<tr>"
      ."<th style='width:2%'></th>"      
      ."<th style='width:68%'>Task</th>"
      ."<th style='width:10%'>Amount</th>"
      ."<th style='width:8%'>Status</th>"
      ."<th style='width:12%'>Date</th>"
      ."</tr>"
      ."</thead>"
      ."<tbody>";

       $statusArray = array("Approved","Paid");

       for ($i=0;$i<$numOfTaskPaymentRequests;$i++)
       {
        if ($allTaskPaymentRequests[$i]['payment_issue_datetime']=='0')   
        {
            $Status = $statusArray[0];
            $submit_date = substr($allTaskPaymentRequests[$i]['payment_request_datetime'],0,11);
        }
        else
        {
            $Status = $statusArray[1];
            $submit_date = substr($allTaskPaymentRequests[$i]['payment_issue_datetime'],0,11);
        }
         
        $class = 'info';
        if ($i%2==0)
            $class = 'success';
        $contentOfProjectPaymentRequest .="<tr class='".$class."' id='project_payment_request_row_".$allTaskPaymentRequests[$i]['task_payment_record_id']."'>"
            ."<td><i title='View details of task payment.' id='id_task_payment_".$allTaskPaymentRequests[$i]['task_payment_record_id']."' onClick='showProjectPaymentRequest(".$allTaskPaymentRequests[$i]['task_payment_record_id'].",".$allTaskPaymentRequests[$i]['construction_task_id'].")' class='fa fa-angle-up' style='font-size:32px;color:#107FC9'></i></td>"
            ."<td>".$allTaskPaymentRequests[$i]['construction_task_name']."</td>"
            ."<td>".$allTaskPaymentRequests[$i]['payment_amount']."</td>"
            ."<td>".$Status."</td>"                
            ."<td>".$submit_date."</td>"
            ."</tr>"
            ."<tr>"
            ."<td colspan='5' style='display:none' id='details_payment_request_".$allTaskPaymentRequests[$i]['task_payment_record_id']."'></td>"
            ."</tr>";
       }
        $contentOfProjectPaymentRequest .="</tbody>"
                                        ."</table>";       
   }
   return $contentOfProjectPaymentRequest;
 }
 
  private function getCanadianTaxRateByLocation($province)
  {
   $taxRates = array();   
   $String_SQL = "Select * 
                  From pogopro_canadian_tax_rate
                  Where province_fullname = ?";
  $status=$this->db_conn->prepare($String_SQL);
  $status->execute([$province]);
   if (!$status)
    {
      echo "[getCanadianTaxRateByLocation]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
    }else
    {      
     while ($row=  $status->fetch())
     {
      //$taxRates[$row['tax_rate_name']] = $row['tax_rate_value']; 
      $taxRates[] = array(
      "tax_rate_id"=>$row['tax_rate_id'],
      "tax_rate_name"=>$row['tax_rate_name'],
      "tax_rate_value"=>$row['tax_rate_value']    
      );   
     }
    }      
    return $taxRates;  
  }
 
 private function getPogoproTaxRate()
 {
  $totalTaxRate = 0.00;   
  $pogopro_privince = "Ontario";
  $taxRates = $this->getCanadianTaxRateByLocation($pogopro_privince);
  foreach ($taxRates as $taxRate)
  {
    $totalTaxRate += $taxRate['tax_rate_value'];  
  }
  return $totalTaxRate;
 }
 
 function addPogoproAccountingPayableRecord(
         $project_id,
         $project_bid_id,
         $project_ap_title,
         $project_ap_desc,
         $project_ap_amount,
         $tax_amount,
         $deduct_cost=0.00)
 {
  $current_date = date('Y-m-d'); 
  $pogopro_tax_rate = $this->getPogoproTaxRate();  
  $bounsOfPogopro = ($project_ap_amount+$tax_amount)*POGOPRO_CHARGE_PERCENTAGE*(1+$pogopro_tax_rate);
  $String_SQL = "Insert into pogopro_project_accounting_payable(
      project_id,project_bid_id,project_ap_title,project_ap_desc,project_ap_amount,tax_amount,issue_date,pogopro_charge,deduct_cost) values(?,?,?,?,?,?,?,?,?)";
  $status=$this->db_conn->prepare($String_SQL);
  $status->execute([$project_id,$project_bid_id,$project_ap_title,$project_ap_desc,$project_ap_amount,$tax_amount,$current_date,$bounsOfPogopro,$deduct_cost]);
  if (!$status)
     {
      echo "[addPogoproAccountingPayableRecord]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      //echo $String_SQL;   
      return true;
     }
 }
 
 function makePayPogoproAccountingPayableRecord($task_id)
 {
  $paymentDetails = $this->getPaymentScheduleDetailsByInvolvedTask($task_id);
  if (count($paymentDetails)>0)
  {
  $project_bid_id = $paymentDetails['project_bid_id'];
  $project_id = $paymentDetails['project_id'];
  if ($this->areAllTasksCompleted($paymentDetails['involved_tasks']))
  {
   //Insert pogopro account payable record 
   $customTaxRates = (new pogoproProjectAccountingManager())->getPogoproProjectBidCustomTaxRates($project_bid_id); 
   $overPaidCredit = (new pogoproProjectChangeManager())->getOverPaidCredit($project_bid_id);
   $deduct_cost = 0.00;
   $payment_amount = $paymentDetails['payment_schedule_amount'];
   if ($overPaidCredit>0.00)
   {
     if ($payment_amount >= $overPaidCredit) 
     {
      $deduct_cost = $overPaidCredit; 
      $payment_amount -= $overPaidCredit;
      $overPaidCredit -= $deduct_cost;       
     }else
     {
      $deduct_cost = $payment_amount;  
      $overPaidCredit -= $deduct_cost;
      $payment_amount = 0.00;
     }
     (new pogoproProjectChangeManager())->updatePogoproProjectOverPaidCredit($project_id, $overPaidCredit);
   }
   $total_tax_rate = 0.00;
   if (count($customTaxRates)>0)
   {
    foreach ($customTaxRates as $taxRate)
     $total_tax_rate += $taxRate['custome_tax_rate_value'];   
   }
   $tax_amount = $payment_amount * $total_tax_rate;
   $this->addPogoproAccountingPayableRecord(
           $paymentDetails['project_id'],
           $paymentDetails['project_bid_id'],
           $paymentDetails['payment_schedule_title'],
           $paymentDetails['payment_schedule_desc'],
           //$paymentDetails['payment_schedule_amount'],
           $payment_amount,
           $tax_amount,
           $deduct_cost);   
  }
  }
 }
 
 private function getPaymentScheduleDetailsByInvolvedTask($task_id)
 {
  $paymentDetails = array();   
  $String_SQL = "Select a.*,b.posted_project_id
                 From pogopro_project_bid_payment_scheule a,pogopro_posted_project_bid b
                 Where Locate('".$task_id."',a.involved_tasks)>0 AND a.project_bid_id = b.project_deal_id";
  $status = $this->db_conn->query($String_SQL);
  if (!$status)
     {
      echo "[getPaymentScheduleDetailsByInvolvedTask]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row=  $status->fetch())
      {
       $involved_tasks = $row['involved_tasks']; 
       $involved_tasks = str_replace("[","",$involved_tasks);
       $involved_tasks = str_replace("]","",$involved_tasks);
       $paymentDetails = array(
        "project_id"=>$row['posted_project_id'],   
        "payment_schedule_id"=>$row['custom_payment_schedule_id'],
        "project_bid_id"=>$row['project_bid_id'],
        "payment_schedule_title"=>$row['payment_schedule_title'],
        "payment_schedule_desc"=>$row['payment_schedule_desc'],
        "payment_schedule_amount"=>$row['payment_schedule_amount'],
        "payment_percentage"=>$row['payment_percentage'],           
        "involved_tasks"=>$involved_tasks   
       );
      }
     }
     
   return $paymentDetails;
 }
 
 private function areAllTasksCompleted($all_tasks_list)
 {
  $allCompleted = true;   
  $String_SQL = "Select count(*) as unCompletedTasks
                 From pogopro_project_bid_contruction_tasks a
                 Where a.construction_task_id in ($all_tasks_list) and a.task_status != 2;";   
  $status = $this->db_conn->query($String_SQL);
  if (!$status)
     {
      echo "[getPaymentScheduleDetailsByInvolvedTask]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row=  $status->fetch())
      {
       if ($row['unCompletedTasks']>0) 
          $allCompleted = false; 
      }   
     }
   return $allCompleted;  
 }
}
?>

