<?php
/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
include_once("../v2/inc/vars.php");
include_once("../V2/emailPool/pogoproEmailPoolManager.php");
class pogoproProjectTaskStatusManager
{
private $db_conn;
 function __construct($conn=null){ //set db connection in constructor
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection();
		$this->db_conn = $dbconnect_obj->conn;
	}
 }
  function updateTaskStatusToInprogressAndSendNotification()
  {
   $emailSendRequests = array();   
   $listOfTaskStatusUpdatesOnBid = $this->getListOfTasksFromBidWhichWillStartNextDay();
   $tasksOnBids = array_keys($listOfTaskStatusUpdatesOnBid);
   foreach ($tasksOnBids as $task)
   {
    $eachTask = $listOfTaskStatusUpdatesOnBid[$task];
    $emailSendRequests[] = array("emailFrom"=>POGOPRO_SYSTEM_EMAIL_SENDER,"emailTo"=>$eachTask['email_accounts']['m_email'],"emailSubject"=>"Task will be start tomorrow","emailHtmlContent"=>$eachTask['notification_email_contents']['notification_email_to_member']);
    $emailSendRequests[] = array("emailFrom"=>POGOPRO_SYSTEM_EMAIL_SENDER,"emailTo"=>$eachTask['email_accounts']['p_email'],"emailSubject"=>"Task will be start tomorrow","emailHtmlContent"=>$eachTask['notification_email_contents']['notification_email_to_pro']);
   }   
   $allUpdateConstructionIdsOnBid = implode(",",$tasksOnBids);
   //update task status from pending to in-progress (0 to 3) on Bid table
   $this->updateTaskStatusToInprogress(false, $allUpdateConstructionIdsOnBid);
   $listOfTaskStatusUpdatesOnProjectChanges = $this->getListOfTasksFromChangesWhichWillStartNextDay();
   $tasksOnChanges = array_keys($listOfTaskStatusUpdatesOnProjectChanges);
   foreach ($tasksOnChanges as $task)
   {
    $eachTask = $listOfTaskStatusUpdatesOnProjectChanges[$task];
    $emailSendRequests[] = array("emailFrom"=>POGOPRO_SYSTEM_EMAIL_SENDER,"emailTo"=>$eachTask['email'],"emailSubject"=>"Task will be start tomorrow","emailHtmlContent"=>$eachTask['email_contents']['notification_email_to_member']);
    $emailSendRequests[] = array("emailFrom"=>POGOPRO_SYSTEM_EMAIL_SENDER,"emailTo"=>$eachTask['cs_email'],"emailSubject"=>"Task will be start tomorrow","emailHtmlContent"=>$eachTask['email_contents']['notification_email_to_pro']);       
   }
   $allUpdateConstructionIdsOnProjectChanges = implode(",",$tasksOnChanges );
   //update task status from pending to in-progress (0 to 3) on project change task table
   $this->updateTaskStatusToInprogress(true, $allUpdateConstructionIdsOnProjectChanges);
   //add notification emails to pogopro email pool and send them to memeber and pros.
   (new pogoproEmailPoolManager())->addEmailSenndRequestIntoPoolInBatch($emailRequests);   
  }
    
  private function getListOfTasksFromBidWhichWillStartNextDay()
  {
    $project_deal_ids = array();  
    $listOfNextDayStartTasks = array();  
    $next_date = date('Y-m-d', strtotime($date ." +1 day"));  
    $String_SQL = "Select a.construction_task_id,a.pogopro_project_bid_id,b.construction_task_name
                  From pogopro_project_bid_contruction_tasks a,pogopro_construction_task_definition b
                  Where a.pogopro_project_bid_id  in (
				Select project_deal_id as bid_id 
				From pogopro_post_project 
				Where project_deal_id >0) 
                    AND a.task_start_date = ?
                    AND a.task_status = 0
                    AND b.pogopro_construction_task_id = a.construction_task_id
                    Order By a.construction_task_id;";
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$next_date]);
    if (!$status)
     {
      echo "[getListOfTasksWhichWillStartNextDay]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row=  $status->fetch())
      {
       $listOfNextDayStartTasks[] = array(
        "construction_task_id"=>$row['construction_task_id'],
        "pogopro_project_bid_id"=>$row['pogopro_project_bid_id'],
        "construction_task_name"=>$row['construction_task_name']   
       ); 
       $project_deal_ids[] = $row['pogopro_project_bid_id'];
      }
      $TaskAssociateMemberAndMerchants = $this->getTaskAssociateMemberAndMerchantByProjectDealId(implode(",",$project_deal_ids));
     }
     $loop = count($listOfNextDayStartTasks);
     $listOfcomingStartTasks = array();
     for ($i=0;$i<$loop;$i++)
     {
      $listOfNextDayStartTasks[$i]['pogopro_project_bid_id'] = $TaskAssociateMemberAndMerchants[$listOfNextDayStartTasks[$i]['pogopro_project_bid_id']]; 
      $listOfNextDayStartTasks[$i]['email_contents'] = $this->initNotificationEmailToMemberAndMerchant(
              $listOfNextDayStartTasks[$i]['pogopro_project_bid_id']['m_salutation'], 
              $listOfNextDayStartTasks[$i]['pogopro_project_bid_id']['m_name'], 
              $listOfNextDayStartTasks[$i]['pogopro_project_bid_id']['p_name'], 
              $listOfNextDayStartTasks[$i]['construction_task_name']);
      $listOfcomingStartTasks[$listOfNextDayStartTasks[$i]['construction_task_id']] 
              = array(
                  "construction_task_id"=>$listOfNextDayStartTasks[$i]['construction_task_id'],
                  "email_accounts"=>$listOfNextDayStartTasks[$i]['pogopro_project_bid_id'],
                  "notification_email_contents"=>$listOfNextDayStartTasks[$i]['email_contents']
              );
     }
     //return $listOfNextDayStartTasks;
     return  $listOfcomingStartTasks;
  }
  
  private function getTaskAssociateMemberAndMerchantByProjectDealId($project_deal_ids)
  {
    $taskStartAssociateMemberAndMerchant = array();
    $String_SQL = "Select a.member_id,b.salutation as m_salutation,b.name as m_name,b.email as m_email,
                    a.merchant_id,c.business_name as p_name,c.cs_email as p_email, a.project_deal_id
                  From pogopro_post_project a,customer_accounts b,rv_merchants c
                  Where project_deal_id in (?) 
                    AND b.id = a.member_id 
                    AND c.id = a.merchant_id
                  Order By project_deal_id";  
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$project_deal_ids]);
    if (!$status)
     {
      echo "[getListOfTasksWhichWillStartNextDay]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row = $status->fetch())
      {
       $taskStartAssociateMemberAndMerchant[$row['project_deal_id']]= array(   
               "member_id" => $row['member_id'],
               "m_salutation" => $row['m_salutation'],
               "m_name" => $row['m_name'],
               "m_email" => $row['m_email'],
               "merchant_id" => $row['merchant_id'],
               "p_name" => $row['p_name'],
               "p_email" => $row['p_email']           
           );
      }
     }
     return $taskStartAssociateMemberAndMerchant;
  }
  
  private function getListOfTasksFromChangesWhichWillStartNextDay()
  {
    $nextDayStartProjectChangeTasks = array();  
    $next_date = date('Y-m-d', strtotime($date ." +1 day"));   
    $String_SQL = "Select a.construction_task_id,d.construction_task_name,g.salutation,g.name,g.email,h.business_name,h.cs_email,a.task_start_date 
                  From pogopro_project_change_tasks a,
                       pogopro_project_change_items b,
                       pogopro_project_change_object c,
                       pogopro_construction_task_definition d,
                       pogopro_project_change e,
                       pogopro_post_project f,
                       customer_accounts g,
                       rv_merchants h
                 Where a.construction_item_id = b.construction_object_item_id 
                    AND b.construction_object_id = c.construction_object_id 
                    AND d.pogopro_construction_task_id = a.construction_task_definition_id
                    AND c.project_change_id = e.project_change_id AND e.status_of_change = 2
                    AND e.project_id = f.post_project_id 
                    AND f.member_id = g.id 
                    AND f.merchant_id = h.id
                    AND a.task_status = 0 
                    AND a.task_start_date = ? 
                    Order By a.construction_task_id;"; 
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$next_date]);
    if (!$status)
     {
      echo "[getListOfTasksFromChangesWhichWillStartNextDay]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row = $status->fetch())
      {
       $nextDayStartProjectChangeTasks[$row['construction_task_id']*(-1)]= array(   
               "construction_task_name" => $row['construction_task_name'],
               "salutation" => $row['salutation'],
               "name" => $row['name'],
               "email" => $row['email'],
               "business_name" => $row['business_name'],
               "cs_email" => $row['cs_email'],
               "email_contents"=>$this->initNotificationEmailToMemberAndMerchant(
                                        $row['salutation'], 
                                        $row['name'], 
                                        $row['business_name'], 
                                        $row['construction_task_name'])
           );
      }
     }
     return $nextDayStartProjectChangeTasks;
  }
  
  private function updateTaskStatusToInprogress($isProjectChange,$constructionTasks)
  {
   $String_SQL = "Update pogopro_project_bid_contruction_tasks a
                  Set a.task_status = 3
                  Where a.construction_task_id in (?)"; 
				  $param = [$constructionTasks];
   if ($isProjectChange)
   {
    $constructionTasks = str_replace("-", "", $constructionTasks);  
    $String_SQL = "Update pogopro_project_change_tasks a
                   Set a.task_status = 3
                   Where a.construction_task_id in (?)";   
	$param = [$constructionTasks];				   
   }
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute($param);
   if (!$status)
     {
      echo "[updateTaskStatusToInprogress]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      return true;   
     }
  }
  
  private function initNotificationEmailToMemberAndMerchant(
          $member_salutation,
          $member_name,
          $business_name,
          $task_name)
  {
   $notification_email_content_member = $member_salutation." ".$member_name."<br>";
   $notification_email_content_member .= "The following task will be started tomoorow:<br>";
   $notification_email_content_member .= $task_name."<br>";
   
   $notification_email_content_pro = $business_name."<br>";
   $notification_email_content_pro .= "The following task will be started tomoorow:<br>";
   $notification_email_content_pro .= $task_name."<br>";
   
   return array("notification_email_to_member"=>$notification_email_content_member,
                "notification_email_to_pro"=>$notification_email_content_pro);
  }
  
  
  function test()
  {
   //$this->getTaskAssociateMemberAndMerchantByProjectDealId("15,23"); 
   //$this->updateTaskStatusToInprogress(true,"-2,-3,-5,-7");//getListOfTasksFromChangesWhichWillStartNextDay();//
   $this->updateTaskStatusToInprogressAndSendNotification();   
  }
}
?>

