<?php
include_once("../v2/inc/vars.php"); 
include_once("pogoproHelperClass.php");
/* 
 * Clas pogoproProjectShareManager
 * This class will include the following functions:
 * 1) CURD of pogopro project share object 
 * 2) Add or remove image of share object
 * 3) Get list of share object and images
 */
class pogoproProjectShareManager
{
 private $db_conn;
 private $domain_name;
 function __construct($conn=null){ //set db connection in constructor
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection();
		$this->db_conn = $dbconnect_obj->conn;
	}
	$pogoproHelperClass = new pogoproHelperClass();
	$this->domain_name = $pogoproHelperClass -> domain_name;
 }	
 function addPogoproProjectShareObject($project_id,
         $owner_id,
         $owner_role,
         $share_object_title,
         $share_object_content,
         $share_object_challenge,
         $share_object_comments,
         $share_object_rating)
 {
  $String_SQL = "Insert into pogopro_project_share_management(project_id,owner_id,owner_role,"
          . "share_object_subject,share_object_conent,share_object_challenge,share_object_comments,share_object_rating) values(?,?,?,?,?,?,?,?);"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id,$owner_id,$owner_role,$share_object_title,$share_object_content,$share_object_challenge,$share_object_comments,$share_object_rating]);
  if (!$status)
  {
   echo "[addPogoproProjectShareObject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   $insert_share_object_id = $this->db_conn->lastInsertId();   
   return $insert_share_object_id;
  }  
 }
 
 function updatePogoproProjectShareObject($share_object_id,
         $share_object_title,
         $share_object_content,
         $share_object_challenge,
         $share_object_comments)
 {
  $String_SQL = "Update pogopro_project_share_management Set share_object_subject= ? ,share_object_conent= ?,share_object_challenge= ?,share_object_comments= ? "
              . "Where share_object_id= ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$share_object_title,$share_object_content,$share_object_challenge,$share_object_comments,$share_object_id]);
  if (!$status)
  {
   echo "[updatePogoproProjectShareObject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   return 1;
  }  
 }
 
 function deletePogoproProjectShareObject($share_object_id)
 {
  $String_SQL = "Delete From pogopro_project_share_management Where share_object_id= ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$share_object_id]);
  if (!$status)
  {
   echo "[deletePogoproProjectShareObject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   return true;
  }  
 }
 
 function addImageToPogoproProjectShareObject($share_object_id,$gallery_image_ids,$share_image_type)
 {   
  $String_SQL = "Insert into pogopro_project_share_image_management(share_object_id,share_image_id,share_image_name,share_image_type) values";
  $numOfImages = count($gallery_image_ids);
  $String_Values = "";
  for ($i=0;$i<$numOfImages;$i++)
  {
   $image = $gallery_image_ids[$i];
   $array_image = explode(":", $image);
   $String_Values .= "($share_object_id,'$array_image[0]','$array_image[1]',$share_image_type),";
  }
  $String_Values = substr($String_Values, 0,-1);
  $String_SQL .= $String_Values;

  $status = $this->db_conn->query($String_SQL);
  if (!$status)
  {
   echo "[addImageToPogoproProjectShareObject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   return true;
  }   
 }
 
 function getListOfProjectShareObject($project_id,$owner_id)
 {
  $String_SQL = "Select * From pogopro_project_share_management 
                 Where project_id = ? AND owner_id = ? Order by share_object_id"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id,$owner_id]);
  if (!$status)
  {
   echo "[getListOfProjectShareObject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   $allProjectShareObjects = array(); 
   while ($row=  $status->fetch())
   {
    $allProjectShareObjects[] = array(
     "share_object_id"=>$row['share_object_id'],
     "project_id"=>$row['project_id'],
     "owner_id"=>$row['owner_id'],
     "owner_role"=>$row['owner_role'],
     "share_object_subject"=>$row['share_object_subject'],
     "share_object_conent"=>$row['share_object_conent']        
    );   
   }
   return $allProjectShareObjects;
  }    
 }
 
 private function getSingleProjectShareObject($share_object_id)
 {
  $String_SQL = "Select * From pogopro_project_share_management Where share_object_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$share_object_id]);
  if (!$status)
  {
   echo "[getSingleProjectShareObject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   $allProjectShareObjects = array(); 
   while ($row=  $status->fetch())
   {
    $allProjectShareObjects = array(
     "share_object_id"=>$row['share_object_id'],
     "project_id"=>$row['project_id'],
     "owner_id"=>$row['owner_id'],
     "owner_role"=>$row['owner_role'],
     "share_object_subject"=>$row['share_object_subject'],
     "share_object_conent"=>$row['share_object_conent'], 
     "share_object_challenge"=>$row['share_object_challenge'],
     "share_object_comments"=>$row['share_object_comments'],
     "share_object_rating"=>$row['share_object_rating']  
    );   
   }
   return $allProjectShareObjects;
  }    
 }
 
 function getListOfImageAttachedToProjectShareObject($share_object_id,$share_image_type)
 {
  $String_SQL = "Select a.*,b.owner_role,b.project_id  
                 From pogopro_project_share_image_management a,pogopro_project_share_management b 
                 Where a.share_object_id = ? 
                 AND b.share_object_id = a.share_object_id 
                 AND a.share_image_type = ?
                 Order By a.project_sharing_image_id";   
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$share_object_id,$share_image_type]);
  if (!$status)
  {
   echo "[getListOfImageAttachedToProjectShareObject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   $allImagesOfProjectShareObject = array(); 
   while ($row=  $status->fetch())
   {
    $allImagesOfProjectShareObject[] = array(
     "project_sharing_image_id"=>$row['project_sharing_image_id'],
     "share_object_id"=>$row['share_object_id'],
     "share_image_id"=>$row['share_image_id'],
     "image_desc"=>"",
     "image_name"=>$row['share_image_name'],
     "owner_role"=>$row['owner_role'],
     "project_id"=>$row['project_id']        
    );   
   }
   return $allImagesOfProjectShareObject;
  }
 }
 
 function getContentOfProjectShareObjectManagement($project_id,$merchant_id,$owner_role)
 {
  $allProjectShareObjects = $this->getListOfProjectShareObject($project_id, $merchant_id);
  $numOfProjectShareObjects = count($allProjectShareObjects); 
  $String_project_content = "<table style='width:100%'>"
          . "<tr style='background-color:skyblue;'>";
  if ($numOfProjectShareObjects>0)
  {
   $String_Share_URL = "https://".$this->domain_name."/v2/pogoproShare.php?dip=".$project_id."_".$merchant_id."_".$owner_role;   
   $String_project_content .= "<td style='width:80%'><h4 style='margin-left:4px;'>Project Share Object:</h4></td>"
   ."<td style='width:5%'><img src='images/facebook.png' style='width:28px;height:28px;' onClick='shareMyProjectWithFacebookCircle(\"".$String_Share_URL."\")'></td>"
   ."<td style='width:5%'><img src='images/twitter.png' style='width:28px;height:28px;' onClick='shareMyProjectWithTwitterCircle(\"".$String_Share_URL."\")'></td>"
   ."<td style='width:5%'><img src='images/GooglePlus.png' style='width:28px;height:28px;' onClick='shareMyProjectWithGooglePlusCircle(\"".$String_Share_URL."\")'></td>"           
   ."<td style='width:5%'><img src='img/add.png' style='width:28px;height:28px;display:none' onClick='addNewProjectShareObject(".$project_id.",".$merchant_id.",".$owner_role.")'></td>"
   ."<tr ><td colspan='5' id='add_new_project_share_object_row_".$project_id."' style='display:none'></td>"
   ."<table border='0' class='table' style='width:100%'>"
   ."<thead>"
   ."<tr>"
   ."<th style='width:5%'></th>"           
   ."<th style='width:85%'>Title</th>"
   ."<th style='width:5%'></th>"
   ."<th style='width:5%'></th>"      
   ."</tr>"
   ."</thead>"
   ."<tbody>";
   for ($i=0;$i<$numOfProjectShareObjects;$i++)
   {
    $class = 'info';
    if ($i%2==0)
       $class = 'success'; 
    $String_project_content .="<tr class='".$class."'>"
            //76east(11-feb-2020)."<td><i id='share_object_viewer_".$allProjectShareObjects[$i]['share_object_id']."' class='material-icons' style='font-size:32px;color:#107FC9' onClick='projectShareObjectView(".$allProjectShareObjects[$i]['share_object_id'].")'>expand_less</i></td>"
            . "<td><img id='share_object_viewer_".$allProjectShareObjects[$i]['share_object_id']."' src='projectmanager_icons/btn_right_arrow.png' style='width:24px;height:24px;' onClick='projectShareObjectView(".$allProjectShareObjects[$i]['share_object_id'].")'></td>"
            ."<td id='td_project_share_object_subject_".$allProjectShareObjects[$i]['share_object_id']."'>".$allProjectShareObjects[$i]['share_object_subject']."</td>"
            ."<td><img src='img/edit-icon.png' style='width:28px;height:28px;' onClick='projectShareObjectEditor(".$allProjectShareObjects[$i]['share_object_id'].")'></td>"
            ."<td><img src='projectmanager_icons/btn_delete_24.png' style='width:24px;height:24px;' onClick='deleteProjectShareObject(".$allProjectShareObjects[$i]['project_id'].",".$allProjectShareObjects[$i]['owner_id'].",".$allProjectShareObjects[$i]['owner_role'].",".$allProjectShareObjects[$i]['share_object_id'].")'></td>"
            ."</tr>"
            ."<tr>"
            ."<td colspan='4'  id='details_project_share_object_".$allProjectShareObjects[$i]['share_object_id']."'>".$this->getContentOfProjectShareObjectViewerForSharePage($allProjectShareObjects[$i]['share_object_id'])."</td>" 
            ."</tr>";   
   } 
   $String_project_content .="</tbody>"
                           ."</table>";
  }else
  {
   $String_project_content .= "<td style='width:95%'><h4 style='margin-left:4px;'>Project Share Object:</h4></td>"
   ."<td style='width:5%'><img src='img/add.png' style='width:28px;height:28px;' onClick='addNewProjectShareObject(".$project_id.",".$merchant_id.",".$owner_role.")'></td>"
   ."<tr ><td colspan='2' id='add_new_project_share_object_row_".$project_id."' style='display:none'></td>";        
  }    
   $String_project_content.= "</tr>"
   . "</tr></table>";
  
  return $String_project_content;   
 }
 
 function getContentOfProjectShareObjectManagementForSharePage($project_id,$merchant_id,$owner_role)
 {
  $allProjectShareObjects = $this->getListOfProjectShareObject($project_id, $merchant_id);
  $numOfProjectShareObjects = count($allProjectShareObjects); 
  $firstShareObject = 0;
  if ($numOfProjectShareObjects>0)
  {
   $firstShareObject = $allProjectShareObjects[0]['share_object_id'];   
   $String_project_content .= "<table border='0' class='table' style='width:100%'>"
   ."<thead>"
   ."<tr>"
   ."<th style='width:5%'></th>"           
   ."<th style='width:95%'></th>"      
   ."</tr>"
   ."</thead>"
   ."<tbody>";
   for ($i=0;$i<$numOfProjectShareObjects;$i++)
   {
    $class = 'info';
    if ($i%2==0)
       $class = 'success'; 
    $String_project_content .="<tr class='".$class."' onClick='projectShareObjectView(".$allProjectShareObjects[$i]['share_object_id'].")'>"
            ."<td><i id='share_object_viewer_".$allProjectShareObjects[$i]['share_object_id']."' class='material-icons'>expand_less</i></td>"
            //<img id='share_object_viewer_".$allProjectShareObjects[$i]['share_object_id']."' src='projectmanager_icons/btn_right_arrow.png' style='width:12px;height:12px;display:'>
            ."<td id='td_project_share_object_subject_".$allProjectShareObjects[$i]['share_object_id']."'>".$allProjectShareObjects[$i]['share_object_subject']."</td>"
            ."</tr>"
            ."<tr>"
            ."<td colspan='2'  id='details_project_share_object_".$allProjectShareObjects[$i]['share_object_id']."'>".$this->getContentOfProjectShareObjectViewerForSharePage($allProjectShareObjects[$i]['share_object_id'])."</td>" 
            ."</tr>";   
   } 
   $String_project_content .="</tbody>"
                           ."</table>";
  }   
   $String_project_content.= "</tr>"
   . "</tr></table>";
  $returnArrray = array("openObject"=>$firstShareObject,
      "share_project_title"=>$allProjectShareObjects[0]['share_object_subject'],
      "showList"=>$String_project_content,
      "shareLinkLogoImageURL"=>$this->getLogoImageForShareLink($firstShareObject ));
  return $returnArrray;//$String_project_content;   
 } 
 
 function getLogoImageForShareLink($project_share_object_id)
 {
   $allImagesofShareObject_after = $this->getListOfImageAttachedToProjectShareObject($project_share_object_id,2); 
   $facebook_use_image = str_replace("/pogo.pro/", "", $allImagesofShareObject_after[0]['image_name']);
   return $shareLinkLogoImageURL = "http://www.pogo.pro/".$facebook_use_image;
 }
 
 function getContentOfProjectShareObjectViewer($project_share_object_id)
 {
  $singleShareObject = $this->getSingleProjectShareObject($project_share_object_id);
  $allImagesofShareObject = $this->getListOfImageAttachedToProjectShareObject($project_share_object_id);
  $numOfImages = count($allImagesofShareObject);
  $contentOfsingleShareObject ="<div class='form-group'>"
          ."<label>Subject:</label>"
          ."<input type='email' class='form-control' style='height:32px;' value='".$singleShareObject['share_object_subject']."'id='email' readonly>"
          ."<label>Description:</label>"
          ."<textarea class='form-control' rows='5' id='comment' readonly>".$singleShareObject['share_object_conent']."</textarea>"        
          //."<label>Challenge:</label>"
          //."<textarea class='form-control' rows='5' id='comment' readonly>".$singleShareObject['share_object_conent']."</textarea>"
         // ."<label>Comments of homeowner:</label>"
         // ."<textarea class='form-control' rows='5' id='comment' readonly>".$singleShareObject['share_object_conent']."</textarea>"          
          ."</div>";
  if ($numOfImages>0)
  {
          $contentOfsingleShareObject.="<div class='container' style='margin-top:10px;width:50%;'>"
	  ."<div id='myCarousel_".$project_share_object_id."' class='carousel slide' data-ride='carousel' data-interval='false'>"
	  ."<!-- Indicators -->"
	  ."<ol class='carousel-indicators'>";
          for ($i=0;$i<$numOfImages;$i++)
          {
            if ($i==0)  
	       $contentOfsingleShareObject.="<li data-target='#myCarousel_".$project_share_object_id."' data-slide-to='".$i."' class='active'></li>";
            else
	       $contentOfsingleShareObject.="<li data-target='#myCarousel_".$project_share_object_id."' data-slide-to='".$i."'></li>";
          }
	  $contentOfsingleShareObject.="</ol>"	
	  ."<!-- Wrapper for slides -->"
	  ."<div class='carousel-inner' role='listbox' style='margin-top:10px;'>";
  
          for ($i=0;$i<$numOfImages;$i++)
          {
              if ($i>0) 
                  $active="";
              else
                  $active =" active";
              $contentOfsingleShareObject.="<div class='item".$active."' style='margin-top:18px;'>"
                ."<img src='".RENOVATION_PROJECT_IMAGE_SERVER_DIR.$allImagesofShareObject[$i]['image_name']."'>"
                ."<div class='carousel-caption' style='background-color:transparent;'>"
                ."<p>".$allImagesofShareObject[$i]['image_desc']."</p>"
                ."</div>"
                ."</div>";   
          }
	    $contentOfsingleShareObject.="</div>"
	
	    ."<!-- Left and right controls -->"
	    ."<a class='left carousel-control' href='#myCarousel_".$project_share_object_id."' role='button' data-slide='prev'>"
	    ."<span class='glyphicon glyphicon-chevron-left' aria-hidden='true'></span>"
	    ."<span class='sr-only'>Previous</span>"
	    ."</a>"
	    ."<a class='right carousel-control' href='#myCarousel_".$project_share_object_id."' role='button' data-slide='next'>"
	    ."<span class='glyphicon glyphicon-chevron-right' aria-hidden='true'></span>"
	    ."<span class='sr-only'>Next</span>"
	    ."</a>" 
            ."</div>"
            ."</div>";
  }          
  return $contentOfsingleShareObject;
 }
 
 function getContentOfProjectShareObjectViewerForSharePage($project_share_object_id)
 {
  $singleShareObject = $this->getSingleProjectShareObject($project_share_object_id);
  $allImagesofShareObject = $this->getListOfImageAttachedToProjectShareObject($project_share_object_id,1);
  $allImagesofShareObject_after = $this->getListOfImageAttachedToProjectShareObject($project_share_object_id,2);
  $numOfImages = count($allImagesofShareObject);
  $numOfImages_a = count($allImagesofShareObject_after);
  $contentOfsingleShareObject ="<div class='form-group' style='margin-bottom:0px;'>"
          ."<label>Subject:</label>"
          ."<input type='email' class='form-control' style='height:32px;' value='".$singleShareObject['share_object_subject']."'id='email' readonly>"
          ."<label>Description:</label>"
          ."<textarea class='form-control' rows='5' id='comment' readonly>".$singleShareObject['share_object_conent']."</textarea>"        
          ."<label>Challenge:</label>"
          ."<textarea class='form-control' rows='5' id='comment' readonly>".$singleShareObject['share_object_challenge']."</textarea>"        
          ."<label>Comments of homeowner:</label>"
          ."<textarea class='form-control' rows='5' id='comment' readonly>".$singleShareObject['share_object_comments']."</textarea>" 
          ."<label>Rating of homeowner:</label>" 
          ."<div style='margin-left:0px;' id='share_object_rating' value='".$singleShareObject['share_object_rating']."'></div>"                
  	  ."</div>";
  if ($numOfImages>0)
  { 
     $contentOfsingleShareObject.="<div>"
          ."<label>Picture before renovation:</label>"
          ."</div>";      
     $contentOfsingleShareObject.="<div class='container' style='margin-top:10px;width:75%;'>"
	  ."<div id='myCarousel_1_".$project_share_object_id."' class='carousel slide' data-ride='carousel' data-interval='false'>"
	  ."<!-- Indicators -->"
	  ."<ol class='carousel-indicators'>";
          for ($i=0;$i<$numOfImages;$i++)
          {
            if ($i==0)  
	       $contentOfsingleShareObject.="<li data-target='#myCarousel_1_".$project_share_object_id."' data-slide-to='".$i."' class='active'></li>";
            else
	       $contentOfsingleShareObject.="<li data-target='#myCarousel_1_".$project_share_object_id."' data-slide-to='".$i."'></li>";
          }
	  $contentOfsingleShareObject.="</ol>"	
	  ."<!-- Wrapper for slides -->"
	  ."<div class='carousel-inner' role='listbox' style='margin-top:10px;'>";
  
          for ($i=0;$i<$numOfImages;$i++)
          {
              if ($i>0) 
                  $active="";
              else
                  $active =" active";
              $contentOfsingleShareObject.="<div class='item".$active."' style='margin-top:18px;'>"
                ."<img src='".$allImagesofShareObject[$i]['image_name']."'>"
                ."<div class='carousel-caption' style='background-color:transparent;'>"
                ."<p>".$allImagesofShareObject[$i]['image_desc']."</p>"
                ."</div>"
                ."</div>";   
          }
	    $contentOfsingleShareObject.="</div>"
	
	    ."<!-- Left and right controls -->"      
	    ."<a class='left carousel-control' href='#myCarousel_1_".$project_share_object_id."' role='button' data-slide='prev'>"
	    ."<span class='glyphicon glyphicon-chevron-left' aria-hidden='true'></span>"
	    ."<span class='sr-only'>Previous</span>"
	    ."</a>"
	    ."<a class='right carousel-control' href='#myCarousel_1_".$project_share_object_id."' role='button' data-slide='next'>"
	    ."<span class='glyphicon glyphicon-chevron-right' aria-hidden='true'></span>"
	    ."<span class='sr-only'>Next</span>"
	    ."</a>"
            ."</div>"
            ."</div>";
  }
  if ($numOfImages_a>0)
  {
     $contentOfsingleShareObject.="<div>"
          ."<label>Picture after renovation:</label>"
          ."</div>";       
     $contentOfsingleShareObject.="<div class='container' style='margin-top:10px;width:75%;'>"
	  ."<div id='myCarousel_2_".$project_share_object_id."' class='carousel slide' data-ride='carousel' data-interval='false'>"
	  ."<!-- Indicators -->"
	  ."<ol class='carousel-indicators'>";
          for ($i=0;$i<$numOfImages_a;$i++)
          {
            if ($i==0)  
	       $contentOfsingleShareObject.="<li data-target='#myCarousel_2_".$project_share_object_id."' data-slide-to='".$i."' class='active'></li>";
            else
	       $contentOfsingleShareObject.="<li data-target='#myCarousel_2_".$project_share_object_id."' data-slide-to='".$i."'></li>";
          }
	  $contentOfsingleShareObject.="</ol>"	
	  ."<!-- Wrapper for slides -->"
	  ."<div class='carousel-inner' role='listbox' style='margin-top:10px;'>";
  
          for ($i=0;$i<$numOfImages_a;$i++)
          {
              if ($i>0) 
                  $active="";
              else
                  $active =" active";
              $contentOfsingleShareObject.="<div class='item".$active."' style='margin-top:18px;'>"
                ."<img src='".$allImagesofShareObject_after[$i]['image_name']."'>"
                ."<div class='carousel-caption' style='background-color:transparent;'>"
                ."<p>".$allImagesofShareObject_after[$i]['image_desc']."</p>"
                ."</div>"
                ."</div>";   
          }
	    $contentOfsingleShareObject.="</div>"
	
	    ."<!-- Left and right controls -->"       
	    ."<a class='left carousel-control' href='#myCarousel_2_".$project_share_object_id."' role='button' data-slide='prev'>"
	    ."<span class='glyphicon glyphicon-chevron-left' aria-hidden='true'></span>"
	    ."<span class='sr-only'>Previous</span>"
	    ."</a>"
	    ."<a class='right carousel-control' href='#myCarousel_2_".$project_share_object_id."' role='button' data-slide='next'>"
	    ."<span class='glyphicon glyphicon-chevron-right' aria-hidden='true'></span>"
	    ."<span class='sr-only'>Next</span>"
	    ."</a>" 
            ."</div>"
            ."</div>";
  }  
  return $contentOfsingleShareObject;
 } 
 
 function getContentOfImageListOfProjectShareObject($project_share_object_id,$share_image_type)
 { 
  $allImagesofShareObject = $this->getListOfImageAttachedToProjectShareObject($project_share_object_id,$share_image_type);
  $numOfImages = count($allImagesofShareObject); 
  $maxImagesOneRow = 12;
  $numOfImageLines = $numOfImages % $maxImagesOneRow;
  $numOfImageLines = ($numOfImages - $numOfImageLines)/$maxImagesOneRow;
  if (($numOfImages % $maxImagesOneRow) >0)
      $numOfImageLines++;
  $contentOfImageList = "";
  for ($i=0;$i<$numOfImageLines;$i++)
  {
   $contentOfImageList .="<ul class='navlist'>";   
   $endPoint = ($i+1)*$maxImagesOneRow;
   if ($endPoint>$numOfImages)
       $endPoint = $numOfImages;
   for ($k=$i*$maxImagesOneRow;$k<$endPoint;$k++)
   {
    $contentOfImageList .="<li>"
                        ."<img id='share_object_img_".$allImagesofShareObject[$k]['project_sharing_image_id']."' style='width:64px;height:48px;' src='".$allImagesofShareObject[$k]['image_name']."'  title='".$allImagesofShareObject[$k]['image_desc']."'>"
                        ."<img src='projectmanager_icons/btnClose_16.png' style='margin-bottom: 32px;width:16px;height:16px;' onclick='removePictureFromProjectShareObject(".$allImagesofShareObject[$k]['project_id'].",".$allImagesofShareObject[$k]['owner_role'].",".$project_share_object_id.",".$allImagesofShareObject[$k]['project_sharing_image_id'].",$share_image_type)'>"
                        ."</li>";   
   } 
   $contentOfImageList .="</ul>";
  }
  
  return $contentOfImageList;
 }
 
 function getContentOfImageListWhichUnSelectedByProjectShareObject(
         $project_id,
         $owner_role,
         $share_image_type,
         $project_share_object_id)
 {
  $allUnSelectedProjectImages = $this->getListOfProjectImagesWhichUnSelectByShareObject($project_id,$owner_role,$share_image_type);   
  $numOfImages = count($allUnSelectedProjectImages); 

  $maxImagesOneRow = 12;
  $numOfImageLines = $numOfImages % $maxImagesOneRow;
  $numOfImageLines = ($numOfImages - $numOfImageLines)/$maxImagesOneRow;
  if (($numOfImages % $maxImagesOneRow) >0)
      $numOfImageLines++;
  $contentOfImageList = "";
  if ($numOfImageLines>0)
         $contentOfImageList .="<p style='margin-right:8px;text-align:right'><i class='fa fa-times-circle-o' id='cancel_btn_".$share_image_type."' title='Cancel adding image' style='font-size:24px;color:#107FC9' onClick='cancelAddingImages(".$share_image_type.",".$project_share_object_id.")'></i></p>";   
  for ($i=0;$i<$numOfImageLines;$i++)
  {
   $contentOfImageList .="<ul class='navlist'>";   
   $endPoint = ($i+1)*$maxImagesOneRow;
   if ($endPoint>$numOfImages)
       $endPoint = $numOfImages;
   for ($k=$i*$maxImagesOneRow;$k<$endPoint;$k++)
   {
    $contentOfImageList .="<li>"
                        ."<img id='share_object_img_".$allUnSelectedProjectImages[$k]['project_sharing_image_id']."' style='width:64px;height:48px;' src='".$allUnSelectedProjectImages[$k]['image_name']."'  title='".$allUnSelectedProjectImages[$k]['image_desc']."'>"
                        ."<input type='checkbox' value='".$allUnSelectedProjectImages[$k]['gallery_image_id'].":".$allUnSelectedProjectImages[$k]['image_name']."' name='image_share_object_".$share_image_type."_".$project_id."[]' style='margin-bottom:28px;width:20px;height:20px;' onClick='addImageToProjectShareObject(".$project_id.",".$owner_role.",".$project_share_object_id.",\"".$allUnSelectedProjectImages[$k]['gallery_image_id'].":".$allUnSelectedProjectImages[$k]['image_name']."\",$share_image_type);'>"
                        ."</li>";   
   } 
   $contentOfImageList .="</ul>";
  }
  return $contentOfImageList;
 }

 private function getImagesOfProjectFromQuote($project_id)
 {
  $imagesFromQuote =array();   
  $String_SQL = "Select a.* 
                 From pogopro_project_quote_construction_item_images a,
                      pogopro_project_quote_construction_items b,
                      pogopro_project_quote_construction_object c,
                      pogopro_project_quote d
                 Where a.construction_item_id = b.construction_object_item_id 
                 AND b.construction_object_id = c.construction_object_id
                 AND c.project_quote_id = d.project_quote_id
                 AND d.project_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id]);
  if (!$status)
  {
   echo "[getImagesOfProjectFromQuote]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {  
   while($row=  $status->fetch())
   {
    $imagesFromQuote[] = array(
     "gallery_image_id"=>"Q_".$row['item_image_id'],  
     "image_name"=>RENOVATION_RFQ_IMAGE_SERVER_DIR.$row['image_name'],
     "image_desc"=>""//$row['image_desc']   
    );   
   }
  }
  return $imagesFromQuote;
 }

 private function getImagesOfProjectFromChanges($project_id)
 {
  $imagesFromChanges =array();   
  $String_SQL = "Select a.* 
                 From pogopro_project_change_item_images a,
                      pogopro_project_change_items b,
                      pogopro_project_change_object c,
                      pogopro_project_change d
                 Where a.construction_item_id = b.construction_object_item_id 
                 AND b.construction_object_id = c.construction_object_id
                 AND c.project_change_id = d.project_change_id
                 AND d.status_of_change = 2
                 AND d.project_id = ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id]);
  if (!$status)
  {
   echo "[getImagesOfProjectFromChanges]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {  
   while($row=  $status->fetch())
   {
    $imagesFromChanges[] = array(
     "gallery_image_id"=>"C_".$row['item_image_id'],   
     "image_name"=>RENOVATION_CHANGE_IMAGE_SERVER_DIR.$row['image_name'],
     "image_desc"=>""//$row['image_desc']   
    );   
   }
  }
  return $imagesFromChanges;  
 }
 
 
 private function getImagesOfProjectFromCompletedTasks($project_id)
 {
  $imagesAfterRenovation = array();   
  $String_SQL = "Select a.* 
                From pogopro_project_task_complete_request_attachments a,
                          pogopro_project_task_complete_request b  
                Where a.task_complete_status_request_id = b.project_task_complete_request_id
                AND b.request_status = 1
                AND b.project_task_id in (
                (Select a.construction_task_id*(-1) 
                From pogopro_project_change_tasks a,
                               pogopro_project_change_items b,
                               pogopro_project_change_object c,
                               pogopro_project_change d
                 Where d.project_id = :pid1
                 AND d.status_of_change =2
                 AND a.construction_item_id = b.construction_object_item_id
                 AND b.construction_object_id = c.construction_object_id
                 AND c.project_change_id = d.project_change_id 
                 Union
                 Select a.construction_task_id
                      From pogopro_project_bid_contruction_tasks a,
                          pogopro_posted_project_bid b,
                          pogopro_post_project c
                      Where a.pogopro_project_bid_id = b.project_deal_id
                      AND b.project_deal_id = c.project_deal_id	
                      AND c.post_project_id = :pid2) 
                ) order by a.task_complete_status_request_attachment_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([':pid1' => $project_id,':pid2'=>$project_id]);
  if (!$status)
  {
   echo "[getImagesOfProjectFromChanges]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {  
   while($row=  $status->fetch())
   {
    $imagesAfterRenovation[] = array(
        
     //"task_complete_status_request_attachment_id"=>$row['task_complete_status_request_attachment_id'],
     //"task_complete_status_request_id"=>$row['task_complete_status_request_id'],
     "gallery_image_id"=>"T_".$row['task_complete_status_request_attachment_id'],         
     "image_name"=>RENOVATION_PROJECT_IMAGE_SERVER_DIR.$row['attachment_url'],
     "image_desc"=>""   
    );   
   }
  }
  return $imagesAfterRenovation;  
 }
 
 private function getImagesFromProjectGallery($project_id,$owner_role)
 {
  $imagesInProjectGallery = array();
  $String_SQL = "Select a.gallery_image_id,a.image_name,a.image_desc
                From pogopro_post_project_gallery a
                Where a.posted_project_id = ?
                AND a.owner_role = ?;";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id,$owner_role]);
  if (!$status)
  {
   echo "[getImagesOfProjectFromChanges]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {  
   while($row=  $status->fetch())
   {
    $imagesInProjectGallery[] = array(
     "gallery_image_id"=>"G_".$row['gallery_image_id'],   
     "image_desc"=>"",//$row['image_desc'],
     "image_name"=>RENOVATION_PROJECT_IMAGE_SERVER_DIR.$row['image_name']   
    );   
   }
  }
  return $imagesInProjectGallery;
 }
         
 function getContentOfProjectShareObjectEditor($project_share_object_id)
 {   
  $singleShareObject = $this->getSingleProjectShareObject($project_share_object_id);
  $contentOfsingleShareObject ="<div class='form-group'>"
          ."<label>Subject:</label>"
          ."<input id='share_object_subject_".$project_share_object_id."' type='text' class='form-control' style='height:32px;' value='".$singleShareObject['share_object_subject']."'>"
          ."<label>Description:</label>"
          ."<textarea class='form-control' rows='5' id='share_object_content_".$project_share_object_id."'>".$singleShareObject['share_object_conent']."</textarea>"   
          ."<label>Challenge:</label>"
          ."<textarea class='form-control' rows='5' id='share_object_challenge_".$project_share_object_id."'>".$singleShareObject['share_object_challenge']."</textarea>" 
          ."<label>Comments of homeowner:</label>"
          ."<textarea class='form-control' rows='5' id='share_object_comments_".$project_share_object_id."'>".$singleShareObject['share_object_comments']."</textarea>" 
          ."<label>Rating of homeowner:</label>"
          ."<div style='margin-left:0px;' id='share_object_rating_".$project_share_object_id."' value='".$singleShareObject['share_object_rating']."'></div>"          
          ."</div>"                  
  	  ."<label>Pictures before renovation:&nbsp;&nbsp;<img src='img/btn_add_more.png' style='margin-top:4px;' onClick='showProjectImageList(".$singleShareObject['project_id'].",".$singleShareObject['owner_role'].",1,".$project_share_object_id.")'></label>"
          //."</div>"
          ."<div id='project_share_object_attached_image_1_".$project_share_object_id."'>"
          .$this->getContentOfImageListOfProjectShareObject($project_share_object_id,1)
          ."</div>" 
          ."<div id='project_image_list_zone_1_".$project_share_object_id."' style='border:2px solid #107FC9;display:none'></div>"	  
          ."<label>Pictures after renovation:&nbsp;&nbsp;<img src='img/btn_add_more.png' style='margin-top:4px;' onClick='showProjectImageList(".$singleShareObject['project_id'].",".$singleShareObject['owner_role'].",2,".$project_share_object_id.")'></label>"
          ."<div id='project_share_object_attached_image_2_".$project_share_object_id."'>"
          .$this->getContentOfImageListOfProjectShareObject($project_share_object_id,2)
          ."</div>"          
          ."<div id='project_image_list_zone_2_".$project_share_object_id."' style='border:2px solid #107FC9;display:none'></div>"
          ."<hr>"
          ."<button type='button' class='btn btn-primary' onClick='updateProfileOfProjectShareObject(".$project_share_object_id.")'>Update</button>&nbsp;&nbsp;<button type='button' class='btn info' onClick='closeProjectShareObjectEditor(".$project_share_object_id.")'>Cancel</button>";    
  return $contentOfsingleShareObject;
 }
 
 private function getProjectProfiles($project_id)
 {
  //Profile of completed project includes the following contents:
  //1) Title
  //2) Desc
  //3) average rating
  //4) comments of tasks  
  $rating = 0;
  $rating_count = 0;
  $comments = "";
  $arrayOfCompletedProjectProfile = array();
  $basicProfile = $this->getBasicProfileOfProject($project_id);
  $allRatingsAndComments = $this->getTaskRatingAndCommentsForCompletedProject($basicProfile['project_deal_id']);
  $allRatingsAndComments = array_merge($allRatingsAndComments,$this->getTaskRatingAndCommentsForCompletedProjectOnChanges($project_id));
  foreach($allRatingsAndComments as $ratingAndComment)
  {
   if ($ratingAndComment['rating']>0)
   {
    $rating += $ratingAndComment['rating'];
    $rating_count++;       
   }
   $comments .= $ratingAndComment['review']."\r\n";
  }
  $basicProfile['comments'] = $comments;
  $basicProfile['rating'] = number_format($rating/$rating_count, 1);
  return array("basicProfile"=>$basicProfile);  
 }
 
 private function getBasicProfileOfProject($project_id)
 {
  $basicProfile = array();   
  $String_SQL = "Select * From pogopro_post_project Where post_project_id = ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id]);
  if (!$status)
  {
   echo "[getBasicProfileOfProject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  { 
   while($row=  $status->fetch())
   {
     $basicProfile = array(
      "project_title"=>$row['project_title'],
      "project_desc"=>$row['project_desc'],
      "project_deal_id"=>$row['project_deal_id']   
     );  
   }
  }
  return $basicProfile;
 }
 
 private function getTaskRatingAndCommentsForCompletedProject($project_bid)
 {
  $basicProfile = array();   
  $String_SQL = "Select * From pogopro_project_bid_contruction_tasks Where task_status = 2 and pogopro_project_bid_id = ? Order by construction_task_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_bid]);
  if (!$status)
  {
   echo "[getBasicProfileOfProject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  { 
   while($row=  $status->fetch())
   {
     $basicProfile[] = array(
      "rating"=>$row['rating'],
      "review"=>$row['review']   
     );  
   }
  }
  return $basicProfile;  
 }
 
 private function getTaskRatingAndCommentsForCompletedProjectOnChanges($project_id)
 {
  $basicProfile = array();   
  $String_SQL = "Select a.rating,a.review
                 From pogopro_project_change_tasks a,
                          pogopro_project_change_items b,
                          pogopro_project_change_object c,
                          pogopro_project_change d
                 Where a.construction_item_id = b.construction_object_item_id
                 AND b.construction_object_id =c.construction_object_id
                 AND c.project_change_id = d.project_change_id
                 AND a.task_status = 2
                 AND d.project_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id]);
  if (!$status)
  {
   echo "[getTaskRatingAndCommentsForCompletedProjectOnChanges]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  { 
   while($row=  $status->fetch())
   {
     $basicProfile[] = array(
      "rating"=>$row['rating'],
      "review"=>$row['review']   
     );  
   }
  }
  return $basicProfile;   
 }
         
 function getContentOfNewProjectShareObjectEditor($project_id,$owner_id,$owner_role)
 {
  $profilesOfCompletedProject = $this->getProjectProfiles($project_id);   
  $contentOfsingleShareObject ="<div class='form-group'>"
          ."<label>Subject:</label>"
          ."<input id='share_object_title_".$project_id."' type='text' class='form-control' style='height:32px;' value='".$profilesOfCompletedProject['basicProfile']['project_title']."'>"
          ."<label>Description:</label>"
          ."<textarea class='form-control' rows='5' id='share_object_desc_".$project_id."'>".$profilesOfCompletedProject['basicProfile']['project_desc']."</textarea>"        
          ."</div>"
          ."<label>Challenge:</label>"
          ."<textarea class='form-control' rows='5' id='share_object_challenge_".$project_id."'></textarea>"
          ."<label>Comments of homeowner:</label>"
          ."<textarea class='form-control' rows='5' id='share_object_comments_".$project_id."'>".$profilesOfCompletedProject['basicProfile']['comments']."</textarea>"
          ."<label>Rating of homeowner:</label>"
          ."<div style='margin-left:0px;' id='share_object_rating_".$project_id."' value='".$profilesOfCompletedProject['basicProfile']['rating']."'></div>"          
          ."</div>"          
          ."<div id='project_image_list_zone_before_".$project_share_object_id."' style='display:'>"
          ."<label>Pictures before renovation:</label>"
          .$this->getContentOfImageListWhichUnSelectedByProjectShareObject($project_id, $owner_role, 1,0)
          ."</div>"
          ."<div id='project_image_list_zone_after_".$project_share_object_id."' style='display:'>"
          ."<label>Pictures after renovation:</label>"
          .$this->getContentOfImageListWhichUnSelectedByProjectShareObject($project_id, $owner_role, 2,0)
          ."</div>"          
          ."<hr>"
          ."<button type='button' class='btn btn-primary' onClick='addNewProjectShareObjectRecord(".$project_id.",".$owner_id.",".$owner_role.")'>Add</button>&nbsp;&nbsp;<button type='button' class='btn info' onClick='closeAddNewProjectShareObject(".$project_id.")'>Cancel</button>";    
  return $contentOfsingleShareObject;
 }
 
 function getListOfProjectImagesWhichUnSelectByShareObject($project_id,$owner_role,$share_image_type)
 {
  /*
   * Alogrithm: find all images (A),and already Selected image (S)
   * Get difference (A)-(S)
   */  
  $allUnSelectedProjectImages = array();  
  $allImagesOwnedByProject = array();
  switch ($share_image_type)
  {
   case 1: //Picture before renovation
         {
          $allImagesOwnedByProject = array_merge($allImagesOwnedByProject,$this->getImagesOfProjectFromQuote($project_id));
          $allImagesOwnedByProject = array_merge($allImagesOwnedByProject,$this->getImagesOfProjectFromChanges($project_id));
          $allImagesOwnedByProject = array_merge($allImagesOwnedByProject,$this->getImagesFromProjectGallery($project_id,$owner_role));
          $allSelectedImages = $this->getSelectedImagesBySharedObject($project_id,$owner_role,$share_image_type);
          $allUnSelectedProjectImages = $this->getArrayDiff($allImagesOwnedByProject,$allSelectedImages);
         }
         break;
   case 2: //Picture before renovation
         {
          $allImagesOwnedByProject = array_merge($allImagesOwnedByProject,$this->getImagesOfProjectFromCompletedTasks($project_id));
          //$allImagesOwnedByProject = array_merge($allImagesOwnedByProject,$this->getImagesOfProjectFromChanges($project_id));
          $allImagesOwnedByProject = array_merge($allImagesOwnedByProject,$this->getImagesFromProjectGallery($project_id,$owner_role));
          $allSelectedImages = $this->getSelectedImagesBySharedObject($project_id,$owner_role,$share_image_type);
          $allUnSelectedProjectImages = $this->getArrayDiff($allImagesOwnedByProject,$allSelectedImages);
         }
         break;     
  }
  return $allUnSelectedProjectImages;
 }
 
 private function getArrayDiff($array1,$array2)
 {
  $diff_array = array();   
  foreach ($array1 as $array)
  {
    if (!in_array($array,$array2))
        $diff_array[] = $array;    
  }
  return $diff_array;
 }
 
 private function getSelectedImagesBySharedObject($project_id,$owner_role,$share_image_type)
 {
  $allSelectedProjectImages = array();
  $String_SQL = "Select a.share_image_id,a.share_image_name
                 From pogopro_project_share_image_management a,
                     pogopro_project_share_management b
                 Where a.share_object_id = b.share_object_id
                 AND  b.project_id = ? 
                 AND   b.owner_role = ?    
                 AND  a.share_image_type = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id,$owner_role,$share_image_type]);
 if (!$status)
 {
  echo "[getListOfProjectImagesWhichUnSelectByShareObject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 {
   while ($row=  $status->fetch())
   {
    $allSelectedProjectImages[] = array(
    "gallery_image_id"=>$row['share_image_id'],  
    "image_desc"=>"",//$row['image_desc'],
    "image_name"=>$row['share_image_name']       
    );   
   }    
  }
    return $allSelectedProjectImages;
 }

 function deleteShareImageFromProjectShareObject($project_share_image_id)
 {
  $String_SQL = "Delete From pogopro_project_share_image_management Where project_sharing_image_id = ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_share_image_id]);
  if (!$status)
  {
   echo "[deleteShareImageFromProjectShareObject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   return true;
  }
 }

}//End of class
?>

