<?php
/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
class pogoproProjectImageManipulateManager
{
 private $source_image;
 private $target_image;
 private $target_width;
 private $target_height;
 private $scale_rate;
 private $imagePath;
 private $source_width;
 private $source_height;
 
 function __construct($source_image,$target_image,$target_width,$target_height,$imagePath) 
 {
  $this->source_image =  $source_image;
  $this->target_image =  $target_image;
  $this->target_width =  $target_width;
  $this->target_height = $target_height;
  $this->imagePath = $imagePath;
  
  list($width, $height) = getimagesize($this->imagePath.$this->source_image);
  $this->source_width = $width;
  $this->source_height = $height;
  
  $this->scale_rate = 1;
  if ($width>$this->target_width)
  {
    $this->scale_rate = ($width/$this->target_width);
  }else if ($height>$this->target_height)
  {
    $this->scale_rate = ($height/$this->target_height);  
  }
  $this->target_width = $width/$this->scale_rate;
  $this->target_height = $height/$this->scale_rate;
 } //End of Function _construct 
 
 function resizeImage()
 {
  if ($this->scale_rate==1)
      return true;
  $imageType = strtolower($this->getTypeOfImage($this->source_image));    
  switch ($imageType)
  {
   case  "jpg":
         $source = imagecreatefromjpeg($this->imagePath.$this->source_image);
         break;
   case  "png":
         $source = imagecreatefrompng($this->imagePath.$this->source_image);
         break;     
   case  "gif":
         $source = imagecreatefromgif($this->imagePath.$this->source_image);
         break;      
  }
  $destination = imagecreatetruecolor($this->target_width, $this->target_height);
  imagecopyresampled($destination, $source, 0, 0, 0, 0, $this->target_width, $this->target_height, $this->source_width, $this->source_height);
  $imageType = strtolower($this->getTypeOfImage($this->target_image)); 
  switch ($imageType) 
  {
   case "jpg":
        imagejpeg($destination, $this->imagePath.$this->target_image);
        break;
   case "png":
        imagepng($destination, $this->imagePath.$this->target_image);
        break;    
   case "gif": 
        imagegif($destination, $this->imagePath.$this->target_image);
        break;    
  }
  return true;
 } 
 
 private function getTypeOfImage($imageFileName)
 {
  $fileAttributes = explode(".", $imageFileName);
  return $fileAttributes[1];  
 }
 }//End of class
?>

