<?php
/*
 * Class:Pogopro Project Communication Manager
 * Description:
 * This class will enscape all functions of project communication(Message,Email)
 * 
 */
include_once("pogoproQuoteFunctionManager.php");
include_once("pogoproHelperClass.php");
class pogoproProjectCommunicationManager
{
 private $db_conn;
 private $domain_name;
 private $project_id,$project_title,$project_desc,$project_deal_id;
 private $member_id,$member_salutation,$member_name,$member_email,$member_address;
 private $merchant_id,$merchant_salutation,$merchant_name,$merchant_email;
 private $tasksOfProjectBid =array();
 
 function getProjectTitle()
 {
  return $this->project_title;
 }
 function getProjectId()
 {
  return $this->project_id;
 }
 
 function getProjectDesc()
 {
  return $this->project_desc;   
 }
 
 function getMemberSalutation()
 {
  return $this->merchant_salutation;   
 }
 
 function getMemberName()
 {
  return $this->member_name;   
 }
 
 function getMerchantSalutation()
 {
  return $this->merchant_salutation;   
 }
 
 function getMerchantName()
 {
  return $this->merchant_name;   
 }
 
 function getGender($salutation)
 {
  if ($salutation=='Mr.')
      return "his";
  else
      return "her";
 }
 /*
 function __construct($project_id)
 {
  $this->project_id = $project_id;
  $this->getProjectProfle($this->project_id);
 }*/
 
 function __construct($project_id,$project_bid_id=0)
 {
  $dbconnect_obj = new dbconnection();
  $this->db_conn = $dbconnect_obj->conn;
  $this->project_id = $project_id;
  $this->getProjectProfle($this->project_id,$project_bid_id);
	$pogoproHelperClass = new pogoproHelperClass();
	$this->domain_name = $pogoproHelperClass -> domain_name;
 } 
 
 private function getProjectProfle($project_id,$project_bid_id=0)
 {
  if ($project_bid_id>=0)
  {
      $projectProfile = (new pogoproQuoteFunctionManager())->getProjectProfileAndEmailsOfBuyerAndSeller($project_id,$project_bid_id);
      if ($this->project_id==0) 
          $this->project_id = $projectProfile['project_id'];
      $this->project_title = $projectProfile['project_title'];
      $this->project_desc = $projectProfile['project_desc'];
      $this->project_deal_id = $projectProfile['project_bid_id'];
      //Project Buyer info
      $this->member_id = $projectProfile['member_id'];
      $this->member_salutation= $projectProfile['m_salutation'];
      $this->member_name= $projectProfile['m_name'];
      $this->member_email= $projectProfile['m_email'];
      $this->member_address = $projectProfile['m_address'];
      //Project Professional info
      $this->merchant_id = $projectProfile['merchant_id'];
      $this->merchant_salutation = $projectProfile['p_salutation'];
      $this->merchant_name = $projectProfile['p_name'];
      $this->merchant_email = $projectProfile['p_email'];
  }
 }
 
 function getProjectBidTasks($project_bid_id)
 {
     
 }
 
 function setMemberId($member_id)
 {
  $this->member_id = $member_id;   
 }
 
 function getMemberId()
 {
  return $this->member_id;   
 }
 
 function setMerchantId($merchant_id)
 {
  $this->merchant_id = $merchant_id;   
 }
 
 function setMerchantSalutation($merchant_salutation)
 {
  $this->merchant_salutation = $merchant_salutation;   
 }
 
 function setMerchantName($merchant_name)
 {
  $this->merchant_name = $merchant_name;   
 }
 
 function setMerchantEmail($merchant_email)
 {
  $this->merchant_email = $merchant_email;   
 }
 /**
  * sendProjectMessage
  * @param type $message_body
  * @param type $direction: 0 - From member to merchant,1 - From merchant to member
  */
 function sendProjectMessage($message_body,$direction)
 {
  $ps_manager = new pogoproProfessionalServiceManager();   
  switch ($direction)
  {
   case 0:
       $ps_manager->pushProjectMessageIntoHub(
               $this->project_id, 
               $this->member_id, 
               $this->merchant_id, 
               $message_body);
        break;
   case 1:
       $ps_manager->pushProjectMessageIntoHub(
               $this->project_id,
               $this->merchant_id,
               $this->member_id,                 
               $message_body);       
        break;
  }
 }
 /**
  * Function sendEmailToProjectBuyer
  * @param type $email_subject
  * @param type $email_desc :(description of email contents)
  * @param type $email_content_divisions : (in this part: use <p></p> and <div></div> to show contents parts)
  */
 function sendEmailToProjectBuyer($email_subject,$email_desc,$email_content_divisions)
 {
  $client_name = $this->member_salutation." ".$this->member_name;   
  $email_subject = str_replace("'", "\'", $email_subject);
  $email_content = "<div>"
                ."<p style='margin-left:8px;'>".$client_name.":</p>"
                ."<p style='margin-left:8px;'>".$email_desc."</p>"
                ."<table>"
                ."<tr>"
                ."<td style='width:8%' valign='top'><a href='http://".$this->domain_name."'><img style='width:115px;height:40px' src='http://".$this->domain_name."/v2/img/logo2.png'></a></td>"
                ."<td style='width:92%'>"
                .$email_content_divisions
                ."</td>"
                ."</tr>"
                ."<table>"
                ."</div>"
                ."<div style='margin-top:16px;'>"
                ."<p style='font-size:24px;color:#3c763d'>Thanks for using ".$this->domain_name." service.</p>"
                ."</div>";
   $email_content = str_replace("'", "\'", $email_content);
   (new pogoproEmailPoolManager())->addEmailSendRequestIntoPool
    (
     POGOPROMailSENDER,
     $this->member_email,
     $email_subject,
     $email_content       
    );     
 }
 /**
  * sendEmailToProjectMerchant
  * @param type $email_subject
  * @param type $email_desc : (description of email contents)
  * @param type $email_content_divisions : (in this part: use <p></p> and <div></div> to show contents parts)
  */
 function sendEmailToProjectMerchant($email_subject,$email_desc,$email_content_divisions)
 {
  $client_name = $this->merchant_salutation." ".$this->merchant_name;   
  $email_subject = str_replace("'", "\'", $email_subject);
  $email_content = "<div>"
                ."<p style='margin-left:8px;'>".$client_name.":</p>"
                ."<p style='margin-left:8px;'>".$email_desc."</p>"
                ."<table>"
                ."<tr>"
                ."<td style='width:8%' valign='top'><a href='http://".$this->domain_name."'><img style='width:115px;height:40px' src='http://".$this->domain_name."/v2/img/logo2.png'></a></td>"
                ."<td style='width:92%'>"
                .$email_content_divisions
                ."</td>"
                ."</tr>"
                ."<table>"
                ."</div>"
                ."<div style='margin-top:16px;'>"
                ."<p style='font-size:24px;color:#3c763d'>Thanks for using ".$this->domain_name." service.</p>"
                ."</div>";
   $email_content = str_replace("'", "\'", $email_content);

   (new pogoproEmailPoolManager())->addEmailSendRequestIntoPool
    (
     POGOPROMailSENDER,
     $this->merchant_email,
     $email_subject,
     $email_content       
    );     
 }

 function getTaskNameById($project_task_id)
 {
  $project_task_name = "";   
  $String_SQL = "Select b.construction_task_name
                 From pogopro_project_bid_contruction_tasks a,pogopro_construction_task_definition b
                 Where a.construction_task_definition_id = b.pogopro_construction_task_id
                 AND a.construction_task_id = '".$project_task_id."'"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute();
  if (!$status)
  {
   echo "[getTaskNameById]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   while ($row=  $status->fetch())
   {
    $project_task_name = $row['construction_task_name'];   
   }        
  }

  return $project_task_name;
 }
 
 function getListOfInvitedProsByProjectId($project_id)
 {
  $arrayOfInvitedPros = array();   
  $String_SQL = "Select a.merchant_id,c.salutation,c.name,c.email,d.project_title,d.project_desc
                 From pogopro_posted_project_bid a, rv_merchants b,customer_accounts c, pogopro_post_project d
                 Where a.posted_project_id = '".$project_id."' AND 
                       a.merchant_id = b.id AND 
                       b.member_id = c.id AND 
                       a.posted_project_id = d.post_project_id
                 Order by a.merchant_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute();
  if (!$status)
  {
   echo "[getListOfInvitedProsByProjectId]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   while ($row=  $status->fetch())
   {
    $arrayOfInvitedPros[] = array(
        "merchant_id"=>$row['merchant_id'],
        "merchant_salutation"=>$row['salutation'],
        "merchant_name"=>$row['name'],   
        "merchant_email"=>$row['email'],
        "project_title"=>$row['project_title'],
        "project_desc"=>$row['project_desc']
     );   
   }        
  }
  return $arrayOfInvitedPros; 
 }
}
?>

