<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
//include_once("../pogo_utility/pogo_pro_utility_functions.php");
include_once("$_SERVER[DOCUMENT_ROOT]/pogo_utility/pogo_pro_utility_functions.php");
//include_once("../v2/inc/vars.php"); 
include_once("$_SERVER[DOCUMENT_ROOT]/v2/inc/vars.php");
class pogoproProjectChangeManager
{
 private $db_conn;
 function __construct($conn=null){ //set db connection in constructor
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection();
		$this->db_conn = $dbconnect_obj->conn;
	}
 }	
 function addProjectChangeRequest(
         $project_change_title,
         $project_change_desc,
         $project_id
         ) 
 {
  $String_SQL = "Insert into pogopro_project_change(
          project_change_title,
          project_change_desc,
          project_id,
          build_datetime) values(?,?,?,?);";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_change_title,$project_change_desc,$project_id,date('Y-m-d H:i:s')]);
  if (!$status)
   {
    echo "MySQL Query Error:".$status->errorInfo().":SQL=>".$String_SQL; 
    return false;
   }else
   {
    return $this->db_conn->lastInsertId();     
   }
 }
 
 function updateProjectChangeRequest(
                $project_change_id, 
                $project_change_title,
                $project_change_desc
         ) 
 {
  $String_SQL = "Update pogopro_project_change 
          Set project_change_title =  ?,project_change_desc= ? Where project_change_id= ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_change_title,$project_change_desc,$project_change_id]);
  if (!$status)
   {
    echo "MySQL Query Error:".$status->errorInfo().":SQL=>".$String_SQL; 
    return false;
   }else
   {
    return true;     
   }
 }
 
 function submitProjectChange($project_change_id)
 {
  $String_SQL = "Update pogopro_project_change set status_of_change = 1,submit_datetime = ? Where project_change_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([date('Y-m-d H:i:s'),$project_change_id]);
  if (!$status)
   {
    echo "MySQL Query Error:".$status->errorInfo().":SQL=>".$String_SQL; 
    return false;
   }else
   {
    return true;     
   }    
 }
 
 function deleteProjectChangeRequest($project_change_id)
 {
  $String_SQL = "Delete From pogopro_project_change Where project_change_id= ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_change_id]);
  if (!$status)
   {
    echo "MySQL Query Error:".$status->errorInfo().":SQL=>".$String_SQL; 
    return false;
   }else
   {
    return true;     
   }     
 }
 
function addConstructionObject($project_change_id,
                               $construction_object_name,
                               $construction_catagoey_id)
{
 $service_category_ids = explode(",",$construction_catagoey_id);
 $construction_object_names = explode("[]",$construction_object_name);    
 
 $String_SQL = "Insert into pogopro_project_change_object(project_change_id,construction_object_name,construction_catagoey_id) "
            . "values";
 $counter = count($service_category_ids);
 for ($k=0;$k<$counter;$k++)
 {
  $String_SQL .="(".$project_change_id.",'".$construction_object_names[$k]."',".$service_category_ids[$k].")";   
  if (($k+1)<$counter)
      $String_SQL .=",";
 }

 $status = $this->db_conn->query($String_SQL);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;
 }else
 {
   if ($counter==1)
       return $this->db_conn->lastInsertId();
   else return true;
 }   
}

function deleteConstructionObject($construction_object_id)
{
 $String_SQL = "Delete From pogopro_project_change_object Where construction_object_id= ?";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$construction_object_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 { 
   return true;   
 } 
}

function getAllChangeObjectsUnderChangeId($project_change_id)
{
 $allChangeObjectsUnderChangeId  = array();
 $String_SQL = "Select construction_object_id From pogopro_project_change_object Where project_change_id= ?";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_change_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 { 
   while ($row=  $status->fetch())
   {
    $allChangeObjectsUnderChangeId[] = $row['construction_object_id'];   
   }
   return implode(",",$allChangeObjectsUnderChangeId);   
 }
}

function addConstructionItem($construction_object_id,$selected_items)
{
 $String_SQL = "Insert into pogopro_project_change_items(construction_object_id,pogopro_construction_item_id) values";
 $numOfItems = count($selected_items);
 $String_vales = "";
 for ($i=0;$i<$numOfItems;$i++)
 {
  $String_vales .= "(".$construction_object_id.",".$selected_items[$i]."),";   
 }
 $String_vales = substr($String_vales, 0,-1);
 $String_SQL .= $String_vales.";";

 $status = $this->db_conn->query($String_SQL);

 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 { 
   if ($numOfItems==1)
       return $this->db_conn->lastInsertId();
   else
       return true;   
 } 
}

 function deletePogoproConstructionItem($construct_item_id)
 {
    $String_SQL = "Delete From pogopro_project_change_items Where construction_object_item_id= ?";
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$project_change_id]);
    if (!$status)
    {
     echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
    }else
    { 
     return true;   
    }       
 }
 
 function refreshAttributesOfConstructObject($construction_object_id)
 {
 	//number of items
 	$numOfItems = 0;
 	$numOfItemHasTasks = 0;
 	$numOfItemHasPhotoes = 0;
 	$numOfTasks =0;
 	$numOfUncompltedTasks = 0;
 
 	$String_SQL = "Select count(*) as count
                From pogopro_project_change_items a
                Where a.status = 0 and a.construction_object_id = ?";
 	//echo $String_SQL;
 	$status = $this->db_conn->prepare($String_SQL);
	$status->execute([$construction_object_id]);
    if (!$status)
 	{
 		echo "[isProjectDetailsMissing]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
 	}else
 	{
 		$row = $status->fetch();
 		$numOfItems = $row['count'];
 	}
 
 	//the number of rows is how many items has image
 	$String_SQL = "Select count(a.construction_item_id)
            From pogopro_project_change_item_images a,pogopro_project_change_items b
            Where a.construction_item_id = b.construction_object_item_id AND b.status =0 AND b.construction_object_id = ? Group by a.construction_item_id";
 	//echo $String_SQL;
 	$status = $this->db_conn->prepare($String_SQL);
	$status->execute([$construction_object_id]);
 	if (!$status)
 	{
 		echo "[isProjectDetailsMissing]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
 	}else
 	{
 		$numOfItemHasPhotoes = $status->rowCount();
 	}
 
 	//the number of rows is how many items has tasks
 	$String_SQL = "Select count(a.construction_item_id)
            From pogopro_project_change_tasks a,pogopro_project_change_items b
            Where a.task_status = 0 and a.construction_item_id = b.construction_object_item_id AND b.construction_object_id = ? Group by a.construction_item_id";
 	//echo $String_SQL;
 	$status = $this->db_conn->prepare($String_SQL);
	$status->execute([$construction_object_id]);
 	if (!$status)
 	{
 		echo "[isProjectDetailsMissing]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
 	}else
 	{
 		$numOfItemHasTasks = $status->rowCount();
 	}
 
 	//tasks completed
 	$String_SQL = "Select count(*) as count
           From pogopro_project_change_tasks a,pogopro_project_change_items b
           Where a.task_status = 0 AND a.construction_item_id = b.construction_object_item_id
	   AND ((a.construction_task_measure_length <> 0.00
	   AND a.construction_task_measure_width <> 0.00) OR
	   a.construction_task_ea_quantity <> 0)
	   AND b.construction_object_id = ?";
 	//echo $String_SQL;
 	$status = $this->db_conn->prepare($String_SQL);
	$status->execute([$construction_object_id]);
 	if (!$status)
 	{
 		echo "[isProjectDetailsMissing]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
 	}else
 	{
 		$row = $status->fetch();
 		$numOfTasks = $row['count'];
 	}
 
 	//Task uncompleted
 	$String_SQL = "Select count(*) as count
           From pogopro_project_change_tasks a,pogopro_project_change_items b
           Where a.task_status = 0 AND a.construction_item_id = b.construction_object_item_id
	   AND ((a.construction_task_measure_length = 0.00
	   AND a.construction_task_measure_width = 0.00) AND
	   a.construction_task_ea_quantity = 0)
	   AND b.construction_object_id = ?";
 	//echo $String_SQL;
 	$status = $this->db_conn->prepare($String_SQL);
	$status->execute([$construction_object_id]);
 	if (!$status)
 	{
 		echo "[isProjectDetailsMissing]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
 	}else
 	{
 		$row = $status->fetch();
 		$numOfUncompltedTasks = $row['count'];
 	}
 	//total number of tasks
 	$numOfTasks += $numOfUncompltedTasks;
 
 	$String_SQL = "Update   "
 			. "Set contain_items= ?"
 			.", contain_item_has_tasks= ?"
 			.",contain_item_has_photos= ?"
 			.",contain_tasks= ?"
 			.",contain_uncompleted_tasks= ?"
 			." Where construction_object_id=?";
 			//echo $String_SQL;
 			$status = $this->db_conn->prepare($numOfItems);
			$status->execute([$numOfItems,$numOfItemHasTasks,$numOfItemHasPhotoes,$numOfTasks,$numOfUncompltedTasks,$construction_object_id]);
 			if (!$status)
 			{
 				echo "[isProjectDetailsMissing]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
 			}else
 			{
 				//$row = $status->fetch();
 				//$numOfUncompltedTasks = $row['count'];
 				//return true;
 			}
 			return $numOfItems;
 }
 
 
 function updateTaskNotification($task_id,$task_notification)
 {
  $String_SQL = "Update pogopro_project_change_tasks Set task_notification= ? Where construction_task_id= ?";  
  echo $String_SQL;
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$task_notification,$task_id]);
  if (!$status)
  {
    echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  { 
    return true;   
  }  
 }
 
private function getReferenceCostFromTaskDefinition($defined_task_id)
{
 $String_SQL = "Select * From pogopro_construction_task_definition Where pogopro_construction_task_id = ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$defined_task_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 { 
    $row=  $status->fetch();
    $taskDefinition = array(
      "pogopro_construction_task_id"=>$row['pogopro_construction_task_id'],
      "construction_task_name"=>$row['construction_task_name'],
      "construction_task_desc"=>$row['construction_task_desc'], 
      "pogopro_construction_item_id"=>$row['pogopro_construction_item_id'],
      "task_measurement_unit"=>$row['task_measurement_unit'],
      "material_unit_cost"=>$row['task_material_cost_per_unit'], 
      "labor_unit_cost"=>$row['task_labor_cost_per_unit']
     );  
   return $taskDefinition;
 }
}

function getConstructionObjectIdByConstructionItemId($construction_item_id)
{
 $String_SQL = "Select a.construction_object_id
                From pogopro_project_change_items a
                Where a.construction_object_item_id = ?";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$construction_item_id]);
 if (!$status)
 {
  echo "[getConstructionObjectIdByConstructionItemId]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 {
  $row = $status->fetch();
  $construction_object_id = $row['construction_object_id']; 
  return $construction_object_id;
 }
}

function getConstructionObjectIdByConstructionTaskId($construction_task_id)
{
 $String_SQL = "Select b.construction_object_id
                From pogopro_project_change_tasks a, pogopro_project_change_items b
                Where a.construction_item_id = b.construction_object_item_id AND  
		a.construction_task_id = ?";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$construction_task_id]);
 if (!$status)
 {
  echo "[getConstructionObjectIdByConstructionTaskId]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 {
  $row = $status->fetch();
  $construction_object_id = $row['construction_object_id']; 
  return $construction_object_id;
 }    
}

function getConstructionItemIdByTaskId($construction_task_id)
{
 $construction_item_id = 0;
 $String_SQL = "Select construction_item_id From pogopro_project_change_tasks Where construction_task_id= ?";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$construction_task_id]);
 if (!$status)
 {
  echo "[getConstructionItemIdByTaskId]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 {
  while ($row=  $status->fetch())
  {
   $construction_item_id = $row['construction_item_id'];   
  }
 }
 return $construction_item_id;
}

function addContructionTaskWithReferenceCost(
        $construction_item_id,
        $construction_task_ids,
        $task_usages,
        $task_cost_customs)
{
 $new_add_task_ids = array();   
 $numOfItems = count($construction_task_ids);
 for ($i=0;$i<$numOfItems;$i++)
 {
      $String_SQL = "Insert into pogopro_project_change_tasks(construction_item_id,construction_task_definition_id,reference_material_unit_cost,reference_labor_unit_cost,task_start_date,task_end_date";
      $reference_costs = $this->getReferenceCostFromTaskDefinition($construction_task_ids[$i]);
      $task_usgae= explode(":",$task_usages[$i]);
      $unitName = $task_usgae[0];
      $custom_cost_task = explode(":",$task_cost_customs[$i]);
      if ($custom_cost_task[0]>0.00)
          $reference_costs['material_unit_cost'] = $custom_cost_task[0];
      if (($custom_cost_task[1]>0.00))
          $reference_costs['labor_unit_cost'] = $custom_cost_task[1];      
      
      if ($unitName=="SF"||$unitName=="SQ"||$unitName=="SI")
      {
        $String_SQL .=",construction_task_measure_length,construction_task_measure_width) values";
        $String_SQL .= "(".$construction_item_id.",".$construction_task_ids[$i].",".$reference_costs['material_unit_cost'].",".$reference_costs['labor_unit_cost'].",'".date('Y-m-d')."','".date('Y-m-d')."',".$task_usgae[1].",".$task_usgae[2].")";
      }else if ($unitName=="BF"||$unitName=="CF"||$unitName=="CI"||$unitName=="CY")
      {
        $String_SQL .=",construction_task_measure_length,construction_task_measure_width,construction_task_measure_height) values";
        $String_SQL .= "(".$construction_item_id.",".$construction_task_ids[$i].",".$reference_costs['material_unit_cost'].",".$reference_costs['labor_unit_cost'].",'".date('Y-m-d')."','".date('Y-m-d')."',".$task_usgae[1].",".$task_usgae[2].",".$task_usgae[3].")";          
      }else
      {
         $String_SQL .=",construction_task_ea_quantity) values"; 
         $String_SQL .= "(".$construction_item_id.",".$construction_task_ids[$i].",".$reference_costs['material_unit_cost'].",".$reference_costs['labor_unit_cost'].",'".date('Y-m-d')."','".date('Y-m-d')."',".$task_usgae[1].")";          
      }

      $status = $this->db_conn->query($String_SQL);
      if (!$status)
      {
        echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;
      }else
      {
       $new_add_task_ids[] = $this->db_conn->lastInsertId();
      }
 }
  return $new_add_task_ids;     
} 

 function deletePogoproConstructionTask($construction_task_id)
 {
    $String_SQL = "Delete From pogopro_project_change_tasks Where construction_task_id = ?";
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$construction_task_id]);
    if (!$status)
    {
     echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
    }else
    { 
     return true;   
    }      
 }
function  updatePogoproConstructionTaskQuantity($construction_task_id,
                                                $task_quantity)
{
 $String_SQL = "Update pogopro_project_change_tasks set construction_task_ea_quantity = ? Where construction_task_id= ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$task_quantity,$construction_task_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 { 
   return true;   
 } 
}

function  updatePogoproConstructionTaskArea($construction_task_id,
                                            $task_length,
                                            $task_width)
{
 $String_SQL = "Update pogopro_project_change_tasks set construction_task_measure_length = ?,construction_task_measure_width = ? Where construction_task_id= ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$task_length,$task_width,$construction_task_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 { 
   return true;   
 } 
}

function  updatePogoproConstructionTaskVolume($construction_task_id,
                                            $task_length,
                                            $task_width,
                                            $task_height)
{
 $String_SQL = "Update pogopro_project_change_tasks set construction_task_measure_length = ?,construction_task_measure_width = ?,construction_task_measure_height = ? Where construction_task_id= ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$task_length,$task_width,$task_height,$construction_task_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
 }else
 { 
   return true;   
 } 
}

function updatePogoproConstructionTaskMaterialUnitCost($construction_task_id,$new_material_unit_cost)
{
 $String_SQL = "Update pogopro_project_change_tasks Set reference_material_unit_cost = ? Where construction_task_id = ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$new_material_unit_cost,$construction_task_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
   return false;
 }else
 {
   return true;
 }    
}

function updatePogoproConstructionTaskLaborUnitCostByOwner($construction_task_id,$owner_known_labor_unit_cost)
{
 $String_SQL = "Update pogopro_project_change_tasks Set reference_labor_unit_cost = ? Where construction_task_id = ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$owner_known_labor_unit_cost,$construction_task_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
   return false;
 }else
 {
   return true;
 }    
}
function addPictureToConstructionItem($item_id,$image_name,$image_desc)
{
 $String_SQL = "Insert into pogopro_project_change_item_images(construction_item_id,image_name,image_desc) "
         . "values(?,?,?)";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$item_id,$image_name,$image_desc]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
   return false;
 }else
 {
   return true;
 }
}

function removePictureFromItem($item_image_id)
{
 $String_SQL = "Delete From pogopro_project_change_item_images Where item_image_id = ?";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$item_image_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
   return false;
 }else
 {
   return true;
 } 
}

function getContentOfItemPictures($item_id)
{
 $String_Content="";   
 $allPictures = $this->getListOfPictureForSelectedItem($item_id);
 $numOfPictures = count($allPictures);
 $numOfMaxPictureInOneBlock = 8;
 $lessThanMax = $numOfPictures % $numOfMaxPictureInOneBlock; 
 $numOfULBlocks = ($numOfPictures-$lessThanMax)/$numOfMaxPictureInOneBlock + 1;
 for ($i=0;$i<$numOfULBlocks;$i++)
 {
    $String_Content.="<ul class='navlist'>";
    $startPoint =$i*$numOfMaxPictureInOneBlock;
    $endPoint = ($i+1)*$numOfMaxPictureInOneBlock;    
    if ($endPoint>$numOfPictures) 
          $endPoint=$numOfPictures;
    for ($k=$startPoint;$k<$endPoint;$k++)
      {
       $String_Content.="<li><img id='item_pic_".$allPictures[$k]['construction_item_id']."_".$allPictures[$k]['item_image_id']."' style='width:64px;height:48px;' src='pogopro_renovation/Change_images/".$allPictures[$k]['image_name']."' onclick='showLargeImage(".$allPictures[$k]['construction_item_id'].",\"".$allPictures[$k]['construction_item_id']."_".$allPictures[$k]['item_image_id']."\",\"".$allPictures[$k]['image_name']."\")' title='".$allPictures[$k]['image_desc']."'><img src='projectmanager_icons/btnClose_16.png' style='margin-bottom: 32px;width:16px;height:16px;' onclick='removePictureFromConstructionItem(".$allPictures[$k]['item_image_id'].",".$allPictures[$k]['construction_item_id'].")'></li>";
      }  
    $String_Content.="</ul>";
 }
 return $String_Content;
}

private function getListOfPictureForSelectedItem($item_id)
{
 $allPictures = array();   
 $String_SQL = "Select * From pogopro_project_change_item_images Where construction_item_id = ? Order by item_image_id";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$item_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
   return false;
 }else
 {
   while ($row=  $status->fetch())
   {
    $allPictures[] = array(
     "item_image_id"=>$row['item_image_id'],
     "construction_item_id"=>$row['construction_item_id'],
     "image_name"=>$row['image_name'],
     "image_desc"=>$row['image_desc']   
    );   
   }
   return $allPictures;
 }  
}
function updateStartDateOfTaskOfProjectBid($task_id,$start_date)
{
 $String_SQL = "Update pogopro_project_change_tasks  "
             . "Set task_start_date = ? Where construction_task_id = ?";
             //." AND pogopro_project_bid_id = ".$project_bid_id;  
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$start_date,$task_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
   return false;
 }else
 { 
  return true;   
 }
}
function updateEndDateOfTaskOfProjectBid($task_id,$end_date)
{
 $String_SQL = "Update pogopro_project_change_tasks  "
             . "Set task_end_date = ? Where construction_task_id = ?";
             //." AND pogopro_project_bid_id = ".$project_bid_id;  
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$end_date,$task_id]);
 if (!$status)
 {
   echo "Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
   return false;
 }else
 { 
  return true;   
 }
}
/*
function testClearExContract($project_change_id)
{
 $allIDs = $this->getProjectAndItsBidIdsByProjectChangeId($project_change_id);   
 $project_bid_id = $allIDs['project_bid_id'];
 //$this->updateProjectBidPaymentScheduleStatus($project_bid_id,1,0); //active to expired
 //$this->updateProjectBidPaymentScheduleStatus($project_bid_id,-1,1);//tmp to active
 //$this->updateProjectBidContrstuctionTasksList($project_change_id);
 //clean payments for ex-contract
 //Step 1: if (buyer paid less , then send invoice to ask buyer to pay left part
 $buyerCredit = $this->getBuyerCredit($project_bid_id);
 if ($buyerCredit<0)
 {
  //Send invoice and add receivable record  
  $ppcm = new pogoproProjectAccountingManager();   
  $project_ar_title = "Last payment of project before change.";
  $project_ar_desc = $project_ar_title;
  $project_ar_amount = $buyerCredit*(-1);
  $customTaxRates = $ppcm->getPogoproProjectBidCustomTaxRates($project_bid_id);
  $total_tax_rate = 0.00;
  foreach ($customTaxRates as $customTaxRate)
  $total_tax_rate += $customTaxRate['custome_tax_rate_value'];  
  $tax_amount = $project_ar_amount * $total_tax_rate;  
  $pogopro_project_ar_transaction_id = $ppcm->addPogoproProjectReceivableRecord(
          $allIDs['project_id'], 
          $project_ar_title, 
          $project_ar_desc, 
          $project_ar_amount, 
          $tax_amount);  
  //Send invoice
  $issue_date = date('Y-m-d');
  $start_date = strtotime($issue_date);
  $business_days = PAYMENT_DUE_DAYS;
  $end_date =  date('Y-m-d', strtotime($business_days, $start_date));
  $invoiceSending = array(
  "project_id"=>$allIDs['project_id'], 
  "project_bid_id"=>$project_bid_id,
  "transaction_id"=>$pogopro_project_ar_transaction_id,
  "payment_schedule_desc"=>$project_ar_title,
  "payment_schedule_amount"=>$project_ar_amount, 
  "send_invoice_date"=>$issue_date,
  "payment_schedule_date"=>$end_date      
  );
  (new pogoproProfessionalServiceManager())->getPogoproProjectPaymentInvoice($invoiceSending, false);    
}
 $overPaidCredit = $this->getOverPaidCredit($project_bid_id);
 if ($overPaidCredit<0)
 {
  //issue payable record to pay pro for ex-completed tasks. 
  $ppcm = new pogoproProjectAccountingManager();    
  $project_ap_title = "Last payment of project before change.";
  $project_ap_desc = $project_ap_title;
  $project_ap_amount = $overPaidCredit*(-1);  
  $customTaxRates = $ppcm->getPogoproProjectBidCustomTaxRates($project_bid_id);
  $total_tax_rate = 0.00;
  foreach ($customTaxRates as $customTaxRate)
  $total_tax_rate += $customTaxRate['custome_tax_rate_value'];  
  $tax_amount = $project_ap_amount * $total_tax_rate;  
  
  (new pogoproTaskPaymentManager())->addPogoproAccountingPayableRecord(
          $allIDs['project_id'], 
          $project_bid_id, 
          $project_ap_title, 
          $project_ap_desc, 
          $project_ap_amount, 
          $tax_amount);   
 }
}*/ 

function actionOnApprovedProjectChange($project_change_id)
{
 $allIDs = $this->getProjectAndItsBidIdsByProjectChangeId($project_change_id);   
 $project_bid_id = $allIDs['project_bid_id'];
 $this->updateProjectBidPaymentScheduleStatus($project_bid_id,1,0); //active to expired
 $this->updateProjectBidPaymentScheduleStatus($project_bid_id,-1,1);//tmp to active
 $this->updateProjectBidContrstuctionTasksList($project_change_id);
 //clean payments for ex-contract
 //Step 1: if (buyer paid less , then send invoice to ask buyer to pay left part
 $buyerCredit = $this->getBuyerCredit($project_bid_id);
 if ($buyerCredit<0)
 {
  //Send invoice and add receivable record  
  $ppcm = new pogoproProjectAccountingManager();   
  $project_ar_title = "Last payment of project before change.";
  $project_ar_desc = $project_ar_title;
  $project_ar_amount = $buyerCredit*(-1);
  $customTaxRates = $ppcm->getPogoproProjectBidCustomTaxRates($project_bid_id);
  $total_tax_rate = 0.00;
  foreach ($customTaxRates as $customTaxRate)
  $total_tax_rate += $customTaxRate['custome_tax_rate_value'];  
  $tax_amount = $project_ar_amount * $total_tax_rate;  
  $pogopro_project_ar_transaction_id = $ppcm->addPogoproProjectReceivableRecord(
          $allIDs['project_id'], 
          $project_ar_title, 
          $project_ar_desc, 
          $project_ar_amount, 
          $tax_amount);  
  //Send invoice
  $issue_date = date('Y-m-d');
  $start_date = strtotime($issue_date);
  $business_days = PAYMENT_DUE_DAYS;
  $end_date =  date('Y-m-d', strtotime($business_days, $start_date));
  $invoiceSending = array(
  "project_id"=>$allIDs['project_id'], 
  "project_bid_id"=>$project_bid_id,
  "transaction_id"=>$pogopro_project_ar_transaction_id,
  "payment_schedule_desc"=>$project_ar_title,
  "payment_schedule_amount"=>$project_ar_amount, 
  "send_invoice_date"=>$issue_date,
  "payment_schedule_date"=>$end_date      
  );
  (new pogoproProfessionalServiceManager())->getPogoproProjectPaymentInvoice($invoiceSending, false);
 }
 
 $overPaidCredit = $this->getOverPaidCredit($project_bid_id);
 if ($overPaidCredit<0)
 {
  //issue payable record to pay pro for ex-completed tasks. 
  $ppcm = new pogoproProjectAccountingManager();    
  $project_ap_title = "Last payment of project before change.";
  $project_ap_desc = $project_ap_title;
  $project_ap_amount = $overPaidCredit*(-1);  
  $customTaxRates = $ppcm->getPogoproProjectBidCustomTaxRates($project_bid_id);
  $total_tax_rate = 0.00;
  foreach ($customTaxRates as $customTaxRate)
  $total_tax_rate += $customTaxRate['custome_tax_rate_value'];  
  $tax_amount = $project_ap_amount * $total_tax_rate;  
  
  (new pogoproTaskPaymentManager())->addPogoproAccountingPayableRecord(
          $allIDs['project_id'], 
          $project_bid_id, 
          $project_ap_title, 
          $project_ap_desc, 
          $project_ap_amount, 
          $tax_amount);   
 }
 //Step 2: If (pogo.pro paid less, then issue payable record to pay pro for completed tasks
 //Set invoice send date:
 $this->updateProjectDealPaymentsInvoiceIssueDate($project_bid_id);
 $this->cleanProjectTasksFromTmpTable($project_bid_id);
}

function getBuyerCredit($project_bid_id)
{
 $buyerCredit = 0.00;   
 $String_SQL = "Select a.project_buyer_credit 
                From pogopro_project_accounting_buyer_credit a,pogopro_post_project b 
                Where a.project_id = b.post_project_id AND b.project_deal_id = ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_bid_id]);
 if (!$status)
 {
   echo "[getBuyerCredit]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
 }else
 { 
  while ($row=  $status->fetch())
  {
    $buyerCredit = $row['project_buyer_credit'];  
  }
 }
 return $buyerCredit;
}

function getOverPaidCredit($project_bid_id)
{
 $overPaidCredit = 0.00;   
 $String_SQL = "Select a.overpaid_amount
                From pogopro_project_account_pogo_credit a,pogopro_post_project b
                Where a.project_id = b.post_project_id AND b.project_deal_id = '".$project_bid_id."'"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute();
 if (!$status)
 {
   echo "[getOverPaidCredit]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
 }else
 { 
  while ($row=  $status->fetch())
  {
    $overPaidCredit = $row['overpaid_amount'];  
  }
 }
 return $overPaidCredit;    
}

private function updateProjectDealPaymentsInvoiceIssueDate($project_bid_id)
{
  $allPaymentSchedules = (new pogoproProjectAccountingManager())->getListOfPogoproProjectBidPaymentSchedule($project_bid_id); 
  foreach ($allPaymentSchedules as $paymentSchedule)
  {
   $today = date('Y-m-d');  
   $issue_date = $paymentSchedule['payment_schedule_date'];
   $daysBetweenTodayAndScheduleDate = (new PogoProUtilityManager())->getDaysBetweenTwoDates($today, $issue_date);
   $start_date = strtotime($issue_date);
   $business_days = SEND_INVOICE_DAYS;
   if ($daysBetweenTodayAndScheduleDate<7)
   {
    if ($daysBetweenTodayAndScheduleDate==0) 
        $business_days = "+1 day"; 
    else if ($daysBetweenTodayAndScheduleDate==1)
        $business_days = "0 day";
    else
    {
        $b_dates = $daysBetweenTodayAndScheduleDate - 1;
        $business_days = "-$b_dates day";
    }
   }
   $end_date =  date('Y-m-d', strtotime($business_days, $start_date));           
   $this->setPogoproAccountingReceiavableInvoiceSendDate(
           $paymentSchedule['custom_payment_schedule_id'],
           $end_date);   
  }
 }
 
 private function setPogoproAccountingReceiavableInvoiceSendDate($custom_payment_schedule_id,$send_invoice_date)
 {
  $String_SQL = "Update pogopro_project_bid_payment_scheule set send_invoice_date = '".$send_invoice_date."' Where custom_payment_schedule_id = '".$custom_payment_schedule_id."'"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute();
  if (!$status)
  {
   echo "Query error[setPogoproAccountingReceiavableInvoiceSendDate]:".$status->errorInfo()." with SQL:".$String_SQL;  
   return false;
  }else
  { 
    return true;   
  }  
 }
 
private function updateProjectBidPaymentScheduleStatus($project_bid_id,$old_status,$new_status)
{
 $String_SQL = "Update pogopro_project_bid_payment_scheule Set status = ? Where project_bid_id = ? AND status = ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$new_status,$project_bid_id,$old_status]);
 if (!$status)
 {
  echo "Query error[updateProjectBidPaymentScheduleStatus]:".$status->errorInfo()." with SQL:".$String_SQL; 
  return false;
 }else
 {
  return true;   
 } 
}

function updateProjectBidContrstuctionTasksList($project_change_id,$table='pogopro_project_bid_contruction_tasks')
{
 //Get project bid id by project change id
 $project_bid_id = $this->getProjectBidIdByProjectChangeId($project_change_id);
 $allChangedTasks = $this->getAllTasksOfProjectChangeByChangeId($project_change_id);
 foreach ($allChangedTasks as $changedTask)
 {
  //cancelProjectBidConstructionTask
  if ($changedTask['original_construction_task_id']!=0)
      $this->cancelProjectBidConstructionTask($changedTask['original_construction_task_id'],$table);
  //addChangeTaskIntoBidTaskTable  
  $this->addChangeTaskIntoBidTaskTable(
          $changedTask['construction_task_id'], 
          $project_bid_id, 
          $changedTask['construction_item_id'], 
          $changedTask['construction_task_definition_id'], 
          $changedTask['task_start_date'], 
          $changedTask['task_end_date'], 
          $changedTask['reference_material_unit_cost'], 
          $changedTask['reference_labor_unit_cost'], 
          $changedTask['construction_task_measure_length'], 
          $changedTask['construction_task_measure_width'], 
          $changedTask['construction_task_measure_height'], 
          $changedTask['construction_task_ea_quantity'],
          $table);
 }
}

private function getProjectBidIdByProjectChangeId($project_change_id)
{
 $project_bid_id = 0;   
 $String_SQL = "Select a.project_deal_id
                From pogopro_post_project a,pogopro_project_change b
                Where a.post_project_id = b.project_id AND b.project_change_id = ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_change_id]);
 if (!$status)
 {
  echo "Query error[cancelProjectBidConstructionTask]:".$status->errorInfo()." with SQL:".$String_SQL; 
 }else
 {
  while ($row=  $status->fetch())
  {
   $project_bid_id = $row['project_deal_id'];   
  }       
 }
  return $project_bid_id;
}

private function getAllTasksOfProjectChangeByChangeId($project_change_id)
{
 $allTasksOfProjectChange = array();   
 $String_SQL = "Select a.* 
                From pogopro_project_change_tasks a,
                     pogopro_project_change_items b, 
                     pogopro_project_change_object c,
                     pogopro_project_change d
                Where a.construction_item_id AND 
                     a.construction_item_id = b.construction_object_item_id AND 
                     b.construction_object_id = c.construction_object_id AND
		     c.project_change_id = d.project_change_id AND
		     d.project_change_id = ? Order by a.construction_task_id"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_change_id]);
 if (!$status)
 {
   echo "Query error[getAllTasksOfProjectChangeByChangeId]:".$status->errorInfo()." with SQL:".$String_SQL; 
 }else
 { 
  while ($row=  $status->fetch())
  {
   $allTasksOfProjectChange[] = array(
    "construction_task_id"=>$row['construction_task_id'],    
    "construction_item_id"=>$row['construction_item_id'], 
    "construction_task_definition_id"=>$row['construction_task_definition_id'], 
    "reference_material_unit_cost"=>$row['reference_material_unit_cost'],
    "reference_labor_unit_cost"=>$row['reference_labor_unit_cost'],    
    "construction_task_measure_length"=>$row['construction_task_measure_length'], 
    "construction_task_measure_width"=>$row['construction_task_measure_width'], 
    "construction_task_measure_height"=>$row['construction_task_measure_height'], 
    "construction_task_ea_quantity"=>$row['construction_task_ea_quantity'],    
    "construction_task_material_cost"=>$row['construction_task_material_cost'], 
    "task_start_date"=>$row['task_start_date'], 
    "task_end_date"=>$row['task_end_date'],
    "task_notification"=>$row['task_notification'],    
    "task_status"=>$row['task_status'], 
    "rating"=>$row['rating'], 
    "review"=>$row['review'],
    "original_construction_task_id"=>$row['original_construction_task_id']       
   );   
  }
 }
 return $allTasksOfProjectChange;  
}

private function addChangeTaskIntoBidTaskTable(
            $construction_task_id,
            $pogopro_project_bid_id,
            $construction_item_id,
            $construction_task_definition_id,
            $task_start_date,
            $task_end_date,
            $material_unit_cost,
            $labor_unit_cost,
            $construction_task_measure_length,
            $construction_task_measure_width,
            $construction_task_measure_height,
            $construction_task_ea_quantity,
            $table_name ="pogopro_project_bid_contruction_tasks"
        )
{
 $String_SQL = "Insert into $table_name(
                construction_task_id,
                pogopro_project_bid_id,construction_item_id,
                construction_task_definition_id,task_start_date,
                task_end_date,material_unit_cost,labor_unit_cost,
                construction_task_measure_length,construction_task_measure_width,
                construction_task_measure_height,construction_task_ea_quantity) values(
                $construction_task_id*(-1),
                ?,?,?,?,?,?,?,?,?,?,?)"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$pogopro_project_bid_id,$construction_item_id,
                $construction_task_definition_id,$task_start_date,
                $task_end_date,$material_unit_cost,$labor_unit_cost,
                $construction_task_measure_length,$construction_task_measure_width,
                $construction_task_measure_height,$construction_task_ea_quantity]);
 if (!$status)
 {
  echo "Query error[cancelProjectBidConstructionTask]:".$status->errorInfo()." with SQL:".$String_SQL; 
  return false;
 }else
 {
  return true;   
 } 
}

private function cancelProjectBidConstructionTask($construction_task_id,$table="pogopro_project_bid_contruction_tasks")
{
 $String_SQL = "Update $table set task_status = 1 Where construction_task_id = ?";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$construction_task_id]);
 if (!$status)
 {
  echo "Query error[cancelProjectBidConstructionTask]:".$status->errorInfo()." with SQL:".$String_SQL; 
  return false;
 }else
 {
  return true;   
 }
}

private function getProjectCostAndTaskNumberByTaskStatus($project_id,$task_status)
{  
   $project_cost = array(0.00,0.00);
   $String_SQL ="Select b.construction_task_id,
                        b.task_start_date,
                        b.task_end_date,
                        b.material_unit_cost,
                        b.labor_unit_cost,
                        b.construction_task_measure_length,
                        b.construction_task_measure_width,
                        b.construction_task_measure_height,
                        b.construction_task_ea_quantity,
                        b.owner_supply_material,
                        c.task_measurement_unit,
                        c.construction_task_name
                 from pogopro_post_project a,
                      pogopro_project_bid_contruction_tasks b,
                      pogopro_construction_task_definition c
                 Where a.project_deal_id = b.pogopro_project_bid_id AND 
                       a.post_project_id = ? AND b.task_status = ? AND 
                       c.pogopro_construction_task_id = b.construction_task_definition_id
                 Order By b.task_start_date,b.task_end_date,b.construction_task_id";  
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$project_id,$task_status]);
   if (!$status)
    {
      echo "[getProjectCostAndTaskNumberByTaskStatus]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
    }else
    {
      while ($row=  $status->fetch())
      {
        $measureUnit = $row['task_measurement_unit'];
        $task_cost_material = 0.00;
        $task_cost_labor = 0.00;
        
       if ($measureUnit=='SF'||$measureUnit=='SI')
        {
         $measure_area = $row['construction_task_measure_length']*$row['construction_task_measure_width'];
         $task_cost_material = $measure_area *$row['material_unit_cost'];
         $task_cost_labor = $measure_area *$row['labor_unit_cost'];
        }else if ($measureUnit=='SQ')
        {
         $measure_area = $row['construction_task_measure_length']*$row['construction_task_measure_width']/100.00;
         $task_cost_material = $measure_area *$row['material_unit_cost'];
         $task_cost_labor = $measure_area *$row['labor_unit_cost'];          
        }else if ($measureUnit=='CI'||$measureUnit=='CY'||$measureUnit=='CF')
        {
         $measure_cubic = $row['construction_task_measure_length']*$row['construction_task_measure_width']*$row['construction_task_measure_height'];
         $task_cost_material = $measure_cubic *$row['material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['labor_unit_cost'];           
        }else if ($measureUnit=='BF')
        {
         $measure_cubic = $row['construction_task_measure_length']*$row['construction_task_measure_width']*$row['construction_task_measure_height']/144; //(1 BF = 12 inchx 12 inch x 1 inch) 
         $task_cost_material = $measure_cubic *$row['material_unit_cost'];
         $task_cost_labor = $measure_cubic *$row['labor_unit_cost'];           
        }else
        {
         $measure_quantity = $row['construction_task_ea_quantity'];
         $task_cost_material = $measure_quantity*$row['material_unit_cost'];
         $task_cost_labor = $measure_quantity*$row['labor_unit_cost'];           
        } 

        if ($row['owner_supply_material']==1)
            $task_cost_material = 0.00;
        
        $project_cost[0] += $task_cost_material;
        $project_cost[1] += $task_cost_labor;
      }
    }
    return $project_cost;
  }

function getProjectAccountingReceivableCredit($project_id,$project_bid_id)
{
 $totalReceivedFromBuyer = $this->getProjectAccountingReceivables($project_id); //not include tax
 $totalPaidToPro = $this->getProjectAccountingPayables($project_id);// not include tax
 $totalProShouldGetpaidByCompletedTasks = $this->getCostOfProjectCompletedTasks($project_id);
 $BuyerCredit = $totalReceivedFromBuyer - $totalProShouldGetpaidByCompletedTasks; // >0 : buyer paid more, <0: buyer paid less
 $pogoproCredit = $totalPaidToPro - $totalProShouldGetpaidByCompletedTasks; // >0: pogo.pro paid more, <0: pogo.pro paid less.
 $this->updatePogoproProjectBuyerCredit($project_id,$BuyerCredit);
 $this->updatePogoproProjectOverPaidCredit($project_id,$pogoproCredit);
 /*if ($totalProShouldGetpaidByCompletedTasks>$totalPaidToPro)
 {
  $amountWhichShouldPayProBeforeStartNewContract = $totalProShouldGetpaidByCompletedTasks-$totalPaidToPro;  
  $bid_custom_tax_rates = (new pogoproProjectAccountingManager())->getPogoproProjectBidCustomTaxRates($project_bid_id);
  $bid_total_tax_rate = 0.00;
  foreach ($bid_custom_tax_rates as $bid_custom_tax_rate)
  {
   $bid_total_tax_rate += $bid_custom_tax_rate['custome_tax_rate_value'];   
  }
  $tax_amount = $amountWhichShouldPayProBeforeStartNewContract*$bid_total_tax_rate;
  //generate payable record, values = $totalProShouldGetpaidByCompletedTasks>$totalPaidToPro;
  (new pogoproTaskPaymentManager())->addPogoproAccountingPayableRecord(
          $project_id, 
          $project_bid_id, 
          "", 
          $project_ap_desc, 
          $$amountWhichShouldPayProBeforeStartNewContract, 
          $tax_amount);
  $creditOfBuyer = $totalReceivedFromBuyer - $totalPaidToPro;
  if ($amountWhichShouldPayProBeforeStartNewContract > $creditOfBuyer)
  {
   //generate receivable record, values = $amountWhichShouldPayProBeforeStartNewContract - $creditOfBuyer;        
  }else
  {
   $BuyerCredit = $creditOfBuyer - $amountWhichShouldPayProBeforeStartNewContract;    
  }
 }else
 {
  $BuyerCredit = $totalReceivedFromBuyer - $totalProShouldGetpaidByCompletedTasks;
  $pogoproCredit = $totalPaidToPro - $totalProShouldGetpaidByCompletedTasks;
 }
 if ($BuyerCredit>0.00)
 {
  //clean and insert new buyer credit record 
  $this->updatePogoproProjectBuyerCredit($project_id,$BuyerCredit);   
 }
 if ($pogoproCredit>0.00)
 {
  //clean and insert new overpaid record 
  $this->updatePogoproProjectOverPaidCredit($project_id,$pogoproCredit);   
 }*/
 
 return array("buyer_credit"=>$BuyerCredit,"overpaid_credit"=>$pogoproCredit);
}

function updatePogoproProjectBuyerCredit($project_id,$buyer_credit_amount)
{
 $String_SQL = "Delete From pogopro_project_accounting_buyer_credit Where project_id = ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_id]);
 if (!$status)
 {
  echo "Query error[updatePogoproProjectBuyerCredit]:".$status->errorInfo()." with SQL:".$String_SQL; 
 }else
 {
  $String_SQL = "Insert into pogopro_project_accounting_buyer_credit(project_id,project_buyer_credit) values(?,?)";   
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id,$buyer_credit_amount]);
  if (!$status)
  {
   echo "Query error[updatePogoproProjectBuyerCredit]:".$status->errorInfo()." with SQL:".$String_SQL; 
  }else
  { 
   return true;   
  }
 } 
}  

function updatePogoproProjectOverPaidCredit($project_id,$overpaid_amount)
{
 $String_SQL = "Delete From pogopro_project_account_pogo_credit Where project_id = ?"; 
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_id]);
 if (!$status)
 {
  echo "Query error[updatePogoproProjectOverPaidCredit]:".$status->errorInfo()." with SQL:".$String_SQL; 
 }else
 {
  $String_SQL = "Insert into pogopro_project_account_pogo_credit(project_id,overpaid_amount) values(?,?)";   
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id,$overpaid_amount]);
  if (!$status)
  {
   echo "Query error[updatePogoproProjectOverPaidCredit]:".$status->errorInfo()." with SQL:".$String_SQL; 
  }else
  { 
   return true;   
  }
 } 
}

function getProjectAccountingReceivables($project_id)
{
 $String_SQL = "Select a.project_ar_amount,a.tax_amount
                From pogopro_project_accounting_receivable a
                Where a.project_id = ?"; 
                //Where a.project_id = $project_id and a.received_date <>''"; 
 $total_project_receivables = 0.00;
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_id]);
 if (!$status)
 {
  echo "Query error[getProjectAccountingReceivables]:".$status->errorInfo()." with SQL:".$String_SQL; 
 }else
 {
  while ($row=  $status->fetch())
  {
   $total_project_receivables += $row['project_ar_amount'];   
  }
 } 
 return $total_project_receivables;    
}
function getProjectAccountingPayables($project_id)
{
 $String_SQL = "Select a.project_ap_amount,a.tax_amount
                From pogopro_project_accounting_payable a
                Where a.project_id = ?"; 
                //Where a.project_id = $project_id and a.paid_date<>''"; 
 $total_project_payables = 0.00;
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_id]);
 if (!$status)
 {
  echo "Query error[getProjectAccountingPayables]:".$status->errorInfo()." with SQL:".$String_SQL; 
 }else
 {
  while ($row=  $status->fetch())
  {
   $total_project_payables += $row['project_ap_amount'];   
  }
 } 
 return $total_project_payables;    
}
private function getCostOfProjectCompletedTasks($project_id)
{
 $costOfCompletedTasks = $this->getProjectCostAndTaskNumberByTaskStatus($project_id,2);  
 return ($costOfCompletedTasks[0]+$costOfCompletedTasks[1]);
}

function generatePaymentScheduleForProjectChange($project_change_id)
{
 $allIDs = $this->getProjectAndItsBidIdsByProjectChangeId($project_change_id);
 $this->loadProjectTasksFromBidTaskTableTotmpTable($allIDs['project_bid_id']);
 $this->updateProjectBidContrstuctionTasksList($project_change_id,"pogopro_project_bid_contruction_tasks_tmp");
}

function getProjectAndItsBidIdsByProjectChangeId($project_change_id)
{
 $allIDs = array();   
 $String_SQL = "Select b.project_deal_id,b.post_project_id
                From pogopro_project_change a,pogopro_post_project b
                Where a.project_change_id = ? AND a.project_id = b.post_project_id";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_change_id]);
 if (!$status)
 {
  echo "Query error[getProjectAndItsBidIdsByProjectChangeId]:".$status->errorInfo()." with SQL:".$String_SQL; 
 }else
 {
  while ($row=  $status->fetch())
  {
   $allIDs = array("project_id"=>$row['post_project_id'],"project_bid_id"=>$row['project_deal_id']);   
  }
 }  
 return $allIDs;
}
private function cleanProjectTasksFromTmpTable($project_bid_id)
{
 $String_SQL = "Delete from pogopro_project_bid_contruction_tasks_tmp Where pogopro_project_bid_id = ?";  
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_bid_id]);
 if (!$status)
 {
  echo "Query error[loadProjectTasksFromBidTaskTableTotmpTable]:".$status->errorInfo()." with SQL:".$String_SQL;
  return false;
 }else
 {
  return true;   
 }    
}

function loadProjectTasksFromBidTaskTableTotmpTable($project_bid_id)
{
 $this->cleanProjectTasksFromTmpTable($project_bid_id);   
 $String_SQL = "Insert into pogopro_project_bid_contruction_tasks_tmp
                Select * From pogopro_project_bid_contruction_tasks a
                Where a.pogopro_project_bid_id = ?";  
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$project_bid_id]);
 if (!$status)
 {
  echo "Query error[loadProjectTasksFromBidTaskTableTotmpTable]:".$status->errorInfo()." with SQL:".$String_SQL;
  return false;
 }else
 {
  return true;   
 } 
}
 function getProjectIdByChangeId($project_change_id)
 {
  $project_id = 0;   
  $String_SQL = "Select a.project_id
                 From pogopro_project_change a
                 Where a.project_change_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_change_id]);
  if (!$status)
  {
   echo "Query error[getProjectIdByChangeId]:".$status->errorInfo()." with SQL:".$String_SQL;
  }else
  {
   while($row=  $status->fetch())
   {
    $project_id = $row['project_id'];   
   }
  }  
  return $project_id;  
 }
}//End of class pogoproProjectChangeManager
?>

