<?php
/**
 * This class is collections of all functions for pogo.pro project accounting 
 */
//include_once("../v2/inc/vars.php");
include_once("$_SERVER[DOCUMENT_ROOT]/v2/inc/vars.php");
include_once("pogoproTaskPaymentManager.php");
include_once("pogoproHelperClass.php");
class pogoproProjectAccountingManager
{
 private $db_conn;
 private $domain_name;
 function __construct($conn=null){ //set db connection in constructor
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection();
		$this->db_conn = $dbconnect_obj->conn;
	}
	$pogoproHelperClass = new pogoproHelperClass();
	$this->domain_name = $pogoproHelperClass -> domain_name;
 }	
 function addPogoproProjectReceivableRecord(
          $project_id,
          $project_ar_title,
          $project_ar_desc,
          $project_ar_amount,
          $tax_amount,
          $deduct_cost=0.00
          )
 {
   $issue_date = date('Y/m/d');
   $start_date = strtotime($issue_date);
   $business_days = PAYMENT_DUE_DAYS;
   $end_date =  date('Y/m/d', strtotime($business_days, $start_date));     
   $pogopro_project_ar_transaction_id = "";   
   $String_SQL = "Insert into pogopro_project_accounting_receivable("
              . "project_id,project_ar_title,"
              . "project_ar_desc,project_ar_amount,tax_amount,issue_date,due_date,deduct_cost) "
              . "value(?,?,?,?,?,?,?,?)"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id,$project_ar_title,$project_ar_desc,$project_ar_amount,$tax_amount,$issue_date,$end_date,$deduct_cost]);
  if (!$status)
     {
      echo "[addPogoproProjectReceivableRecord]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      $new_pogopro_ar_id = $this->db_conn->lastInsertId();
      $pogopro_project_ar_transaction_id = $new_pogopro_ar_id;//sprintf("%08d",$project_id)."-".sprintf("%08d",$new_pogopro_ar_id);
     }   
  return $pogopro_project_ar_transaction_id;
 }
 
 function updateReceivedDateOfPogoproProjectAccountingReceivable(
         $pogopro_accounting_receivable_id,
         $reference_code,
         $received_date,
         $project_id)
 {
  $current_date = $received_date;//date('Y-m-d');   
  $String_SQL = "Update pogopro_project_accounting_receivable Set received_date = ?, reference_code = ? Where project_account_receivable_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$current_date,$reference_code,$pogopro_accounting_receivable_id]);
  if (!$status)
     {
      echo "[updateReceivedDateOfPogoproProjectAccountingReceivable]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      $this->sendPaymentReceiptToBuyer($pogopro_accounting_receivable_id,$received_date,$project_id);   
      return true;   
     }  
 }
 
 private function sendPaymentReceiptToBuyer($pogopro_accounting_receivable_id,$received_date,$project_id)
 {
  $String_SQL = "Select b.salutation,b.name,b.email
                 From pogopro_post_project a,customer_accounts b
                 Where a.member_id = b.id AND  a.post_project_id = ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id]);
  if (!$status)
     {
      echo "[updateReceivedDateOfPogoproProjectAccountingReceivable]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      $client_name = "";
      $email_address = "";
      while ($row=  $status->fetch())
      {
        $client_name = $row['salutation']." ".$row['name']; 
        $email_address = $row['email'];
      }
      $email_subject = "Receipt for payment:PT".sprintf("%016d",$pogopro_accounting_receivable_id);
      $email_content = "<div>"
                ."<p style='margin-left:8px;'>".$client_name.":</p>"
                ."<p style='margin-left:8px;'>".$subject."</p>"
                ."<table>"
                ."<tr>"
                ."<td style='width:8%' valign='top'><a href='http://".$this->domain_name."'><img style='width:115px;height:40px' src='http://".$this->domain_name."/v2/img/logo2.png'></a></td>"
                ."<td style='width:92%'>"
                ."<p style='margin-left:8px;'>".$email_subject."</p>"
                ."<p style='margin-left:8px;'>We received this payment on ".$received_date."</p>"       
                . "</td>"
                . "</tr>"
                . "<table>"
                . "</div>"
                . "<div style='margin-top:16px;'>"
                . "<p style='font-size:24px;color:#3c763d'>Thanks for using Pogo.pro service.</p>"
                . "</div>";
  //return $email_content;
    $email_content = str_replace("'", "\'", $email_content);
   (new pogoproEmailPoolManager())->addEmailSendRequestIntoPool
    (
     POGOPROMailSENDER,
     $email_address,
     $email_subject,
     $email_content       
    ); 
     }
 }
 
 function getListOfPogoproProjectAccountingReceivableOnWaiting()
 {
  //$String_SQL = "Select * From pogopro_project_accounting_receivable Where received_date=''";//changed 22Apr
  $String_SQL = "Select a.*, b.response_code, b.response_message from pogopro_project_accounting_receivable as a left join pogopro_receivable_transactions_failed_logs as b on a.project_account_receivable_id=b.project_account_receivable_id where a.received_date=''";
  $arrayOfOnWaitingList = array();
  $status = $this->db_conn->query($String_SQL);
  if (!$status)
     {
      echo "[getListOfPogoproProjectAccountingReceivableOnWaiting]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row = $status->fetch())
      {
       $total_amount = $row['project_ar_amount'] + $row['tax_amount'] - $row['deduct_cost'];  
       $arrayOfOnWaitingList[] = array(
        "transaction_id"=>$row['project_account_receivable_id'],
        "buyer_transaction_id" =>"PT".sprintf("%016d",$row['project_account_receivable_id']),   
        "project_id"=>$row['project_id'],
        "project_ar_title"=>$row['project_ar_title'],
        "project_ar_desc"=>$row['project_ar_desc'],
        "project_ar_amount"=>$row['project_ar_amount'],
        "tax_amount"=>$row['tax_amount'],
        "deduct_cost"=>$row['deduct_cost'],   
        "issue_date"=>$row['issue_date'],
        "due_date"=>$row['due_date'],   
        "reference_code"=>$row['reference_code'],   
        "received_date"=>$row['received_date'],
        "total_amount"=>$total_amount,
		"response_code"=>$row['response_code'],   
        "response_message"=>$row['response_message']	
       );   
      }
     }
   return $arrayOfOnWaitingList;  
 }
  
 function getPogoproProjectAccountingReceivables($project_id)
 {
  $allReceivablesOfProject = array();  
  $String_SQL = "Select * From pogopro_project_accounting_receivable Where project_id = ? Order by project_account_receivable_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id]);
  if (!$status)
     {
      echo "[getPogoproProjectAccountingReceivables]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
       while ($row = $status->fetch())
       {
        $allReceivablesOfProject[] = array(
        "project_account_receivable_id"=>$row['project_account_receivable_id'],
        "project_id"=>$row['project_id'],
        "project_ar_title"=>$row['project_ar_title'],
        "project_ar_desc"=>$row['project_ar_desc'],
        "project_ar_amount"=>$row['project_ar_amount'],
        "tax_amount"=>$row['tax_amount'],
        "deduct_cost"=>$row['deduct_cost'],    
        "issue_date"=>$row['issue_date'],
        "due_date"=>$row['due_date'],
        "reference_code"=>$row['reference_code'],
        "received_date"=>$row['received_date']    
        );  
       }
     }
  return  $allReceivablesOfProject;   
 } 
 
 function getfailedReceivableTransactionStatusById($receivable_id)
 {
  $transactionStatusData = array();  
  $String_SQL = "Select * From pogopro_receivable_transactions_failed_logs Where project_account_receivable_id = ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$receivable_id]);
  if (!$status)
     {
      echo "[getPogoproProjectAccountingReceivables]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
       while ($row = $status->fetch())
       {
        $transactionStatusData[] = array(
        "project_account_receivable_id"=>$row['project_account_receivable_id'],
        "response_code"=>$row['response_code'],
        "response_message"=>$row['response_message']  
        );  
       }
     }
  return  $transactionStatusData;   
 } 
 
 function getPogoproProjectAccountingReceivablesByMemberId($buyer_id)
 {
  $allReceivablesOfProjectForBuyer = array();  
  $String_SQL = "SELECT pogopro_post_project.project_title,pogopro_post_project.project_desc  ,pogopro_project_accounting_receivable.* FROM pogopro_post_project INNER JOIN pogopro_project_accounting_receivable ON pogopro_post_project.post_project_id = pogopro_project_accounting_receivable.project_id WHERE pogopro_post_project.member_id = ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$buyer_id]);
  if (!$status)
     {
      echo "[getPogoproProjectAccountingReceivables]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
       while ($row = $status->fetch())
       {
		$total_amount = $row['project_ar_amount'] + $row['tax_amount'] - $row['deduct_cost'];
        $allReceivablesOfProjectForBuyer[] = array(
        "transaction_id"=>$row['project_account_receivable_id'],
		"buyer_transaction_id" =>"PT".sprintf("%016d",$row['project_account_receivable_id']),
        "project_id"=>$row['project_id'],
        "project_ar_title"=>$row['project_ar_title'],
        "project_ar_desc"=>$row['project_ar_desc'],
        "project_ar_amount"=>$row['project_ar_amount'],
        "tax_amount"=>$row['tax_amount'],
        "deduct_cost"=>$row['deduct_cost'],
		"total_amount"=>$total_amount,    
        "issue_date"=>$row['issue_date'],
        "due_date"=>$row['due_date'],
		"received_date"=>$row['received_date'],
        "reference_code"=>$row['reference_code'],
        "project_title"=>$row['project_title'],
		"project_desc"=>$row['project_desc']
        );  
       }
     }
  return  $allReceivablesOfProjectForBuyer;   
 }
 
 function getPogoproProjectAccountingPayables($project_id)
 {
  $allReceivablesOfProject = array();  
  $String_SQL = "Select * From pogopro_project_accounting_payable Where project_id = ? Order by project_account_payable_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id]);
  if (!$status)
     {
      echo "[getPogoproProjectAccountingPayables]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
       while ($row = $status->fetch())
       {
        $allReceivablesOfProject[] = array(
        "project_account_payable_id"=>$row['project_account_payable_id'],
        "project_id"=>$row['project_id'],
        "project_bid_id"=>$row['project_bid_id'],    
        "project_ap_title"=>$row['project_ap_title'],
        "project_ap_desc"=>$row['project_ap_desc'],
        "project_ap_amount"=>$row['project_ap_amount'],
        "tax_amount"=>$row['tax_amount'],
        "issue_date"=>$row['issue_date'],
        "reference_code"=>$row['reference_code'],
        "paid_date"=>$row['paid_date'],
        "deduct_cost"=>$row['deduct_cost']    
        );  
       }
     }
  return  $allReceivablesOfProject;   
 }
 
 function getCountOfPogoproProjectReceivables($project_id)
 {
  $numOfProjectReceivables = 0;   
  $String_SQL = "Select count(*) as num_of_receivables From pogopro_project_accounting_receivable a
                 Where a.project_id = ?;";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_id]);
  if (!$status)
     {
      echo "[getListOfPogoproProjectAccountingReceivableOnWaiting]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
       while ($row=  $status->fetch())
       {
         $numOfProjectReceivables = $row['num_of_receivables'];  
       }
     }
     
   return $numOfProjectReceivables;  
 }
 
 function addPogoproProjectBidCustomTaxRate(
         $project_bid_id,
         $tax_rate_id,
         $custome_tax_rate_value)
 {
  $String_SQL = "Insert into pogopro_project_bid_custom_tax_rate(project_bid_id,tax_rate_id,custome_tax_rate_value) 
                 values(?,?,?)";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_bid_id,$tax_rate_id,$custome_tax_rate_value]);
  if (!$status)
     {
      echo "[addPogoproProjectBidCustomTaxRate]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      return true;
     }
 }
 
 function updatePogoproProjectBidCustomTaxRate(
         $custom_tax_rate_id,
         $custom_tax_rate_value)
 {
  $String_SQL = "Update pogopro_project_bid_custom_tax_rate set custome_tax_rate_value = ? Where custom_tax_rate_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$custom_tax_rate_value,$custom_tax_rate_id]);
  if (!$status)
     {
      echo "[updatePogoproProjectBidCustomTaxRate]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      return true;
     }  
 }
 
 function getPogoproProjectBidCustomTaxRates($project_bid_id)
 {
  $customTaxRates = array();   
  $String_SQL = "Select a.*,b.tax_rate_name
                 From pogopro_project_bid_custom_tax_rate a,pogopro_canadian_tax_rate b
                 Where a.project_bid_id = ? AND a.tax_rate_id = b.tax_rate_id
                 Order By a.custom_tax_rate_id"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_bid_id]);
  if (!$status)
     {
      echo "[updatePogoproProjectBidCustomTaxRate]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
     }else
     {
      while ($row=  $status->fetch())
      {
       $customTaxRates[] = array(
        "custom_tax_rate_id"=>$row['custom_tax_rate_id'],
        "tax_rate_id"=>$row['tax_rate_id'],
        "tax_rate_name"=>$row['tax_rate_name'],   
        "custome_tax_rate_value"=>$row['custome_tax_rate_value']   
       );       
      }
     } 
     
     return $customTaxRates;
 }
 
 function removeProposalOfNewPaymentSchedule($project_bid_id)
 {
  $String_SQL = "Delete from pogopro_project_bid_payment_scheule Where project_bid_id = ? AND status = -1"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_bid_id]);
  if (!$status)
     {
      echo "[addPogoproProjectBidPaymentSchedule]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      return true;    
     }    
 }
 
 function addPogoproProjectBidPaymentSchedule(
         $project_bid_id,
         $payment_schedule_title,
         $payment_schedule_desc,
         $payment_schedule_date,
         $payment_schedule_amount,
         $payment_percentage,
         $involved_tasks,
         $status=1)
 {
/*  $String_SQL = "Insert into pogopro_project_bid_payment_scheule(
                 project_bid_id,
                 payment_schedule_title,
                 payment_schedule_desc,
                 payment_schedule_date,
                 payment_schedule_amount,
                 payment_percentage,
                 involved_tasks,status) values(?,?,?,?,?,?,?,?)"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_bid_id,$payment_schedule_title,$payment_schedule_desc,$payment_schedule_date,$payment_schedule_amount,$payment_percentage,$involved_tasks,$status]);
*/


  $String_SQL = "Insert into pogopro_project_bid_payment_scheule(
                 project_bid_id,
                 payment_schedule_title,
                 payment_schedule_desc,
                 payment_schedule_date,
                 payment_schedule_amount,
                 payment_percentage,
                 involved_tasks,status) values('".$project_bid_id."','".$payment_schedule_title."','".$payment_schedule_desc."','".$payment_schedule_date."','".$payment_schedule_amount."','".$payment_percentage."','".$involved_tasks."','".$status."')"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute();

  if (!$status)
     {
      echo "[addPogoproProjectBidPaymentSchedule]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      return true;    
     }  
 }
 
 function updatePogoproProjectBidPaymentSchedule(
         $custom_payment_schedule_id,
         $payment_schedule_amount,
         $custom_payment_percentage
         )
 {
  $String_SQL = "Update pogopro_project_bid_payment_scheule Set payment_schedule_amount = ?,payment_percentage= ? Where custom_payment_schedule_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$payment_schedule_amount,$custom_payment_percentage,$custom_payment_schedule_id]);
  if (!$status)
     {
      echo "[updatePogoproProjectBidPaymentSchedule]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      return true;    
     }    
 }
 
 function  getListOfPogoproProjectBidPaymentSchedule($project_bid_id,$status=1)
 {
  $pogoproProjectBidPaymentSchedules = array();   
  $String_SQL = "Select * From pogopro_project_bid_payment_scheule Where project_bid_id= '".$project_bid_id."' AND status = '".$status."' Order By custom_payment_schedule_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute();
  if (!$status)
     {
      echo "[getListOfPogoproProjectBidPaymentSchedule]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
     }else
     { 
      while ($row=  $status->fetch())
      {
        $pogoproProjectBidPaymentSchedules[] = array(
         "custom_payment_schedule_id"=>$row['custom_payment_schedule_id'],
         "project_bid_id"=>$row['project_bid_id'],
         "payment_schedule_title"=>$row['payment_schedule_title'],
         "payment_schedule_desc"=>$row['payment_schedule_desc'],
         "payment_schedule_date"=>$row['payment_schedule_date'],
         "payment_schedule_amount"=>$row['payment_schedule_amount'],
         "payment_percentage"=>$row['payment_percentage'],   
         "involved_tasks"=>$row['involved_tasks']   
        );  
      }
     } 
   return $pogoproProjectBidPaymentSchedules;   
 }
 
 function cleanPogoproProjectBidCustomTaxRateAndPaymentSchedule($project_bid_id)
 {
  $this->cleanPogoproProjectBidCustomTaxRate($project_bid_id); 
  $this->cleanPogoproProjectBidPaymentSchedules($project_bid_id);   
 }
 
 private function cleanPogoproProjectBidCustomTaxRate($project_bid_id)
 {
  $String_SQL = "Delete from pogopro_project_bid_custom_tax_rate Where project_bid_id = ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_bid_id]);
  if (!$status)
     {
      echo "[cleanPogoproProjectBidCustomTaxRate]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      return true;    
     }   
 }
 
 private function cleanPogoproProjectBidPaymentSchedules($project_bid_id)
 {
  $String_SQL = "Delete from pogopro_project_bid_payment_scheule Where project_bid_id = ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_bid_id]);
  if (!$status)
     {
      echo "[cleanPogoproProjectBidCustomTaxRate]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      return true;    
     }   
 }
 
 function autoIssueDownPaymentByProjectPaymentSchedule($current_date)
 {
  //$current_date = date('Y-m-d');
  $String_SQL = "Select a.*,b.posted_project_id
                 From pogopro_project_bid_payment_scheule a,pogopro_posted_project_bid b
                 Where a.project_bid_id = b.project_deal_id AND a.payment_schedule_date = ? AND a.involved_tasks = '0'
                 Order by a.custom_payment_schedule_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$current_date]);
  if (!$status)
     {
      echo "[autoIssueDownPaymentByProjectPaymentSchedule]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
     }else
     {
      //echo  $String_SQL;  
      $ptpm = new pogoproTaskPaymentManager();   
      while ($row = $status->fetch())
      {
       $overPaidCredit = (new pogoproProjectChangeManager())->getOverPaidCredit($row['project_bid_id']);   
       $customTaxRates = $this->getPogoproProjectBidCustomTaxRates($row['project_bid_id']);   
       $total_tax_rate = 0.00;
       $payment_amount = $row['payment_schedule_amount'];
       $deduct_cost = 0.00;
       if ($overPaidCredit>0)
       {
         if ($payment_amount>=$overPaidCredit)
         {
          $deduct_cost = $overPaidCredit; 
          $payment_amount -= $overPaidCredit;
          $overPaidCredit = 0.00;
         }else
         {
          $deduct_cost = $payment_amount;
          $overPaidCredit -= $payment_amount;
          $payment_amount = 0.00;
         }
         (new pogoproProjectChangeManager())->updatePogoproProjectOverPaidCredit($row['posted_project_id'], $overPaidCredit);
       }
       if (count($customTaxRates)>0)
       {
        foreach ($customTaxRates as $taxRate)
         $total_tax_rate += $taxRate['custome_tax_rate_value'];   
       }
       //$tax_amount = $row['payment_schedule_amount'] * $total_tax_rate;
       $tax_amount = $payment_amount * $total_tax_rate;
       $ptpm->addPogoproAccountingPayableRecord(
               $row['posted_project_id'], 
               $row['project_bid_id'], 
               $row['payment_schedule_title'], 
               $row['payment_schedule_desc'], 
               //$row['payment_schedule_amount'],
               $payment_amount,
               $tax_amount,
               $deduct_cost);   
      }
     }
 }
 
 function getListOfUnpaidPaymentToPros()
 {
  $allPendingPaidPayments = array();   
  $String_SQL ="Select a.project_account_payable_id,a.project_id,
                       a.project_ap_title,a.project_ap_amount,a.tax_amount,
                       a.deduct_cost,a.issue_date,a.pogopro_charge
                From pogopro_project_accounting_payable a
                Where a.paid_date=''
                Order By a.project_account_payable_id";
								//Order By a.issue_date";  was commented on 25-11-2020
  $status = $this->db_conn->query($String_SQL);
  if (!$status)
     {
      echo "[getListOfUnpaidPaymentToPros]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      while ($row=  $status->fetch())
      {
       $toatl_amount = $row['project_ap_amount']+$row['tax_amount']-$row['deduct_cost']-$row['pogopro_charge'];   
       $allPendingPaidPayments[] =array(
        "project_account_payable_id"=>$row['project_account_payable_id'],
        "project_id"=>$row['project_id'],
        "project_ap_title"=>$row['project_ap_title'],
        "project_ap_amount"=>$row['project_ap_amount'],
        "tax_amount"=>$row['tax_amount'],
        "deduct_cost"=>$row['deduct_cost'],
        "issue_date"=>$row['issue_date'],
        "pogopro_charge"=>$row['pogopro_charge'],
        "total_amount"=>$toatl_amount   
       );
      }
     }
   return $allPendingPaidPayments;  
 }
 
 function updateIssuedPaycheckNo($payable_id,$paycheck_no,$issued_date)
 {
  $String_SQL = "Update pogopro_project_accounting_payable Set reference_code= ?,paid_date= ? Where project_account_payable_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$paycheck_no,$issued_date,$payable_id]);
  if (!$status)
     {
      echo "[updateIssuedPaycheckNo]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
     }else
     {
      return true;    
     }  
 }
}// End of class
?>

