<?php
/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
include_once("../v2/inc/vars.php");
class pogoproPostedProjectVideoManager
{
  private $db_conn;
  function __construct($conn=null){ //set db connection in constructor
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection();
		$this->db_conn = $dbconnect_obj->conn;
	}
  }		
 function addVideoToPostedProject(
         $post_project_id,
         $project_video_title,
         $project_video_url,
         $video_type
         )  
 {
  $new_project_video_id = 0;   
  $String_SQL = "Insert into pogopro_post_project_video(post_project_id,project_video_title,project_video_url,video_type)
                 values(?,?,?,?)";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$post_project_id,$project_video_title,$project_video_url,$video_type]);
  if (!$status)
    {
      echo "[addVideoToPostedProject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;  
    }else
    {  
      $new_project_video_id = $this->db_conn->lastInsertId();  
    }
  return $new_project_video_id;
 }
 
 function removeVideoFromPostedProject($project_video_id)
 {
  $String_SQL = "Delete From pogopro_post_project_video Where project_video_id = ?"; 
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_video_id]);
  if (!$status)
    {
     echo "[removeVideoFromPostedProject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;  
     return false; 
    }else
    {  
     return true;  
    }    
 }
 
 function getListOfVideoForPostedProject($post_project_id)
 {
  $arrayOfVideos = array();
  $String_SQL = "Select * From pogopro_post_project_video Where post_project_id = ? Order by project_video_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$post_project_id]);
  if (!$status)
    {
     echo "[getListOfVideoForPostedProject]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
    }else
    {  
     while ($row=  $status->fetch())
     {
      $video_type = $row['video_type'];   
      $video_url = $row['project_video_url'];
      if ($video_type>0)
          $video_url = $video_url;
      $arrayOfVideos[] = array(
      "project_video_id"=>$row['project_video_id'], 
      "post_project_id"=>$row['post_project_id'], 
      "project_video_title"=>$row['project_video_title'], 
      "project_video_url"=>$video_url, 
      "video_type"=>$video_type 
      );   
     }
    } 
  return $arrayOfVideos;  
 }
 
 function  updateProjectVideoURL($project_video_id,$project_video_url)
 {
  $String_SQL = "Update pogopro_post_project_video Set project_video_url = ? Where project_video_id = ?";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$project_video_url,$project_video_id]);
  if (!$status)
    {
     echo "[updateProjectVideoURL]Query error:".$status->errorInfo()." with SQL:".$String_SQL;  
     return false; 
    }else
    {  
     return true;  
    }  
 }
}// End of class 
?>

