<?php
/* 
 * This class encapused all functions for pogo.pro help system content management.
 */
include_once("../v2/db_connect_pdo.php");//db connect classs
include_once("pogoproProjectImageManipulateManager.php");
class pogoproHelpContentManagementSystemClass
{
	private $db_conn;
	function __construct($conn=null){ //set db connection in constructor
		if($conn){
			$this->db_conn = $conn;	
		}else{
			$dbconnect_obj = new dbconnection();
			$this->db_conn = $dbconnect_obj->conn;
		}
	 }
  function addHelpContentCategory(
          $content_category_name,
          $parent_code="")
  {
   $content_code = $this->getNextHelpContentId($parent_code);   
   $String_SQL = "Insert into pogopro_help_contents(content_code,content_name) values(?,?);"; 
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$content_code,$content_category_name]);
   if (!$status)
     {
      echo "[addHelpContentCategory]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return 0;
     }else
     {
      return $this->db_conn->lastInsertId();
     }   
  }
  
  function updateHelpContentCategory(
          $help_content_id,
          $content_category_name)
  {
   $String_SQL = "Update pogopro_help_contents Set content_name = ? Where help_content_id = ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$content_category_name,$help_content_id]);
   if (!$status)
     {
      echo "[updateHelpContentCategory]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      return true;
     }   
  }
  
  private function getContentCodeByHelpContentId($help_content_id)
  {
   $content_code = "";   
   $String_SQL = "Select content_code From pogopro_help_contents Where help_content_id = ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$help_content_id]);
   if (!$status)
     {
      echo "[getContentCodeByHelpContentId]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while ($row=$status->fetch())
      {
       $content_code = $row['content_code'];   
      }
     }
   return $content_code;  
  }
  
  function deleteHelpContentCategory($help_content_id)
  {
     $content_code = $this->getContentCodeByHelpContentId($help_content_id); 
     $String_SQL = "Delete From pogopro_help_contents Where content_code like '$content_code%'";
     $status = $this->db_conn->query($String_SQL);
     if (!$status)
     {
      echo "[deleteHelpContentCategory]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      return true;
     }   
  }
  
  function addHelpContentItem(
          $parent_code,
          $content_icon_name,
          $content_header,
          $content_paragraph1,
          $content_paragraph2,
          $content_paragraph3,
          $content_tip,
          $content_image_title,
          $content_video_name)
  {
    $content_code = $this->getNextHelpContentId($parent_code);
    $String_SQL = "Insert into pogopro_help_contents(content_code,"
            . "content_icon_name,content_header,"
            . "content_paragraph1,content_paragraph2,"
            . "content_paragraph3,content_tip,content_image_title,content_video_name) value(?,?,?,?,?,?,?,?,?);";
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$content_code,$content_icon_name,$content_header,$content_paragraph1,$content_paragraph2,$content_paragraph3,$content_tip,$content_image_title,$content_video_name]);
    if (!$status)
     {
      echo "[addHelpContentItem]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      return $this->db_conn->lastInsertId();
     }
  }
  
  function uploadFile($help_content_id,$file,$target_folder)
  {
    $image_name = $help_content_id."_".$file['name'];
    $image_name = str_replace(" ", "_", $image_name); 
    $sourcePath = $file['tmp_name']; 
    $targetPath = $target_folder.$image_name; 
    $status = move_uploaded_file($sourcePath,$targetPath) ;
    if ($status)
    {
      $manager = new pogoproProjectImageManipulateManager(
        $image_name,
        $image_name,
        RENOVATION_PROJECT_IMAGE_WIDTH,
        RENOVATION_PROJECT_IMAGE_HEIGHT,
        $target_folder
        );
      $manager->resizeImage();         
    }
    return $status;
  }
  
  function updateContentSmallImage($help_content_id,$targetPath)
  {
    $String_SQL = "Update pogopro_help_contents Set content_image_samll= ? Where help_content_id =".$help_content_id;
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$targetPath]);
    if (!$status)
     {
      echo "[updateContentSmallImage]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      return true;
     }      
  }
  
  function updateContentBigImage($help_content_id,$targetPath)
  {
    $String_SQL = "Update pogopro_help_contents Set content_image_big= ? Where help_content_id = ?";
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$targetPath,$help_content_id]);
    if (!$status)
     {
      echo "[updateContentBigImage]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      return true;
     }      
  } 
  
  function updateContentVideo($help_content_id,$targetPath)
  {
    $String_SQL = "Update pogopro_help_contents Set content_video_name= ? Where help_content_id = ?";
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$targetPath,$help_content_id]);
    if (!$status)
     {
      echo "[updateContentVideo]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      return true;
     }      
  }  
  
  function updateHelpContentItem(
          $help_content_id,
          $content_icon_name,
          $content_header,
          $content_paragraph1,
          $content_paragraph2,
          $content_paragraph3,
          $content_tip,
          $content_image_title,
          $content_video_name)
  {
    $String_SQL = "Update pogopro_help_contents Set content_icon_name= ?,"
            . "content_header= ?,content_paragraph1= ?,"
            . "content_paragraph2= ?,content_paragraph3= ?,"
            . "content_tip= ?,content_image_title= ?,content_video_name = ? Where help_content_id = ?";
    $status = $this->db_conn->prepare($String_SQL);
	$status->execute([$content_icon_name,$content_header,$content_paragraph1,$content_paragraph2,$content_paragraph3,$content_tip,$content_image_title,$content_video_name,$help_content_id]);
    if (!$status)
     {
      echo "[deleteHelpContentItem]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      return true;
     }
  }

  function deleteHelpContentItem(
          $help_content_id)
  {
     $String_SQL = "Delete From pogopro_help_contents Where help_content_id = ?";
     $status = $this->db_conn->prepare($String_SQL);
	 $status->execute([$help_content_id]);
     if (!$status)
     {
      echo "[deleteHelpContentItem]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      return true;
     }   
  }

  function getNextHelpContentId($parent_content_code="")
  {
   $len = 4; 
   $where_cause = "LENGTH(a.content_code) = ".$len;
   $nextHelpContentId = "";
   if ($parent_content_code<>"")
   {
     $len = strlen($parent_content_code)+5;
     $where_cause = "LENGTH(a.content_code) = ".$len." AND a.content_code like '".$parent_content_code."-%'";
   }
   
   $String_SQL = "Select CAST(Substr(max(a.content_code),-4) AS UNSIGNED) + 1 As newCategoryId
                 From pogopro_help_contents a Where ?"; 
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$where_cause]);
   if (!$status)
     {
      echo "[getNextHelpContentId]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
     }else
     {
      while($row=  $status->fetch())
      {
       $conetnt_code =  $row['newCategoryId'];
       if ($conetnt_code==null)
           $nextHelpContentId = "0001";
       else
           $nextHelpContentId = sprintf("%04d", $conetnt_code);
      }
     }
     if ($parent_content_code<>"")
         $nextHelpContentId = $parent_content_code."-".$nextHelpContentId;
     return $nextHelpContentId;
  }
}
?>


