<?php
/* 
 * Class: pogoproCompanyNewsManager
 * Desc:  This class is used to add,update,delete pogopro comapany news,and get the list of company news for display.
 * 
 */
include_once("../v2/db_connect_pdo.php");//db connect classs
class pogoproCompanyNewsManager
{
  private $db_conn;
  function __construct($conn=null){ //set db connection in constructor
		if($conn){
			$this->db_conn = $conn;	
		}else{
			$dbconnect_obj = new dbconnection();
			$this->db_conn = $dbconnect_obj->conn;
		}
  }
  public function addPogoproCompanyNews($post_date,$news_title,$new_content)
  {
   $String_SQL = "Insert into pogopro_company_news(post_date,news_title,news_content) values(? ,?, ?)";  
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$post_date,$news_title,$new_content]);
   if (!$status)
   {
     echo "[addPogoproCompanyNews]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
     return false;
   }else
   {
     return true;  
   }   
  }
  
  public function updatePogoproCompanyNews($news_id,$news_title,$news_content)
  {
   $String_SQL = "Update pogopro_company_news Set news_title = ?,news_content = ? Where pogopro_new_id = ?";  
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$news_title,$news_content,$news_id]);
   if (!$status)
   {
     echo "[updatePogoproCompanyNews]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
     return false;
   }else
   {
     return true;  
   }       
  }
  
  public function deletePogoproCompanyNews($news_id)
  {
   $String_SQL = "Delete from pogopro_company_news Where pogopro_new_id = ?";  
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$news_id]);
   if (!$status)
   {
     echo "[deletePogoproCompanyNews]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
     return false;
   }else
   {
     return true;  
   }       
  } 
  
  public function getListOfPogoproCompanyNews($offset,$limit)
  {
   $arrayOfPogoproCompanyNews = array();   
   $String_SQL = "Select * From pogopro_company_news a order by a.post_date desc limit ? Offset ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$limit,$offset]);
   if (!$status)
   {
     echo "[getListOfPogoproCompanyNews]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
   }else
   {
     while ($row=$status->fetch())
     {
       $arrayOfPogoproCompanyNews[] = array(
        "post_date"=>$row['post_date'],   
        "news_title"=>$row['news_title'],
        "news_content"=>utf8_encode($row['news_content'])           
       );  
     }
   }
   return $arrayOfPogoproCompanyNews;
  }
  
  public function getCountOfPogoproCompanyNews()
  {
   $numberOfPogoproCompanyNews = 0;   
   $String_SQL = "Select count(*) as number_company_news From pogopro_company_news ";
   $status = $this->db_conn->query($String_SQL);
   if (!$status)
   {
     echo "[getCountOfPogoproCompanyNews]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
   }else
   {
     while ($row=  $status->fetch())
     {
      $numberOfPogoproCompanyNews = $row['number_company_news'];   
     }
   }
   return $numberOfPogoproCompanyNews;      
  }
}
?>

