<?php
/* 
 * This class is used to manage pogopro completed projects and its images. 
 * The functions cover Add,Update,Delete and Get
 * 
 */
include_once("../v2/inc/vars.php");
class pogoproCaseStudyManager
{
  private $db_conn;
  function __construct($conn=null){ //set db connection in constructor
		if($conn){
			$this->db_conn = $conn;	
		}else{
			$dbconnect_obj = new dbconnection();
			$this->db_conn = $dbconnect_obj->conn;
		}
  }
 public function addPogoproCaseStudy(
         $project_title,
         $project_desc,
         $project_challenge,
         $homeowner_comments,
         $homowner_rating,
         $outStanding_image="",
         $posted_project_id = 0
         )
 {
  $new_case_study_id = 0;   
  $String_SQL = "insert into pogopro_completed_projects(
          posted_project_id,
          project_title,
          project_desc,
          project_challenge,
          homeowner_comments,
          homowner_rating,
          outStanding_image
          ) values(?,?,?,?,?,?,?)";
 $status = $this->db_conn->prepare($String_SQL);
 $status->execute([$posted_project_id,$project_title,$project_desc,$project_challenge,$homeowner_comments,$homowner_rating,$outStanding_image]);
 if (!$status)
    {
       echo "[addPogoproCaseStudy]Query error:".$status->errorInfo()." with SQL:".$String_SQL;  
    }else
    {  
      $new_case_study_id = $this->db_conn->lastInsertId();  
    }
  return $new_case_study_id;  
 }
 
 public function updatePogoproCaseStudyItem(
         $item_name,
         $item_value,
         $caseStudy_id
         )
 {
   $String_SQL = "Update pogopro_completed_projects Set ? = ? Where completed_project_id = ?";
   $param = [$item_name, $item_value, $caseStudy_id];
   if ($item_name=='homowner_rating'){
       $String_SQL = "Update pogopro_completed_projects Set ? = ? Where completed_project_id = ?";
	   $param = [$item_name, $item_value, $caseStudy_id];
	}       
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute($param);
   if (!$status)
    {
     echo "[updatePogoproCaseStudyItem]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
     return false;
    }else
    {  
     return true;  
    }  
 }        
 
 public function deletePogoproCaseStudy($caseStudy_id)
 {
   $String_SQL = "Delete From pogopro_completed_projects Where completed_project_id = ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$caseStudy_id]);
   if (!$status)
    {
     echo "[updatePogoproCaseStudy]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
     return false;
    }else
    {  
     return true;  
    }  
 }
 
 public function addImageToPogoproCaseStudy($caseStudy_id,
        $image_title,
        $image_name,
        $image_status)
 {
   $String_SQL = "Insert into pogopro_completed_projects_image(
                 completed_project_id,image_title,image_name,image_status
                 ) values(?,?,?,?)";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$caseStudy_id,$image_title,$image_name,$image_status]);
   if (!$status)
    {
     echo "[updatePogoproCaseStudy]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
     return false;
    }else
    {  
     return true;  
    }  
 }
 
 public function deleteImageFromPogoproCaseStudy($completed_project_image_id)
 {
   $String_SQL = "Delete From pogopro_completed_projects_image Where completed_project_image_id = ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$completed_project_image_id]);
   if (!$status)
    {
     echo "[deleteImageFromPogoproCaseStudy]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
     return false;
    }else
    {  
     return true;  
    }   
 }
 
 public function getImagesOfCompletedProject($completed_project_id)
 {
   $imagesOfBefore = array();
   $imagesOfAfter  = array();
   $String_SQL = "Select a.project_sharing_image_id,a.share_image_name as image_name,a.share_image_type as image_status,'' as image_title 
                  From pogopro_project_share_image_management a,
                         pogopro_project_share_management b
                  Where a.share_object_id = b.share_object_id
                  AND b.project_id = ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$completed_project_id]);
   if (!$status)
    {
     echo "[getImagesOfCompletedProject]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
    }else
    {  
     while ($row = $status->fetch())
     {
      $image_status = $row['image_status'];
      if ($image_status>1)
      {
       $imagesOfAfter[] = array(
        "completed_project_image_id"=>$row['project_sharing_image_id'],   
        "image_title"=>$row['image_title'],
        "image_name"=>$row['image_name']   
       );   
      }else
      {
       $imagesOfBefore[] = array(
        "completed_project_image_id"=>$row['project_sharing_image_id'],   
        "image_title"=>$row['image_title'],
        "image_name"=>$row['image_name']           
       );   
      }
     }
    }
    return array($imagesOfBefore,$imagesOfAfter);
 }
 
 public function getListOfCompletedProjectsToShow()
 {
   $showListOfCompletedProjects = array();  
   $String_SQL = "Select a.*,'' as outStanding_image 
                  From pogopro_project_share_management a  WHERE a.project_id NOT IN(88,651,615,630,626,622,609,688,820)
                  Order by share_object_id DESC Limit 20";
   $status = $this->db_conn->query($String_SQL);
   if (!$status)
    {
     echo "[getListOfCompletedProjectsToShow]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
    }else
    {  
     while ($row=  $status->fetch())
     {
       $images = $this->getImagesOfCompletedProject($row['project_id']); 
       $out_standing_image = RENOVATION_COMPLETED_PROJECT_SERVER_DIR."";
       if (count($images[1])>0)
           $out_standing_image = $images[1][0]['image_name'];
       $showListOfCompletedProjects[] = array(
        "completed_project_id"=>$row['project_id'],
        "outStanding_image"=>$out_standing_image,
        "project_title"=>$row['share_object_subject'],
        "project_desc"=>$row['share_object_content'],
        "project_challenge"=>$row['share_object_challenge'],
        "homeowner_comments"=>$row['share_object_comments'],
        "homowner_rating"=>$row['share_object_rating'],   
        "image_of_before"=>$images[0],
        "image_of_after" =>$images[1]           
       );  
     }
    } 
   return $showListOfCompletedProjects; 
 }
 
 public function getDetailsOfCompletedProject($completed_project_id)
 {
   $images = $this->getImagesOfCompletedProject($completed_project_id);      
   $detailsOfCompletedProject = array();  
   $String_SQL = "Select a.*,'' as outStanding_image 
                  From pogopro_project_share_management a Where project_id = ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$completed_project_id]);
   if (!$status)
    {
     echo "[getListOfCompletedProjectsToShow]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
    }else
    {  
     while ($row = $status->fetch())
     {
       $detailsOfCompletedProject = array(
        "completed_project_id"=>$row['project_id'],
        "outStanding_image"=>RENOVATION_COMPLETED_PROJECT_SERVER_DIR.$row['outStanding_image'],
        "project_title"=>$row['share_object_subject'],
        "project_desc"=>$row['share_object_conent'],
        "project_challenge"=>$row['share_object_challenge'],
        "homeowner_comments"=>$row['share_object_comments'],
        "homowner_rating"=>$row['share_object_rating'],   
        "image_of_before"=>$images[0],
        "image_of_after" =>$images[1]
       );  
     }
    } 
   return $detailsOfCompletedProject;     
 }
 
 public function addPogoproPlatformIntroItem(
         $item_image_name,
         $item_title,
         $item_desc,
         $item_show_order
         )
 {
  $pogopro_platform_intro_item_id = 0;   
  $String_SQL = "Insert into pogopro_platform_introduction(item_image_name,item_title,item_desc,item_show_order) 
          values(?,?,?,?)"; 
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$item_image_name,$item_title,$item_desc,$item_show_order]);
   if (!$status)
   {
     echo "[addPogoproPlatformIntroItem]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
   }else
   { 
     $pogopro_platform_intro_item_id = $this->db_conn->lastInsertId();   
   } 
   return $pogopro_platform_intro_item_id;   
 }
 
 public function updatePogoproPlatformIntroItem(
         $platform_introduce_item_id,
         $item_image_name,
         $item_desc,
         $item_show_order         
         )
 {
   $String_SQL = "Update pogopro_platform_introduction Set 
          item_image_name =? ,item_desc = ? ,item_show_order = ? 
          Where platform_introduce_item_id = ?"; 
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$item_image_name,$item_desc,$item_show_order,$platform_introduce_item_id]);
   if (!$status)
   {
     echo "[updatePogoproPlatformIntroItem]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
     return false;
   }else
   { 
     return true;   
   }     
 }
 
 public function updatePogoproPlatformIntroItemContent(
         $platform_introduce_item_id,
         $key_name,
         $key_value       
         )
 {
   if ($key_name=='item_image_name')
   {
    unlink(RENOVATION_PLATFORM_INTRO_DIR.$this->getImageSrcOfPlatformIntroduceItem($platform_introduce_item_id));   
   }   
   $String_SQL = "Update pogopro_platform_introduction Set 
          ? = ? Where platform_introduce_item_id = ?"; 
		  $param = [$key_name,$key_value,$platform_introduce_item_id];
   if ($key_name=='item_show_order')
   {
     $String_SQL = "Update pogopro_platform_introduction Set 
          ? = ? Where platform_introduce_item_id = ?"; 
	 $param = [$key_name,$key_value,$platform_introduce_item_id];		  
   }
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute($param);
   if (!$status)
   {
     echo "[updatePogoproPlatformIntroItemContent]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
     return false;
   }else
   { 
     return true;   
   }     
 } 
 
 private function getImageSrcOfPlatformIntroduceItem($platform_introduce_item_id)
 {
   $imageSrcOfPlatformIntroduceItem = "";  
   $String_SQL = "Select * From pogopro_platform_introduction Where platform_introduce_item_id= ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$platform_introduce_item_id]);
   if (!$status)
   {
     echo "[getImageSrcOfPlatformIntroduceItem]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
   }else
   { 
    while ($row=  $status->fetch())
    {
     $imageSrcOfPlatformIntroduceItem = $row['item_image_name'];   
    }
   }
   return $imageSrcOfPlatformIntroduceItem;
 }
 
 public function deletePogoproPlatformIntroItem($platform_introduce_item_id)
 {
     unlink(RENOVATION_PLATFORM_INTRO_DIR.$this->getImageSrcOfPlatformIntroduceItem($platform_introduce_item_id));  
   $String_SQL = "Delete From pogopro_platform_introduction Where platform_introduce_item_id= ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$platform_introduce_item_id]);
   if (!$status)
   {
     echo "[updatePogoproPlatformIntroItem]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
     return false;
   }else
   { 
     return true;   
   }  
 }
 
 public function getListOfPogoproPlatformIntroItem()
 {
   $allPogoproPlatformIntroItems = array();  
   $String_SQL = "Select * From pogopro_platform_introduction Order by item_show_order";
   $status = $this->db_conn->query($String_SQL);
   if (!$status)
   {
     echo "[getListOfPogoproPlatformIntroItem]Query error:".$status->errorInfo()." with SQL:".$String_SQL;
   }else
   { 
    while ($row = $status->fetch())
    {
     $allPogoproPlatformIntroItems[] = array(
      "platform_introduce_item_id"=>$row['platform_introduce_item_id'], 
      "item_image_name"=>RENOVATION_PLATFORM_INTRO_SERVER_DIR.$row['item_image_name'],
      "item_desc"=>$row['item_desc'],
      "item_title"=>$row['item_title'],
      "item_show_order"=>$row['item_show_order']   
     );   
    }
   } 
   return $allPogoproPlatformIntroItems;
 }
}//End of class
?>

