<?php
/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
include_once("../v2/inc/vars.php");
class pogoproAdminManagementManager
{
 private $db_conn;
 function __construct($conn=null){ //set db connection in constructor
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection();
		$this->db_conn = $dbconnect_obj->conn;
	}
 }
 public function getPogoproCustomerSignupsByCategory(
         $start_date,
         $end_date,
         $category_filter,$search_name) 
 {
  $marketCustomerSignUpReport = array();   
  switch ($category_filter)
  {
   case 0:
        $marketCustomerSignUpReport = $this->getCustomerSignupReportBySource($start_date, $end_date,$search_name);
        break;
   case 1:
        $marketCustomerSignUpReport = $this->getCustomerSignupReportByCampaign($start_date, $end_date,$search_name);
        break; 
   case 2:
        $marketCustomerSignUpReport = $this->getCustomerSignupReportByAffiliates($start_date, $end_date,$search_name);
        break;     
  }
  return $marketCustomerSignUpReport;  
 }
 
 private function getCustomerSignupReportBySource(
         $start_date,
         $end_date,$search_name)
 {
  $marketCustomerSignUpReport = array();
	if($search_name==''){
		$String_SQL = "Select a.source_id,count(*) as sign_ups
                   From customer_accounts a
                   Where a.registration_date >= ? AND a.registration_date <= ?
                   Group by a.source_id";  
		$status = $this->db_conn->prepare($String_SQL);
		$status->execute([$start_date,$end_date]);
	}else{
		$String_SQL = "Select a.source_id,count(*) as sign_ups
                   From customer_accounts a
                   Where a.name like '%$search_name%'
                   Group by a.source_id";  
		$status = $this->db_conn->prepare($String_SQL);
		$status->execute();
	}
  if (!$status)
   {
    echo "[getCustomerSignupReportBySource]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
   }else
   {
    while ($row=  $status->fetch())
    {
     $source_id = $row['source_id'];
     if ($source_id==-1)
         $source_id = 101;
     $marketCustomerSignUpReport[] = array(
      "source_id"=>$source_id,
      "signup_count"=>$row['sign_ups']   
     );   
    }
   }
   return $marketCustomerSignUpReport;
 }
 
 private function getCustomerSignupReportByCampaign(
         $start_date,
         $end_date,$search_name)
 {
  $totalSignups = $this->getTotalSignups($start_date, $end_date,$search_name);  
  $toatlCampaignSignups = 0;
  $marketCustomerSignUpReport = array();
	if($search_name==''){
		$String_SQL = "Select a.promotion_material_id,b.promotion_material_name,count(*) as sign_ups
									 From customer_accounts a,pogopro_promotion_materials b
									 Where a.promotion_material_id=b.promotion_material_id and a.registration_date >= ? AND a.registration_date <= ?
									 Group by a.promotion_material_id";  
		$status = $this->db_conn->prepare($String_SQL);
		$status->execute([$start_date,$end_date]);
	}else{
		$String_SQL = "Select a.promotion_material_id,b.promotion_material_name,count(*) as sign_ups
									 From customer_accounts a,pogopro_promotion_materials b
									 Where a.promotion_material_id=b.promotion_material_id and a.name like '%$search_name%'
									 Group by a.promotion_material_id";  
		$status = $this->db_conn->prepare($String_SQL);
		$status->execute();
	}
  if (!$status)
   {
    echo "[getCustomerSignupReportByCampaign]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
   }else
   {
    while ($row=  $status->fetch())
    {
     $toatlCampaignSignups += $row['sign_ups'];    
     $marketCustomerSignUpReport[] = array(
      "campaign_id"=>$row['promotion_material_id'],
      "campaign_name"=>$row['promotion_material_name'],
      "signup_count"=>$row['sign_ups']   
     );   
    }
    $otherSignups = $totalSignups - $toatlCampaignSignups;
    if ($otherSignups>0)
    {
     $marketCustomerSignUpReport[] = array(
      "campaign_id"=>-1,
      "campaign_name"=>"Others",
      "signup_count"=>$otherSignups   
     );        
    }
   }
   return $marketCustomerSignUpReport;
 }
 
 private function getCustomerSignupReportByAffiliates(
         $start_date,
         $end_date,$search_name)
 {
  $totalSignups = $this->getTotalSignups($start_date, $end_date,$search_name);  
  $toatlCampaignSignups = 0;
  $marketCustomerSignUpReport = array();
	if($search_name==''){
		$String_SQL = "Select a.reference_code,b.name,count(*) as sign_ups
									 From customer_accounts a,r_resellers b
									 Where a.reference_code = b.id and  a.registration_date >= ? AND a.registration_date <= ?
									 Group by a.reference_code";  
		$status = $this->db_conn->prepare($String_SQL);
		$status->execute([$start_date,$end_date]);
	}else{
		$String_SQL = "Select a.reference_code,b.name,count(*) as sign_ups
									 From customer_accounts a,r_resellers b
									 Where a.reference_code = b.id and  a.name like '%$search_name%'
									 Group by a.reference_code";  
		$status = $this->db_conn->prepare($String_SQL);
		$status->execute();
	}
  if (!$status)
   {
    echo "[getCustomerSignupReportByCampaign]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
   }else
   {
    while ($row=  $status->fetch())
    {
     $toatlCampaignSignups += $row['sign_ups'];    
     $marketCustomerSignUpReport[] = array(
      "affiliate_id"=>$row['reference_code'],
      "affiliate_name"=>$row['name'],
      "signup_count"=>$row['sign_ups']   
     );   
    }
    $otherSignups = $totalSignups - $toatlCampaignSignups;
    if ($otherSignups>0)
    {
     $marketCustomerSignUpReport[] = array(
      "affiliate_id"=>-1,
      "affiliate_name"=>"Others",
      "signup_count"=>$otherSignups   
     );        
    }
   }
   return $marketCustomerSignUpReport;
 }

 private function getTotalSignups(         
         $start_date,
         $end_date,$search_name='') 
 {
  $totalSignups = 0;
	if($search_name==''){
		$String_SQL = "Select count(*) as sign_ups
									 From customer_accounts a
									 Where a.registration_date >= ? AND a.registration_date <= ?"; 
		$status = $this->db_conn->prepare($String_SQL);
		$status->execute([$start_date,$end_date]);
	}else{
		$String_SQL = "Select count(*) as sign_ups
									 From customer_accounts a
									 Where a.name like '%$search_name%'"; 
		$status = $this->db_conn->prepare($String_SQL);
		$status->execute();
	}
  if (!$status)
   {
    echo "[getTotalSignups]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
   }else
   {
    while ($row=  $status->fetch())
    {
     $totalSignups = $row['sign_ups'];   
    }
   }
   return $totalSignups;
 }
 
  function getOver2DaysUnsignupInvitationEmails($min_unsign_up_days)
  {
   $over2DaysUnsignupEmails = array();   
   $current_date = date('Y-m-d');
   $String_SQL = "Select a.email_address,a.open_datetime,
                  DATEDIFF('$current_date',a.open_datetime) as unsignup_days,
                  last_fellow_email_send_datetime,is_fellowed_number
                  From pogopro_marketing_email_signup_track a
                  Where DATEDIFF('$current_date',a.open_datetime) > ? and a.customer_id = 0;";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$min_unsign_up_days]);
   if (!$status)
    {
      echo "[getOver2DaysUnsignupInvitationEmails]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
    }else
    {
      while ($row=  $status->fetch())
      {
        $over2DaysUnsignupEmails[] = array(
         "email_address"=>$row['email_address'],
         "open_datetime"=>$row['open_datetime'],
         "unsignup_days"=>$row['unsignup_days'],
         "last_fellow_email_send_datetime"=>$row['last_fellow_email_send_datetime'],
         "is_fellowed_number"=>$row['is_fellowed_number']   
        );  
      }
    }
    return $over2DaysUnsignupEmails;
  }
  
  function updateOver2DaysUnregisteredEmailsStatus($arrayOfSelectedEmail)
  {
   $current_date = date('Y-m-d');   
   $String_SQL = "Update pogopro_marketing_email_signup_track 
                  Set last_fellow_email_send_datetime = ?,is_fellowed_number = is_fellowed_number +1
                  Where email_address = ?";
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$current_date, $arrayOfSelectedEmail]);
   if (!$status)
    {
      echo "[updateOver2DaysUnregisteredEmailsStatus]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
      return false;
    }else
    {
      return true;
    }
  }
  
  function getListOfNewSignups($start_date,$end_date,$search_name)
  {
   $newSignups = array();
		if($search_name==''){	 
   $String_SQL = "Select id,salutation,name,registration_date
                  From customer_accounts 
                  Where registration_date >= ? and registration_date <= ?
                  Order by id;";
	 $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$start_date, $end_date]);
		}
	 else{
		 $String_SQL = "Select id,salutation,name,registration_date
                  From customer_accounts 
                  Where name like '%$search_name%'
                  Order by id;";
			$status = $this->db_conn->prepare($String_SQL);
			$status->execute();
	 }
   if (!$status)
    {
      echo "[getListOfNewSignups]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
    }else
    {
     while ($row=$status->fetch())
     {
       $newSignups[] = array(
        "id"=>$row['id'],
        "salutation"=>$row['salutation'],
        "name"=>$row['name'],
        "registration_date"=>$row['registration_date']   
       );  
     }
    }
    return $newSignups;
  }
  
  function getDetailsOfNewSignUp($customer_id)
  {
   $newSignupDetails = array();   
   $String_SQL = "Select id,salutation,name,email,phone,current_step,merchant_id,registration_date,current_step,address,suite_no,pt,country,city,postal_code,versapay_institution_number,versapay_branch_number,versapay_account_number,isDisabled
                  From customer_accounts 
                  Where id = ?"; 
   $status = $this->db_conn->prepare($String_SQL);
   $status->execute([$customer_id]);
   if (!$status)
    {
      echo "[getDetailsOfNewSignUp]Query error:".$status->errorInfo()." with SQL:".$String_SQL; 
    }else
    {
        
     while ($row=$status->fetch())
     {
		$address = $row['address'];
		if ($row['suite_no']!=="")
			$address .= " Suite ".$row['suite_no'];
		$address .= "&#13;&#10;".$row['city']." ".$row['pt']." ".$row['country'].
		 "&#13;&#10;".$row['postal_code'];
       $newSignups = array(
        "id"=>$row['id'],
        "salutation"=>$row['salutation'],
        "name"=>$row['name'],
        "email"=>$row['email'],   
        "phone"=>$row['phone'], 
        "current_step"=>$row['current_step'],
        "merchant_id"=>$row['merchant_id'],  
        "registration_date"=>$row['registration_date'],
		"address"=>$address,
		"versapay_institution_number"=>$row['versapay_institution_number'],
		"versapay_branch_number"=>$row['versapay_branch_number'],
		"versapay_account_number"=>$row['versapay_account_number'],
		"isDisabled"=>$row['isDisabled']
	   );  
     }
    }
    $newSignups['offered_services'] = $this->getAllOfferedServicesByMerchant($newSignups['merchant_id']);
    return $newSignups;   
  }
  
 private function getAllOfferedServicesByMerchant($merchant_id)
 {
  $allParentLevels = $this->getParentLevelCategory();
  $allOfferedServices = array();
  $String_SQL = "Select a.pro_service_category_id,b.category_name
                 From pogopro_pro_offer_services a,pogopro_pro_service_categories b
                 Where a.merchant_id = ? and a.pro_service_category_id = b.category_code
                 Order By a.offeredService_id";
  $status = $this->db_conn->prepare($String_SQL);
  $status->execute([$merchant_id]);
  if (!$status)
  {
   echo "[getParentLevelCategory]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   while ($row = $status->fetch())
   {
     $level_parent = substr($row['pro_service_category_id'], 0,9);  
     $allOfferedServices[] = array(
         "category_code"=>$row['pro_service_category_id'],
         "category_name"=>"[".$allParentLevels[$level_parent]."] ".$row['category_name']
     );  
   }
  }
  return $allOfferedServices;
 }
 
 private function getParentLevelCategory()
 {
  $String_SQL = "Select a.category_code,a.category_name
                 From pogopro_pro_service_categories a
                 Where length(a.category_code) = 9";
  $parentLevels = array();
  $status = $this->db_conn->query($String_SQL);
  if (!$status)
  {
   echo "[getParentLevelCategory]Query error:".$status->errorInfo()." with SQL:".$String_SQL;   
  }else
  {
   while ($row = $status->fetch())
   {
     $parentLevels[$row['category_code']] = $row['category_name'];  
   }
  }
  return $parentLevels;  
 } 
}//End of class
?>


