<?php
/*
 * Class Name: Pogo.Pro Shopping Cart Manager
 * Description: Pogo.Pro shopping cart manager will be used to manage cstomer's shopping cart and store in current session.
 * When customer checkout its shopping cart, it will be stored into database and clean data in session.
 */
include_once("../v2/inc/vars.php");
include_once("pogo_pro_utility_functions.php");
class pogoProShoppingCartManager
{
  private $db_conn;	
  private $orderItems;
  
  function __construct($conn=null)
  {
	if($conn){
		$this->db_conn = $conn;	
	}else{
		$dbconnect_obj = new dbconnection();
		$this->db_conn = $dbconnect_obj->conn;
	}	  
	$this->orderItems = array();   
  }
  function addOrderItem($productId,$productType,$itemQuantity,$checkInDate="",$checkOutDate="")
  {
    $key = $productType."-".$productId;  
    if ($checkInDate!=""&&$checkOutDate!="")
        $key = $productType."-".$productId."-{".$checkInDate."_".$checkOutDate."}";

    if (array_key_exists($key,$this->orderItems))
    {
     $orderItem = $this->orderItems[$key];
     $orderItem[0] = $orderItem[0] + $itemQuantity;
     $this->orderItems[$key] = $orderItem ;
    }else 
    {
     if ($checkInDate=="")
        $this->orderItems[$key] = array($itemQuantity);
     else
        $this->orderItems[$key] = array($itemQuantity,$checkInDate,$checkOutDate);        
    }
  }
  function updateOrderItem($productId,$productType,$itemQuantity,$checkInDate="",$checkOutDate="")
  {
     $key = $productType."-".$productId;  
     if ($checkInDate!=""&&$checkOutDate!="")
        $key = $productType."-".$productId."-{".$checkInDate."_".$checkOutDate."}";
     
     $orderItem = $this->orderItems[$key];
     $orderItem[0] = $itemQuantity;
     $this->orderItems[$key] = $orderItem ;     
  }
  function showShoppingCartDetails()
  {
   print_r($this->orderItems);   
  }
  function saveOrUpdateShoppingCart(
      $session_id,
      $mod_id,
      $mod_type,
      $sub_id,
      $sub_type,
      $quantity,
      $item_cost,
      $user_id,
      $item_desc,   
      $check_in_date="",
      $check_out_date="",
      $taxRate,
      $order_item_image    
  )
  {
      
    $whereCause = "Where session_id='".$session_id
                    ."' AND mod_id=".$mod_id
                    ." AND sub_id=".$sub_id
                    ." AND type='".$mod_type."'"
                    ." AND sub_type='".$sub_type."'";
    if ($check_in_date<>'') $whereCause .= " AND check_in_date='".$check_in_date."'";
    if ($check_out_date<>'') $whereCause .= " AND check_out_date='".$check_out_date."'";
    $String_SQL = "Update rv_cart Set quantity = quantity + ".$quantity." ".$whereCause;  
    $result=$this->db_conn->query($String_SQL);
    if (!$result)
    {
      echo "Query error:".$result->errorInfo()." with SQL:".$String_SQL;
    }else
    {
      if ($result->rowCount()==0)
      {
        // Save new cart item
        $String_SQL = "Insert into rv_cart("
                . "session_id,userid,mod_id,type,sub_id,sub_type,quantity,item_cost,order_options,check_in_date,check_out_date,date_added,taxRate,image) value(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        echo $String_SQL;
        $result=$this->db_conn->query($String_SQL);
		$result->execute([$session_id,$user_id,$mod_id,$mod_type,$sub_id,$sub_type,$quantity,$item_cost,$item_desc,$check_in_date,$check_out_date,date("Y-m-d H:i:s"),$taxRate,$order_item_image]);        
		if (!$result)
        {
         echo "Query error:".$result->errorInfo()." with SQL:".$String_SQL;
        }else
        {
          if ($result->rowCount()==1)
          {  
            if (isset($_SESSION['payment_amount'])) //refersh shopping cart payment amount
            {
                $_SESSION['payment_amount'] = $this->getPaymentAmountOfShoppingCart($user_id,$session_id);              
            }
            return true;
          }
          else
              return false;
        }
    }else
    {
        if (isset($_SESSION['payment_amount'])) //refersh shopping cart payment amount
            $_SESSION['payment_amount'] = $this->getPaymentAmountOfShoppingCart($user_id,$session_id);        
        return true;
    }
   }
  }
  function getProductDesc($item_id,$item_type)
  {
    $table = $GLOBALS['tables_lookup'][$item_type]; 
    switch ($item_type)
    {
     case 'hotels': 
         $String_SQL = "Select name From ? Where id= ?";
         break;
     case 'attractions':
         $String_SQL = "Select name From ? Where id= ?";
         break; 
     case 'sports_events':
         $String_SQL = "Select event_name as name From ? Where id= ?";
         break;            
    }
    
    $result=$this->db_conn->prepare($String_SQL);
	$result->execute([$table,$item_id]);
    if (!$result)
    {
      echo "Query error:".$result->errorInfo()." with SQL:".$String_SQL;
      return "";
    }else
    { 
      $row = $result->fetch();
      return $row['name'];
    }     
  }
  function getItemDesc($item_id,$item_type)
  {
    $table = $GLOBALS['tables_lookup'][$item_type]; 
    switch ($item_type)
    {
     case 'menu':
          $String_SQL = "Select meal_name as name, meal_type as type,image From ? Where id= ?";
          break;
     case 'accommodation':
          $String_SQL = "Select name, room_type as type,image From ? Where id= ?";
          break;
     case 'facility':
          $String_SQL = "Select name, facility_type as type,image From ? Where id= ?";
          break; 
     case 'pass':
          $String_SQL = "Select pass_name as name, description as type  From ? Where id= ?";
          break;
     case 'seat':
          $String_SQL = "Select section as name, section_description as type  From ? Where id= ?";
          break; 
     case 'Taxi':
     case 'Limousine':
     case 'Car hire':    
          $String_SQL = "Select vehicle_make as name, vehicle_type as type, vehicle_costing_unit as unit From ? Where id= ?";
          break;      
    }

    $result=$this->db_conn->prepare($String_SQL);
	$result->execute([$table,$item_id]);
    if (!$result)
    {
      echo "Query error:".$result->errorInfo()." with SQL:".$String_SQL;
      return "";
    }else
    { 
      $row = $result->fetch();
      if ($item_type=='Taxi'||$item_type=='Limousine'||$item_type=='Car hire')
          return array($row['name'],$row['type'],$row['unit']);
      else if ($item_type=='menu'||$item_type=='accommodation'||$item_type=='facility')
      {
          $dir_array = array(
              "menu"=>HOTEL_MENU_SERVER_DIR,
              "accommodation"=>HOTEL_ACCOMODATION_SERVER_DIR,
              "facility"=>HOTEL_FACILITIES_SERVER_DIR);
          return array($row['name'],$row['type'],$dir_array[$item_type].$row['image']);
      }
      else 
          return array($row['name'],$row['type']);
    } 
  }
 
  function getPaymentAmountOfShoppingCart($user_id,$session_id)
  {
    $shopping_cart_payment_amount = 0.00;  
    $String_SQL = "Select * from rv_cart Where userid= ? AND session_id= ? Order By id";

    $result=$this->db_conn->prepare($String_SQL);
	$result->execute([$user_id,$session_id]);
    if (!$result)
    {
      echo "Query error:".$result->errorInfo()." with SQL:".$String_SQL;
      return 0.00;
    }else
    {  
       while ($row = $result->fetch())
       {   
        $check_in_date = $row['check_in_date']; 
        $check_out_date = $row['check_out_date'];
        if ($check_in_date<>''&&$check_out_date<>'')
        {
         $shopping_cart_payment_amount += $row['item_cost']*$row['quantity']*(new PogoProUtilityManager())->getDaysBetweenTwoDates($check_in_date,$check_out_date);
        }else
         $shopping_cart_payment_amount += $row['item_cost']*$row['quantity'];
       } 
       
       return $shopping_cart_payment_amount;
    }     
  }
} // End of php file 
?>

